<?php
/**
 * This file contains the forecast details template for the main view
 *  in the front-end of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');
?>

<?php
$detailedForecast = $this->data->twcContent->dayf_forecasts[$this->detailedForecast];
?>

<a name="eWeatherForecastDetail"></a>
<table>
	<tr>
		<td class="sectiontableheader<?php echo $this->data->pageClassSuffix; ?>" valign="middle" >
			<?php echo JText::_('COM_EWEATHER_FORECAST').'&nbsp;'.JText::_('COM_EWEATHER_FORECAST_FOR').'&nbsp;'.$this->data->twcContent->loc_city; ?>
			<br/>
			<?php echo JText::_('COM_EWEATHER_LASTUPDATED').'&nbsp;'.$this->data->formattedForecastLastUpdate; ?>
		</td>
	</tr>
	<tr>
		<td>
			<br />
			<div class="eweatherforecastdetail" >
			<table align="center" >
				<tr>
					<td class="ForecastBlockHeader<?php echo $this->data->pageClassSuffix; ?>" >
						<div style="font-weight: bold; text-align: center; color: #000000; border: 0px; vertical-align: bottom;" valign="absmiddle" >
							<a href="<?php echo $this->data->forecastUrl; ?>" title="<?php echo JText::_('COM_EWEATHER_FORECAST_BACK'); ?>">
								<img src="<?php echo $this->data->imageUrls['weatherDetailClose']; ?>" align="left" border="0" alt="" />
							</a>
						</div>
						<b>
							<?php echo JText::_('COM_EWEATHER_FORECAST').'&nbsp;'.JText::_('COM_EWEATHER_FORECAST_FOR').'&nbsp;'.$this->data->formattedDetailedForecastDates[$this->detailedForecast]; ?>
						</b>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;">
						<table>
							<tr>
								<td colspan="2" align="center" >
									<table class="eweatherdetailforecastheader" >
										<tr class="ForecastDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
											<td width="21%" >
												<div class="ForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_FORECAST_TEMP_D_MAX').': '; ?>
												</div>
											</td>
											<td width="12%" >
												<div class="ForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>">
<?php
												if ('N/A' == $detailedForecast->day_temp_max)
												{
													echo 'N/A';
												}
												else
												{
													echo $detailedForecast->day_temp_max.'&deg;'.$this->data->twcContent->h_temp;
												}

?>
												</div>
											</td>
											<td width="34%">&nbsp;</td>
											<td width="21%" >
												<div class="ForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_SUNRISE').': '; ?>
												</div>
											</td>
											<td width="12%" >
												<div class="ForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $detailedForecast->day_sunrise; ?></div>
											</td>
										</tr>
										<tr class="ForecastDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
											<td width="21%" >
												<div class="ForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_FORECAST_TEMP_D_MIN').': '; ?>
												</div>
											</td>
											<td width="12%" >
												<div class="ForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
<?php
												if ('N/A' == $detailedForecast->day_temp_min)
												{
													echo 'N/A';
												}
												else
												{
													echo $detailedForecast->day_temp_min.'&deg;'.$this->data->twcContent->h_temp;
												}
?>
												</div>
											</td>
											<td width="34%">&nbsp;</td>
											<td width="21%" >
												<div class="ForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_SUNSET').': '; ?>
												</div>
											</td>
											<td width="12%" >
												<div class="ForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $detailedForecast->day_sunset; ?>
												</div>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td align="center" >
									<div align="center" style="margin-left: 5%; margin-right: 5%; margin-bottom: 5%; border-bottom: 1px solid #CCCCCC;" >
										<b><?php echo JText::_('COM_EWEATHER_FORECAST_D_DAY'); ?></b>
									</div>
								</td>
								<td align="center">
									<div align="center" style="margin-left: 5%; margin-right: 5%; margin-bottom: 5%; border-bottom: 1px solid #CCCCCC;" >
										<b><?php echo JText::_('COM_EWEATHER_FORECAST_D_NIGHT'); ?></b>
									</div>
								</td>
							</tr>
							<tr>
								<td width="50%" valign="top">
									<table>
										<tr>
											<td width="50%" height="140">
												<div align="center">
													<img src="<?php echo $this->data->detailedForecastDayIcons[$this->detailedForecast]; ?>" border="0" alt="<?php echo $detailedForecast->day_d_text; ?>" />
													<br />
												</div>
											</td>
											<td width="50%" height="140" valign="middle">
												<div class="DaytimeForecastText<?php echo $this->data->pageClassSuffix; ?>" >
<?php
												if ('N/A' != $detailedForecast->day_d_text)
												{
													echo $detailedForecast->day_d_text;
												}
?>
													<br /><br />
												</div>
												<table>
													<tr class="DaytimeForecastDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
														<td>
															<div class="DaytimeForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo JText::_('COM_EWEATHER_FORECAST_D_RAIN').': '; ?>
															</div>
														</td>
														<td>
															<div class="DaytimeForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
<?php
															if ('N/A' == $detailedForecast->day_d_text)
															{
																echo 'N/A';
															}
															else
															{
																echo $detailedForecast->day_d_precipitation.'%';
															}
?>
															</div>
														</td>
													</tr>
													<tr class="DaytimeForecastDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
														<td>
															<div class="DaytimeForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo JText::_('COM_EWEATHER_HUMIDITY').': '; ?>
															</div>
														</td>
														<td>
															<div class="DaytimeForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
<?php
															if ('N/A' == $detailedForecast->day_d_text)
															{
																echo 'N/A';
															}
															else
															{
																echo $detailedForecast->day_d_humidity.'%';
															}
?>
															</div>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td width="50%" height="140" valign="middle">
												<div class="DaytimeForecastWindText<?php echo $this->data->pageClassSuffix; ?>">
<?php
												if ('N/A' != $detailedForecast->day_d_text)
												{
													echo $detailedForecast->day_d_windtext;
												}
?>
													<br /><br />
												</div>
												<table>
													<tr class="DaytimeForecastDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
														<td>
															<div class="DaytimeForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo JText::_('COM_EWEATHER_WINDSPEED').': '; ?>
															</div>
														</td>
														<td>
															<div class="DaytimeForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
<?php
															if ('N/A' == $detailedForecast->day_d_text)
															{
																echo 'N/A';
															}
															else
															{
																echo $detailedForecast->day_d_windspeed.'&nbsp;'.$this->data->twcContent->h_speed;
															}
?>
															</div>
														</td>
													</tr>
													<tr class="DaytimeForecastDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
														<td>
															<div class="DaytimeForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo JText::_('COM_EWEATHER_WINDDIR').': '; ?>
															</div>
														</td>
														<td>
															<div class="DaytimeForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
<?php
															if ('N/A' == $detailedForecast->day_d_text)
															{
																echo 'N/A';
															}
															else
															{
																echo $detailedForecast->day_d_winddirection.'&deg;';
															}
?>
															</div>
														</td>
													</tr>
													<tr class="DaytimeForecastDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
														<td>
															<div class="DaytimeForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo JText::_('COM_EWEATHER_WINDGUST').': '; ?>
															</div>
														</td>
														<td>
															<div class="DaytimeForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
<?php
															if ('N/A' == $detailedForecast->day_d_windgust)
															{
																echo 'N/A';
															}
															else
															{
																echo $detailedForecast->day_d_windgust.'&nbsp;'.$this->data->twcContent->h_speed;
															}
?>
															</div>
														</td>
													</tr>
												</table>

											</td>
											<td width="50%" height="140">
												<div align="center">
<?php
												if (($detailedForecast->day_d_windtext != null) && ($detailedForecast->day_d_windtext != "N/A"))
												{
?>
													<img src="<?php echo $this->data->detailedForecastDayWindIcons[$this->detailedForecast]; ?>" border="0" alt="" />
<?php
												}
												else
												{
?>
													<img src="<?php echo $this->data->detailedForecastDayWindIcons['nodir']; ?>" border="0" alt="" />
<?php
												}
?>
													<br />
												</div>
											</td>
										</tr>
									</table>
								</td>
								<td width="50%" valign="top" style="margin-top: 10px; border-left: 1px solid #CCCCCC; margin-left: 3px;">
									<table>
										<tr>
											<td width="50%" height="140">
												<div align="center">
													<img src="<?php echo $this->data->detailedForecastNightIcons[$this->detailedForecast]; ?>" border="0" alt="<?php echo $detailedForecast->day_n_text; ?>" />
													<br />
												</div>
											</td>
											<td width="50%" height="140" valign="middle">
												<div class="EveningForecastText<?php echo $this->data->pageClassSuffix; ?>">
													<?php echo $detailedForecast->day_n_text; ?>
													<br /><br />
												</div>
												<table>
													<tr class="EveningForecastDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
														<td>
															<div class="EveningForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo JText::_('COM_EWEATHER_FORECAST_D_RAIN').': '; ?>
															</div>
														</td>
														<td>
															<div class="EveningForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo $detailedForecast->day_n_precipitation.'%'; ?>
															</div>
														</td>
													</tr>
													<tr class="EveningForecastDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
														<td>
															<div class="EveningForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo JText::_('COM_EWEATHER_HUMIDITY').': '; ?>
															</div>
														</td>
														<td>
															<div class="EveningForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo $detailedForecast->day_n_humidity.'%'; ?>
															</div>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td width="50%" height="140">
												<div class="EveningForecastWindText"<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $detailedForecast->day_n_windtext; ?>
													<br /><br />
												</div>
												<table>
													<tr class="EveningForecastDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
														<td>
															<div class="EveningForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo JText::_('COM_EWEATHER_WINDSPEED').': '; ?>
															</div>
														</td>
														<td>
															<div class="EveningForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo $detailedForecast->day_n_windspeed.'&nbsp;'.$this->data->twcContent->h_speed; ?>
															</div>
														</td>
													</tr>
													<tr class="EveningForecastDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
														<td>
															<div class="EveningForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo JText::_('COM_EWEATHER_WINDDIR').': '; ?>
															</div>
														</td>
														<td>
															<div class="EveningForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo $detailedForecast->day_n_winddirection.'&deg;'; ?>
															</div>
														</td>
													</tr>
													<tr class="EveningForecastDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
														<td>
															<div class="EveningForecastDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
																<?php echo JText::_('COM_EWEATHER_WINDGUST').': '; ?>
															</div>
														</td>
														<td>
															<div class="EveningForecastDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
<?php
															if ('N/A' == $detailedForecast->day_n_windgust)
															{
																echo 'N/A';
															}
															else
															{
																echo $detailedForecast->day_n_windgust.'&nbsp;'.$this->data->twcContent->h_speed;
															}
?>
															</div>
														</td>
													</tr>
												</table>
											</td>
											<td width="50%" height="140">
												<div align="center">
<?php
												if (($detailedForecast->day_n_windtext != null) && ($detailedForecast->day_n_windtext != "N/A"))
												{
?>
													<img src="<?php echo $this->data->detailedForecastNightWindIcons[$this->detailedForecast]; ?>" border="0" alt="" />
<?php
												}
												else
												{
?>
													<img src="<?php echo $this->data->detailedForecastNightWindIcons['nodir']; ?>" border="0" alt="" />
<?php
												}
?>
													<br />
												</div>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
						<br />
					</td>
				</tr>
			</table>
			</div>
		</td>
	</tr>
</table>
<br/><br/>
