<?php
/**
 * This file contains the RafWeatherData class
 *  for the RafWeather module.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * 03/14/2010: Bob Lavey - Initial revision, converted to MVC module.
 * 03/14/2011: Bob Lavey - Converted to work with Joomla! 1.6.x 
 * 
 * @package eWeather
 * @subpackage eWeather Raf Module
 * @copyright (C) 2007 Skorp<br/>
 *            2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

class RafWeatherData extends JObject
{
	public function __construct($locId, $locName, $weatherLink, $model)
	{
    
		$this->locId = $locId;
		$this->locName = $locName;
		$this->model = $model;
		
		// ask the eWeather component to retrieve the data
		if (false != $this->model)
		{
			$this->weatherData = $this->model->getData($this->locId);
		}

		if ('error' != $this->weatherData->dataType)
		{
			// if the user didn't specify and name,
			//  use The Weather Channel's name
			if (empty($this->locName) && (null != $this->weatherData) && (null != $this->weatherData->twcContent))
			{
				$this->locName = $this->weatherData->twcContent->loc_city;
			}
	
			if (null != $this->weatherData)
			{
				$this->weatherLink = $this->_createWeatherLink($weatherLink);
			}
		}
	}

	protected function _createWeatherLink($weatherLink)
	{
		// create link, if requested
		$link = null;
		
		if (1 == $weatherLink)
		{
			$link = JRoute::_($this->weatherData->rawWeatherUrl.'&amp;locid='.$this->locId);
		}
		else if (2 == $weatherLink)
		{	
			$link = 'http://www.weather.com/outlook/travel/businesstraveler/local/'.$this->locId;
		}
		
		return $link;
	}
}
