<?php
/**
 * This file contains the RafWeatherModule class
 *  for the Raf Weather module.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * 03/14/2010: Bob Lavey - Initial revision, converted to MVC module.
 * 03/14/2011: Bob Lavey - Converted to work with Joomla! 1.6.x 
 *
 * @package eWeather
 * @subpackage eWeather Raf Module
 * @copyright (C) 2007 Skorp<br/>
 *            2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport('joomla.application.component.model');

// setup paths
require_once( JPATH_SITE.DS.'modules'.DS.'mod_rafweather'.DS.'helpers'.DS.'defines.php' );

// get RafWeatherData class
JLoader::register('RafWeatherData', MOD_RAFWEATHER_CLASSES_PATH.DS.'RafWeatherData.php' );

JModel::addIncludePath( COM_EWEATHER_MODELS_PATH );


class RafWeatherModule extends JObject
{
	protected $model = false;
	
	public function __construct($params)
	{
		if (defined( 'COM_EWEATHER_ADMIN_VERSION' ))
		{
			// load the com_eweather language file
			$lang = JFactory::getLanguage();
			$lang->load('com_eweather', COM_EWEATHER_PATH );
			
			// get the module's params
			$this->moduleClassSuffix = $params->get( 'moduleClassSuffix' );
			$this->citiesList = $params->get( 'citiesList' );
			if ("-" == $this->citiesList)
			{
				$this->citiesList = null;
			}
			$this->weatherLink = intval($params->get( 'weatherLink' ));
			$this->currentConditionsIconSize = $params->get( 'currentConditionsIconSize' );
			$this->windDirIconSize = $params->get( 'windDirIconSize' );
			$this->maxColumns = intval($params->get( 'maxColumns' ));
			$this->maxRows = intval($params->get( 'maxRows' ));
			$this->retrieveFromUserProfiles = $params->get( 'retrieveFromUserProfiles' );
			$this->userProfileItemOrder = $params->get( 'userProfileItemOrder' );
			$this->userProfileItemLimit = intval($params->get( 'userProfileItemLimit' ,10 ));
			$this->citiesForSelectedUserIds = $params->get( 'citiesForSelectedUserIds' );
			if ("-" == $this->citiesForSelectedUserIds)
			{
				$this->citiesForSelectedUserIds = null;
			}
			$this->integrateWithUserIds = $params->get( 'integrateWithUserIds' );
			$this->degreeSymbol = $params->get( 'degreeSymbol' , "&deg;" );
	
			// get eWeather Component's "main" model
			$this->model = JModel::getInstance('main', 'eWeatherModel');
			if (false == $this->model)
			{
				$this->_errors['moduleError'] = JText::_('MOD_RAFWEATHER_COMPONENT_NOT_FOUND').': com_eweather';
			}
		}
		else
		{
			$this->_errors['moduleError'] = JText::_('MOD_RAFWEATHER_COMPONENT_NOT_FOUND').': com_eweather';
		}
	}

	public function display()
	{
		if (false != $this->model)
		{
			// setup the list of locations to display
			$this->_addLocationsFromCitiesList($this->citiesList);
			$this->_addLocationsByUserId();
			$this->_addLocationsFromUserProfiles();
			
			// create objects for each location
			$this->locations = $this->_createLocationsFromList();

		}

		if (isset($this->_errors['moduleError']))
		{
			require(JModuleHelper::getLayoutPath('mod_rafweather', 'componenterror'));
		}
		else if ((count($this->locations) > 0) &&
		         ('error' == $this->locations[0]->weatherData->dataType))
		{
			require(JModuleHelper::getLayoutPath('mod_rafweather', 'weathererror'));
		}
		else
		{
			require(JModuleHelper::getLayoutPath('mod_rafweather', 'default'));
		}
	}

	protected function _addLocationsFromCitiesList($citiesList)
	{
		$locationArray = array();
		$locations = array();
		
		$locationArray = explode(",", $citiesList);
		$locationArray = array_unique($locationArray);
		
		foreach ($locationArray as $location)
		{
			$idAndNameArray = explode('=', $location);
			$this->_addLocationToList($idAndNameArray[0], $idAndNameArray[1]);
		}
		
	}
	
	protected function _addLocationsByUserId()
	{
		if ('1' == $this->integrateWithUserIds)
		{
			// get the current user's Id
			$user = JFactory::getUser();
			$userId = $user->get('id');
		
			// remove spaces and newlines
			$replace = array(" ","\n");
			$this->citiesForSelectedUserIds = str_replace($replace,"",$this->citiesForSelectedUserIds);
			
			// break into userId/cities chunks
			$this->citiesForSelectedUserIds = explode(";",$this->citiesForSelectedUserIds);

			foreach ($this->citiesForSelectedUserIds as $citiesForSelectedUserIds)
			{
				// break the userIds/cities chunk into user Ids and cities
				$userIdsAndCities = explode(":",$citiesForSelectedUserIds);
				// $userIdsAndCities[0] is the user Id list
				$userIdList = $userIdsAndCities[0];
				$userIds = explode(",",$userIdList);
				if (in_array($userId, $userIds))
				{
					$this->_addLocationsFromCitiesList($userIdsAndCities[1]);
				}
			}
		}
	}

	protected function _addLocationsFromUserProfiles()
	{
		if ($this->retrieveFromUserProfiles)
		{
			// load the database
			$db = JFactory::getDBO();
			
			if ('1' == $this->userProfileItemOrder)
			{
				$order=" ORDER BY RAND()";
			}
			else
			{
				$order=" ORDER BY id DESC";
			}

			$sql = "SELECT locid FROM #__eweather_profiles ".$order." LIMIT ".$this->userProfileItemLimit;
			$db->setQuery($sql);
			$rows  = $db->loadObjectList();

			if (null != $rows)
			{
				foreach($rows as $row)
				{
					$this->_addLocationToList($row->locid, '');
				}
			}
		}
	}

	protected function _addLocationToList($locId, $locName)
	{
		if (empty($this->locationList))
		{
			$this->locationList .= $locId.'='.$locName;
		}
		else
		{
			$this->locationList .= ','.$locId.'='.$locName;
		}

	}
	
	protected function _createLocationsFromList()
	{
		$locationArray = array();
		$locations = array();
		
		$locationArray = explode(",", $this->locationList);
		$locationArray = array_unique($locationArray);
		
		// if the user requested unlimited columns, use all
		//   the locations, and there will be exactly 1 row
		if ('0' == $this->maxColumns)
		{
			$this->numLocations = count($locationArray);
			$this->numColumns = $this->numLocations;
		}
		// if the user requested unlimited rows, use all
		//   the locations, and fill as many columns as necessary
		else if ('0' == $this->maxRows)
		{
			$this->numLocations = count($locationArray);
			$this->numColumns = $this->maxColumns;
		}
		// for limited columns/rows, we may have to
		//  truncate some of the locations
		else
		{
			if (count($locationArray) > ($this->maxColumns * $this->maxRows))
			{
				$locationArray = array_splice($locationArray, 0, ($this->maxColumns * $this->maxRows));
			}
			$this->numLocations = count($locationArray);
			$this->numColumns = $this->maxColumns;
		}

		foreach ($locationArray as $location)
		{
			// get the locId and name from the list of cities
			$cityAndNameArray = explode('=', $location);
			$locId = $cityAndNameArray[0];
			$locName = $cityAndNameArray[1];
	
			// get the eWeather component's main model
			$model = JModel::getInstance('main', 'eWeatherModel');
			
			$locations[] = new RafWeatherData($locId, $locName, $this->weatherLink, $model);
		}

		return $locations;
	}
}
