<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.SC.class.php,v 0.6 2005/12/17 18:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Serverclass that is used to handle the remote status retrievement option.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/
defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

require_once( $mosConfig_absolute_path . '/includes/domit/xml_domit_lite_include.php' );

class Shoutcast extends ServerMain {
	/**
	* Properties.
	*/
	var $serverip = "localhost";						# Ip addr for server to query
	var $port = 0;								# Port to query
	var $timeout = 160000;							# Timeout in microsecond
	var $retry = 3;

	var $socket = "";							# Socket var...
	var $err = 0;								# Error code, set when an error has occured
	var $errmsg = "";							# Error message...

	var $result = "";							# The result of a status request to the gameserver
	var $serverdata = Array();						# Contains server information
	var $userinfo = Array();						# Contains player information
	var $channelinfo = Array();

	var $numofusers = 0;							# Number of players on server
	var $numofchannels = 0;

	var $online = false;
	/**
	* Constructor. Within this constructor we handle all the logic.
	* First we are going to read 
	*/
	function Shoutcast ($serverip, $port, $debug, $retrycount, $timeout, $username, $password) {
		$this->trace("Shoutcast::_constructor", "_start", 0, 0);

		# Variable settings
		$this->serverip = $serverip;                                    # Initialize properties
		$this->port = $port;
		$this->result = "";						# Contains server respons data
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if
		$this->username = $username;
		$this->password = $password;

		# Here we go!
		$this->trace("Shoutcast::_constructor", "serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);

		$this->socket = $this->getSocket($this->serverip, $this->port, $this->username, $this->password);
		if ($this->socket) {
			$i=0;
			do {
				$this->getServerStatus($this->socket);
				$i++;
			} while (empty($this->result) && $i < $this->retry);	# Retry, sometimes server does not respond that fast :D
			$this->closeSocket($this->socket);			# Also close the connection
		} else {
			$this->trace("Shoutcast::_constructor", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
		} # End if
		$this->trace("Shoutcast::_constructor", "_end", 0, 0);
	} # End function Shoutcast

	/**
	* Opens a connection to the server.
	*/
	function getSocket($ip, $port) {
		$this->trace ("ServerMain::_getSocket ()", "timeout: " . $this->timeout . " (=" . $this->timeout / 100000 . " sec.)", 1, 0);
		return @fsockopen($ip, $port, $this->err, $this->errmsg, $this->timeout / 100000);
	} # End function getSocket

	/**
	* Detemine player that is used by user
	*/
	function getUserAgent ($useragent) {
		$array = split ('/', $useragent);
		switch ($array[0]) {
			case "WinampMPEG":
				$return = "Nullsoft Winamp " . $array[1];
				break;
			case "NSPlayer":
				$return  = "Windows Media Player " . $array[2];
				break;
			default:
				$return = $useragent;
				break;
		} # End switch

		return $return;
	} # End function getUserAgent

	/**
	* Try to read the remote xml file.
	* @param   $row   The row object that holds the record we want to retrieve
	* @return         All properties set to the proper value
	*/
	function getServerStatus($socket) {
		global $mosConfig_absolute_path;

		$this->trace ("Shoutcast::_getServerStatus ()", "_Start", 0, 0);

		# Socket is open, initiate http GET request
		fputs($socket, "GET /admin.cgi?pass=" . $this->password. "&mode=viewxml HTTP/1.0\r\nUser-Agent: Mozilla\r\n\r\n");
		while(!feof($socket)) {
			$this->result .= fgets($socket,1024);
		} # End while

		# Check the http response code: 200 is ok, rest is rubbish
		if (!stristr($this->result, "HTTP/1.0 200 OK")) {
			$this->trace ("Shoutcast::getServerStatus ()", "ERR: invalid httpd response code", 0, 0);
			$this->result ="";
			return false;
		} # End if

		# Now we stript the http response of the result field, just find the
		# xml starting tag, and strip of all that comes in front...
		$this->result = substr($this->result, strpos ($this->result, "<?xml"));
		$this->trace ("Shoutcast::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
		$this->trace ("Shoutcast::getServerStatus ()", $this->result, 2, 1);

		# Write result into cache directory
		$file = tempnam($mosConfig_absolute_path . "/cache/", "shoutcast-stats");
		if (is_writable($mosConfig_absolute_path . "/cache")) {
			$handle = @fopen($file, "w+");
			if ($handle) {
				@fwrite($handle, $this->result);
				@fclose($handle);
			} # End if
		} else {
			$this->trace ("Shoutcast::getServerStatus ()", "ERR: directory '" . $mosConfig_absolute_path . "/cache' is not writable", 0, 0);
			$this->result ="";
			return false;
		} # End if

		# Proceed, we now readout the xml file to get the proper
		# field values.
		$this->online = true;

		# Now we use the Joomla build in xml parser to get the results...
		# First we instantiate the xml class, and read it.
		$xmldoc =& new DOMIT_Lite_Document();
		$xmldoc->resolveErrors( true );
		if (!$xmldoc->loadXML( $file, false, true )) {
			$this->trace ("Shoutcast::getServerStatus ()", "Cached xml file could not be read", 0, 0);
			$this->result ="";
			return false;							# File cannot be read
		} # End if

		# First we check the root element, this needs to contain
		# "icestats", if not we have an invalid respone.
		if ($xmldoc->documentElement->nodeName != "SHOUTCASTSERVER") {
			$this->trace ("Shoutcast::getServerStatus ()", "Invalid doctype in cached xml file (needs to be SHOUTCASTSERVER)", 0, 0);
			$this->result ="";
			return false;							# File cannot be read
		} # End if

		# Check if the document has *any* child nodes, if not exit with
		# error...
		if (!$xmldoc->documentElement->hasChildNodes()) {
			$this->trace ("Shoutcast::getServerStatus ()", "Doctype has no child nodes.", 0, 0);
			$this->result ="";
			return false;
		} # End if
		$childnodes =&$xmldoc->documentElement->childNodes;

		# Pre-check look ok, now walk thru the nodelist. The xml file
		# generated by icestats are quite simple, so no recusion of
		# node walk-thru is used, pretty straight forward...
		for ($i = 0; $i < $xmldoc->documentElement->childCount; $i++) {
			$nodename = $childnodes[$i]->nodeName;
			switch (strtolower ($nodename)) {
			case "listeners":
				# Source node holds a subset with the
				# information per listener, for shoutcast
				# this is the userdata...
				$this->numofusers = 0;
				$subnode = $xmldoc->getElementsByPath( $nodename, 1 );
				if ($subnode->hasChildNodes()) {
					$values = $subnode->childNodes;
					$j=0;
					foreach ($values as $value) {
						# The listeren subnode holds some
						# subnodes, so we have to walk thru
						# them here step by step.
						if ($value->hasChildNodes()) {
							$lvalues = $value->childNodes;
							foreach ($lvalues as $lvalue) {
								switch ($lvalue->nodeName) {
									case "CONNECTTIME";
										$uservalue = sec2time($lvalue->getText());
										break;

									case "USERAGENT";
										$uservalue = $this->getUserAgent($lvalue->getText($lvalue->getText()));
										break;
									default:
										$uservalue = $lvalue->getText();
								} # End switch
								$usernode = strtolower($lvalue->nodeName);
								$this->userinfo[$j][$usernode] = $uservalue;
							} # End foreach
						} # End if
						$j++;
					} # End foreach
					$this->numofusers = $j;
				} # End if
				break;

			case "songhistory":
				# Source node holds a subset with the
				# information per listener, for shoutcast
				# we store this information in an 
				# server variable.
				$subnode = $xmldoc->getElementsByPath( $nodename, 1 );
				if ($subnode->hasChildNodes()) {
					$values = $subnode->childNodes;
					$j=0;
					foreach ($values as $value) {
						$subnode = $value->nodeName . $sourcecounter;
						$this->serverdata["songtime" . $j] = substr ($value->getText(), 0, 10);
						$this->serverdata["songtitle" . $j] = substr ($value->getText(), 10);
						$j++;
					} # End foreach
				} # End if
				$this->serverdata['songhistorycount'] = $j;
				break;

			case "webdata":
				# we skipt the webdata here
				break;

			default:
				$this->serverdata[strtolower($nodename)] = $xmldoc->documentElement->childNodes[$i]->getText();
				break;
			} # End switch
		} # End for

		# Do some cleanup here
		unlink ($file);

		$this->trace ("Shoutcast::_getServerStatus ()", "_End", 0, 0);
		return true;
	} # End function getServerStatus

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		return $this->online;
	} # End function IsServerRunning
	
	/**
	* Returns the current number of users on the server.
	*/
	function getUsersOnline () {
		return number_format($this->numofusers);
	} # End function getUsersOnline

	/**
	* Return the maximum number of clients that may connect to this server.
	*/
	function getMaxClients () {
		return number_format($this->serverdata['maxlisteners'] , 0, "." ,"");
	} # End function getMaxClients

	/**
	* Return the operating system the server is running on.
	*/
	function getOSRunning () {
		return "Unknown";
	} # End function getOSRunning
} # End class SlowServer
?>