<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: game.BF2.php,v 0.6 2005/12/17 15:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* This file contains the variable definition for the Battle Field 2 gametype.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

$headerfields = Array();
$headervalues = Array();
$playerinfo = Array();
$shortvalues = Array();

$headerfields[] = _SERVERSTAT_NAME;
$headerfields[] = _SERVERSTAT_IP;
$headerfields[] = _SERVERSTAT_PLAYERS;
$headerfields[] = _SERVERSTAT_MAP;
$headerfields[] = _SERVERSTAT_VERSION;

$headervalues[] = $server->getHostname();
$headervalues[] = $server->serverip . ":" . getGamePort ($row);
if ($server->serverdata['maxplayers'] !=0) {
	$headervalues[] = $server->numofusers . "/" . $server->serverdata['maxplayers'] . " (" . number_format (($server->numofusers/$server->serverdata['maxplayers']) * 100, 2) . "%)";
} else {
	$headervalues[] = $server->numofusers;
} # End if
$headervalues[] = $server->getMapName();
$headervalues[] = $server->serverdata['version'];

$playerinfo['fields'] = Array ('playername', 'score', 'ping');
$playerinfo['headers'] = Array (_SERVERSTAT_PLAYER, _SERVERSTAT_SCORE, _SERVERSTAT_PING);
$playerinfo['transform'] = Array (1, 0, 0);

# The values for the short status
$shortvalues[] = $server->getHostname();
$shortvalues[] = $server->getMapName();
if ($server->serverdata['maxplayers'] !=0) {
	$shortvalues[] = $server->numofusers . "/" . $server->serverdata['maxplayers'] . " (" . number_format (($server->numofusers/$server->serverdata['maxplayers']) * 100, 2) . "%)";
} else {
	$shortvalues[] = 0;
} # End if?>