<?php
/**
* Serverstatus 0.6 for Mambo 4.5.2 CMS 
* @version $Id: _template.trace.php,v 0.6 2005/12/22 18:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* This file contains the serverstat template for the trace option of Serverstat.
* The template is rendered when requested, and is rendered seperatly of the
* servertype used.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.*/

/**
* Let me explain what we are going to do here. The default mambo code uses 
* an static reference to the style sheet used for tabs in forms. Here we 
* inherit the mosTabs class, and change the constructor for using an template 
* dependend style sheet. If the style has no tabbed stylesheet present, we use
* the default stylesheet.
*/
class mosTabsModified extends mosTabs {
	/**
	* Constructor
	* Includes files needed for displaying tabs and sets cookie options
	* @param int useCookies, if set to 1 cookie will hold last used tab between page refreshes
	*/
	function mosTabsModified($useCookies) {
		global $mosConfig_live_site, $mosConfig_absolute_path, $cur_template;

		if (file_exists( $mosConfig_absolute_path. "/templates/". $cur_template ."/css/tabpane.css" )) {
			echo "<link id=\"luna-tab-style-sheet\" type=\"text/css\" rel=\"stylesheet\" href=\"" . "templates/". $cur_template ."/css/tabpane.css\"/>";
		} else {
			echo "<link id=\"luna-tab-style-sheet\" type=\"text/css\" rel=\"stylesheet\" href=\"" . $mosConfig_live_site. "/includes/js/tabs/tabpane.css\" />";
		} # End if
		echo "<script type=\"text/javascript\" src=\"". $mosConfig_live_site . "/includes/js/tabs/tabpane.js\"></script>";
		$this->useCookies = $useCookies;
	} # End function mosTabsModified
} # End class mosTabsModified 

$tabs = new mosTabsModified(1);

if ($server->IsServerRunning ()) {
	$status = '<font color="#008000">Online</font>';
} else {
	$status = '<font color="red">Offline</font>';
} # End if

global $serverstat_classtreshhold;

?>

<table width="100%" border="0" class="contentpaneopen" cellspacing="5" cellpadding="0">
<tr valign="top">
<td width="100%">
	<?php
	$tabs->startPane("server-pane");
	$tabs->startTab(_SERVERSTAT_BUTTON_TRACESERVER,"server-page");
	?>
	<table width="100%">
	<tr valign="top">
	<td width="50%">
		<table class="contentpaneopen">
		<tr valign="top">
			<td class="componentheading" colspan="2"align="left"><?php echo _SERVERSTAT_FRONTHEADER_STATS_SERVERDETAILS; ?></th>
		</tr>
		<tr valign="top">
			<td nowrap><strong><?php echo _SERVERSTAT_DETAILS_SERVERNAME; ?></strong></td>
			<td><?php echo $row->servername; ?></td>
		</tr>
		<tr valign="top">
			<td nowrap><strong><?php echo _SERVERSTAT_DETAILS_IP; ?></strong></td></td>
			<td><?php echo $row->ip; ?></td>
		</tr>
		<tr valign="top">
			<td nowrap><strong><?php echo _SERVERSTAT_DETAILS_PORT; ?></strong></td>
			<td><?php echo $row->port; ?></td>
		</tr>
		<tr valign="top">
			<td nowrap><strong><?php echo _SERVERSTAT_DETAILS_PORT1; ?></strong></td>
			<td><?php echo $row->port1; ?></td>
		</tr>
		</table>
	</td>
	<td width="50%">
		<table class="contentpaneopen">
		<tr valign="top">
			<td class="componentheading" colspan="2"align="left"><?php echo _SERVERSTAT_FRONTHEADER_STATS_PUBLISHINGINFO; ?></td>
		</tr>
		<tr valign="top">
			<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_SERVERID; ?></strong></td>
			<td align="left"><?php echo $row->id; ?> </td>
		</tr>
		<tr valign="top">
			<td width="90px" align="left"><strong><strong><?php echo _SERVERSTAT_PUBLISHED_STATE; ?></strong></td>
			<td align="left">
			<?php echo $row->published > 0 ? 'Published' : 'Unpublished';?>
			</td>
		</tr>
		<tr valign="top">
			<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_VIEWS; ?></strong></td>
			<td align="left"><?php echo $row->views; ?> </td>
		</tr>
		<tr valign="top">
			<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_HITS; ?></strong></td>
			<td align="left"><?php echo $row->hits; ?> </td>
		</tr>
		<tr valign="top">
			<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_THRESHOLDCOUNTER; ?></strong></td>
			<td align="left"><?php echo $row->tcounter; ?> </td>
		</tr>
		<tr valign="top">
			<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_CREATED; ?></strong></td>
			<td align="left"><?php echo mosFormatDate( $row->created, '%Y-%m-%d %H:%M:%S' ); ?> </td>
		</tr>
		<tr valign="top">
			<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_CREATEDBY; ?></strong></td>
			<td align="left"><?php echo empty($row->creator) ? '-' : $row->creator ; ?> </td>
		</tr>
		<tr valign="top">
			<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_LASTMODIFIED; ?></strong></td>
			<td align="left"><?php echo mosFormatDate( $row->modified, '%Y-%m-%d %H:%M:%S' ); ?> </td>
		</tr>
		<tr valign="top">
			<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_MODIFIEDBY; ?></strong></td>
			<td align="left"><?php echo empty($row->modifier) ? '-' : $row->modifier ; ?> </td>
		</tr>
		<tr valign="top">
			<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_CURRENTSTATUS; ?></strong></td>
			<td align="left"><?php echo $status; ?> </td>
		</tr>
		</table>
	</td>
	</tr>
	<tr>
		<td colspan="2" width="100%"><br /><?php echo _SERVERSTAT_TRACE_PRERESULTS; ?><br /><br /></td>
	</tr>
	<tr valign="top">
		<td align="left"><strong><?php echo _SERVERSTAT_TRACE_HOSTCHECK; ?></strong></td>
		<td>
		<?php
		$lookup = gethostbyname($row->ip);
		if ($lookup == $row->ip) {
			echo "<font color=\"green\">" . _SERVERSTAT_TRACE_IP_SAME . "</font>";
		} else {
			$reverselookup = gethostbyaddr($lookup);
			if ($reverselookup != $row->ip) {
				echo "<font color=\"red\"><strong>" . _SERVERSTAT_TRACE_IP_DIFFER . "</strong></font><br />";
				echo _SERVERSTAT_TRACE_IP_LOOKUP . "<br><small><i><b>$lookup</i></i></small><br /><br />";
				echo _SERVERSTAT_TRACE_IP_REVERSELOOKUP . "<br><small><i><b>$reverselookup</b></i><small><br />";
			} else {
				echo "<font color=\"green\">" . _SERVERSTAT_TRACE_IP_OK . "</font>";
			} # End if
		} # End if
		?>
		</td>
	</tr>
	<tr valign="top">
		<td align="left"><strong><?php echo _SERVERSTAT_TRACE_CLASSTIMING; ?></strong></td>
		<td>
		<?php
		for ($j=0; $j<count($serverstat_classtreshhold); $j++) {
			$color = $serverstat_classtreshhold[$j][1];
			if ($server->getClassTiming() < $serverstat_classtreshhold[$j][0]) {
				break;
			} # End if
		} # End for
		echo "<font color=\"$color\">" . number_format($server->getClassTiming(), 5) . "</font>";
		?>
	</tr>
	</table>
	<?php
	$tabs->endTab();
	$tabs->startTab(_SERVERSTAT_BUTTON_TRACEDETAILS,"trace-page");
	?>
	<table width="100%">
	<tr>
		<th class="componentheading" width="100%"><?php echo _SERVERSTAT_TRACEHEADER; ?></th>
	</tr>
	</table>

	<table width="100%" cellspacing="0" cellpadding="5" class="contentpane">
		<tr><td colspan="4" align="left"><?php echo _SERVERSTAT_TRACE_INFO ?></th>
		</tr>
		<?php
		?>
		<tr>
			<td width="2%" align="left" class="sectiontableheader"><?php echo _SERVERSTAT_TRACE_NR ?></td>
			<td width="5%" align="left" class="sectiontableheader"><?php echo _SERVERSTAT_TRACE_TIME ?></td>
			<td width="5%" align="left" class="sectiontableheader"><?php echo _SERVERSTAT_TRACE_METHOD ?></td>
			<td width="5%" align="left" class="sectiontableheader"><?php echo _SERVERSTAT_TRACE_INFORMATION ?></td>
		</tr>
		
		<?php
		# Now walkt thru the debug array, and render all information
		$currenttime = 0;
		for ($i=0; $i < count($server->debug_log); $i++) {
			?>
			<tr>
				<td width="2%"><?php echo $i; ?>.</td>
				<td width="5%" align="left">
				<?php
				if ($i > 0) {
					echo number_format($server->debug_log[$i]['time'] - $currenttime, 5);
				} else {
					$firsttime = $server->debug_log[$i]['time'];
					echo "-";
				} # End if
				?>
				</td>
				<td nowrap width="23%"><?php echo $server->debug_log[$i]['method']; ?></td>
				<td nowrap width="70%">
				<?php 
				if ($server->debug_log[$i]['type'] == 0) {
					echo $server->debug_log[$i]['string'];
				} else {
					echo hexdump ($server->debug_log[$i]['string'], $htmloutput = true, $uppercase = false, $return = false);
				} # End if
				$currenttime = $server->debug_log[$i]['time'];
				?>
				</td>
			</tr>
			<?php
		} # End for

		?>
		<tr>
			<th colspan="4" align="left"><strong><?php echo _SERVERSTAT_TRACE_TOTALTIME . number_format($currenttime - $firsttime, 5); ?></strong></th>
		</tr>
	</table>
	<?php
	$tabs->endTab();
	$tabs->startTab(_SERVERSTAT_BUTTON_TRACEPHP,"php-page");
	?>
	<table width="100%" cellspacing="5" cellpadding="0">
	<tr>
		<th colspan="4" class="componentheading" width="100%"><?php echo _SERVERSTAT_TRACEHEADERPHP; ?></th>
	</tr>
	<tr>
		<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_INI_SAFEMODE; ?></strong></td>
		<td><?php echo ini_get('safe_mode') ? "on" : "off"; ?></td>
		<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_INI_MAXEXECUTIONTIME; ?></strong></td>
		<td><?php echo ini_get('max_execution_time'); ?></td>
	</tr>
	<tr>
		<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_INI_MAXINPUTTIME; ?></strong></td>
		<td><?php echo ini_get('max_input_time'); ?></td>
		<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_INI_MEMORYLIMIT; ?></strong></td>
		<td><?php echo ini_get('memory_limit'); ?></td>
	</tr>
	<tr>
		<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_INI_FILEUPLOADS; ?></strong></td>
		<td><?php echo ini_get('file_uploads') ? "on" : "off"; ?></td>
		<td align="left"><strong><?php echo _SERVERSTAT_PUBLISHED_INI_UPLOADMAXFILESIZE; ?></strong></td>
		<td><?php echo ini_get('upload_max_filesize'); ?></td>
	</tr>
	</table>
	<?php
	$tabs->endTab();
	$tabs->endPane();
	?>
</td>
</tr>
</table>
