<?php
/**
* @version $Id: mod_serverstat.php,v 0.6.1 2006/01/21 11:35:00 wilcojansen Exp $
* @package Serverstat
*
* LICENSE
* =======
* Copyright (C) 2005/2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once ( $mosConfig_absolute_path."/administrator/components/com_serverstat/includes/function.serverstat.php");
require ( $mosConfig_absolute_path."/administrator/components/com_serverstat/config/config.serverstat.php");

# Load language file
$map = $mosConfig_absolute_path . '/administrator/components/com_serverstat';

if (file_exists($map.'/language/'.$mosConfig_lang.'.php')) {
	require_once ($map.'/language/'.$mosConfig_lang.'.php');
} elseif (file_exists($map.'/language/english.php'))  {
	require_once ($map.'/language/english.php');
} else {
	die ( 'Language file not present...' );
}# End if

# Yes, we want an overlib effect here :D
mosCommonHTML::loadOverlib();

$individual = number_format($params->get( 'individual' ));
$shortstatus = number_format($params->get( 'shortstatus' ));

# Handle the extra option to show the short server status
switch ($individual) {
case 1:	# before
	showServerStatusShort ( $params, $database );
	if ($shortstatus) showServerStatusList( $database );
	break;
case 2: # after
	if ($shortstatus) showServerStatusList( $database );
	showServerStatusShort ( $params, $database );
	break;
default:
	if ($shortstatus) showServerStatusList( $database );
	break;
} # End switch

/*
* Show a collection of servers, but then the short status.
*/
function showServerStatusShort ( $params, $database ) {
	global $mosConfig_absolute_path, $mosConfig_live_site;

	$servers = split ( ";", $params->get ( 'servers' ) );
	if (count ($servers) == 0 ) return;

	for ($i=0; $i < count ($servers); $i++) {
		# Yes, this is an very simple query...we start the 
		$database->setQuery( "SELECT * FROM #__serverstat_servers"
		. "\nWHERE id=" . $servers[$i]
		. "\nORDER BY ordering"
		);
		$rows = $database->loadObjectList();

		if (count($rows) == 1) {
			echo "<table width=\"100%\" cellspacing=\"0\" cellpadding=\"1\">";
			$row = $rows[0];

			$server = instantiateServerClass ( $row , false, true);
			if (!$server) {
				echo _SERVERSTAT_CLASSNOTFOUND;
			} else 	{
				$file = $mosConfig_absolute_path . "/administrator/components/com_serverstat/includes/game." . $row->servertype . ".php";
				if (!file_exists($file)) { ?>
					<tr><td align="center"><?php echo _SERVERSTAT_GAMETYPENOTSUPPORTED; ?> </td></tr>
					<?php
					return;
				} # End if
				include ($file);

				$url = $mosConfig_live_site . "/index.php?option=com_serverstat&task=view&id=" . $row->id;

				$width = $params->get( 'width', 0 );
				$height = $params->get( 'height', 0 );
				?>

				<tr valign="top">
				<td colspan="3">
					<table border="0" cellspacing="0" cellpadding="0" width="100%">
					<tr><td>
						<a href="<?php echo $url; ?>">
						<img src="<?php echo getImagePath ($row, $server); ?>" align="middle" <?php if ($width !=0) echo " width=\"$width\""; if ($height !=0) echo " height=\"$height\""; ?> border="0" align="left">
						</a>
					</td></tr>
					</table>
				</td>
				</tr>
				<?php
				if ($server->IsServerRunning ()) {
					for ($j=0; $j < count($shortvalues); $j++) {
						echo "<tr valign=\"top\">\n";
						echo "<td align=\"center\" colspan=\"3\"><small>" . $shortvalues[$j] . "</small></td>\n";
						echo "</tr>\n";
					} # End for
				} else {
					$text = str_replace ('[servername]', $row->servername, _SERVERSTAT_OFFLINE);
					$text = str_replace ('[ip]', $row->ip, $text);
					$text = str_replace ('[port]', $row->port, $text);
					?>
					<tr><td align="left" colspan="2"><small><?php echo $text; ?></small></td></tr>
					<?php
				} # End if
			} # End if
		} # End if
		echo "<tr><td>&nbsp;</td></tr>";
		echo "</table>\n";
	} # End for
} # End function showServerStatusShort

/*
* Function that renders the published servers, and their running status,
* including a tooltip.
*/
function showServerStatusList ( $database ) {
	global $mosConfig_live_site, $serverstat_threshold;

	# Yes, this is an very simple query...we start the 
	$database->setQuery( "SELECT * FROM #__serverstat_servers"
	. "\nWHERE published > 0"
	. "\nORDER BY ordering"
	);
	$rows = $database->loadObjectList();

	if (count($rows) != 0) {
		# Start buidling the information here...
		echo "<table width=\"100%\" cellspacing=\"0\" cellpadding=\"1\">";
		for ($i=0; $i < count( $rows ); $i++) {
			$row = &$rows[$i];
			echo  "<tr>\n";

			# Render the server image
			$image = trim($row->image);
			if (empty($image)) {
				$image  = getServerConfigVar ($row, "icon");
			} # End if
			echo "<td width=\"3%\"><img src=\"" . $mosConfig_live_site . "/administrator/components/com_serverstat/images/" . $image . "\"></td>";

			# Here we handle the server name, and online server status. If the 
			# tcounter value exceeds the config treshold, and we do not have an
			# interval check, we just skip the online status check for this
			# server.
			$url = "index.php?option=com_serverstat&task=view&id=" . $row->id;
			if ($row->tcounter > $serverstat_threshold && ($row->views % $serverstat_threshold !=0) && $serverstat_threshold !=0) {
				$tooltip = _SERVERSTAT_UNKNOWN;
				$imagestatus = "unknown.gif";
			} else {
				# Instantiate the server class.
				if (!$server = instantiateServerClass ( $row , false, true)) {
					Die (str_replace ("[class]", $row->servertype, _SERVERSTAT_CLASSNOTFOUND));
				} # End if

				# Handle the on/offline status.
				if ($server->IsServerRunning ()) {
					$imagestatus = "online.gif";
					if ($server->getUsersOnline () == 1) {
						$tooltip = str_replace ('[numofusers]', number_format ($server->getUsersOnline ()), _SERVERSTAT_ONLINE_ONE);
					} else {
						$tooltip = str_replace ('[numofusers]', number_format ($server->getUsersOnline ()), _SERVERSTAT_ONLINE_MORE);
					} # End if
					$tooltip = str_replace ('[os]', $server->getOSRunning(), $tooltip);

					# reset offline counter
					$database->setQuery( "UPDATE #__serverstat_servers"
					. "\nSET tcounter=0"
					. "\nWHERE id=".$row->id
					);

					if (!$database->query()) {
						die ("Error resetting tcounter for gameserver : " . $row->id);
					} # End if
				} else {
					$imagestatus = "offline.gif";
					$tooltip = _SERVERSTAT_OFFLINE;

					# increment offline counter
					$database->setQuery( "UPDATE #__serverstat_servers"
					. "\nSET tcounter=tcounter+1"
					. "\nWHERE id=".$row->id
					);

					if (!$database->query()) {
						die ("Error updating tcounter for gameserver : " . $row->id);
					} # End if
				} # End if
			} # End if

			$tooltip = str_replace ('[servername]', $row->servername, $tooltip);
			$tooltip = str_replace ('[ip]', $row->ip, $tooltip);
			$tooltip = str_replace ('[port]', $row->port, $tooltip);
			echo "<td>" . mosToolTip( $tooltip, $title=$row->servername, $width='', $image='tooltip.png', $text=$row->servername, $href=$url) . "</td>";
			echo "<td><img src=\"" . $mosConfig_live_site . "/administrator/components/com_serverstat/images/" . $imagestatus . "\"></td>";
			echo "</tr>\n";
	
			# update views link for this server
			$database->setQuery( "UPDATE #__serverstat_servers"
			. "\nSET views=views+1"
			. "\nWHERE id=".$row->id
			);
	
			if (!$database->query()) {
				die ("Error updating views count for gameserver : " . $row->id);
			} # End if
		} # End for
		echo "</table>\n";
	} else {
		echo _SERVERSTAT_NOSERVERS;
	} # End if
	echo "<br />";
} # End function showServerStatusList
?>