<?php
/**
* @version $Id: mod_serverstatindividual.php,v 0.6 2005/12/17 22:30:00 wilcojansen Exp $
* @package Serverstatindividual
* @copyright (C) 2005 Wilco Jansen
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

# Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once ( $mosConfig_absolute_path."/administrator/components/com_serverstat/includes/function.serverstat.php");
require( $mosConfig_absolute_path."/administrator/components/com_serverstat/config/config.serverstat.php");

# Load language file
$map = $mosConfig_absolute_path . '/administrator/components/com_serverstat';

if (file_exists($map.'/language/'.$mosConfig_lang.'.php')) {
	require_once ($map.'/language/'.$mosConfig_lang.'.php');
} elseif (file_exists($map.'/language/english.php'))  {
	require_once ($map.'/language/english.php');
} else {
	die ( 'Language file not present...' );
}# End if

# Determine module parameters
$id = $params->get( 'id', 1 );
$width = $params->get( 'width', 0 );
$height = $params->get( 'height', 0 );
$moduleclass_sfx = $params->get( 'moduleclass_sfx', "" );
$randomizer = $params->get( 'randomizer', 0 );

# If randomizing is enabled, just read out all id's, and select a random id
# to render. When disabled (0) just go on...
if ($randomizer == 1) {
	# read record from database, of not found render an error message
	# Yes, this is an very simple query...
	$database->setQuery( "SELECT id FROM #__serverstat_servers"
	. "\nWHERE published=1"
	);
	$rows = $database->loadObjectList();

	switch (count($rows)) {
		case 0:
		case 1:
			break;

		default:
			$i = number_format(mt_rand ( 1, count ($rows))) - 1;
			$id = $rows[$i]->id;
			break;
	} # End switch		
} # End if

# read record from database, of not found render an error message
# Yes, this is an very simple query...
$database->setQuery( "SELECT * FROM #__serverstat_servers"
. "\nWHERE id = $id"
);
$rows = $database->loadObjectList();

if (count($rows) != 1) {
	echo _SERVERSTAT_NOSERVER;
} else {
	$row = $rows[0];

	$server = instantiateServerClass ( $row , false, true);
	if (!$server) {
		echo _SERVERSTAT_CLASSNOTFOUND;
	} else 	{
		# Ok, we know which server we have here, so we include the template
		# that comes with the server provided.
		$template = $row->template;
		if (empty($template)) {
			$template = getServerConfigVar ($row, "template") . ".php";
		} # End if
		$include = $mosConfig_absolute_path. "/modules/mod_serverstatindividual/" . $template;
		if (file_exists($include) && !is_dir($include)) {
			?>
			<table width="90%" border="0" class="contentpaneopen<?php echo $moduleclass_sfx; ?>">
			<?php
			require_once( $include);
			?>
			</table>
			<?php
		} else {
			echo _SERVERSTAT_ERRTEMPLATE;
		} # End if
 	} # End if
} # End if
?>