<?php
/**
 * Core Design Chili Code plugin for Joomla! 1.5
 * @author      Daniel Rataj, <info@greatjoomla.com>
 * @package     Joomla
 * @subpackage	Content
 * @category    Plugin
 * @version     1.0.4
 * @copyright	Copyright (C) 2007 - 2010 Great Joomla!, http://www.greatjoomla.com
 * @license		http://www.gnu.org/copyleft/gpl.html GNU/GPL 3
 * 
 * This file is part of Great Joomla! extension.   
 * This extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This extension is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// Import library dependencies
jimport('joomla.plugin.plugin');
jimport('joomla.filesystem.file');
// end

class plgContentCdChilicode extends JPlugin
{

	/**
	 * Constructor
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @param object $subject The object to observe
	 * @param object $params  The object that holds the plugin parameters
	 * @since 1.5
	 */
	function plgContentCdChilicode(&$subject)
	{
		parent::__construct($subject);

		$this->plgname = 'cdchilicode';
		$this->plugin = &JPluginHelper::getPlugin('content', $this->plgname);
		$this->params = new JParameter($this->plugin->params);
	}

	/**
	 * Call the Chilicode function
	 *
	 * Method is called by the view
	 *
	 * @param 	object		The article object.  Note $article->text is also available
	 * @param 	object		The article params
	 * @param 	int			The 'page' number
	 */
	function onPrepareContent(&$article, &$params, $limitstart)
	{
		// regular expression
		$languages = array();
		$languages []= 'js';
		$languages []= 'php';
		$languages []= 'mysql';
		$languages []= 'html';
		$languages []= 'java';
		$languages []= 'cplusplus';
		$languages []= 'csharp';
		$languages []= 'delphi';
		$languages []= 'lotusscript';
		$languages []= 'css';
		$languages []= 'none';
		
		$regex = "#{chilicode(?:\s?(" . implode("|", $languages) . ")?\s?(content|file)?)?}(.*?){/chilicode}#is";

		if (!preg_match($regex, $article->text)) return false;
		
		// load language
		JPlugin::loadLanguage('plg_content_' . $this->plgname, JPATH_ADMINISTRATOR);
		
		// Scriptegrator check
		if (!class_exists('JScriptegrator')) {
			JError::raiseNotice('', JText::_('CHILICODE_ENABLE_SCRIPTEGRATOR'));
			return false;
		} else {
			$message = JScriptegrator::check('1.4.0', 'jquery', 'site');
			if ($message)  {
			   JError::raiseNotice('', $message);
			   return false;
      		}
		}
		
		// load head JS and CSS
		$live_path = JURI::base(true) . '/'; // define live site
		$document = &JFactory::getDocument();

		$lineNumbers = (int)$this->params->get('lineNumbers', 1);
		if ($lineNumbers) {
			$lineNumbers = 'true';
		} else {
			$lineNumbers = 'false';
		}
		
		$cd_chili_jQuery_chili_script ='
		<script type="text/javascript">
		ChiliBook.automatic = true;
		ChiliBook.lineNumbers = ' . $lineNumbers . ';
		ChiliBook.recipeFolder = "' . $live_path . 'plugins/content/cdchilicode/js/chilicode/";
		</script>';
		$document->addScript($live_path .
	            'plugins/content/' . $this->plgname . '/js/chilicode/jquery.chili.js');
		$document->addCustomTag($cd_chili_jQuery_chili_script);
		
		$document->addStyleSheet($live_path . 'plugins/content/' . $this->plgname . '/css/cdchilicode.css', 'text/css');
		
		// Explication:
		// $match[1]	-> code
		
		// replacement {chilicode}{/chilicode}
		$article->text = preg_replace_callback($regex, array($this, 'replacer'), $article->text);
	}

	/**
	 * Replacer
	 *
	 * @param	array
	 * @return	string
	 */
	function replacer(&$match)
	{
		$absolute_path = dirname(dirname(dirname(__FILE__))); // define absolute path

		// load database parameters
		$directory = $this->params->get('directory', 'images/stories');
		$default_lang = $this->params->get('default_lang', 'php');
		$default_source = $this->params->get('default_source', 'php');
		// end

		$lang = $default_lang; // lang not defined
		if ($match[1])$lang = $match[1];
		
		$source = $default_source; // code not defined
		if ($match[2]) $source = $match[2];
		
		$code = ''; // code not defined
		if ($match[3]) {
			$code = $match[3];
			$code = strip_tags(str_replace(array('<br />'), "\n", trim($code)));
			
		}
		
		switch ($source)
		{
			case 'content':
					
				if ($lang === 'none') {
					return '<pre class="cdchilicode_pre_block"><code>' . $code . '</code></pre>';
				} else {
					return '<pre class="cdchilicode_pre_block"><code class="' . $lang .
                    '">' . $code . '</code></pre>';
				}

				return '<pre class="cdchilicode_pre_block"><code class="' . $lang .
                '">' . $code . '</code></pre>';
				break;
				
			case 'file':

				// check if path to the file is defined
				if (!$code) {
					JError::raiseNotice('', JText::_('CHILICODE_NO_PATH'));
					return false;
				}

				$source_path = JPath::clean($absolute_path . DS . $directory . DS . $code);
				
				if (JFile::exists($source_path)) {
					$content = JFile::read($source_path);

					return '<pre class="cdchilicode_pre_block"><code class="' . $lang .
                    '">' . $content . '</code></pre>';
				} else {
					JError::raiseNotice('', JText::_('CHILICODE_NO_FILE'));
					return false;
				}

				break;
				
			default:
				return '<pre class="cdchilicode_pre_block"><code class="' .
				$lang . '">' . $code . '</code></pre>';
				break;
		}
	}
}
?>
