<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.ASE.class.php,v 0.6 2005/12/17 21:15:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Class that holds the specific code for retrieving the status for gameservers
* using the Ase protocol. Parts of the code have been taken from the KjStat
* v0.87 (beta, public) package that was developed by Sam 'KingJackaL' Evans.
* (This class has been altered quite a lot for usage within Serverstat)
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class Ase extends ServerMain {
	/**
	* Properties.
	*/
	var $serverip = "localhost";						# Ip addr for server to query
	var $port = "29253";							# Port to query
	var $timeout = 160000;							# Timeout in microsecond
	var $retry = 3;

	var $socket = "";							# Socket var...
	var $err = 0;								# Error code, set when an error has occured
	var $errmsg = "";							# Error message...

	var $result = "";							# The result of a status request to the gameserver
	var $serverdata = Array();						# Contains server information
	var $userinfo = Array();						# Contains player information
	var $numofusers = 0;							# Number of players on server

	var $playervars = Array();

	/**
	* Constructor.
	*/
	function Ase ($serverip, $port, $debug, $retrycount, $timeout, $servertype) {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if

		$this->playervars = $this->_getPlayerVars($servertype);

		# Here we go!
		$this->trace("Ase::_constructor", "serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;                                    # Initialize properties
		$this->port = $port;
		$this->result = "";						# Contains server respons data

		$this->socket = $this->getSocket($this->serverip, $this->port);
		if ($this->socket) {
			$i=0;
			do {
				$this->getServerStatus($this->socket);
				$i++;
			} while (empty($this->result) && $i < $this->retry);	# Retry, sometimes server does not respond that fast :D
			$this->closeSocket($this->socket);			# Also close the connection
		} else {
			$this->trace("Ase::_constructor", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
		} # End if
	} # End constructor Gamespy

	/*
	* Additional variables to handle Ase header logic. We have values per game
	* here to determine the proper values.
	*/
	function _getPlayerVars ($servertype) {
		$Asevars = Array ('AA'    => Array ('leader' => 'leader', 'goal' => 'goal', 'honor' => 'honor', 'player' => 'name', 'ping' => 'ping', 'roe' => 'roe', 'kia' => 'kia', 'enemy' => 'score'),
		                       'BFV'   => Array ('player' => 'name', 'score' => 'score', 'deaths' => 'deaths', 'ping' => 'ping', 'team' => 'team', 'kills' => 'kills'),
                                       'BF2'   => Array ('player' => 'name', 'score' => 'score', 'ping' => 'ping', 'team' => 'team', 'deaths' => 'kills', 'pid' => 'pid', 'skill' => 'skill'),
                                       'HALO'  => Array ('player' => 'name', 'score' => 'score', 'ping' => 'ping', 'team' => 'team'),
                                      );

		reset ($Asevars);
		$gs2="";
		while (list($server, $element) = each($Asevars)) {
			if ($server == $servertype) {
				$gs2 = $element;
			} # End if
		} # End while
		
		return $gs2;
	} # End function _getPlayerVars

	/**
	* Initiates a status call to the server.
	* Returns true if successfull, false if an error occured
	*/
	function getServerStatus($socket) {
		$this->trace ("Ase::_getServerStatus ()", "", 0, 0);

		# configure stream
		socket_set_blocking ($socket, true);				# Set blocking mode...wait until we have an reaction
		socket_set_timeout ($socket, $this->timeout / 100000);		# Set the timeout (in microseconds here!)

		# And interact with the gameserver to get the server vars
		$command = "\x73";						# Command to interact with gameserver
		$this->trace ("Ase::getServerStatus ()", "Starting server interaction", 1, 1);
		$this->trace ("Ase::getServerStatus ()", $command, 1, 1);
		fwrite($socket, $command);					# Interact with command

		if (!($this->result = @fread($socket, 4096))) {
			$this->err = 110;
			$this->errmsg = "No data from stream";
			$this->trace ("Ase::getServerStatus ()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg , 0, 0);
			return false;
		} # End if

		$this->trace ("Ase::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
		$this->trace ("Ase::getServerStatus ()", $this->result, 2, 1);

		$j = 0;
		if(substr($this->result, $j, 4) != 'EYE1') {
			$this->err = 120;
			$this->errmsg = "Bad ping response";
			$this->trace ("Ase::getServerStatus ()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg , 0, 0);
			return false;
		} # End if

		$j = $j + 4;

		# Now we try to get all server variables...
		$gamelength = ord($this->result[$j]);
		$gamevalue = substr($this->result, $j + 1, $gamelength - 1);
		$j += $gamelength;						# shift off gamename
		$this->serverdata['gamename'] = $gamevalue;

		$portlength = ord($this->result[$j]);
		$portvalue = substr($this->result, $j + 1, $portlength - 1);
		$j += $portlength;						# shift off port
		$this->serverdata['gameport'] = $portvalue;

		$namelength = ord($this->result[$j]);
		$namevalue = substr($this->result, $j + 1, $namelength - 1);
		$j += $namelength;						# shift off name
		$this->serverdata['name'] = $namevalue;

		$gametypelength = ord($this->result[$j]);
		$gametypevalue = substr($this->result, $j + 1, $gametypelength - 1);
		$j += $gametypelength;						# shift off gametype
		$this->serverdata['gametype'] = $gametypevalue;

		$maplength = ord($this->result[$j]);
		$mapvalue = substr($this->result, $j + 1, $maplength - 1);
		$j += $maplength;						# shift off current map playing
		$this->serverdata['map'] = $mapvalue;

		$versionlength = ord($this->result[$j]);
		$versionvalue = substr($this->result, $j + 1, $versionlength - 1);
		$j += $versionlength;						# shift off version of server
		$this->serverdata['version'] = $versionvalue;

		$passwordlength = ord($this->result[$j]);
		$passwordvalue = substr($this->result, $j + 1, $passwordlength - 1);
		$j += $passwordlength;						# shift off password protected server
		$this->serverdata['password'] = $passwordvalue;

		$playerslength = ord($this->result[$j]);
		$playersvalue = substr($this->result, $j + 1, $playerslength - 1);
		$j += $playerslength;						# shift off number of players
		$this->serverdata['num_total'] = $playersvalue;

		$slotslength = ord($this->result[$j]);
		$slotsvalue = substr($this->result, $j + 1, $slotslength - 1);
		$j += $slotslength;						# shift off slots (max number of players)
		$this->serverdata['num_avail'] = $slotsvalue;

		$infodone = false;
		while(!($infodone)) {
			$settinglength = ord($this->result[$j]);
			$settingvalue = substr($this->result, $j + 1, $settinglength - 1);
			$j += $settinglength;					# shift off setting name

			if ($settinglength == 1) { 				# end of info
				$infodone = true;
				continue;
			} # End if

			$valuelength = ord($this->result[$j]);
			$valuevalue = substr($this->result, $j + 1, $valuelength - 1);
			$j += $valuelength; 					# shift off setting value

			if ($settingvalue != " ") {
				$this->serverdata[$settingvalue] = $valuevalue;
			} # End if
		} # End while

		# Parse player data
		$this->numofusers = $playersvalue;
		for($i = 0; $i < $playersvalue; $i++) {
			$this->userinfo[$i] = array();

			$playerflag = ord($this->result[$j++]);

			if (($playerflag & 1) == 1) { 				# starts with playername
				$namelength = ord($this->result[$j]);
				$namevalue = substr($this->result, $j + 1, $namelength - 1);
				$j += $namelength;			# shift off playername
				$this->userinfo[$i]['name'] = $namevalue;
			} # End if

			if (($playerflag & 2) == 2) {				# now team name
				$teamlength = ord($this->result[$j]);
				$teamvalue = substr($this->result, $j + 1, $teamlength - 1);
				$j += $teamlength;			# shift off team name

				if ($givesTeamStats) {
					if ($teamvalue == $team1) {
						array_key_exists('num_team1', $totalsarray) ? $totalsarray['num_team1']++ : $totalsarray['num_team1'] = 1;
						$this->userinfo[$i]['team'] = 1;
					} else if ($teamvalue == $team2) {
						array_key_exists('num_team2', $totalsarray) ? $totalsarray['num_team2']++ : $totalsarray['num_team2'] = 1;
						$this->userinfo[$i]['team'] = 2;
					} else {
						array_key_exists('num_others', $totalsarray) ? $totalsarray['num_others']++ : $totalsarray['num_others'] = 1;
						$this->userinfo[$i]['team'] = 0;
					} # End if
				} else {
					$this->userinfo[$i]['team'] = $teamvalue;
				} # End if
			} # End if

			if (($playerflag & 4) == 4) { 				# now skin
				$skinlength = ord($this->result[$j]);
				$skinvalue = substr($this->result, $j + 1, $skinlength - 1);
				$j += $skinlength; 			# shift off skin
				$this->userinfo[$i]['skin'] = $skinvalue;
			} # End if

			if (($playerflag & 8) == 8) { 				# now score
				$scorelength = ord($this->result[$j]);
				$scorevalue = substr($this->result, $j + 1, $scorelength - 1);
				$j += $scorelength; 			# shift off score
				$this->userinfo[$i]['score'] = $scorevalue;
			} # End if

			if (($playerflag & 16) == 16) { 			# now ping
				$pinglength = ord($this->result[$j]);
				$pingvalue = substr($this->result, $j + 1, $pinglength - 1);
				$j += $pinglength; 			# shift off ping
				$this->userinfo[$i]['ping'] = $pingvalue;
			} # End if

			if (($playerflag & 32) == 32) { // now time
				$timelength = ord($this->result[$j]);
				$timevalue = substr($this->result, $j + 1, $timelength - 1);
				$j += $timelength; // shift off time
				$this->userinfo[$i]['time'] = $timevalue;
			} # End if
		} # End for

		return true;
	} # End function getServerStatus

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		$this->trace ("Ase::_IsServerRunning ()", "", 0, 0);

		if (!empty($this->result)) {
			return true;
		} else {
			return false;
		} # End if
	} # End function IsServerRunning 

	/**
	* Return the maximum number of clients that may connect to this server.
	*/
	function getMaxClients () {
		$this->trace ("Ase::_getMaxClients ()", "", 0, 0);
		return number_format($this->serverdata['num_avail']);
	} # End function getMaxClients
} # End class Gamespy
?>