<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.HL1.class.php,v 0.6 2005/12/17 21:15:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Class that holds the specific game code for an Half Life gameserver. Parts
* of the code have been taken from the KjStat v0.87 (beta, public) package
* that was developed by Sam 'KingJackaL' Evans.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class HL extends ServerMain {
	/**
	* Properties.
	*/
	var $serverip = "localhost";						# Ip addr for server to query
	var $port = "29253";							# Port to query
	var $timeout = 160000;							# Timeout in microsecond
	var $retry = 3;

	var $result = "";							# The result of a status request to the gameserver
	var $serverdata = Array();						# Contains server information
	var $userinfo = Array();						# Contains player information
	var $numofusers = 0;							# Number of players on server

	var $serveronline = false;						# Local flag

	/**
	* Constructor.
	*/
	function HL ($serverip, $port, $debug, $retrycount, $timeout) {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if

		# Here we go!
		$this->trace("HL::_constructor", "serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;                                    # Initialize properties
		$this->port = $port;
		$this->result = "";						# Contains server respons data

		$this->socket = $this->getSocket($this->serverip, $this->port);
		if ($this->socket) {
			$i=0;
			do {
				$this->trace("HL::_constructor", "Retry number : " . $i, 0, 0);
				if ($this->getServerStatus($this->socket)) {	# Interact with gameserver
					$this->serveronline = true;
				} else {
					$this->serveronline = false;
				} # End if;		
				$i++;
			} while (empty($this->result) && $i < $this->retry);	# Retry, sometimes server does not respond that fast :D

			#$this->trace("HL::_constructor", $this->result, 1, 1);
			$this->closeSocket($this->socket);
		} else {
			$this->trace("HL::_constructor", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
		} # End if
	} # End constructor HL

	/**
	* Retrieve the basic information of this server.
	* log information.
	* @param  string   $socket  Socket descriptor
	* @return boolean  true: retrieval succesfull, false: failure
	*/
	function getServerStatus($socket) {
		$this->trace("HL::_getServerStatus()", "", 0, 0);

		# We start with retrieving the server details. An DOD server
		# responds to an command that is given with a datagram that
		# holds the details.
		$this->trace("HL::_getServerStatus()", "Retrieving details", 0, 0);
		$command = "\xff\xff\xff\xffdetails";
		socket_set_blocking ($socket, true);				# Set blocking mode...wait until we have an reaction
		socket_set_timeout ($socket, $this->timeout / 100000);		# Set the timeout (in microseconds here!)
		fwrite($socket, $command); 					# Command to retrieve basic info

		$this->trace ("HL::getServerStatus ()", $command , 1, 1);
		$this->result = @fread($socket, 4096);				# Read stream
		$this->trace ("HL::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
		$this->trace ("HL::getServerStatus ()", $this->result, 2, 1);

		$socketstatus = socket_get_status($socket);                    # Determine current status of stream
		if ($socketstatus["timed_out"] || strlen ($this->result) <= 20) {
			$this->err = 100;					# Just an code...can be anything
			$this->errmsg = "Connection timed out";			# This is what's wrong ;-)
			$this->result = "";
			$this->trace("HL::getServerStatus()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
			return false;						# We have failed!
		} # End if

		# Parse datagram, for this we just "walk" along the string
		$i = 0;
		if(substr($this->result, $i, 5) != "\xff\xff\xff\xffm") { 	# bad ping response?
			$this->err = 110;					# Just an code...can be anything
			$this->errmsg = "Bad ping response";			# This is what's wrong ;-)
			$this->result = "";
			$this->trace("HL::getServerStatus()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
			return false;
		} # End if
		$i += 5;

		$addresslength = strpos($this->result, "\x00", $i) - $i;
		$addressvalue = substr($this->result, $i, $addresslength);
		$i += $addresslength + 1;
		$this->serverdata['address'] = $addressvalue;

		$namelength = strpos($this->result, "\x00", $i) - $i;
		$namevalue = substr($this->result, $i, $namelength);
		$i += $namelength + 1;
		$this->serverdata['name'] = $namevalue;

		$maplength = strpos($this->result, "\x00", $i) - $i;
		$mapvalue = substr($this->result, $i, $maplength);
		$i += $maplength + 1;
		$this->serverdata['map'] = $mapvalue;

		$gamedirlength = strpos($this->result, "\x00", $i) - $i;
		$gamedirvalue = substr($this->result, $i, $gamedirlength);
		$i += $gamedirlength + 1;
		$this->serverdata['mod'] = $gamedirvalue;

		$gamedesclength = strpos($this->result, "\x00", $i) - $i;
		$gamedescvalue = substr($this->result, $i, $gamedesclength);
		$i += $gamedesclength + 1;
		$this->serverdata['gamedesc'] = $gamedescvalue;

		$this->serverdata['num_total'] = ord($this->result[$i++]);
		$this->serverdata['num_avail'] = ord($this->result[$i++]);
		$this->serverdata['version'] = "protocol " . ord($this->result[$i++]);
		$this->serverdata['servertype'] = $this->result[$i++] == "l" ? "listen" : "dedicated";
		$this->serverdata['serveros'] = $this->result[$i++] == "l" ? "linux" : "windows";
		$this->serverdata['password'] = ord($this->result[$i++]);
		$this->serverdata['modded'] = ord($this->result[$i++]);

		if ($this->serverdata['modded'] == 1) {
			$modsitelength = strpos($this->result, "\x00", $i) - $i;
			$modsitevalue = substr($this->result, $i, $modsitelength);
			$i += $modsitelength + 1;
			$this->serverdata['modsite'] = $modsitevalue;

			$moddownloadlength = strpos($this->result, "\x00", $i) - $i; 
			$moddownloadvalue = substr($this->result, $i, $moddownloadlength);
			$i += $moddownloadlength + 1;
			$this->serverdata['moddownload'] = $moddownloadvalue;

			$i++; # shift off unused byte

			$this->serverdata['modver'] = ord($this->result[$i++]);
			$this->serverdata['modsize'] = ord($this->result[$i++]);

			$this->serverdata['modserverside'] = ord($this->result[$i++]);
			$this->serverdata['moddll'] = ord($this->result[$i++]);
			$this->serverdata['secure'] = ord($this->result[$i++]);
		} # End if

		# From here we try to retrieve the rules for this server. For
		# this we issue another command to the server, and yes, the
		# server needs to respond with an different datagram for the
		# rules information we want to retrieve here.
		$this->trace("HL::_getServerStatus()", "Retrieving rules", 0, 0);
		$command = "\xff\xff\xff\xffrules";
		fwrite($socket, $command); 					# Command to retrieve basic info

		$this->trace ("HL::getServerStatus ()", $command , 1, 1);
		$this->result = @fread($socket, 4096);				# Read stream
		$this->trace ("HL::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
		$this->trace ("HL::getServerStatus ()", $this->result, 2, 1);

		$socketstatus = socket_get_status($socket);                    # Determine current status of stream
		if ($socketstatus["timed_out"]) {
			$this->err = 100;					# Just an code...can be anything
			$this->errmsg = "Connection timed out";			# This is what's wrong ;-)
			$this->result = "";
			$this->trace("HL::getServerStatus()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
			return false;						# We have failed!
		} # End if

		if (empty($this->result)) {
			$this->err = 110;					# Just an code...can be anything
			$this->errmsg = "No data returned";			# This is what's wrong ;-)
			$this->result = "";
			$this->trace("HL::getServerStatus()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
			return false;						# We have failed!
		} # End if
		$i = 0;
		# check if this is a partial reply packet - half of a long rules output
		if (substr($this->result, $i, 4) == "\xfe\xff\xff\xff") {
			# the two halves are hard truncated, often in the 
			# middle of a variable name (ugly, yes, but don't
			# blame me, i dit not make this game).
			if (substr($this->result, 9, 4) == "\xff\xff\xff\xff") {
				# we have the first half first
				# save the rules head chunk minus the header
				$this->trace("HL::getServerStatus()", "Partial reply packet received, handling first part", 0, 0);
				$resulthead = substr($this->result, 9, strlen($this->result) - 9);

				# get second half of message
				if (!($this->result = @fread($socket, 4096))) {
					$this->err = 110;
					$this->errmsg = "Error reading socket stream: first half";
					$this->result = "";
					$this->trace("HL::getServerStatus()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
					return false;
				} # End if
				$this->trace("HL::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
				$this->trace("HL::getServerStatus()", $this->result, 1, 1);

				# save the rules tail chunk minus the header
				$resulttail = substr($this->result, 9, strlen($this->result) - 9);
			} else {
				# we have the second half first
				# save the rules tail chunk minus the header
				$this->trace("HL::getServerStatus()", "Partial reply packet received, handling second part", 0, 0);
				$resulttail = substr($this->result, 9, strlen($this->result) - 9);

				# get second half of message
				if (!($this->result = @fread($socket, 4096))) {
					$this->err = 110;
					$this->errmsg = "Error reading socket stream: second half";
					$this->result = "";
					$this->trace("HL::getServerStatus()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
					return false;
				} # End if
				$this->trace("HL::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
				$this->trace("HL::getServerStatus()", $this->result, 1, 1);

				# save the rules head chunk minus the header
				$resulthead = substr($this->result, 9, strlen($this->result) - 9);
			} # End if

			# add the tail and head chunks to make a normal (big) rules packet
			$this->result = $resulthead . $resulttail;
		} # End if

		# Parse datagram, for this we just "walk" along the string
		$i = 0;
		if(substr($this->result, $i, 5) != "\xff\xff\xff\xffE") { 	# bad ping response?
			$this->trace ("HL::getServerStatus ()", "No rules found, strange but true, retry, maybe this server will wake up", 2, 0);
			return true;
		} # End if
		$i += 5;

		$rulecount = ord(substr($this->result, $i, 2));
		$this->trace("HL::getServerStatus()", "$rulecount rules found in total datagram", 0, 0);
		$i += 2;
		for ($j = 0; $j < $rulecount; $j++) {
			$settinglength = strpos($this->result, "\x00", $i) - $i;
			$settingname = substr($this->result, $i, $settinglength);
			$i += $settinglength + 1;

			$valuelength = strpos($this->result, "\x00", $i) - $i;
			$valuename = substr($this->result, $i, $valuelength);
			$i += $valuelength + 1;
			$this->serverdata["$settingname"] = $valuename;
		} # End for

		# From here we try to retrieve the player data for this server.
		# For this we issue the last command to the server, and yes, the
		# server needs to respond with yest an different datagram for
		# the player information we want to retrieve here.
		$this->trace("HL::_getServerStatus()", "Retrieving player data", 0, 0);

		$command = "\xff\xff\xff\xffplayers";
		fwrite($socket, $command); 					# Command to retrieve basic info

		$this->trace ("HL::getServerStatus ()", $command , 1, 1);
		$this->result = @fread($socket, 4096);				# Read stream
		$this->trace ("HL::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
		$this->trace ("HL::getServerStatus ()", $this->result, 2, 1);

		$socketstatus = socket_get_status($socket);                    # Determine current status of stream
		if ($socketstatus["timed_out"]) {
			$this->err = 100;					# Just an code...can be anything
			$this->errmsg = "Connection timed out";			# This is what's wrong ;-)
			$this->result = "";
			$this->trace("HL::getServerStatus()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
			return false;						# We have failed!
		} # End if

		# Parse datagram, for this we just "walk" along the string
		$i = 0;
		if(substr($this->result, $i, 5) != "\xff\xff\xff\xffD") { 	# bad ping response?
			$this->trace ("HL::getServerStatus ()", "No player data found", 2, 0);
			return true;
		} # End if
		$i += 5;

		$this->numofusers = ord($this->result[$i++]);

		for ($j = 0; $j < $this->numofusers; $j++) {
			$this->userinfo[$j] = array();
			$this->userinfo[$j]['slot'] = ord($this->result[$i++]);

			$namelength = strpos($this->result, "\x00", $i) - $i;
			$namevalue = substr($this->result, $i, $namelength);
			$i += $namelength + 1;
			$this->userinfo[$j]['name'] = $namevalue;

			$this->userinfo[$j]['score'] = ord(substr($this->result, $i, 4));
			$i += 4;

			$this->userinfo[$j]['ping'] = ord(substr($this->result, $i, 4));
			$i += 4;
		} # End for

		if(array_key_exists('deathmatch', $this->serverdata) && $this->serverdata['deathmatch'] == 1) {
			$this->serverdata['gametype'] = "dm";
		} else if (array_key_exists('coop', $this->serverdata) && $this->serverdata['coop'] == 1) {
			$this->serverdata['gametype'] = "coop";
		} # end if

		if(!array_key_exists('num_team1', $this->serverdata)) $this->serverdata['num_team1'] = 0;
		if(!array_key_exists('num_team2', $this->serverdata)) $this->serverdata['num_team2'] = 0;
		if(!array_key_exists('num_others', $this->serverdata)) $this->serverdata['num_others'] = 0;

		if(!array_key_exists('mod', $this->serverdata)) {
			$this->serverdata['mod'] = "";
		} # End if

		return true;
	} # End function getPlayersInfo

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		return $this->serveronline;
	} # End function IsServerRunning

	/**
	* Return the maximum number of clients that may connect to this server.
	*/
	function getMaxClients () {
		return number_format($this->serverdata['num_avail']);
	} # End function getMaxClients

} # End class HL
?>