<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.HL2.class.php,v 0.6 2005/12/27 03:15:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Class that holds the specific game code for the half-life 2 protocol.
* Taken most of the code from an existing php class, no author was available in the
* source code, so i cannot put any referral here, but thx anyway :-)
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class HL2 extends ServerMain {
	/**
	* Properties.
	*/
	var $serverip;
	var $port;
	var $timeout = 175000;							# Timeout in microsecond
	var $sock;
	var $data;
	var $sortBy;
	var $retry;

	var $serverdata = Array();						# Contains server information
	var $userinfo = Array();						# Contains player information
	var $numofusers = 0;							# Number of players on server

	var $game;
	var $online = false;							# Is server online?

	/**
	* Constructor.
	*/	
	function HL2($serverip, $port="", $debug, $retrycount, $timeout, $game = "CSS") {
		$this->trace("HL2::_constructor", "_start", 0, 0);
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if
		$this->game = $game;

		# Here we go!
		$this->trace("HL2::_constructor", "serverip: $serverip  port: $port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;
		$this->port = (empty($port)) ? 27015 : $port;
		$this->status();

		$this->trace("HL2::_constructor", "_end", 0, 0);
	} # End constructor CS
	
	/**
	* Retrieve server status
	*/
	function status() {
		$this->trace("HL2::_status()", "", 0, 0);
		if(!$this->sock = @fsockopen("udp://".$this->serverip, $this->port, $this->err, $this->errmsg, $this->timeout / 100000)) {
                        $this->err = 100;					# Just an code...can be anything
       	                $this->errmsg = "Could not connect to socket";		# This is what's wrong ;-)
			$this->trace("HL2::status()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
               	        return false;						# We have failed!
		} # End if

		$command = "\xFF\xFF\xFF\xFFW";

		$this->trace("HL2::status()", "Initiating counter strike source interaction:", 0, 0);
		$this->trace("HL2::status()", $command, 1, 1);

		fwrite($this->sock, $command );
		$string = fread($this->sock, 4096);
		
		if(empty($string)) {
			@fclose($this->sock);
			return false;
		} # End if

		$challenge [] = $string;
		$status = $challenge[0];
		$i = 5;
		$s2c_challenge = $this->readString($status, $i);

		$this->trace("HL2::status()", "Challenge response (building command with this value): ", 0, 0);
		$this->trace("HL2::status()", $s2c_challenge, 1, 1);

		$querys[] = "\xFF\xFF\xFF\xFF\x54Source Engine Query";		# Command to retrieve server status
		$querys[] = "\xFF\xFF\xFF\xFF\x55" . $s2c_challenge;		# Command to retrieve player info
		$querys[] = "\xFF\xFF\xFF\xFF\x56" . $s2c_challenge;		# Command to retrieve rules

		stream_set_blocking ($this->sock, true);			# Set blocking mode...wait until we have an reaction
		stream_set_timeout ($this->sock, 0, $this->timeout);		# Set the timeout (in microseconds here!)

		foreach($querys AS $querystring) {
			$this->trace("HL2::status()", "Initiating server interaction:", 0, 0);
			$this->trace("HL2::status()", $querystring, 1, 1);
			fwrite($this->sock, $querystring);

			$string = fread($this->sock, 4096);
			if(!empty($string)) {
				$this->data[] = $string;
				$this->trace("HL2::status()", "Server response " . strlen($string) . " bytes stored in row " . (count($this->data) - 1), 0, 0);
				$this->trace("HL2::status()", $string, 1, 1);
			} else {
				$this->trace("HL2::status()", "no response on request received", 0, 0);
			} # End if
		} # End foreach
		@fclose($this->sock);
			
		if(empty($this->data[0])) {
                        $this->err = 100;				# Just an code...can be anything
       	                $this->errmsg = "Connection timed out";		# This is what's wrong...
			$this->trace("HL2::status()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
               	        return false;
               	} # End if
			
		$this->parseStatus();
		$this->parsePlayers();
		$this->parseRules();

		$this->online = true;
		return TRUE;
	} # End function status
	
	/*
	* Retrieve the status for this server...
	*/
	function parseStatus() {
		$status = $this->data[0];
		$i = 5;

		$this->serverdata['ip']	= $this->serverip;
		$this->serverdata['port'] = $this->port;
		//exit();
		if ($this->game = "HL2" && !ereg("\xFF\xFF\xFF\xFF\x6D", $status) || $this->game = "CSS" && !ereg("\xFF\xFF\xFF\xFF\x6D", $status) || $this->game = "HLDM" && !ereg("\xFF\xFF\xFF\xFF\x6D", $status) ) {
			$this->serverdata['net_protocol'] = ord($status{$i++});
			$this->serverdata['hostname'] = $this->readString($status, $i);
			$this->serverdata['map'] = $this->readString($status, $i);
			$this->serverdata['game_dir'] = $this->readString($status, $i);	
			$this->serverdata['game_type'] = $this->readString($status, $i);
			$this->serverdata['appid'] = ord($status{$i++}.$status{$i++});
			$this->serverdata['num_players'] = ord($status{$i++});
			$this->serverdata['max_players'] = ord($status{$i++});
			$this->serverdata['bot_players'] = ord($status{$i++});
			$this->serverdata['dedicated'] = $status{$i++};
			$this->serverdata['server_os'] = $status{$i++};
			$this->serverdata['needpass'] = ord($status{$i++});
			$this->serverdata['secure'] = ord($status{$i++});
			$this->serverdata['version'] = $this->readString($status, $i);
		} else {
			$this->serverdata['address'] = $this->readString($status, $i);	# Next in line is the hostname,
			$this->serverdata['hostname'] = $this->readString($status, $i);	# Next in line is the hostname,
			$this->serverdata['map'] = $this->readString($status, $i);	# followed by map name
			$this->serverdata['game_dir'] = $this->readString($status, $i);	
			$this->serverdata['game_type'] = $this->readString($status, $i);
			$this->serverdata['num_players'] = ord($status{$i++});
			$this->serverdata['max_players'] = ord($status{$i++});
			$this->serverdata['net_protocol'] = ord($status{$i++});		# First byte contains protocol value
			$this->serverdata['dedicated'] = $status{$i++};
			$this->serverdata['server_os'] = $status{$i++};
			$this->serverdata['needpass'] = ord($status{$i++});
			$this->serverdata['secure'] = ord($status{$i++});
			$this->serverdata['version'] = $this->readString($status, $i);
		} # End if
		return TRUE;
	} # End function parseStatus

	/*
	* Retrieve the player data for this server...
	*/
	function parsePlayers() {
		$players = $this->data[1];

		if( substr($players, 0, 5) != "\xff\xff\xff\xffD") {
			$this->trace("HL2::parsePlayers()", "Bad ping response (no data returned)", 0, 0);			
			return TRUE;
		} # End if

		$i=5;
		$p=0;
		$num_players = ord($players{$i++});

		$this->trace("HL2::parsePlayers()", "Number of users found:" . number_format($num_players), 0, 0);
		$this->userinfo['players'] = array();
		if($num_players > 0) {
			for($p = 0; $p < $num_players; $p++) {
				if(!empty($players{$i+1})) {
					$this->userinfo[$p]['index'] = ord($players{$i++});
					$this->userinfo[$p]['name'] = $this->readString($players, $i);
					
					$frags = unpack("L", substr($players, $i, $i+4)); $i+=4;
					$this->userinfo[$p]['frags'] = $frags[1];
					
					$time = unpack("f", substr($players, $i, $i+4)); $i+=4;
					$time = mktime(0, 0, $time[1]);
					# $time = date("H:i:s", $time);
					$this->userinfo[$p]['time'] = $time;
				} # End if
			} # End for
		} # End if
		$this->numofusers = $p;
		
		return TRUE;
	} # End function parsePlayers

	/*
	* Retrieve server rules...
	*/
	function parseRules() {
		if (!isset($this->data[2])) {
			$this->trace("HL2::parsePlayers()", "No rules returned!", 0, 0);
			return TRUE;
		} # End if

		if( substr($this->data[2], 0, 4) != "\xfe\xff\xff\xff") {
			$this->trace("HL2::parsePlayers()", "Bad ping response (no data returned, or data does not contain rules response)", 0, 0);
			return TRUE;
		} # End if

		$rules = substr($this->data[2], 9);				# Last line contains server settings
		$rule = explode("\x00", $rules);				# Split into an array, delimiter is ASCII 0
		#if ($this->game != "HL2") {
		#	array_shift ($rule);
		#	array_shift ($rule);
		#} # End if
		
		for($i = 1; $i < count($rule) - 1; $i+=2) {
			$this->serverdata[$rule[$i]] = $rule[$i+1];		# Store variable
		} # End for
		return TRUE;
	} # End function parseRules

	/*
	* Filter out the result value from an string. In counter strike the
	* server response hold an variable name, followed by the variable value
	* that is delimited by an ASCII character 0.
	*/
	function readString($string, &$i) {
		$begin = $i;
		$strlen = strlen($string);
		for ($i; ($i < $strlen) && ($string{$i} != chr(0)); $i++);
		$result = substr($string, $begin, $i-$begin);
		$i++;
		
		return $result;
	} # End function readString

      /**
        * Function that is used to check if the server is running. Call with
        * serverip and port to check. Returns true is running, else returns 
        * false.
        */
        function IsServerRunning () {
		$this->trace("HL2::_IsServerRunning()", "", 0, 0);
		return $this->online;
        } # End function IsServerRunning 

	/**
	* Return the operating system the server is running on.
	* Returns false when os cannot be detected.
	*/
	function getOSRunning () {
		if (eregi ("linux", $this->serverdata['server_os'])) return "Linux";
		if (eregi ("win-x86", $this->serverdata['server_os'])) return "Windows";          
		return $this->serverdata['server_os'];
	} # End function getOSRunning

	/**
	* Returns the current number of users on the server.
	*/
	function getUsersOnline () {
		return number_format($this->numofusers);
	} # End function getUsersOnline

	/**
	* Return the maximum number of clients that may connect to this server.
	*/
	function getMaxClients () {
		return number_format($this->serverdata['max_players']);
	} # End function getMaxClients
} # End class CS
?>