<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.Q3.class.php,v 0.6 2005/12/17 21:15:00 wilcojansen Exp $
* @package serverstat 0.6
*
* This class contains all logic to question a standard quake 3 gameserver, also
* support Quake 2 status handling :-).
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class Q3 extends ServerMain {
	/**
	* Constructor.
	*/
	function Q3 ($serverip, $port, $debug, $retrycount, $timeout, $servertype = "Q3") {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if

		# Here we go!
		$this->trace("Q3::_constructor", "serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;                                    # Initialize properties
		$this->port = $port;
		$this->servertype = $servertype;				# Store the servertype
		$this->result = "";						# Contains server respons data

		$this->socket = $this->getSocket($this->serverip, $this->port);
		if ($this->socket) {
			$i=0;
			do {
				if ($this->getServerStatus($this->socket)) {		# Interact with gameserver
					$this->trace ("Q3::_constructor ()", "bytes read : " . strlen($this->result), 1, 0);
					$this->trace ("Q3::_constructor ()", $this->result, 2, 1);
					$this->getServerInfo();
					$this->getUserInfo();
				} # End if
				$i++;
			} while (empty($this->result) && $i < $this->retry);	# Retry, sometimes server does not respond that fast :D
			$this->trace("Q3::_constructor", $this->result, 1, 1);
			$this->closeSocket($this->socket);			# Also close the connection
		} else {
			$this->trace("Q3::_constructor", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
		} # End if

		$this->serverdata['num_players'] = $this->numofusers;
		$this->serverdata['ip'] = $this->serverip;
		$this->serverdata['port'] = $this->port;
	} # End constructor Q3

	/**
	* Command line to interact with server.
	*/
	function getCommand () {
		$this->trace ("Q3::_getCommand ()", "", 9, 0);

		switch ($this->servertype) {
		case "Q2":
			return "\xff\xff\xff\xffstatus\x00";
			break;

		default:
			return "\xff\xff\xff\xffgetstatus\n";
			break;
		} # End switch
	} # End if

	/**
	* Initiates a status call to the server.
	* Returns true if successfull, false if an error occured
	*/
	function getServerStatus($socket) {
		$this->trace ("Q3::_getServerStatus ()", "", 0, 0);

		socket_set_blocking ($socket, true);				# Set blocking mode...wait until we have an reaction
		socket_set_timeout ($socket, $this->timeout / 100000);		# Set the timeout (in microseconds here!)
		fwrite ($socket, $this->getCommand());				# Interact with gameserver

		$this->trace ("Q3::getServerStatus ()", $this->getCommand(), 1, 1);
		$this->result = @fread($socket, 4096);				# Read stream
		$this->trace ("Q3::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
		$this->trace ("Q3::getServerStatus ()", $this->result, 2, 1);

		#$socketstatus = socket_get_status($socket);                    # Determine current status of stream
		#if ($socketstatus["timed_out"] || strlen ($this->result) <= 20) {
		#	$this->err = 100;					# Just an code...can be anything
		#	$this->errmsg = "Connection timed out";			# This is what's wrong ;-)
		#	$this->trace ("Q3::getServerStatus ()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg , 0, 0);
		#	return false;						# We have failed!
		#} # End if
		switch ($this->servertype) {
		case "Q2":
			$this->result = substr ($this->result, 11);             # Strip header response (something like "print")
			break;
		default:
			$this->result = substr ($this->result, 20);             # Strip header response (something like "statusResponse")
			break;
		} # End switch

		return true;
	} # End function getServerStatus

	/**
	* Return the server information. The server information is stored in
	* an array, example of server variable: $this->serverdata['sv_minRate']
	*/
        function getServerInfo () {
		$this->trace ("Q3::_getServerInfo ()", "", 0, 0);
		$serverinfo = substr ($this->result, 0, strpos($this->result, "\n"));

		$serversplit = split ("[\]", $serverinfo);
		for ($i=0; $i <= sizeof($serversplit) - 2; $i+=2) {
			$j=$i+1;
			$this->serverdata["$serversplit[$i]"] = $serversplit[$j];
		} # End for
	} # End function getServerInfo
        
	/**
	* Return the user information. The user information is stored in
	* an array, example of player variable: $this->userinfo[0]['name'].
	* In Quake 3 the player information consists of the following fields:
	* 'frags' --> number of frags
	* 'ping'  --> the players ping time
	* 'name'  --> the name of the player
	*/
        function getUserInfo () {
		$this->trace ("Q3::_getUserInfo", "", 0, 0);
		$playerinfo = substr ($this->result, strpos($this->result, "\n") + 1);
		$playerinfo = substr ($playerinfo, 0, strlen ($playerinfo) - 1);

		if (strlen ($playerinfo)) {
			$playersplit = split ("\n", $playerinfo);
			$this->numofusers =0;
			while (list($key, $data) = each ($playersplit)) {
				eregi("^([-0-9]+) ([-0-9]+) \"(.*)\"",$data,$playerdetails);
				$this->userinfo[$key]['frags'] = $playerdetails[1];
				$this->userinfo[$key]['ping'] = $playerdetails[2];
				$this->userinfo[$key]['name'] = $playerdetails[3];
				$this->numofusers++;
			} # End while
		} # End if
	} # End function getUserInfo
        
	/**
	* Return version information if running version.
	*/
	function getServerVersion() {
		return $this->serverdata['version'];
	} # End function getServerInfo

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		$this->trace ("Q3::_IsServerRunning ()", "", 0, 0);
		if (!empty($this->result)) {
			return true;
		} else {
			return false;
		} # End if
	} # End function IsServerRunning 

	/**
	* Returns true if server is password protected.
	* Returns false for public servers.
	*/
	function isPasswordProtected () {
		if ($this->serverdata['g_needpass'] == 0) {
			return false;
		} # End if
		return true;
	} # End function isPasswordProtected
} # End class Q3
?>