<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.WEB.class.php,v 0.6 2005/12/17 21:15:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Class that holds the specific game code for an Webserver.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class Webserver extends ServerMain {
	/**
	* Properties.
	*/
	var $serverip = "localhost";						# Ip addr for server to query
	var $port = 80;								# Port to query
	var $timeout = 200000;							# Timeout in microsecond
	var $retry = 3;

	var $socket = "";							# Socket var...
	var $err = 0;								# Error code, set when an error has occured
	var $errmsg = "";							# Error message...

	var $result = "";							# The result of a status request to the gameserver
	var $serverdata = "";							# Contains server information: not used!
	var $numofusers = 0;							# Number of users: not used!

	var $online = false;							# Local flag

	/**
	* Constructor.
	*/
	function Webserver ($serverip, $port, $debug, $retrycount, $timeout) {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if

		# Here we go!
		$this->trace("WEB::_constructor", "serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;                                    # Initialize properties
		$this->port = $port;
		$this->result = "";						# Contains server respons data

		$this->socket = $this->getSocket($this->serverip, $this->port);

		if ($this->socket) {
			$i=0;
			do {
				if ($this->getServerStatus($this->socket)) {	# Interact with webserver
					$this->online = true;
				} else {
					$this->online = false;
				} # End if;		
				$i++;
			} while (empty($this->result) && $i < $this->retry);	# Retry, sometimes server does not respond that fast :D

			$this->trace("WEB::_constructor", $this->result, 1, 1);
			$this->closeSocket($this->socket);			# Also close the connection
		} else {
			$this->trace("WEB::_constructor", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
		} # End if
	} # End function Webserver

	/**
	* Opens a connection to the server.
	*/
	function getSocket($ip, $port) {
		$this->trace ("WEB::_getSocket ()", "timeout: " . $this->timeout . " (=" . $this->timeout / 100000 . " sec.)", 1, 0);
		return @fsockopen($ip, $port, $this->err, $this->errmsg, $this->timeout / 100000);
	} # End function getSocket

	/**
	* Initiates a status call to the server. Do an GET to the intented
	* webserver, and read the page. If we get an result, the server
	* is online, if not, the server is offline. Simple and easy.
	* Returns true if successfull, false if an error occured
	*/
	function getServerStatus ($socket) {
		$this->trace ("WEB::_getServerStatus ()", "Initiating http page request", 0, 0);
		socket_set_blocking ($socket, true);				# Set blocking mode...wait until we have an reaction
		socket_set_timeout ($socket, $this->timeout / 100000);		# Set the timeout (in microseconds here!)

		$command = "GET / HTTP/1.0\r\nHost: "  . $this->serverip . ":" . $this->port . "\r\n\r\n";
		$this->trace ("WEB::getServerStatus ()", $command, 1, 1);

		#die ($command);
		fputs ($socket, $command);

		# First we retrieve the response headers. All known response
		# headers will be stored into the $this->serverdata array.
		$this->trace ("WEB::getServerStatus ()", "Retrieving responseheader", 1, 0);
		$i=0;
		while (!feof($socket)) {
			$line = fgets ($socket, 4096);

			if(preg_match('/^\s*[\r\n|\r|\n]$/', $line)) {
				# Have an empty line! All Headers retrieved now! Body begins with next line.
				break;
			} # End if

			# First response in responseheader holds the HTTP result
			# code (200 OK etc), split this one up into some
			# serverdata fields.
			if ($i == 0) {
				preg_match("=^(HTTP/\d+\.\d+) (\d{3}) ([^\r\n]*)=", $line, $matches);
				if(isset($matches[0])) $this->serverdata["status-line"] = $matches[0];
				if(isset($matches[1])) $this->serverdata["http-version"] = $matches[1];
				if(isset($matches[2])) $this->serverdata["status-code"] = $matches[2];
				if(isset($matches[3])) $this->serverdata["reason-phrase"] = $matches[3];
			} # End if

			# We now split up the response fields, and store them 
			# into the serverdata array.
			if ($i > 0) {
				$matches = split (":", $line, 2);
				$this->serverdata[strtolower($matches[0])] = $matches[1];
			} # End if
			$this->trace ("WEB::getServerStatus ()", $line, 1, 0);
			$this->result .= $line;
			$i++;
    		} # End while
		$this->trace ("WEB::getServerStatus ()", "bytes read (response header): " . strlen($this->result), 1, 0);
		$this->trace ("WEB::getServerStatus ()", $this->result, 2, 1);

		$socketstatus = socket_get_status($socket);                    # Determine current status of stream
		if ($socketstatus["timed_out"] ) {
			$this->err = 100;					# Just an code...can be anything
			$this->errmsg = "Connection timed out";			# This is what's wrong ;-)
			$this->result = "";
			return false;						# We have failed!
		} # End if

		# Now we retrieve the page (body of HTML page). No special
		# actions are performed here.
		$this->trace ("WEB::getServerStatus ()", "Dumping body of HTML page", 1, 0);
		$i=0;
		while (!feof($socket)) {
			$this->result .= fgets ($socket, 4096);
		} # End while

		$socketstatus = socket_get_status($socket);                    # Determine current status of stream
		if ($socketstatus["timed_out"] ) {
			$this->err = 100;					# Just an code...can be anything
			$this->errmsg = "Connection timed out";			# This is what's wrong ;-)
			$this->result = "";
			return false;						# We have failed!
		} # End if
		$this->trace ("WEB::getServerStatus ()", "bytes read (full datagram): " . strlen($this->result), 1, 0);
		$this->trace ("WEB::getServerStatus ()", $this->result, 2, 1);

		return true;
	} # End function getServerStatus

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		return $this->online;
	} # End function IsServerRunning

	/**
	* Returns the current number of users on the server.
	*/
	function getUsersOnline () {
		return number_format($this->numofusers);
	} # End function getUsersOnline

	/**
	* Return the maximum number of clients that may connect to this server.
	* For a webserver we cannot retrieve the maximum number of users (makes
	* no sense), so we return 0 here.
	*/
	function getMaxClients () {
		return number_format(0);
	} # End function getMaxClients

	/**
	* Return the operating system the server is running on. We do not have
	* any clue of the OS we are going to, just return "Unknown".
	*/
	function getOSRunning () {
		if (isset($this->serverdata['server'])) {
			return $this->serverdata['server'];
		} # End if

		return "Unknown";
	} # End function getOSRunning
} # End class Webserver
?>