<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.main.class.php,v 0.5 2005/12/17 23:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Main Serverclass, holds all basic routines that are used in child classes.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class ServerMain  {
	/**
	* Properties.
	*/
	var $serverip = "localhost";						# Ip addr for server to query
	var $port = "29253";							# Port to query
	var $timeout = 160000;							# Timeout in microsecond
	var $retry = 3;
	var $servertype = "";

	var $socket = "";							# Socket var...
	var $err = 0;								# Error code, set when an error has occured
	var $errmsg = "";							# Error message...

	var $result = "";							# The result of a status request to the gameserver
	var $serverdata = Array();							# Contains server information
	var $userinfo = "";							# Contains player information
	var $numofusers = 0;							# Number of players on server

	/**
	* Debugging and tracing
	*/
	var $debug = false;							# BOOLEAN: switch debugging ON/OFF
	var $debug_level = 0;							# 0 = lowest detail, higher is more detail
	var $debug_log = Array();						# Contain logged information

	/**
	* Vars used for performance loging and load measurement
	*/
	var $minping = 0;
	var $maxping = 0;
	var $avgping = 0;

	/**
	* Return the timestamp, based on seconds and microseconds
	*/
	function getMicroTime() { 
		list($usec, $sec) = explode(" ",microtime()); 
		return ((float)$usec + (float)$sec); 
	} # End function getmicrotime()

	/**
	* Return lowest found ping for an user.
	*/
	function getPingLowest() {
		$this->determinePingvalues ();
		return intval($this->minping);
	} # End function getPingLowest

	/**
	* Return highest found ping for an user.
	*/
	function getPingHighest () {
		$this->determinePingvalues ();
		return intval($this->maxping);
	} # End function getPingHighest

	/**
	* Return avarage found ping for an user.
	*/
	function getPingAvarage () {
		$this->determinePingvalues ();
		return intval($this->avgping);
	} # End function getPingAvarage

	/**
	* Returns the current number of users on the server.
	*/
	function getUsersOnline () {
		return number_format($this->numofusers);
	} # End function getUsersOnline

	/**
	* Return the operating system the server is running on.
	*/
	function getOSRunning () {
		if (isset($this->serverdata['version'])) {
			if (eregi ("linux", $this->serverdata['version'])) return "Linux";
			if (eregi ("win-x86", $this->serverdata['version'])) return "Windows";
			if (eregi ("WIN32", $this->serverdata['platform'])) return "Windows";
			if (eregi ("LINUX", $this->serverdata['platform'])) return "Linux";
		} # End if
		return "Unknown";
	} # End function getOSRunning

	/**
	* Opens a connection to the server.
	*/
	function getSocket($ip, $port) {
		$this->trace ("ServerMain::_getSocket ()", "timeout: " . $this->timeout . " (=" . $this->timeout / 100000 . " sec.)", 1, 0);
		return @fsockopen("udp://$ip", $port, $this->err, $this->errmsg, $this->timeout / 100000);
	} # End function getSocket

	/**
	* Closes the connection to the server.
	*/
	function closeSocket($socket) {
		$this->trace ("ServerMain::_closeSocket ()", "", 9, 0);
		@fclose($socket);
	} # end function closeSocket(...)

	/**
	* Determine user performance numbers, minimum ping, maximum ping and
	* of course the avarage.
	*/
	function determinePingvalues () {
		$this->trace ("ServerMain::_determinePingvalues ()", "", 9, 0);
		$this->maxping = 0;
		$this->avgping = 0;

		if ($this->getUsersOnline() == 0) {
			$this->minping = 0;
			return;
		} # End if

		$this->minping = 999;

		for ($i=0; $i < $this->getUsersOnline(); $i++) {
			if ($this->userinfo[$i]['ping'] < $this->minping) {
				$this->minping = $this->userinfo[$i]['ping'];
			} # end if

			if ($this->userinfo[$i]['ping'] > $this->maxping) {
				$this->maxping = $this->userinfo[$i]['ping'];
			} # end if

			$this->avgping += $this->userinfo[$i]['ping'];
		} # End for
		
		$this->avgping = @intval($this->avgping / $this->getUsersOnline());

		$this->trace ("ServerMain::determinePingvalues ()", "min: " . $this->minping . "avg: " . $this->avgping . "max: " . $this->maxping, 9, 0);
	} # End functon determinePingvalues 

	/**
	* Just an routine used for debugging and tracing. Builds an array of
	* log information. This information is calculated from the debug_log
	* array that is built in the trace option.
	*
	* @call   nothing
	* @return double            The amount of time in seconds this class 
	*                           needed to retrieve the information.
	*/
	function getClassTiming() {
		if (count($this->debug_log) == 0) {
			return number_format(0);
		} # End if

		$i = count($this->debug_log) - 1;
		$time = $this->debug_log[$i]['time'] - $this->debug_log[0]['time'];

		return $time;
	} # End funtcion getClassTiming

	/**
	* Return the mapname that is currently running. Most gameservers return
	* the $this->serverdata['mapname'] value here, will be overrided in
	* specific classes when needed. All known values are handled here.
	* specific classes.
	* @call   nothing
	* @return string    The name of the map that is running
	*/
	function getMapName() {
		$return = "unknown";
		if (is_array($this->serverdata)) {
			if(array_key_exists('mapname', $this->serverdata)) $return=trim(strtolower(str_replace(" ", "_", $this->serverdata['mapname'])));
			if(array_key_exists('g_scoreboardpic', $this->serverdata)) $return=trim(strtolower(str_replace(" ", "_", $this->serverdata['g_scoreboardpic'])));
			if(array_key_exists('map', $this->serverdata)) $return= trim(strtolower(str_replace(" ", "_", $this->serverdata['map'])));
			if(array_key_exists('si_map', $this->serverdata)) $return=trim(strtolower(str_replace(" ", "_", $this->serverdata['si_map'])));
		} # End if
		return $return;
	} # End function 

	/**
	* Return the hostname. Most gameservers return the 
	* $this->serverdata['hostname'] value here, will be overrided in
	* specific classes when needed. All known values are handled here.
	* specific classes.
	* @call   nothing
	* @return string    The name of the host.
	*/
	function getHostName() {
		$return = "unknown";
		if (is_array($this->serverdata)) {
			if(array_key_exists('hostname', $this->serverdata)) $return = trim(q3Name2HTML($this->serverdata['hostname']));
			if(array_key_exists('si_name', $this->serverdata)) $return = trim(q3Name2HTML($this->serverdata['si_name']));
			if(array_key_exists('sv_hostname', $this->serverdata)) $return = trim(q3Name2HTML($this->serverdata['sv_hostname']));
			if(array_key_exists('server_name', $this->serverdata)) $return = trim(getASCII($this->serverdata['server_name']));
			if(array_key_exists('name', $this->serverdata)) $return = trim(getASCII($this->serverdata['name']));
		} # End if
		return $return;
	} # End function 

	/**
	* Return the hostname in ASCII. Most gameservers return the 
	* $this->serverdata['hostname'] value here, will be overrided in
	* specific classes when needed. All known values are handled here.
	* specific classes.
	* @call   nothing
	* @return string    The name of the host.
	*/
	function getHostNameASCII () {
		$return = "unknown";
		if (is_array($this->serverdata)) {
			if(array_key_exists('hostname', $this->serverdata)) $return = trim(getASCII($this->serverdata['hostname']));
			if(array_key_exists('si_name', $this->serverdata)) $return = trim(getASCII($this->serverdata['si_name']));
			if(array_key_exists('sv_hostname', $this->serverdata)) $return = trim(getASCII($this->serverdata['sv_hostname']));
			if(array_key_exists('server_name', $this->serverdata)) $return = trim(getASCII($this->serverdata['server_name']));
		} # End if
		return $return;
	} # End function getHostNameASCII

	function getNumPlayers() {
		return number_format($this->numofusers);
	} # End function getNumPlayer

	function getMaxClients() {
		if(@array_key_exists('maxplayers', $this->serverdata)) return number_format($this->serverdata['maxplayers']);
		if(@array_key_exists('sv_maxclients', $this->serverdata)) return number_format($this->serverdata['sv_maxclients']);
		if(@array_key_exists('maxlisteners', $this->serverdata)) return number_format($this->serverdata['maxlisteners']);
		if(@array_key_exists('maxclients', $this->serverdata)) return number_format($this->serverdata['maxclients']);
		return number_format(0);
	} # End function getNumPlayer

	function getNumBots() {
		return false;
	} # End function getNumBots

	/**
	* Just an routine used for debugging and tracing. Builds an array of
	* log information.
	*
	* @param  string   $method  The method that is logging
	* @param  string   $string  The string for logging/tracing
	* @param  integer  $level   The debug level, determines which messages get logged
	* @param  integer  $type    0 = informational
	*                           1 = data
	* @return nothing
	*/
	function trace($method, $string, $level=0, $type=0) {
		#if(!$this->debug) return;

		# Add entries to the variable
		$entry = Array();
		$entry['method'] = $method;
		$entry['string'] = $string;
		$entry['level'] = $level;
		$entry['type'] = $type;
		$entry['time'] = $this->getmicrotime();
		$this->debug_log[] = $entry;
	} # End function trace
} # End class Servermain
?>