<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: template.slowserver.class.php,v 0.6 2005/12/17 15:15:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Serverclass that is used to handle the slow server option within Serverstat.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class SlowServer extends ServerMain {
	/**
	* Properties.
	*/
	var $serverip = "localhost";						# Ip addr for server to query
	var $port = "29253";							# Port to query
	var $timeout = 160000;							# Timeout in microsecond
	var $retry = 3;

	var $socket = "";							# Socket var...
	var $err = 0;								# Error code, set when an error has occured
	var $errmsg = "";							# Error message...

	var $result = "";							# The result of a status request to the gameserver
	var $serverdata = "";							# Contains server information
	var $userinfo = "";							# Contains player information
	var $numofusers = 0;							# Number of players on server

	var $online = false;
	/**
	* Constructor. Within this constructor we handle all the logic.
	* First we are going to read 
	*/
	function SlowServer ($database, $id ) {
		$this->trace("slowserver::_constructor", "_start", 0, 0);

		# Read corresponding server record.
		$database->setQuery( "SELECT * FROM #__serverstat_servers"
		. "\nWHERE id=$id"
		);
		$rows = $database->loadObjectList();

		# If server vars is empty, the server is considered offline,
		# else we unpack all variables into the properties. Remember
		# we only have the variables needed for module response, this
		# logic will not work for detailed information purposed.
		if (count ($rows) == 1) {
			$row = $rows[0];

			$this->trace("slowserver::_constructor", "serverip: " . $row->ip . "port: "  . $row->port, 0, 0);

			if (!empty($row->slowservervars)) {
				$this->online = true;
				$serversplit = split (";", $row->slowservervars);
				for ($i=0; $i <= sizeof($serversplit) - 2; $i+=2) {
					$j=$i+1;
					$this->serverdata["$serversplit[$i]"] = $serversplit[$j];
				} # End for
			} # End if
		} # End if

		if (isset ($this->serverdata['numofusers'])) {
			$this->numofusers = $this->serverdata['numofusers'];
		} else {
			$this->numofusers = 0;
		} # End if
		$this->serverip = $row->ip;
		$this->port = $row->port;
		$this->trace("slowserver::_constructor", "_end", 0, 0);
	} # End function SlowServer

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		return $this->online;
	} # End function IsServerRunning
	
	/**
	* Returns the current number of users on the server.
	*/
	function getUsersOnline () {
		return number_format($this->serverdata['numofusers']);
	} # End function getUsersOnline

	/**
	* Return the operating system the server is running on.
	*/
	function getOSRunning () {
		return "Unknown";
	} # End function getOSRunning

} # End class SlowServer
?>