<?php
// English translation file for Serverstat module version 0.6
//
// Copyright (C) 2006 Wilco Jansen
// All rights reserved.
//
// This source file is part of the Serverstat Component, a Joomla
// custom Component By Wilco Jansen (willebil) - www.ned-clan.nl 
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// Please note that the GPL states that any headers in files and
// Copyright notices as well as credits in headers, source files
// and output (screens, prints, etc.) can not be removed.
// You can extend them with your own credits, though...
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html.
//

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

# The definitions...quite simple if you ask me :D
DEFINE('_SERVERSTAT_STATHEADER','Online server details');

DEFINE('_SERVERSTAT_ONLINE_ONE','[servername] ([ip]:[port]) is online. Currently there is [numofusers] user online.');
DEFINE('_SERVERSTAT_ONLINE_MORE','[servername] ([ip]:[port]) is online. Currently there are [numofusers] users online.');
DEFINE('_SERVERSTAT_OFFLINE','[servername] ([ip]:[port]) is offline.');
DEFINE('_SERVERSTAT_UNKNOWN','Status of [servername] ([ip]:[port]) has not been checked.');

DEFINE('_SERVERSTAT_NOSERVER','Server cannot be found!');
DEFINE('_SERVERSTAT_NOSERVERS','No servers defined!');
DEFINE('_SERVERSTAT_ERRTEMPLATE','Template for this server cannot be found!');
DEFINE('_SERVERSTAT_SERVEROFFLINE','Server is offline!');
DEFINE('_SERVERSTAT_NOCHANNELS','No channels defined on this server!');

# Definitions for online server status
DEFINE('_SERVERSTAT_BUTTON_SERVER','Server');
DEFINE('_SERVERSTAT_BUTTON_PLAYER','Players');
DEFINE('_SERVERSTAT_BUTTON_USER','Users');
DEFINE('_SERVERSTAT_BUTTON_CHANNEL','Channels');
DEFINE('_SERVERSTAT_PLAYER_DETAILS','Players details');
DEFINE('_SERVERSTAT_SERVER_DETAILS','Details of server');
DEFINE('_SERVERSTAT_USER_DETAILS','Details of users');
DEFINE('_SERVERSTAT_CHANNEL_DETAILS','Details of channels');

DEFINE('_SERVERSTAT_AXIS','Axis');
DEFINE('_SERVERSTAT_ALLIES','Allies');
DEFINE('_SERVERSTAT_SPECTATORS','Spectators');
DEFINE('_SERVERSTAT_PLAYER','Player');
DEFINE('_SERVERSTAT_FRAGS','Frags');
DEFINE('_SERVERSTAT_RATE','Rate');
DEFINE('_SERVERSTAT_ETFRAGS','XP');
DEFINE('_SERVERSTAT_SCORE','Score');
DEFINE('_SERVERSTAT_DEATHS','Deaths');
DEFINE('_SERVERSTAT_KILLS','Kills');
DEFINE('_SERVERSTAT_PING','Ping');
DEFINE('_SERVERSTAT_TEAM','Team');
DEFINE('_SERVERSTAT_CLASS','Class');
DEFINE('_SERVERSTAT_SLOT','Slot');
DEFINE('_SERVERSTAT_MINPING','Min. Ping');
DEFINE('_SERVERSTAT_MAXPING','Max. Ping');
DEFINE('_SERVERSTAT_AVGPING','Avg. Ping');
DEFINE('_SERVERSTAT_SETTING','Setting');
DEFINE('_SERVERSTAT_VALUE','Value');
DEFINE('_SERVERSTAT_CURUSERS','Current Users');
DEFINE('_SERVERSTAT_USER','User');
DEFINE('_SERVERSTAT_CHANNEL','Channel');
DEFINE('_SERVERSTAT_TIME','Time');
DEFINE('_SERVERSTAT_USERS','Users : ');
DEFINE('_SERVERSTAT_CHANNELNAME','Channelname');
DEFINE('_SERVERSTAT_TOPIC','Subject');
DEFINE('_SERVERSTAT_MAXUSERS','Max. users');
DEFINE('_SERVERSTAT_PASSWORD','pw?');
DEFINE('_SERVERSTAT_PROTOCOL','Protocol');
DEFINE('_SERVERSTAT_NUMPLAYERS','[count] players online');

DEFINE('_SERVERSTAT_ID','Id.');
DEFINE('_SERVERSTAT_NAME','Server name: ');
DEFINE('_SERVERSTAT_TYPE','Type');
DEFINE('_SERVERSTAT_IP','Ip adress: ');
DEFINE('_SERVERSTAT_PLAYERS','Players: ');
DEFINE('_SERVERSTAT_MAP','Map: ');
DEFINE('_SERVERSTAT_VERSION','Server version: ');
DEFINE('_SERVERSTAT_LISTENERS','Current / max / peak listeners : ');
DEFINE('_SERVERSTAT_LISTENER_CURRENT','Current listeners : ');
DEFINE('_SERVERSTAT_STREAM_BANDWITH','Stream bandwidth : ');
DEFINE('_SERVERSTAT_SONG','Titel of current song : ');
DEFINE('_SERVERSTAT_GENRE','Genre : ');
DEFINE('_SERVERSTAT_URL','Homepage : ');

DEFINE('_SERVERSTAT_UPTIME','Uptime : ');
DEFINE('_SERVERSTAT_DAYS',' days ');
DEFINE('_SERVERSTAT_BYTESSEND','Bytes send : ');
DEFINE('_SERVERSTAT_BYTESRECEIVED','Bytes received : ');

DEFINE('_SERVERSTAT_NOPLAYERS','No players on this server.');
DEFINE('_SERVERSTAT_NOUSERS','No users on this server.');
DEFINE('_SERVERSTAT_NOPLAYERS_AXIS','No players in axis team present.');
DEFINE('_SERVERSTAT_NOPLAYERS_ALLIES','No players in allies team present.');
DEFINE('_SERVERSTAT_NOSPECS','No spectators present.');
DEFINE('_SERVERSTAT_NOPLAYERSINTEAM','No players in this team.');

DEFINE('_SERVERSTAT_ICE_CLIENTCONNECTIONS','Client connections (cumulative): ');
DEFINE('_SERVERSTAT_ICE_SOURCECONNECTIONS','Source connections (cumulative): ');
DEFINE('_SERVERSTAT_ICE_SOURCES','Number of sources active: ');
DEFINE('_SERVERSTAT_ICE_NOSOURCES','No sources available (empty icecast server)');
DEFINE('_SERVERSTAT_ICE_PLAYLIST','Playlist: ');
DEFINE('_SERVERSTAT_ICE_ARTIST','Artist playing: ');
DEFINE('_SERVERSTAT_ICE_TITLE','Song title: ');
DEFINE('_SERVERSTAT_ICE_BITRATE','Bitrate (kbytes/second): ');
DEFINE('_SERVERSTAT_ICE_CHANNELS','Number of channels: ');
DEFINE('_SERVERSTAT_ICE_SAMPLERATE','Samplerate (kbytes/second): ');
DEFINE('_SERVERSTAT_ICE_LISTENERS','Number of listeners: ');
DEFINE('_SERVERSTAT_ICE_PUBLIC','Public source? ');
DEFINE('_SERVERSTAT_ICE_TYPE','Media type of the stream: ');
DEFINE('_SERVERSTAT_ICE_URL','Listen:');
DEFINE('_SERVERSTAT_ICE_LISTEN','Click to listen');

DEFINE('_SERVERSTAT_YES','Yes');
DEFINE('_SERVERSTAT_NO','No');

# Logging and notification
DEFINE('_SERVERSTAT_LOGACTION','Action');
DEFINE('_SERVERSTAT_LOGACTION_NEW','Insert');
DEFINE('_SERVERSTAT_LOGACTION_UPDATE','Update');
DEFINE('_SERVERSTAT_LOGACTION_NONE','-');
DEFINE('_SERVERSTAT_LOGACTION_CLASSTIMING','Class timing');

DEFINE('_SERVERSTAT_LOGDISABLED','Logging of servers has been disabled!');
DEFINE('_SERVERSTAT_NOSERVER2STAT','Logging of servers has been activated, but there are no servers activated for which we need to log information.');

DEFINE('_SERVERSTAT_MAILSEND_OFFLINE','Server has gone OFF-line, sending an mail notification');
DEFINE('_SERVERSTAT_MAILSEND_ONLINE','Server has gone ON-line, sending an mail notification');
DEFINE('_SERVERSTAT_SUBJECT_OFFLINE','Serverstat notification: Server [server] has gone OFF-line');
DEFINE('_SERVERSTAT_SUBJECT_ONLINE','Serverstat notification: Server [server] is ON-line again');
DEFINE('_SERVERSTAT_BODY_OFFLINE','Serverstat notification: Please note that the server [server] has gone OFF-line.');
DEFINE('_SERVERSTAT_BODY_ONLINE','Serverstat notification: Please note that the server [server] has gone ON-line.');

# Server list (all).
DEFINE('_SERVERSTAT_LIST_SERVERNAME','Servername');
DEFINE('_SERVERSTAT_LIST_PUBLISHED','Published');
DEFINE('_SERVERSTAT_LIST_ORDER','Re-order');
DEFINE('_SERVERSTAT_LIST_IP','IP address');
DEFINE('_SERVERSTAT_LIST_PORT','Port');
DEFINE('_SERVERSTAT_LIST_CATEGORY','Category');
DEFINE('_SERVERSTAT_LIST_TYPE','Type');
DEFINE('_SERVERSTAT_LIST_SELECT_CATEGORY','Select Servercategory');
DEFINE('_SERVERSTAT_LIST_SELECT_TYPE','Select Servertype');

# Subheaders for statistics tab (backend)
DEFINE('_SERVERSTAT_STAT_SERVERNAME','Servername');
DEFINE('_SERVERSTAT_STAT_IP','IP adress');
DEFINE('_SERVERSTAT_STAT_PORT','Port');
DEFINE('_SERVERSTAT_STAT_TYPE','Server type');

DEFINE('_SERVERSTAT_STAT_USERS','Users');
DEFINE('_SERVERSTAT_STAT_MAXUSERS','Max. Users');
DEFINE('_SERVERSTAT_STAT_MINPING','Min. Ping');
DEFINE('_SERVERSTAT_STAT_MAXPING','Max. Ping');
DEFINE('_SERVERSTAT_STAT_AVGPING','Avg. Ping');
DEFINE('_SERVERSTAT_STAT_CLASSTIMING','Class timing');
DEFINE('_SERVERSTAT_STAT_HOURS','Hours');
DEFINE('_SERVERSTAT_STAT_DAY','Day');
DEFINE('_SERVERSTAT_STAT_DAYS','Days');
DEFINE('_SERVERSTAT_STAT_MONTH','Month');
DEFINE('_SERVERSTAT_STAT_MONTHS','Months');
DEFINE('_SERVERSTAT_STAT_YEAR','Year');
DEFINE('_SERVERSTAT_STAT_YEARS','Years');
DEFINE('_SERVERSTAT_STAT_USERLOAD','Load %');

# Server details (edit/new) tab
DEFINE('_SERVERSTAT_DETAILS_SERVERNAME','Servername:');
DEFINE('_SERVERSTAT_DETAILS_IP','Server IP address/hostname:');
DEFINE('_SERVERSTAT_DETAILS_PORT','Server Port:');
DEFINE('_SERVERSTAT_DETAILS_PORT1','Server Port1:');
DEFINE('_SERVERSTAT_DETAILS_PORT1_INFO','Enter this port when an server needs an second port for querying. As far as known, this is only needed for teamspeak servers and servers where the query port differs from the gameport (see documentation for details).');
DEFINE('_SERVERSTAT_DETAILS_USERNAME','Username:');
DEFINE('_SERVERSTAT_DETAILS_USERNAME_INFO','Enter the username that is needed to retrieve the online status for this server (see documentation for details).');
DEFINE('_SERVERSTAT_DETAILS_PASSWORD','Password:');
DEFINE('_SERVERSTAT_DETAILS_PASSWORD_INFO','Enter the password that is needed to retrieve the online status for this server (see documentation for details).');
DEFINE('_SERVERSTAT_DETAILS_CATEGORY','Category:');
DEFINE('_SERVERSTAT_DETAILS_TYPE','Type:');
DEFINE('_SERVERSTAT_DETAILS_TIMEOUT','Timeout:');
DEFINE('_SERVERSTAT_DETAILS_TOOLTIP_TIMEOUT','Enter the timeout value (in milliseconds) for this server. 0 means the timeout value of the default configuration will be used.');

# Published info tab (used with properties of server detail, and used within the
# status tab when rendering server statistics
DEFINE('_SERVERSTAT_PUBLISHED_INFO','In this tab you can select if the server needs to be visible, and de order of the server in the overview. You also can see information about the server that is registered by the module.');
DEFINE('_SERVERSTAT_PUBLISHED_PUBLISHED','Published:');
DEFINE('_SERVERSTAT_SLOWSERVER','Slow server:');
DEFINE('_SERVERSTAT_PUBLISHED_ORDER','Ordering:');
DEFINE('_SERVERSTAT_PUBLISHED_SERVERID','Server ID:');
DEFINE('_SERVERSTAT_PUBLISHED_STATE','Status:');
DEFINE('_SERVERSTAT_PUBLISHED_VIEWS','Viewed:');
DEFINE('_SERVERSTAT_PUBLISHED_HITS','Hits:');
DEFINE('_SERVERSTAT_PUBLISHED_THRESHOLDCOUNTER','Threshold:');
DEFINE('_SERVERSTAT_PUBLISHED_CREATED','Created:');
DEFINE('_SERVERSTAT_PUBLISHED_CREATEDBY','Created by:');
DEFINE('_SERVERSTAT_PUBLISHED_LASTMODIFIED','Modified:');
DEFINE('_SERVERSTAT_PUBLISHED_MODIFIEDBY','Modified by:');
DEFINE('_SERVERSTAT_PUBLISHED_CURRENTSTATUS','Online status:');

DEFINE('_SERVERSTAT_PUBLISHED_INI_SAFEMODE','php:safemode');
DEFINE('_SERVERSTAT_PUBLISHED_INI_MAXEXECUTIONTIME','php:maxexecutiontime');
DEFINE('_SERVERSTAT_PUBLISHED_INI_MAXINPUTTIME','php:maxinputtime');
DEFINE('_SERVERSTAT_PUBLISHED_INI_MEMORYLIMIT','php:memorylimit');
DEFINE('_SERVERSTAT_PUBLISHED_INI_FILEUPLOADS','php:fileuploads');
DEFINE('_SERVERSTAT_PUBLISHED_INI_UPLOADMAXFILESIZE','php:uploadmaxfilesize');

DEFINE('_SERVERSTAT_PUBLISHED_LOGENTRIES','Log entries:');
DEFINE('_SERVERSTAT_PUBLISHED_LOGSTARTED','Log started on:');
DEFINE('_SERVERSTAT_PUBLISHED_LASTLOG','Last log:');
DEFINE('_SERVERSTAT_PUBLISHED_LOGINTERVAL','Log interval:');

# Appearrence tab
DEFINE('_SERVERSTAT_APPEARRENCE_INFO','In this tab you can determine how the online status is shown in the module (the small-icon before servername) and the template that will be used for rendering the server detail page.');
DEFINE('_SERVERSTAT_APPEARRENCE_SERVERIMAGE','Server image:');
DEFINE('_SERVERSTAT_APPEARRENCE_DETAILSTEMPLATE','Detail template:');

# Logging tab
DEFINE('_SERVERSTAT_LOGGING_INFO','In this tab you can enable or disable the server logging and notification. Remember that server logging needs to be activated within the config area and the crontab (check the administration manual for more details).');
DEFINE('_SERVERSTAT_LOGGING_ENABLE','Logging enabled for this server:');
DEFINE('_SERVERSTAT_LOGGING_EMAILNOTIFICATION','Email notification:');
DEFINE('_SERVERSTAT_LOGGING_EMAIL','Email address:');

# Tweaking tab
DEFINE('_SERVERSTAT_RETRY_INFO','It sometimes happens that the server does not respond immediatly, and then seems to be offline. This values determines the times the Serverstat component will retry to get the server status. Remember, the higher the value, the lower performance you get with offline servers! This value overides the default configuration setting when greater then 0, when entered an value of 0 the default configuration value will be used.');
DEFINE('_SERVERSTAT_RETRYCOUNT','Retry count:');
DEFINE('_SERVERSTAT_TIMEOUT_INFO','The timeout value is specified in microseconds and determines the amount of time Serverstat will try to contact an server. Keep in mind that high values can lead to a performance drop, enter a value of 0 to use the server default value (not visible, check out the administrator manual for a table with values per servertype).');
DEFINE('_SERVERSTAT_TIMEOUT','Timeout value (microseconds):');

# Backend headers
DEFINE('_SERVERSTAT_BACKHEADER_SERVERLIST_ALL','Serverstat - Server List [All]');
DEFINE('_SERVERSTAT_BACKHEADER_EDIT','Serverstat - Edit ');
DEFINE('_SERVERSTAT_BACKHEADER_NEW','Serverstat - New ');
DEFINE('_SERVERSTAT_BACKHEADER_STATS','Serverstat - Statistics ');
DEFINE('_SERVERSTAT_BACKHEADER_STATS_ALL',' All ');
DEFINE('_SERVERSTAT_BACKHEADER_STATS_SERVER','Server ');
DEFINE('_SERVERSTAT_BACKHEADER_STATS_REPORDATE','Date ');
DEFINE('_SERVERSTAT_BACKHEADER_STATS_PUBLISHINGINFO','General information');
DEFINE('_SERVERSTAT_BACKHEADER_STATS_PUBLISHINGLOGINFO','Datalog information');
DEFINE('_SERVERSTAT_BACKHEADER_STATS_GRAPHICS','Graphical image of server performance');
DEFINE('_SERVERSTAT_BACKHEADER_SERVERDETAILS','Server details');

# Mappack logic
DEFINE('_SERVERSTAT_MAPPACK_ALL','Available map-packs');
DEFINE('_SERVERSTAT_MAPPACK_DESCRIPTION','Description');
DEFINE('_SERVERSTAT_MAPPACK_VERSION','Version');
DEFINE('_SERVERSTAT_MAPPACK_STATUS','Status');
DEFINE('_SERVERSTAT_MAPPACK_ERRNOMAPS','No map-packs found! Please check the main configuration.');
DEFINE('_SERVERSTAT_MAPPACK_MAPNOTINSTALLED','Map-pack not installed, select map-pack and click on install to install');
DEFINE('_SERVERSTAT_MAPPACK_INSTALLED','Version [version] of map-pack installed');
DEFINE('_SERVERSTAT_MAPPACK_INSTALLEDUPGRADE','Version [version] of map-pack installed, select map-pack and click on install to upgrade');

DEFINE('_SERVERSTAT_MAPPACK_RESULTS','Results of map-pack (de-)installation');
DEFINE('_SERVERSTAT_ERR_MAPPACK_NOSELECTION','No map-pack selected!');
DEFINE('_SERVERSTAT_MAPPACK_INSTALLOK','Map-pack for [description] has sucessfully been installed');
DEFINE('_SERVERSTAT_MAPPACK_INSTALLNOK','Map-pack for [description] has NOT been installed ([errmsg])');
DEFINE('_SERVERSTAT_MAPPACK_NOTHING','Map-pack for [description] selected, but nothing has been done (versions are equal)');
DEFINE('_SERVERSTAT_MAPPACK_UPGRADE','Map-pack for [description] had been upgraded');
DEFINE('_SERVERSTAT_MAPPACK_UPGRADEOK','Map-pack for [description] has sucessfully been upgraded');
DEFINE('_SERVERSTAT_MAPPACK_UPGRADENOK','Map-pack for [description] has NOT been upgraded ([errmsg])');
DEFINE('_SERVERSTAT_MAPPACK_DELETEOK','Map-pack for [description] has sucessfully been removed');
DEFINE('_SERVERSTAT_MAPPACK_DELETENOK','Map-pack for [description] has NOT been removed ([errmsg])');
DEFINE('_SERVERSTAT_MAPPACK_NOTINSTALLED','Map-pack [description] not installed');

# Text for tabs
DEFINE('_SERVERSTAT_TABPUBLISHING','Publishing');
DEFINE('_SERVERSTAT_TABPUBLISHING_INFO','Publication information');
DEFINE('_SERVERSTAT_APPEARANCE','Appearance');
DEFINE('_SERVERSTAT_LOGGING','Logging');
DEFINE('_SERVERSTAT_MISCELLANEOUS','Miscellaneous');
DEFINE('_SERVERSTAT_TABDETAILS','Details');
DEFINE('_SERVERSTAT_TABGRAPHICAL','Graphics');
DEFINE('_SERVERSTAT_TABSTATUS','Status');
DEFINE('_SERVERSTAT_TABSERVERLOGGING','Server logging and notification');
DEFINE('_SERVERSTAT_TABSERVERRETRY','Server retry options');
DEFINE('_SERVERSTAT_TWEAKING','Tweaking');
DEFINE('_SERVERSTAT_TABTIMEOUT','Timeout behaviour');

# Text for JpGraph images
DEFINE('_SERVERSTAT_JPGRAPH_USERS','Users per hour');
DEFINE('_SERVERSTAT_JPGRAPH_PERFORMANCE','Performance per hour');
DEFINE('_SERVERSTAT_JPGRAPH_CLASS_PERFORMANCE','Class performance per hour');
DEFINE('_SERVERSTAT_JPGRAPH_PERFORMANCE_X','Hours');
DEFINE('_SERVERSTAT_JPGRAPH_PERFORMANCE_Y','Ping');
DEFINE('_SERVERSTAT_JPGRAPH_PERFORMANCE_CLASS_Y','Time (seconds)');
DEFINE('_SERVERSTAT_JPGRAPH_MINPING','Minimum ping');
DEFINE('_SERVERSTAT_JPGRAPH_MAXPING','Maximum ping');
DEFINE('_SERVERSTAT_JPGRAPH_AVGPING','Avarage ping');

# Configuration fields
DEFINE('_SERVERSTAT_CONFIG_THRESHOLD','Threshold:');
DEFINE('_SERVERSTAT_CONFIG_DEFAULTTEMPLATE','Default template:');
DEFINE('_SERVERSTAT_CONFIG_CONNECTBUTTON','Client connect button:');
DEFINE('_SERVERSTAT_CONFIG_RETRYCOUNT','Retry count:');
DEFINE('_SERVERSTAT_CONFIG_TRACETEMPLATE','Trace template:');
DEFINE('_SERVERSTAT_CONFIG_LOGGING','Logging activated:');
DEFINE('_SERVERSTAT_CONFIG_INTERVAL','Logging interval:');
DEFINE('_SERVERSTAT_CONFIG_JPGRAPH','JpGraph support:');
DEFINE('_SERVERSTAT_CONFIG_TWEAKING','Tweaking tab enabled:');
DEFINE('_SERVERSTAT_CONFIG_BACKENDCHECK','Perform backend servercheck:');
DEFINE('_SERVERSTAT_CONFIG_NOTEMPLATE','No templates found! Please check your install, this message normally is not visible, only when the installation was not properly executed!');
DEFINE('_SERVERSTAT_CONFIG_TIMEOUT','Timeout:');
DEFINE('_SERVERSTAT_CONFIG_URLMASTERMAPPACK','Location of mappack (url):');

DEFINE('_SERVERSTAT_TOOLTIP_TRESHHOLD','When an server is offline, the offline status is shown until the number of times that this value is exceeded. If so, the unknown status is rendered. This is an feature that will prevent performance loss on sites when an remote server is offline. Default value is 5.');
DEFINE('_SERVERSTAT_TOOLTIP_TEMPLATE','When no template is choosen in de server detail tab, this template is used to render the server details.');
DEFINE('_SERVERSTAT_TOOLTIP_CONNECTBUTTON','Here you can enable/disable the appearence of client connect buttons in the templates. Remember that for some games you need to install steam support, see the online manual for details');
DEFINE('_SERVERSTAT_TOOLTIP_LOGGING','Enable this to activate the server logging. Remember to add an crontab job to really start the logging!');
DEFINE('_SERVERSTAT_TOOLTIP_INTERVAL','Enter the log interval which you want to use. See documentation for usage.');
DEFINE('_SERVERSTAT_TOOLTIP_JPGRAPH_YES','JpGraph supplies the possibility to add some graphical info to the serverstat module. Activate this item to simple enable this feature.');
DEFINE('_SERVERSTAT_TOOLTIP_JPGRAPH_NO','JpGraph supplies the possibility to add some graphical info to the serverstat module. Currently the module is not installed, please install the JpGraph module to activate this feature.');
DEFINE('_SERVERSTAT_TOOLTIP_TIMEOUT','This value determines the default timeout value (in milliseconds), this is the default value for server. Beside this value you can configure this value per server.');
DEFINE('_SERVERSTAT_TOOLTIP_TRACETEMPLATE','This template is used for rendering the trace information for an server. Do not use this template for normal usage!');
DEFINE('_SERVERSTAT_TOOLTIP_RETRYCOUNT','It sometimes happens that the server does not respond immediatly, and then seems to be offline. This value determines the times the Serverstat component will retry to get the server status. Remember, the higher the value, the lower performance you get with offline servers!');
DEFINE('_SERVERSTAT_TOOLTIP_TWEAKING','Enable this option to make the server tweaking tab visibile in the server details. Be cautious enabling this option, please check out the administrator manual before enabling this option!');
DEFINE('_SERVERSTAT_TOOLTIP_BACKENDCHECK','When the online server check locks up the site, and you want to administer servers, uncheck this option and no online check will be performed in the backend.');
DEFINE('_SERVERSTAT_TOOLTIP_URLMASTERMAPPACK','Here the url is placed were Serverstat can find the map-pack master xml file, default this is http://www.ned-clan.nl/serverstat/');

DEFINE('_SERVERSTAT_TRACEHEADER','Trace of server interaction');
DEFINE('_SERVERSTAT_TRACEHEADERPHP','Server settings (php & local Joomla)');
DEFINE('_SERVERSTAT_BUTTON_TRACESERVER','Server');
DEFINE('_SERVERSTAT_BUTTON_TRACEDETAILS','Trace');
DEFINE('_SERVERSTAT_BUTTON_TRACEPHP','PHP');
DEFINE('_SERVERSTAT_FRONTHEADER_STATS_SERVERDETAILS','Server details');
DEFINE('_SERVERSTAT_FRONTHEADER_STATS_PUBLISHINGINFO','Publishing details');
DEFINE('_SERVERSTAT_TRACE_PRERESULTS','Next you see some server checks that have been performed. Keep in mind these checks do not depend on server settings that have been entered in the back-end of Serverstat.');
DEFINE('_SERVERSTAT_TRACE_HOSTCHECK','Hostname/ip resolving check : ');
DEFINE('_SERVERSTAT_TRACE_INFO','Next you see the trace information for this server.');
DEFINE('_SERVERSTAT_TRACE_NR','Nr.');
DEFINE('_SERVERSTAT_TRACE_TIME','Time');
DEFINE('_SERVERSTAT_TRACE_METHOD','Method');
DEFINE('_SERVERSTAT_TRACE_INFORMATION','Trace information');
DEFINE('_SERVERSTAT_TRACE_TOTALTIME','Total time retrieving server status ');
DEFINE('_SERVERSTAT_TRACE_IP_SAME','Ip address entered, no further checks needed.');
DEFINE('_SERVERSTAT_TRACE_IP_DIFFER','Hostname and reversed lookup of ip-address differ!');
DEFINE('_SERVERSTAT_TRACE_IP_LOOKUP','ip-adress resolved : ');
DEFINE('_SERVERSTAT_TRACE_IP_REVERSELOOKUP','reverse lookup of ip-address : ');
DEFINE('_SERVERSTAT_TRACE_CLASSTIMING','class timing (seconds): ');

# Javascript error messages
DEFINE('_SERVERSTAT_JSCRIPTERR_SERVERNAME','Please enter an servername!');
DEFINE('_SERVERSTAT_JSCRIPTERR_SERVERTYPE','Please choose an servertype!');
DEFINE('_SERVERSTAT_JSCRIPTERR_IP','Please enter an ip adress or host name for this server!');
DEFINE('_SERVERSTAT_JSCRIPTERR_PORT','Please enter an (valid) port addess for this server!');
DEFINE('_SERVERSTAT_JSCRIPTERR_PORT1','Please enter an (valid) port1 addess for this server!');
DEFINE('_SERVERSTAT_JSCRIPTERR_RETRYCOUNT','Please enter valid retrycount value!');
DEFINE('_SERVERSTAT_JSCRIPTERR_EMAIL','When enabling the email notification you need to enter an valid e-mail address!');
DEFINE('_SERVERSTAT_JSCRIPTERR_TIMEOUT','Please enter an correct timeout value!');

# Online help
DEFINE('_SERVERSTAT_HELP_HEADER','Help');
DEFINE('_SERVERSTAT_HELP_VERSION','Serverstat version ');
DEFINE('_SERVERSTAT_HELP_ADMINISTRATIONMANUAL','Administration manual');

DEFINE('_SERVERSTAT_HELP_BUTTON_GO','Go');
DEFINE('_SERVERSTAT_HELP_SEARCH','Search');
DEFINE('_SERVERSTAT_HELP_BUTTON_CLEAR','Clear results');

DEFINE('_SERVERSTAT_HELP_CREDITS','Credits');
DEFINE('_SERVERSTAT_HELP_SUPPORT','Support');
DEFINE('_SERVERSTAT_HELP_LICENCE','Licence');
DEFINE('_SERVERSTAT_HELP_SYSTEMINFO','System Info');

# Search bot
DEFINE('_SERVERSTAT_SEARCH_SERVERTYPE','Servertype: ');

# new for release 0.5
DEFINE('_SERVERSTAT_STATE','State');
DEFINE('_SERVERSTAT_LIST_DEFAULT','Default for servertype');

DEFINE('_SERVERSTAT_REMOTESTATUS','Remote Status');
DEFINE('_SERVERSTAT_CONFIG_REMOTESTATUS','Enable remote status retrievement: ');
DEFINE('_SERVERSTAT_CONFIG_SERVICEPROVIDER','Service provider: ');
DEFINE('_SERVERSTAT_CONFIG_ACTASSERVICEPROVIDER','Act as remote service provider: ');
DEFINE('_SERVERSTAT_TOOLTIP_REMOTESTATUS','Check this option when you want to activate the remote-status retrievement option. Please read the online manual carefully when enabling this option!');
DEFINE('_SERVERSTAT_TOOLTIP_SERVICEPROVIDER','The full url of the website that is able to act as a remote server status service provider. Please use a host here that is certified to handle this job. Also read the online manual carefully when enabling this option!');
DEFINE('_SERVERSTAT_TOOLTIP_ACTASSERVICEPROVIDER','Do you want others to retrieve the online status using your website? Read the online manual carefully when enabling this option!');

DEFINE('_SERVERSTAT_INFO_REMOTESTATUS','Warning! Only enable this option when you fully understand the logic behing remote server status retrievement. All information can be found in the online documentation!');

DEFINE('_SERVERSTAT_TOTALTIME','Total time');

DEFINE('_SERVERSTAT_CLASSNOTFOUND','Panic! Server class ([class]) not found!');

DEFINE('_SERVERSTAT_ICE_STEAMINFO','Playing [song] with [listeners] listeners, click to listen');

# new for release 0.5.2
DEFINE('_SERVERSTAT_CONFIG_LOGPUBLISHED','Only log published servers: ');
DEFINE('_SERVERSTAT_TOOLTIP_LOGPUBLISHED','Here you can specify if only published servers will be logged, uncheck if you want logging enabled for all servers.');
DEFINE('_SERVERSTAT_CONFIG_LOGREMOTE','Log remote servers: ');
DEFINE('_SERVERSTAT_TOOLTIP_LOGREMOTE','If your site acts as a remote service provider, you can enable statisics logging here for servers that have been collected remotely.');

# new for release 0.5.3
DEFINE('_SERVERSTAT_AVARAGE_LISTENTIME','Average Listen Time: ');
DEFINE('_SERVERSTAT_SONGHISTORY','Song history');
DEFINE('_SERVERSTAT_LOGMESSAGEFINAL','Updating of [servers] server(s) took [time] seconds');

# new for release 0.6
DEFINE('_SERVERSTAT_DISABLEWHENLOGTHRESHOLDREACHED','Auto disable logging when threshold is reached: ');
DEFINE('_SERVERSTAT_TOOLTIP_DISABLEWHENLOGTHRESHOLDREACHED','When you enable this option, the logging option will get disabled when the class timing reaches the threshold value below. See online documentation for a description of this logic.');
DEFINE('_SERVERSTAT_LOGTHRESHOLD','Auto disable threshold value (seconds): ');
DEFINE('_SERVERSTAT_TOOLTIP_LOGTHRESHOLD','Threshold value in seconds. A value that is 0 or less then 0 will lead to auto disabling all logging for servers!');
DEFINE('_SERVERSTAT_UPTIMETODAY','Uptime today: ');
DEFINE('_SERVERSTAT_UPTIMEMONTH','Uptime this month: ');
DEFINE('_SERVERSTAT_UPTIMEOVERALL','Overall uptime: ');
DEFINE('_SERVERSTAT_GAMETYPENOTSUPPORTED','Gametype is not supported');
DEFINE('_SERVERSTAT_SERVERTYPE','Server type: ');
DEFINE('_SERVERSTAT_INCLUDEREMOTE','Include remote servers: ');
DEFINE('_SERVERSTAT_HELP_INSTANT','Short information about selected server');
DEFINE('_SERVERSTAT_HELP_NOTAVAILABLE','No information for this servertype available.');
DEFINE('_SERVERSTAT_CODEC','Voice Codec : ');
DEFINE('_SERVERSTAT_VOICEFORMAT','Voice Format : ');
DEFINE('_SERVERSTAT_BUTTON_STATUS','Status');
DEFINE('_SERVERSTAT_BUTTON_CONNECT','Connect');
DEFINE('_SERVERSTAT_LOGRETENTION','Retention: ');
DEFINE('_SERVERSTAT_TOOLTIP_LOGRETENTION','The amount of days to keep the logging information, 0 is keep forever. Keep in mind that a high value can generate high number of records in the database.');
DEFINE('_SERVERSTAT_TEAMSPEAK_SERVER','Server address: [host], Max users: [maxusers], Uptime: [time]');
DEFINE('_SERVERSTAT_TEAMSPEAK_CHANNEL','Max players: [maxusers], Codec: [codec], Topic: [topic]');
DEFINE('_SERVERSTAT_TEAMSPEAK_USER','Time online: [time], Ping: [ping]');

# Month names
$serverstat_monthnames = Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "Oktober", "November", "December" );
?>
