<?php
/**
* Serverstatus 0.6.1 for Joomla CMS 
* @version $Id: serverstat.php,v 0.6.1 2006/01/13 22:50:00 wilcojansen Exp $
* @package serverstat 0.6.1 - Show online server status
*
* LICENSE
* =======
* Copyright (C) 2005/2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/includes/function.serverstat.php");
require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/config/config.serverstat.php");
require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/class.serverstat.php");

# Load language file
$map = $mosConfig_absolute_path . '/administrator/components/com_serverstat';

if (file_exists($map.'/language/'.$mosConfig_lang.'.php')) {
	require_once($map.'/language/'.$mosConfig_lang.'.php');
} elseif (file_exists($map.'/language/english.php'))  {
	require_once($map.'/language/english.php');
} else {
	die ( 'Language file not present...' );
}# End if

/**
* Handle the events.
*/
switch ($task) {
	case "view":
	case "trace":
		$id = intval( mosGetParam( $_GET, 'id', 0 ) );
		showServer( $option, $database, $id, $task );
		break;

	case "log":
		logServerStats ();
		break;

	case "remote":
		showServerRemote( $option, $database, $task );
		break;

	default:
		showServerList( $option, $database );
		break;
} # End switch

/**
* Render the details using the templates...
*/
function showServer ( $option, $database, $id, $task ) {
	global $mosConfig_absolute_path, $serverstat_trace_template;
	global $serverstat_connectbutton, $mosConfig_live_site;
?>
<table width="100%">
<tr>
<th class="contentheading" width="100%"><?php echo _SERVERSTAT_STATHEADER; ?></th>
</tr>
</table>

<table class="contentpaneopen" width="100%">
<tr>
<td width="100%">
<?php
	# First we read the server record
   	$database->setQuery( "SELECT * FROM #__serverstat_servers"
   	. "\nWHERE id=" . $id
   	);
   	$rows = $database->loadObjectList();

	# We can only have 1 result here, if not, throw an error
	if (count($rows) != 1) {
		echo _SERVERSTAT_NOSERVER;
	} else {
		# Now we determine which template we need to include. Also instantiate
		# the server variable so it can be used within the template.
		if (strtolower ($task) == "trace") {
			$debug = true;
		} else {
			$debug = false;
		} # End if

		$row = $rows[0];
		if (!$server = instantiateServerClass ( $row, $debug, false )) {
			echo str_replace ("[class]", $row->servertype, _SERVERSTAT_CLASSNOTFOUND);
		} else {
			$vars = "";
			if ($server->IsServerRunning () || $task == "trace") {
				if (strtolower ($task) == "trace") {
					$include = $mosConfig_absolute_path. "/administrator/components/com_serverstat/templates/" . $serverstat_trace_template;
				} elseif (!empty($row->template) != "") {
					$include = $mosConfig_absolute_path. "/administrator/components/com_serverstat/templates/" . $row->template;
				} else {
					$include = $mosConfig_absolute_path. "/administrator/components/com_serverstat/templates/" . getServerConfigVar ($row, "template") . ".php";
				} # End if

				if (file_exists($include) && !is_dir($include)) {
					require_once( $include);
				} else {
					echo _SERVERSTAT_ERRTEMPLATE;
				} # End if
			
				# Update the hits counter and slowserver variables here
				$slowservervars = Array();
				$slowservervars[] = "numofusers";
				$slowservervars[] = $server->getUsersOnline();
				$slowservervars[] = "os";
				$slowservervars[] = $server->getOSRunning ();

				if (!empty($server->serverdata)) {
					# Also add all $this->serverdata variables, can be used
					# later on to show details of server in slow-server
					# option.
					foreach ($server->serverdata as $key => $value) {
						$slowservervars[] = getASCII($key);
						# replace probable delimiters from values
						#$value = str_replace (";", "", $value);
						#$value = str_replace ("'", "", $value);
						$slowservervars[] = getASCII($value);
					} # End foreach
				} # End if
				$vars = implode(";", $slowservervars);
			} else {
				echo _SERVERSTAT_SERVEROFFLINE;
			} # End if

			# Now write record, update hitcount, and of course save
			# the server data for slow-server option.
			$database->setQuery( "UPDATE #__serverstat_servers"
			. "\nSET hits=hits+1,"
			. "slowservervars='" . $vars . "'"
			. "\nWHERE id=".$row->id
			);
	
			if (!$database->query()) {
				die ("Error setting the slowserver variables for gameserver : " . $id . "<br><br>" . $database->stderr());
			} # End if
		} # End if
	} # End if
?>
</td>
</tr>
</table>
<?php
} # End function showServer

/**
* Just log some information for servers into the database.
*/
function logServerStats () {
	global $database, $mosConfig_absolute_path, $mosConfig_mailfrom, $mosConfig_fromname;
	global $serverstat_collectstats, $serverstat_threshold, $serverstat_logpublished, $serverstat_logremote;
	global $serverstat_disablewhenlogthresholdreached, $serverstat_logthreshold, $serverstat_logretention;

	# Only go along when logging is enabled (sound logical is it not?)
	if ($serverstat_collectstats == 0) { 
		echo _SERVERSTAT_LOGDISABLED;
		return;
	} # End if

	# First thing we are gonna do here is to do some cleaning of the logged
	# records (the retention option in the main config)
	if ($serverstat_logretention > 0) {
		$query = "DELETE FROM #__serverstat_stats WHERE date < '" . date ('Y-m-d', strtotime(date ('Y-m-d')) - ($serverstat_logretention * 24 * 60 * 60)) . "'";
		$database->setQuery($query);

		if (!$database->query()) {
			die ("Error cleaning up old log (check retention value in main configuration");
		} # End if
	} # End if
?>
<table width="100%">
<tr>
<th class="contentheading" width="100%"><?php echo _SERVERSTAT_STATHEADER; ?></th>
</tr>
</table>

<table class="contentpaneopen" width="100%" cellspacing="0" cellpadding="5">
<?php
	# "Walk" along all published servers, and servers for which the logging
	# has been activated. Just handle the extra config options
	# "only log published" and "log remote server" option here.
	$query = "SELECT * FROM #__serverstat_servers WHERE collectstats > 0";

	if ($serverstat_logpublished != 0) {
		$query .= " AND published > 0";
	} # End if

	if ($serverstat_logremote == 0) {
		$query .= " AND remote = 0";
	} # End if

	$database->setQuery($query);
	$rows = $database->loadObjectList();

	# We can only have 1 result here, if not, throw an error
	if (count($rows) == 0) {
		echo "<tr><td>"  . _SERVERSTAT_NOSERVER2STAT . "</td></tr>\n";
	} else {
		?>
		<tr class="sectiontableheader">
			<th width="3%" align="left"><?php echo _SERVERSTAT_ID; ?></th>
			<th width="10%" align="left"><?php echo _SERVERSTAT_TYPE; ?></th>
			<th width="50%" align="left"><?php echo _SERVERSTAT_NAME; ?></th>
			<th align="right"><?php echo _SERVERSTAT_CURUSERS; ?></th>
			<th align="right"><?php echo _SERVERSTAT_MAXUSERS; ?></th>
			<th align="right"><?php echo _SERVERSTAT_MINPING; ?></th>
			<th align="right"><?php echo _SERVERSTAT_MAXPING; ?></th>
			<th align="right"><?php echo _SERVERSTAT_AVGPING; ?></th>
			<th align="right"><?php echo _SERVERSTAT_LOGACTION_CLASSTIMING; ?></th>
			<th align="left"><?php echo _SERVERSTAT_LOGACTION; ?></th>
		</tr>
		<?php
		$time=0;
		for ($i=0; $i < count( $rows ); $i++) {
			$row = &$rows[$i];

			if (!$server = instantiateServerClass ( $row, $debug )) {
				$result = str_replace ("[class]", $row->servertype, _SERVERSTAT_CLASSNOTFOUND);
			} else {
				# Update/insert an row for logging information
				switch (ServerLog($row->id, $server)) {
					case -1:
						$result = _SERVERSTAT_LOGACTION_NONE;
						break;
					case 0:
						$result = _SERVERSTAT_LOGACTION_UPDATE;
						break;
					case 1:
						$result = _SERVERSTAT_LOGACTION_NEW;
						break;
				} # End switch
			} # End if

			# Render the results for this server.
			?>
			<tr>
				<td width="3%" align="left"><?php echo $row->id; ?>.</td>
				<td width="10%" align="left"><?php echo $row->servertype ; ?></td>
				<td width="50%" align="left">
				<?php
				echo $row->servername;
				if (!$server->IsServerRunning ()) {
					echo "<font color=\"red\">*</font>";
				} # Echo 
				?>
				</td>
				<td align="right"><?php echo $server->getUsersOnline (); ?></td>
				<td align="right"><?php echo $server->getMaxClients (); ?></td>
				<td align="right"><?php echo $server->getPingLowest(); ?></td>
				<td align="right"><?php echo $server->getPingHighest(); ?></td>
				<td align="right"><?php echo $server->getPingAvarage(); ?></td>
				<?php
				# Auto disable logging when threshold is reached
				# (only when this option is enabled)
				$time = $server->getClassTiming();
				$totaltime += $time;
				if ($serverstat_disablewhenlogthresholdreached == 1 && $time > $serverstat_logthreshold) {
					$database->setQuery( "UPDATE #__serverstat_servers"
					. "\nSET collectstats=0"
					. "\nWHERE id=".$row->id
					);
	
					if (!$database->query()) {
						die ("Error updating collectstats flag for gameserver : " . $row->id);
					} # End if
				} # End if
				?>
				<td align="right"><?php echo number_format($time, 5); ?></td>
				<td align="left"><?php echo $result; ?></td>
			</tr>
			<?php
			if ($row->emailnotification != 0 && !empty($row->email)) {
				# Mail notification: online --> offline logic:
				# Here we handle the mail notification for the given
				# server record. When the threshold value exceeds
				# the configuration value, and the mailsend column
				# is equal to 0, we have not send an e-mail yet, just
				# send it and "flip" the mailsend value.
				if ($row->tcounter > $serverstat_threshold && $row->mailsend == 0) {
					# Build mail message, and send it. Use the 
					# mosMail method that comes within the Joomla
					# framework.
					$from = $mosConfig_mailfrom;
					$fromname = $mosConfig_fromname;
					$subject = _SERVERSTAT_SUBJECT_OFFLINE;
					$subject = str_replace("[server]", $row->servername . " (" . $row->ip . ":" . $row->port . ")", $subject);
					$body = _SERVERSTAT_BODY_OFFLINE;
					$body = str_replace("[server]", $row->servername . " (" . $row->ip . ":" . $row->port . ")", $body);
					mosMail($from, $fromname, $row->email, $subject, $body);

					# Set mailsend flag here
					$database->setQuery( "UPDATE #__serverstat_servers"
					. "\nSET mailsend=1"
					. "\nWHERE id=".$row->id
					);
	
					if (!$database->query()) {
						die ("Error updating mailsend flag for gameserver : " . $row->id);
					} # End if
					?>
					<tr>
					<td>&nbsp;</td>
					<td colspan="8" align="left"><?php echo _SERVERSTAT_MAILSEND_OFFLINE; ?></td>
					</tr>
					<?php
				} # End if
			
				# Mail notification: offline --> online logic:
				# Here we handle the mail notification for the given
				# server record. When the threshold is 0 and the 
				# mailsend flag is set, the server has gone online
				# but not mail has been send for notification, just
				# send it if this event occurs, and reset the mailsend
				# flag.
				if ($row->tcounter == 0 && $row->mailsend == 1) {
					# Build mail message, and send it. Use the 
					# mosMail method that comes within the Joomla
					# framework.
					$from = $mosConfig_mailfrom;
					$fromname = $mosConfig_fromname;
					$subject = _SERVERSTAT_SUBJECT_ONLINE;
					$subject = str_replace("[server]", $row->servername . " (" . $row->ip . ":" . $row->port . ")", $subject);
					$body = _SERVERSTAT_BODY_ONLINE;
					$body = str_replace("[server]", $row->servername . " (" . $row->ip . ":" . $row->port . ")", $body);
					mosMail($from, $fromname, $row->email, $subject, $body);

					# Set mailsend flag here
					$database->setQuery( "UPDATE #__serverstat_servers"
					. "\nSET mailsend=0"
					. "\nWHERE id=".$row->id
					);
	
					if (!$database->query()) {
						die ("Error updating mailsend flag for gameserver : " . $row->id);
					} # End if
					?>
					<tr>
					<td>&nbsp;</td>
					<td colspan="8" align="left"><?php echo _SERVERSTAT_MAILSEND_ONLINE; ?></td>
					</tr>
					<?php
				} # End if
			} # End if
		} # End for
		?>
		<tr><td colspan="10">
		<?php 
		$text = str_replace ("[servers]" , count($rows), _SERVERSTAT_LOGMESSAGEFINAL);
		echo str_replace ("[time]" , number_format($totaltime, 5), $text);
		?>
		</td></tr>
		<?php
	} # End if
?>
</table>
<?php
} # End function logServerStats

/**
* Function to insert or update an entry in the server log.
* servers to the proper HTML variant.
*
* Returns -1 : no record written
* Returns 0  : record updated
* Returns 1  : record inserted
*/
function ServerLog($id, $server) {
	global $database, $serverstat_loginterval;

	$result = -1;

	# first we determinge the date/time stamp
	$intervaldate = date ("Y-m-d H:") . sprintf("%02d", intval(date ("M") / $serverstat_loginterval) * $serverstat_loginterval) . ":00";
	
	# now we try to read the record, if it exsists, we calculate the avarage
	# values for the fields, en update the record. If the record does not
	# exist we just insert a new record.
	$database->setQuery( "SELECT * FROM #__serverstat_stats"
	. "\nWHERE serverid=" . $id
	. "\nAND date='"  . $intervaldate . "'"
	);

	if ($server->IsServerRunning ()) {
		$online = 1;
	} else {
		$online = 0;
	} # End if

	$rows = $database->loadObjectList();
	if (count($rows) == 0) {
		$result = 1;
		$database->setQuery( "INSERT INTO #__serverstat_stats"
		. "\nSET serverid=$id"
		. "\n   ,date='" . $intervaldate . "'"
		. "\n   ,users =" . $server->getUsersOnline ()
		. "\n   ,maxusers =" . $server->getMaxClients ()
		. "\n   ,pinglowest =" . $server->getPingLowest()
		. "\n   ,pinghighest =" . $server->getPingHighest()
		. "\n   ,pingavarage =" . $server->getPingAvarage()
		. "\n   ,classtiming  =" . $server->getClassTiming()
		. "\n   ,online = " . $online
		);

		if (!$database->query()) {
			die ($database->stderr());
		} # End if
	} else {
		$row = $rows[0];

		# We have an existing record. We not just overwrite the values, we calculate
		# the avararage value of the row and server value here.
		$result = 0;

		$database->setQuery( "UPDATE #__serverstat_stats"
		. "\nSET users =" . ($server->getUsersOnline () + $row->users) /2
		. "\n   ,maxusers =" . ($server->getMaxClients () + $row->maxusers) /2
		. "\n   ,pinglowest =" . intval(($server->getPingLowest() + $row->pinglowest) / 2)
		. "\n   ,pinghighest =" . intval(($server->getPingHighest() + $row->pinghighest) / 2)
		. "\n   ,pingavarage =" . intval(($server->getPingAvarage() + $row->pingavarage) / 2)
		. "\n   ,classtiming =" . ($server->getClassTiming() + $row->classtiming) / 2
		. "\n   ,online=" . ($online + $row->online ) / 2
		. "\nWHERE serverid=$id"
		. "\nAND date='" . $intervaldate . "'"
		);

		if (!$database->query()) {
			die ($database->stderr());
		} # End if
	} # End if

	# Slow server option....
	$vars = "";
	if ($server->IsServerRunning ()) {
		# Update the hits counter and slowserver variables here
		$slowservervars = Array();
		$slowservervars[] = "numofusers";
		$slowservervars[] = $server->getUsersOnline();
		$slowservervars[] = "os";
		$slowservervars[] = $server->getOSRunning ();

		if (!empty($server->serverdata)) {
			# Also add all $this->serverdata variables, can be used
			# later on to show details of server in slow-server
			# option.
			foreach ($server->serverdata as $key => $value) {
				$slowservervars[] = getASCII($key);
				# replace probable delimiters from values
				#$value = str_replace (";", "", $value);
				#$value = str_replace ("'", "", $value);
				$slowservervars[] = getASCII($value);
			} # End foreach
		} # End if
		$vars = implode(";", $slowservervars);
	} # End if

	# Now write record, update hitcount, and of course save
	# the server data for slow-server option.
	$database->setQuery( "UPDATE #__serverstat_servers"
	. "\n    SET hits=hits+1"
	. "\n   ,slowservervars='" . $vars . "'"
	. "\n   ,logged = '" . date('Y-m-d H:i:s') . "'"
	. "\nWHERE id=" . $id
	);

	if (!$database->query()) {
		die ("Error setting the slowserver variables for gameserver : " . $id . "<br><br>" . $database->stderr());
	} # End if

	return $result;
} # End function ServerLog

/**
* Show a complete list of published servers and their status.
*/
function showServerList ( $option, $database ) {
	global $mosConfig_absolute_path, $serverstat_template, $serverstat_trace_template;
	global $serverstat_connectbutton, $mosConfig_live_site, $serverstat_classtreshhold;

	# Load language file
	$map = $mosConfig_absolute_path . '/administrator/components/com_serverstat';

	if (file_exists($map.'/language/'.$mosConfig_lang.'.php')) {
		require_once ($map.'/language/'.$mosConfig_lang.'.php');
	} elseif (file_exists($map.'/language/english.php'))  {
		require_once ($map.'/language/english.php');
	} else {
		die ( 'Language file not present...' );
	}# End if

	# Yes, we want an overlib effect here :D
	mosCommonHTML::loadOverlib();

	?>
	<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
	<tr>
		<th class="title"><div align="left">&nbsp;</div></th>
		<th class="title"><div align="left"><strong><?php echo _SERVERSTAT_LIST_SERVERNAME; ?></strong></div></th>
		<th class="title"><div align="center"><strong><?php echo _SERVERSTAT_STATE; ?></strong></div></th>
		<th class="title"><div align="right"><strong><?php echo _SERVERSTAT_LIST_IP; ?></strong></div></th>
		<th class="title"><div align="right"><strong><?php echo _SERVERSTAT_LIST_PORT; ?></strong></div></th>
		<th class="title"><div align="left"><strong><?php echo _SERVERSTAT_LIST_TYPE; ?></strong></div></th>
		<th class="title"><div align="right"><strong><?php echo _SERVERSTAT_STAT_CLASSTIMING; ?></strong></div></th>
	</tr>
	<?php
	# Yes, this is an very simple query...
	$database->setQuery( "SELECT * FROM #__serverstat_servers"
	. "\nWHERE published > 0"
	. "\nORDER BY ordering"
	);
	$rows = $database->loadObjectList();

	if (count($rows) != 0) {
		$totaltime = 0;
		# Start buidling the information here...
		for ($i=0; $i < count( $rows ); $i++) {
			$row = &$rows[$i];
			echo "<tr>\n";

			# Render the server image
			$image = trim($row->image);
			if (empty($image)) {
				$image  = getServerConfigVar ($row, "icon");
			} # End if
			echo "<td width=\"3%\"><img src=\"" . $mosConfig_live_site . "/administrator/components/com_serverstat/images/" . $image . "\"></td>";

			# Here we handle the server name, and online server status. If the 
			# tcounter value exceeds the config treshold, and we do not have an
			# interval check, we just skip the online status check for this
			# server.
			$url = "index.php?option=com_serverstat&task=view&id=" . $row->id;
			if ($row->tcounter > $serverstat_threshold && ($row->views % $serverstat_threshold !=0) && $serverstat_threshold !=0) {
				$tooltip = _SERVERSTAT_UNKNOWN;
				$imagestatus = "unknown.gif";
			} else {
				# Handle slow server support. If slowserver switch is set,
				# the proper class is inserted here, so we instantiate the
				# server class.
				if (!$server = instantiateServerClass ( $row , false, true)) {
					Die (str_replace ("[class]", $row->servertype, _SERVERSTAT_CLASSNOTFOUND));
				} # End if

				# Handle the on/offline status.
				if ($server->IsServerRunning ()) {
					$imagestatus = "online.gif";
					if ($server->getUsersOnline () == 1) {
						$tooltip = str_replace ('[numofusers]', number_format ($server->getUsersOnline ()), _SERVERSTAT_ONLINE_ONE);
					} else {
						$tooltip = str_replace ('[numofusers]', number_format ($server->getUsersOnline ()), _SERVERSTAT_ONLINE_MORE);
					} # End if
					$tooltip = str_replace ('[os]', $server->getOSRunning(), $tooltip);

					# reset offline counter
					$database->setQuery( "UPDATE #__serverstat_servers"
					. "\nSET tcounter=0"
					. "\nWHERE id=".$row->id
					);
	
					if (!$database->query()) {
						die ("Error resetting tcounter for gameserver : " . $row->id);
					} # End if
				} else {
					$imagestatus = "offline.gif";
					$tooltip = _SERVERSTAT_OFFLINE;

					# increment offline counter
					$database->setQuery( "UPDATE #__serverstat_servers"
					. "\nSET tcounter=tcounter+1"
					. "\nWHERE id=".$row->id
					);

					if (!$database->query()) {
						die ("Error updating tcounter for gameserver : " . $row->id);
					} # End if
				} # End if
			} # End if

			$tooltip = str_replace ('[servername]', $row->servername, $tooltip);
			$tooltip = str_replace ('[ip]', $row->ip, $tooltip);
			$tooltip = str_replace ('[port]', $row->port, $tooltip);
			echo  "<td>" . mosToolTip( $tooltip, $title=$row->servername, $width='', $image='tooltip.png', $text=$row->servername, $href=$url) . "</td>\n";
			echo  "<td align=\"center\"><img src=\"" . $mosConfig_live_site . "/administrator/components/com_serverstat/images/" . $imagestatus . "\"></td>\n";
			echo  "<td align=\"right\">" . $row->ip . "</td>\n";
			echo  "<td align=\"right\">" . $row->port . "</td>\n";
			echo  "<td>" . $row->servertype . "</td>\n";
			?>
			<td align="right">
			<?php
			for ($j=0; $j<count($serverstat_classtreshhold); $j++) {
				$color = $serverstat_classtreshhold[$j][1];
				if ($server->getClassTiming() < $serverstat_classtreshhold[$j][0]) {
					break;
				} # End if
			} # End for
			echo "<font color=\"$color\">" . number_format($server->getClassTiming(), 5) . "</font>";
			$totaltime = $totaltime + $server->getClassTiming();
			?>
			</td>

			<?php
			echo  "</tr>\n";

			# update views link for this server
			$database->setQuery( "UPDATE #__serverstat_servers"
			. "\nSET views=views+1"
			. "\nWHERE id=".$row->id
			);

			if (!$database->query()) {
				die ("Error updating views count for gameserver : " . $row->id);
			} # End if
		} # End for
		
		echo "<tr><td>&nbsp;</td></tr>\n";
		echo "<tr>";
		echo "<td align=\"left\" colspan=\"6\"><strong>"  . _SERVERSTAT_TOTALTIME . "</strong></td>";
		echo "<td align=\"right\">" . number_format($totaltime, 5) . "</td>";
		echo "</tr>\n";
	} else {
		echo  "<tr><td colspan=\"6\" align=\"left\"><br><strong>" . _SERVERSTAT_NOSERVERS . "</strong></td></tr>\n";
	} # End if
	?>

	</table>

	<?php
} # End function showServerList

/**
* Show online server status, but out here is in the remote server status
* format, which simply means this will be an xml file.
*/
function showServerRemote( $option, $database, $task ) {
	global $my, $mosConfig_absolute_path, $serverstat_version, $serverstat_actasserviceprovider;
	global $mosConfig_live_site, $mosConfig_mailfrom;

	if ($serverstat_actasserviceprovider == 1) {
		# First we retrieve the server parameters
		$ip = mosGetParam( $_GET, 'ip', 0 );
		$port = intval( mosGetParam( $_GET, 'port', 0 ) );
		$port1 = intval( mosGetParam( $_GET, 'port1', 0 ) );
		$username = mosGetParam( $_GET, 'username', 0 );
		$password = mosGetParam( $_GET, 'password', 0 );
		$servertype = mosGetParam( $_GET, 'servertype', "Q3" );

		# Check if this server already is present in the database, if not
		# we add this server to the #__serverstat_servers table.
		# Key values are: ip, port, servertype and remote.
	   	$database->setQuery( "SELECT * FROM #__serverstat_servers"
	   	. "\nWHERE ip='$ip'"
	   	. "\nAND port=$port"
	   	. "\nAND servertype='$servertype'"
	   	. "\nAND remote=1"
	   	);

	   	$rows = $database->loadObjectList();
		if (count($rows) == 0) {
			$row = new mosServerstatServers ( $database );
			if (!$row->bind( $_GET )) {
				Die ("Panic: Values cannot be stored in database");
			} # End if
			$row->remote = 1;
			$row->created 		= $row->created ? mosFormatDate( $row->created, '%Y-%m-%d %H:%M:%S', -$mosConfig_offset * 60 * 60 ) : date( "Y-m-d H:i:s" );
			$row->created_by 	= $row->created_by ? $row->created_by : $my->id;

			# Store current fields, throw error when not succesfull.
			$row->checkin();
			if (!$row->store()) {
			 	die ("Panic: Remote server record could not be written");
			} # End if
			$row->updateOrder();
		} elseif (count($rows) == 1) {
			$row = $rows[0];
		} else {
			Die ("Panic: Error in database, duplicate remote servers in database!");
		} # End if

		# Retrieve the server status using the core logic.
		if (!$server = instantiateServerClass ( $row, $debug, false )) {
			Die (str_replace ("[class]", $row->servertype, _SERVERSTAT_CLASSNOTFOUND));
		} # End if

		# Update the servername with a proper value so this one can be
		# selected thru the backend...
		$servername = $server->getHostNameASCII ();
		if (empty($servername)) {
			$servername = $ip . ":" . $port;
		}# End if

		# Update record with latest information we have here. Hits and views
		# are updated, also we update the description field with the servername
		# we retrieve from the server class.
		$database->setQuery( "UPDATE #__serverstat_servers"
		. "\nSET hits=hits+1,"
		. "\nviews=views+1,"
		. "\nservername='$servername',"
		. "\nport1=$port1,"
		. "\nmodified='" . date( "Y-m-d H:i:s" ) . "',"
		. "\nmodified_by='" . $my->id . "',"
		. "\nusername='$username',"
		. "\npassword='$password'"
		. "\nWHERE id=".$row->id
		);

		if (!$database->query()) {
			die ("Panic! Error updating server record: " . $id . "<br><br>" . $database->stderr());
		} # End if
	} # End if

	# Start building the XML output here, First we put the general part of 
	# the xml file in place.
	$result = Array();
	$result[] = "<?xml version=\"1.0\" ?>\n";
	$result[] = "<serverstat>\n";
	$result[] = "<name>Serverstat remote status file</name>\n";
	$result[] = "<creationDate>" . date( "Y-m-d H:i:s" ) . "</creationDate>\n";
	$result[] = "<author>Wilco Jansen, generated by the Serverstat main component</author>\n";
	$result[] = "<copyright>This file is released under the GNU/GPL License</copyright>\n";
	$result[] = "<authorEmail>" . $mosConfig_mailfrom . "</authorEmail>\n";
	$result[] = "<authorUrl>" . $mosConfig_live_site . "</authorUrl>\n";
	$result[] = "<version>" . $serverstat_version . "</version>\n";
	$result[] = "<description>Serverstat remote status file</description>\n";
	if ($serverstat_actasserviceprovider == 0) {
		$status = "?";
	} else {
		if ($server->IsServerRunning()) {
			$status = 1;
			# Hande server data rendering
			if (getServerConfigVar ($row, 'serverdata')) {
				$result[] = "<serverdata>\n";
				foreach ($server->serverdata as $key => $value) {
					if (chop(getASCII($key)) != "") {
						$result[] = "<" . getASCII($key) . ">"  . htmlspecialchars ($value) . "</" . getASCII($key) . ">\n";
					} # End if
				} # End foreach
				$result[] = "</serverdata>\n";
			} # End if

			# Handle player data rendering
			if (getServerConfigVar ($row, 'userinfo')) {
				for ($i=0; $i < $server->numofusers; $i++) {
					$result[] = "<userinfo id=\"$i\">\n";
					foreach ($server->userinfo[$i] as $key => $value) {
						$result[] = "<$key>"  . htmlspecialchars ($value) . "</$key>\n";
					} # End foreach
					$result[] = "</userinfo>\n";
				} # End for
			} # End if

			# Handle channel data rendering (teamspeak etc.)
			if (getServerConfigVar ($row, 'channelinfo')) {
				for ($i=0; $i < $server->numofchannels; $i++) {
					$result[] = "<channelinfo id=\"$i\">\n";
					foreach ($server->channelinfo[$i] as $key => $value) {
						$result[] = "<$key>"  . htmlspecialchars ($value) . "</$key>\n";
					} # End foreach
					$result[] = "</channelinfo>\n";
				} # End for
			} # End if
		} else {
			$status = -1;
		} # End if
	} # End if
	$result[] = "<result>$status</result>\n";

	# closing tag for xml file
	$result[] = "</serverstat>\n";

	# Content build, write the file
	$filename = tempnam ($mosConfig_absolute_path . "/media/", "serverstat.xml");

	if (!$handle = @fopen($filename, "w+")) {
		Die ("Panic: Cannot create xml file ($filename)");
	} # End if

	for ($i=0; $i<count($result); $i++) {
		fwrite($handle, $result[$i]);
	} # End for

	# Redirect output to the XML file
	Header("Content-Type: application/xml charset=utf-8");
	Header("Content-Disposition: inline; filename=" . basename($filename));
	readfile($filename, "r");

	# Delete file, and stop running here...
	unlink ($filename);
	die();
} # End function showServerRemote
?>
