<?php
/**
 * Joomla! 1.5 component mochigames
 *
 * @version $Id: mygames.php 36 2010-01-26 13:00:20Z yosha79 $
 * @author Maritn Mueller
 * @package Joomla
 * @subpackage mochigames
 * @license GNU/GPL
 * @copyright	Copyright (C) 2009 Martin Mueller. All rights reserved.
 *
 */

defined('_JEXEC')   or die();
class MochigamesControllerMygames extends MochigamesController{
  function __construct(){
    parent::__construct();
    $this->registerTask( 'add', 'edit' );
    $this->registerTask(   'unpublish', 'publish');
    $view =& $this->getView('mygames', 'html');

    // Standard model
    $view->setModel( $this->getModel( 'mochigames', 'MochigamesModel' ), true );
  }

 function edit() {
 	$uid=JRequest::getCmd("tag",NULL);
	if($uid==NULL){ $msg="Error: No Unique Tag ID found.";
	  $this->setRedirect("index.php?option=com_mochigames", $msg, 'error');
	  return;
	}
    JRequest::setVar(   'layout', 'default_form'  );
    JRequest::setVar('hidemainmenu', 1);
    parent::display();
  }

  function manualadd() {
    JRequest::setVar(   'layout', 'default_manualadd'  );
    JRequest::setVar('hidemainmenu', 1);
    parent::display();
  }
  

  function delete() {
	$model=$this->getModel( 'mochigames', 'mochigamesModel' );
    $params = &JComponentHelper::getParams( 'com_mochigames' );
	$uid=JRequest::getString("tag",NULL);
	$game=$model->getGame($uid);


	$path=JPATH_ROOT.DS.$params->get("dir_swf").$game->slug."/";
	//delete tags
    $model->deleteGame2Tags($game->id);
	//delete cats
	$model->deleteGame2Cats($game->id);

	//delete files
	$errmsg="";
	if($game->doe=="download") {
  	  $success=unlink($path.$game->swfname);
  	}
  	else $success=true;
	if($success==false)
	   $errmsg.="SWF Fie could not be deleted. ";
	$success=unlink($path.$game->imgname);
	if($success==false)
	   $errmsg.="IMG File could not be deleted. ";
	$success=unlink($path."index.html");
	rmdir($path); 
		   
	if($errmsg==""){
	  $model->deleteGame($game->uid);
	  $errmsg="SUCCESS";
	}
		$limit=JRequest::getInt("limit",25);
		$offset=JRequest::getInt("offset",0);
	    $fcid=JRequest::getInt("fcid",-1);

	$this->setRedirect("index.php?option=com_mochigames&view=mygames&fcid=".$fcid."&limit=".$limit."&offset=".$offset, $errmsg);

  }
  function manualsave() {
	      $model=$this->getModel( 'mochigames', 'mochigamesModel' );
     	  $params = &JComponentHelper::getParams( 'com_mochigames' );
		  $ok=true;
		  $game->uid=JRequest::getString("uid",NULL,'POST');;
		  $game->slug=JRequest::getString("slug",NULL,'POST');;
		  $game->title=JRequest::getString("title",NULL,'POST');;
		  $game->description=JRequest::getString("description",NULL,'POST');;
		  $game->instruction=JRequest::getString("instruction",NULL,'POST');
		  $tags=JRequest::getString("keywords",NULL,'POST');
		  $cats=JRequest::getVar('fcat','array(0)','POST','array');

		  $game->x=JRequest::getString("resx",NULL,'POST');;
		  $game->y=JRequest::getString("resy",NULL,'POST');;

		  $abs_swf_file=JRequest::getVar("abs_swf_file",NULL,'POST');
		  $abs_img_file=JRequest::getVar("abs_img_file",NULL,'POST');
		  $game->date_added=date('Y-m-d H:i:s T');

		  
		  $game->swfname=$abs_swf_file;

		  $dest_swf=JPATH_ROOT.DS.$params->get("dir_swf").$swf_file;
		  $game->imgname=$abs_img_file;
	      $errmsg="";

              if($errmsg=="")
              {
                $game->swfname=$game->swfname;
                $game->imgname=$game->imgname;
                $gameid=$model->insertGame($game);

                $cat->gid=$gameid;
                $cat->cids=$cats;
                $model->deleteGame2Cats($gameid);
                $model->insertGame2Cats($gameid,$cats);

                $tags=strip_tags($tags);
                $tags=explode(",",$tags);
                //delete gameid 2 tags
                $model->deleteGame2Tags($gameid);

                for($i=0;$i<count($tags);$i++) {
                  $tag=$tags[$i];
                  $tag=trim($tag);
                  if(strlen($tag)>=3) {
                    $tagid=$model->insertTag($tag);
                    $model->insertGame2Tag($gameid,$tagid);
                  }

                }


              }

		  if($errmsg=="") $msg="SUCCESS: ".$game->title." has been saved";
		  else $msg=$errmsg;

		$limit=JRequest::getInt("limit",25);
		$offset=JRequest::getInt("offset",0);
	    $fcid=JRequest::getInt("fcid",-1);
		  $this->setRedirect("index.php?option=com_mochigames&view=mygames&limit=".$limit."&offset=".$offset."&fcid=".$fcid."", $msg);
  	
  }
  function save(){
	      $model=$this->getModel( 'mochigames', 'mochigamesModel' );
     	  $params = &JComponentHelper::getParams( 'com_mochigames' );
		  $ok=true;
		  $game->uid=JRequest::getString("uid",NULL,'POST');;
		  $game->title=JRequest::getString("title",NULL,'POST');;
		  $game->description=JRequest::getString("description",NULL,'POST');;
		  $game->instruction=JRequest::getString("instruction",NULL,'POST');
		  $tags=JRequest::getString("keywords",NULL,'POST');
		  $cats=JRequest::getVar('fcat','array(0)','POST','array');

		  $game->x=JRequest::getString("resx",NULL,'POST');;
		  $game->y=JRequest::getString("resy",NULL,'POST');;

		  $abs_swf_file=JRequest::getVar("abs_swf_file",NULL,'POST');
		  $abs_img_file=JRequest::getVar("abs_img_file",NULL,'POST');
		  $game->date_added=date('Y-m-d H:i:s T');

		  $swf_file=explode("/",$abs_swf_file);
		  $game->swfname=$swf_file=$swf_file[count($swf_file)-1];

		  $dest_swf=JPATH_ROOT.DS.$params->get("dir_swf").$swf_file;
		  //echo $dest_swf;
		  $swf_file=explode(".",$swf_file);
		  $img_file=explode(".",$abs_img_file);
		  $game->imgname=$img_file=$swf_file[0].".".$img_file[count($img_file)-1];
	      $errmsg="";
		  if($model->isInDB($game->uid)) {
		    $tmp=$model->getGame($game->uid);
		    $tmp->title=$game->title;
		    $tmp->x=$tmp->res_x;
		    $tmp->y=$tmp->res_y;
		    $tmp->description=$game->description;
		    $tmp->instruction=$game->instruction;
		    //$tmp->cats=$game->cats;
		    $gameid=$tmp->id;
		    $model->insertGame($tmp);

                $cat->gid=$tmp->id;
                $cat->cids=$cats;
                $model->deleteGame2Cats($gameid);
                $model->insertGame2Cats($gameid,$cats);

                $tags=strip_tags($tags);
                $tags=explode(",",$tags);
                //delete gameid 2 tags
                $model->deleteGame2Tags($gameid);

                for($i=0;$i<count($tags);$i++) {
                  $tag=$tags[$i];
                  $tag=trim($tag);
                  if(strlen($tag)>=3) {
                    $tagid=$model->insertTag($tag);
                    $model->insertGame2Tag($gameid,$tagid);
                  }

                }
		    $errmsg="Game has been updated";
		  }
		  else {

              if(file_exists($dest_swf))
                $errmsg.="WARNING: File already exists.";
              if(JRequest::getCmd('task') == 'save' && $errmsg=="") {
                  $dest_img=JPATH_ROOT.DS.$params->get("dir_img").$img_file;
                  $dest_swf=str_replace("%20","-",$dest_swf);
                  if (!copy($abs_swf_file, $dest_swf))
                  {
                    $errmsg.= ("failed to copy SWF $file...<br>\n");
                  }
                  $dest_img=str_replace("%20","-",$dest_img);
                  if (!copy($abs_img_file, $dest_img))
                   {
                    $errmsg.= ("failed to copy IMG $file...<br>\n");
                  }
                  //TODO: Check filesize to ensure the SWF file has been copied correctly.

              }
              if($errmsg=="")
              {
                $game->swfname=$params->get("dir_swf").$game->swfname;
                $game->swfname=str_replace("%20","-",$game->swfname);
                $game->imgname=$params->get("dir_img").$game->imgname;
                $game->imgname=str_replace("%20","-",$game->imgname);
                $gameid=$model->insertGame($game);

                $cat->gid=$gameid;
                $cat->cids=$cats;
                $model->deleteGame2Cats($gameid);
                $model->insertGame2Cats($gameid,$cats);

                $tags=strip_tags($tags);
                $tags=explode(",",$tags);
                //delete gameid 2 tags
                $model->deleteGame2Tags($gameid);

                for($i=0;$i<count($tags);$i++) {
                  $tag=$tags[$i];
                  $tag=trim($tag);
                  if(strlen($tag)>=3) {
                    $tagid=$model->insertTag($tag);
                    $model->insertGame2Tag($gameid,$tagid);
                  }

                }


              }
          }
		  if($errmsg=="") $msg="SUCCESS: ".$game->title." has been saved";
		  else $msg=$errmsg;

		$limit=JRequest::getInt("limit",25);
		$offset=JRequest::getInt("offset",0);
	    $fcid=JRequest::getInt("fcid",-1);
		  $this->setRedirect("index.php?option=com_mochigames&view=mygames&limit=".$limit."&offset=".$offset."&fcid=".$fcid."", $msg);
		  //parent::display();
  }
}