

DROP TABLE IF EXISTS `#__mochicat`;
CREATE TABLE IF NOT EXISTS `#__mochicat` (
  `catid` int(11) NOT NULL auto_increment,
  `catname` varchar(50) NOT NULL,
  `parentid` int(11) NOT NULL default '-1',
  PRIMARY KEY  (`catid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Categories';

INSERT INTO `#__mochicat` ( `catname`, `parentid`) VALUES
('Action', -1),
('Adventure', -1),
('Board Game', -1),
('Casino', -1),
('Dress Up', -1),
('Driving', -1),
('Education', -1),
('Fighting', -1),
('Leaderboard', -1),
('Other', -1),
('Pimp my / Customize', -1),
('Puzzles', -1),
('Rhythm', -1),
('Sports', -1),
('Shooting', -1),
('Strategy', -1);

-- --------------------------------------------------------


DROP TABLE IF EXISTS `#__mochigame`;
CREATE TABLE IF NOT EXISTS `#__mochigame` (
  `id` int(11) NOT NULL auto_increment,
  `uid` varchar(32) NOT NULL,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) default NULL,
  `description` text NOT NULL,
  `swfname` varchar(255) default NULL,
  `imgname` varchar(255) NOT NULL,
  `instruction` text NOT NULL,
  `date_added` varchar(255) NOT NULL,
  `stat_clicked` int(11) NOT NULL default '0',
  `embed_code` text NOT NULL,
  `res_x` int(11) NOT NULL,
  `res_y` int(11) NOT NULL,
  `doe` varchar(10) NOT NULL,
  `leaderboard` tinyint(4) default NULL,
  `coin` tinyint(4) default NULL,
  `premium` tinyint(4) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='table for the mochigames';

-- --------------------------------------------------------


DROP TABLE IF EXISTS `#__mochitag`;
CREATE TABLE IF NOT EXISTS `#__mochitag` (
  `tagid` int(11) NOT NULL auto_increment,
  `tagname` varchar(50) NOT NULL,
  PRIMARY KEY  (`tagid`),
  UNIQUE KEY `tagname` (`tagname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='mochi-meta tags';

-- --------------------------------------------------------


DROP TABLE IF EXISTS `#__mochi_game2cat`;
CREATE TABLE IF NOT EXISTS `#__mochi_game2cat` (
  `gid` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  UNIQUE KEY `uniqueindex` (`gid`,`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------


DROP TABLE IF EXISTS `#__mochi_game2tag`;
CREATE TABLE IF NOT EXISTS `#__mochi_game2tag` (
  `gid` int(11) NOT NULL,
  `tid` int(11) NOT NULL,
  UNIQUE KEY `uniqueindex` (`gid`,`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;