<?php
/**
 * Joomla! 1.5 component mochigames
 *
 * @version $Id: mochigames.php 36 2010-01-26 13:00:20Z yosha79 $
 * @author Maritn Mueller
 * @package Joomla
 * @subpackage mochigames
 * @license GNU/GPL
 * @copyright	Copyright (C) 2009 Martin Mueller. All rights reserved.
 *
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// Import Joomla! libraries
jimport('joomla.application.component.model');
include_once(JPATH_LIBRARIES.DS.'joomla'.DS.'database'.DS.'table'.DS.'component.php');

class MochigamesModelParameter extends JTableComponent {
  function __construct() {
      $db =& JFactory::getDBO();
      parent::__construct($db);
  }

  function save($array) {
     $db =& JFactory::getDBO();
      parent::loadByOption('com_mochigames');
      $elem="";
      $array=$array['array'];

      for($i=0;$i<count($array);$i++) {
       $arr=current($array);
       $elem.=key($array)."=".$arr."\r\n";
       next($array);
      }

      $this->params=$elem;
      $query="UPDATE #__components SET params='$elem' WHERE id='$this->id'";
      $db->setQuery($query);
      $db->Execute($query);
      if($db->getErrorMsg()=="") return TRUE;
      else return FALSE;
  }
}

class MochigamesModelFeed extends JModel {

	function getFeed($cat, $offset, $limit){

      $db =& JFactory::getDBO();
	  //$session =&JFactory::getSession();

	  if(empty($cat))
	    $cat="all";

      $params = &JComponentHelper::getParams( 'com_mochigames' );
      $publisherid=$params->get('publisherid');

	  $game=array();
	  if($params->get('JSON_or_RSS')=="rss") {
	  	 if($params->get('curl_or_fopen')=="curl") {
		  	 //Curl support
		  	 $ch = curl_init();
		  	 curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	 		 curl_setopt($ch, CURLOPT_URL, "http://www.mochimedia.com/feeds/games/".$publisherid."/".$cat."/?limit=".$limit."&offset=".$offset."");
	 		 curl_setopt($ch, CURLOPT_HEADER, FALSE);
	 		 
	 		 $ref = curl_exec  (  $ch  );
	 		 curl_close($ch);	
	 		 $feed=simplexml_load_string($ref);
	  	 }
	  	 else {
		 //fopen support
 		 	$feed = simplexml_load_file("http://www.mochimedia.com/feeds/games/".$publisherid."/".$cat."/?limit=".$limit."&offset=".$offset."");
	  	 }
		  for($i=0;$i<count($feed->entry);$i++) {
		    $entry=$feed->entry[$i];
		  	$game[$i]->title=(string)$entry->title;;
			$game[$i]->author=(string)$entry->author->name;
			$game[$i]->file_swf=(string)$entry->link[1]->attributes()->href;
			$game[$i]->file_type=(string)$entry->link[1]->attributes()->type;
			$game[$i]->file_img=(string)$entry->summary->div->a->img->attributes()->src;
			$summary=array();
			for($j=0;$j<count($entry->summary->div->dl->dt);$j++) {
			  $summary[(string)$entry->summary->div->dl->dt[$j]] = (string)$entry->summary->div->dl->dd[$j];
			  //=array((string)$entry->summary->div->dl->dt[$j] => $entry->summary->div->dl->dd[$j]);
			}

			$game[$i]->uid = $summary['Tag'];
			$game[$i]->slug = $summary['Slug'];
			$game[$i]->description = $summary['Description'];
			$game[$i]->res = $summary['Resolution'];
			$resolution=explode("x", $summary['Resolution']);
			$game[$i]->x=$resolution[0];
			$game[$i]->y=$resolution[1];
			$game[$i]->instruction = $summary['Instructions'];
			$game[$i]->categories = $summary['Categories'];
			$game[$i]->rating = $summary['Rating'];
			$game[$i]->leaderboard= $summary['Leaderboards'];
			$game[$i]->file_size= $summary['SWF file size'];
			$game[$i]->keywords= $summary['Keywords'];

		  }

	  }
	  else if ($params->get('JSON_or_RSS')=="json") {
	  	 if($params->get('curl_or_fopen')=="curl") {
			 //Curl support
		  	 $ch = curl_init();
		  	 curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	 		 curl_setopt($ch, CURLOPT_URL, "http://www.mochimedia.com/feeds/games/".$publisherid."/".$cat."/?limit=".$limit."&offset=".$offset."&format=json");
	 		 curl_setopt($ch, CURLOPT_HEADER, FALSE);
	 		 
	 		 $json = curl_exec  (  $ch  );
	 		 curl_close($ch);	
	  	 }
	  	 else {
 		 //fopen support
	  		$json =  file_get_contents("http://www.mochimedia.com/feeds/games/".$publisherid."/".$cat."/?limit=".$limit."&offset=".$offset."&format=json");
	  	 } 
	  	$feed=json_decode($json);
	     $feeds=$feed->games;
	     for($i=0;$i<count($feeds);$i++) {
	        $entry=$feeds[$i];
		  	$game[$i]->title=$entry->name;
		  	$game[$i]->slug=$entry->slug;
		  	$game[$i]->author=$entry->author;
			$game[$i]->file_swf=$entry->swf_url;
			$game[$i]->file_type="application/x-shockwave-flash";
			$game[$i]->file_img=$entry->thumbnail_url;
   			$game[$i]->uid = $entry->game_tag;
			$game[$i]->description = $entry->description;
			$game[$i]->res = $entry->resolution;
			$resolution=explode("x", $entry->resolution);
			$game[$i]->x=$resolution[0];
			$game[$i]->y=$resolution[1];
			$game[$i]->instruction = $entry->instructions;
			$game[$i]->categories = implode(", ",$entry->categories);
			$game[$i]->rating = $entry->rating;
			if($entry->leaderboard_enabled=="1") $game[$i]->leaderboard="True";
			else $game[$i]->leaderboard="False";
			if($entry->coins_enabled=="1") $game[$i]->coins="True";
			else $game[$i]->coins="False";
			//Not yet implemented by mochi
			//			if($entry->premium_games=="1") $game[$i]->premium="True";
			//			else $game[$i]->premium="False";
			$game[$i]->file_size= $entry->swf_file_size;
			$game[$i]->keywords= implode(", ",$entry->tags);
	     }

	  }
	  
	  return $game;
	}

	  function getCats() {
           $filter['premium_games']=JText::_('Premium Games');
           $filter['coins_enabled']=JText::_('Coins Games');
           $filter['featured_games']=Jtext::_('Featured Games');
           $filter['leaderboard_enabled']=Jtext::_('Leaderboard Games');
           $filter['all']=Jtext::_('All Games');
           $filter['action']=Jtext::_('Action');
           $filter['adventure']=Jtext::_('Adventure');
           $filter['board_game']=Jtext::_('Board Game');
           $filter['casino']=Jtext::_('Casino');
           $filter['dress-up']=Jtext::_('Dress Up');
           $filter['driving']=Jtext::_('Driving');
           $filter['education']=Jtext::_('Education');
           $filter['fighting']=Jtext::_('Fighting');
           $filter['other']=Jtext::_('Other');
           $filter['customize']=Jtext::_('Pimp My / Customize');
           $filter['puzzles']=Jtext::_('Puzzles');
           $filter['rhythm']=Jtext::_('Rhythm');
           $filter['shooting']=Jtext::_('Shooting');
           $filter['sports']=Jtext::_('Sports');
           $filter['strategy']=Jtext::_('Strategy');

           return $filter;
	  }

	  function getGame($uid) {
          $params = &JComponentHelper::getParams( 'com_mochigames' );
          $publisherid=$params->get('publisherid');
          if($params->get('JSON_or_RSS')=="rss") {
          	 if($params->get('curl_or_fopen')=="curl") {
				 //Curl support
			  	 $ch = curl_init();
			  	 curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		 		 curl_setopt($ch, CURLOPT_URL, "http://www.mochimedia.com/feeds/games/".$publisherid."/".$uid."/");
		 		 curl_setopt($ch, CURLOPT_HEADER, FALSE);
		 		 
		 		 $ref = curl_exec  (  $ch  );
		 		 curl_close($ch);	
		 		 $feed=simplexml_load_string($ref);
          	 }
          	 else {
             	 $feed = simplexml_load_file("http://www.mochimedia.com/feeds/games/".$publisherid."/".$uid."/");
          	 }
          	 
             $entry=$feed->entry[0];
             $game->title=(string)$entry->title;;
             $game->author=(string)$entry->author->name;
             $game->file_swf=(string)$entry->link[1]->attributes()->href;
             $game->file_type=(string)$entry->link[1]->attributes()->type;
             $game->file_img=(string)$entry->summary->div->a->img->attributes()->src;
             $summary=array();
             for($j=0;$j<count($entry->summary->div->dl->dt);$j++) {
               $summary[(string)$entry->summary->div->dl->dt[$j]] = (string)$entry->summary->div->dl->dd[$j];
               //=array((string)$entry->summary->div->dl->dt[$j] => $entry->summary->div->dl->dd[$j]);
             }

            $game->uid = $summary['Tag'];
            $game->slug = $summary['Slug'];
             $game->description = $summary['Description'];
             $game->res = $summary['Resolution'];
             $resolution=explode("x", $summary['Resolution']);
             $game->x=$resolution[0];
             $game->y=$resolution[1];
             $game->instruction = $summary['Instructions'];
             $game->categories = $summary['Categories'];
             $game->rating = $summary['Rating'];
             $game->leaderboard= $summary['Leaderboards'];
             $game->file_size= $summary['SWF file size'];
             $game->keywords= $summary['Keywords'];
          }
          else if ($params->get('JSON_or_RSS')=="json") {
          	 if($params->get('curl_or_fopen')=="curl") {
				 //Curl support
			  	 $ch = curl_init();
			  	 curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		 		 curl_setopt($ch, CURLOPT_URL, "http://www.mochimedia.com/feeds/games/".$publisherid."/".$uid."/?format=json");
		 		 curl_setopt($ch, CURLOPT_HEADER, FALSE);
		 		 
		 		 $json = curl_exec  (  $ch  );
		 		 curl_close($ch);	
          	 }
          	 else {
             	 $json =  file_get_contents("http://www.mochimedia.com/feeds/games/".$publisherid."/".$uid."/?format=json");
          	 }
          	
	        $feed=json_decode($json);
	        $entry=$feed->games[0];
		  	$game->title=$entry->name;
		  	$game->slug=$entry->slug;
			$game->author=$entry->author;
			$game->file_swf=$entry->swf_url;
			$game->file_type="application/x-shockwave-flash";
			$game->file_img=$entry->thumbnail_url;
   			$game->uid = $entry->game_tag;
			$game->description = $entry->description;
			$game->res = $entry->resolution;
			$resolution=explode("x", $entry->resolution);
			$game->x=$resolution[0];
			$game->y=$resolution[1];
			$game->instruction = $entry->instructions;
			$game->categories = implode(", ",$entry->categories);
			$game->rating = $entry->rating;
			if($entry->leaderboard_enabled=="1") $game->leaderboard="True";
			else $game->leaderboard="False";
			if($entry->coins_enabled=="1") $game->coins="True";
			else $game->coins="False";
			$game->file_size= $entry->swf_file_size;
			$game->keywords= implode(", ",$entry->tags);
          }

	      return $game;

	  }
}


class MochigamesModelMochigames extends JModel {
    var $parameter;
    var $feed;
  /**
   * Items total
   * @var integer
   */
  var $_total = null;

  /**
   * Pagination object
   * @var object
   */
  var $_pagination = null;
function __construct()
  {

  parent::__construct();

  global $mainframe, $option;

  // Get pagination request variables
  $limit    = $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );
$limitstart = JRequest::getVar('limitstart',0);

  // In case limit has been changed, adjust it
  $limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

  $this->setState('limit', $limit);
  $this->setState('limitstart', $limitstart);

  $this->parameter=new MochigamesModelParameter();
  $this->feed=new MochigamesModelFeed();

    }

    function isInDB($uid) {
      $db =& JFactory::getDBO();

	  $query="SELECT count(*) FROM #__mochigame WHERE uid='$uid'";
	  $db->setQuery($query);
	  $result=$db->loadResult();
	  if($result>0) return 1;
	  else return 0;

    }

    function getCats($catid=NULL){
      $db =& JFactory::getDBO();

      if($catid) $add="WHERE catid='$catid'";
      else $add="";
      $query="SELECT * FROM #__mochicat ".$add." ORDER BY catname ASC";
	  $db->setQuery($query);
	  $result=$db->loadObjectList();

      return $result;
    }

    function insertGame($game) {
      $db=& JFactory::getDBO();

      $game->description=mysql_real_escape_string($game->description);
      $game->instruction=mysql_real_escape_string($game->instruction);
      $game->title=mysql_real_escape_string($game->title);
      $game->swfname=mysql_real_escape_string($game->swfname);
      $game->imgname=mysql_real_escape_string($game->imgname);
      $game->embed_code=mysql_real_escape_string($game->embed_code);
	  if($game->leaderboard=="True") $game->leaderboard=1;
	  else $game->leaderboard=0;
	  if(@$game->coins=="True") $game->coins=1;
	  else $game->coins=0;
	  $query ="INSERT INTO #__mochigame (uid,name,slug,description,instruction,swfname,imgname,date_added,res_x,res_y,embed_code,doe, leaderboard, coin) \r\n";
      $query.="VALUES ('$game->uid','$game->title','$game->slug','$game->description','$game->instruction','$game->swfname','$game->imgname','$game->date_added','$game->x','$game->y','$game->embed_code','$game->doe','$game->leaderboard','$game->coins') \r\n";
      $query.=" ON DUPLICATE KEY \r\n";
      $query.="UPDATE name='$game->title', description='$game->description', \r\n";
      $query.="instruction='$game->instruction'";
	  $db->setQuery($query);
	  $db->Execute($query);
	  echo $db->getErrorMsg();

	  return $db->insertid();

    }

	function deleteGame2Cats($gameid) {
      $db=& JFactory::getDBO();
      $query="DELETE FROM #__mochi_game2cat WHERE gid='$gameid'";
      $db->setQuery($query);
      $db->Execute($query);

	}

	function insertGame2Cats($gameid,$cats){
      $db=& JFactory::getDBO();

      for($i=0;$i<count($cats);$i++) {
          $cat=$cats[$i];
          $query ="INSERT INTO #__mochi_game2cat (gid,cid) ";
          $query.="VALUES ('$gameid','$cat')";
          $db->setQuery($query);
          $db->Execute($query);
      }
	}

	function deleteGame2Tags($gameid){
      $db=& JFactory::getDBO();
      $query="SELECT tid FROM #__mochi_game2tag WHERE gid='$gameid'";
      $db->setQuery($query);
      $tids=$db->loadResultArray();

	 $cnts=array();
      for($i=0;$i<count($tids);$i++) {
        $tid=$tids[$i];
        $query="SELECT count(*) FROM #__mochi_game2tag WHERE tid='$tid'";
        $db->setQuery($query);
        $cnt=$db->loadResult();
        $cnts[]=$cnt;
        if($cnt<=1) {
          $query="DELETE FROM #__mochitag WHERE tagid='$tid'";
          $db->setQuery($query);
          $db->Execute($query);

        }
      }

      $query="DELETE FROM #__mochi_game2tag WHERE gid='$gameid'";
      $db->setQuery($query);
      $db->Execute($query);
	  return $cnts;

	}

	function insertTag($tag) {
      $db=& JFactory::getDBO();
      $tag=mysql_real_escape_string($tag);

      $query="SELECT tagid FROM #__mochitag WHERE tagname='$tag'";

      $db->setQuery($query);
      $tagid=$db->loadResult();
      if(!empty($tagid)) {
        return $tagid;
      }
      else {
        $query="INSERT INTO #__mochitag (tagname) VALUES ('$tag')";
  	    $db->setQuery($query);
	    $db->Execute($query);
	    echo $db->getErrorMsg();
	    return $db->insertid();
      }

	}

	function insertGame2Tag($gameid,$tagid) {
      $db=& JFactory::getDBO();
      $query="INSERT INTO #__mochi_game2tag (gid,tid) VALUES ('$gameid','$tagid')";
  	  $db->setQuery($query);
	  $db->Execute($query);
	}

	function getGame($uid) {
      $db=& JFactory::getDBO();
      $query="SELECT * FROM #__mochigame WHERE uid='$uid'";
  	  $db->setQuery($query);
  	  $result=$db->loadObject();
  	  return $result;
	}


	function deleteGame($uid) {
      $db=& JFactory::getDBO();
      $query="DELETE FROM #__mochigame WHERE uid='$uid'";
  	  $db->setQuery($query);
  	  $db->Execute($query);

	}

	function getCatsByGame($gid) {
      $db=& JFactory::getDBO();
	  $query ="SELECT #__mochicat.catname FROM #__mochicat, #__mochi_game2cat \r\n ";
	  $query.="WHERE #__mochicat.catid = #__mochi_game2cat.cid \r\n ";
	  $query.="AND #__mochi_game2cat.gid='$gid'";
  	  $db->setQuery($query);
	  $result=$db->loadResultArray();

      return $result;

	}

	function getTagsByGame($gid) {
      $db=& JFactory::getDBO();
	  $query ="SELECT #__mochitag.tagname FROM #__mochitag, #__mochi_game2tag \r\n ";
	  $query.="WHERE #__mochitag.tagid = #__mochi_game2tag.tid \r\n ";
	  $query.="AND #__mochi_game2tag.gid='$gid'";
  	  $db->setQuery($query);
	  $result=$db->loadResultArray();

      return $result;

	}

	function paramBind($array, $ignore = '')
	{
        if (key_exists( 'params', $array ) && is_array( $array['params'] ))
        {
                $registry = new JRegistry();
                $registry->loadArray($array['params']);
                $array['params'] = $registry->toString();
        }
        return JParameter::bind($array, $ignore);
	}

	function getCat($cid) {
      $db=& JFactory::getDBO();
	  $query ="SELECT * FROM #__mochicat \r\n";
	  $query.="WHERE catid = '$cid'";
  	  $db->setQuery($query);
	  $result=$db->loadObject();

      return $result;

	}
	
	function insertCat($cat) {
      $db=& JFactory::getDBO();

	  $query ="INSERT #__mochicat \r\n";
	  $query.="(catid, catname, parentid) \r\n";
	  $query.="VALUES ('','$cat->catname','$cat->parentid')";
  	  $db->setQuery($query);
	  $db->Execute($query);
	}

	function updateCat($cat) {
      $db=& JFactory::getDBO();

	  $query ="UPDATE #__mochicat \r\n";
	  $query.="SET catname='$cat->catname', parentid='$cat->parentid' \r\n";
	  $query.="WHERE catid='$cat->catid'";
  	  $db->setQuery($query);
	  $db->Execute($query);
	}

	function deleteCat($cat) {
      $db=& JFactory::getDBO();

	  $query ="SELECT * FROM #__mochicat \r\n";
	  $query.="WHERE parentid='$cat' \r\n";
  	  $db->setQuery($query);
	  $cats1=$db->loadObjectList();
	  echo $db->getErrorMsg();

	  if(!empty($cats1)) {
	    for($i=0;$i<count($cats1);$i++) {
	      $cat1=$cats1[$i];
          $query ="SELECT * FROM #__mochicat \r\n";
          $query.="WHERE parentid='$cat1->catid' \r\n";
          $db->setQuery($query);
          $cats2=$db->loadObjectList();
	      if(!empty($cats2)) {
            for($j=0;$j<count($cats2);$j++) {
              $cat2=$cats2[$j];
              $query="DELETE FROM #__mochi_game2cat \r\n";
              $query.="WHERE cid='$cat2->catid' ";
              $db->setQuery($query);
              $db->Execute($query);
        	  echo $db->getErrorMsg();

              $query="DELETE FROM #__mochicat \r\n";
              $query.="WHERE catid='$cat2->catid'";
              $db->setQuery($query);
              $db->Execute($query);
           	  echo $db->getErrorMsg();

            }
	      }


          $query="DELETE FROM #__mochi_game2cat \r\n";
          $query.="WHERE cid='$cat1->catid' ";
          $db->setQuery($query);
          $db->Execute($query);
     	  echo $db->getErrorMsg();

          $query="DELETE FROM #__mochicat \r\n";
          $query.="WHERE catid='$cat1->catid'";
          $db->setQuery($query);
          $db->Execute($query);
       	  echo $db->getErrorMsg();

	    }
	  }

      $query="DELETE FROM #__mochi_game2cat \r\n";
      $query.="WHERE cid='$cat' ";
      $db->setQuery($query);
      $db->Execute($query);
 	  echo $db->getErrorMsg();

      $query="DELETE FROM #__mochicat \r\n";
      $query.="WHERE catid='$cat'";
      $db->setQuery($query);
      $db->Execute($query);
   	  echo $db->getErrorMsg();
	}

	function getGames($catid=NULL,$order=NULL,$limitstart=0,$limit=20) {
      $db=& JFactory::getDBO();
	  $query ="SELECT * FROM #__mochigame \r\n";

	  if($catid!=NULL && $catid!=-1) {
	    $query ="SELECT #__mochigame.* FROM #__mochigame, #__mochi_game2cat \r\n";
	    $query.="WHERE #__mochi_game2cat.cid='$catid' \r\n";
	    $query.="AND #__mochigame.id=#__mochi_game2cat.gid \r\n";
	  }
	  if($order!=NULL)
	    $query.=" ORDER BY ".$order." \r\n";
	  else
	    $query.=" ORDER BY #__mochigame.name ASC \r\n";


  	  $query.="LIMIT $limitstart,$limit ";


  	  $db->setQuery($query);
	  $games=$db->loadObjectList();
	  return $games;

	}
	
  function getTotal()
  {
    $db =& JFactory::getDBO();

    $query = 'SELECT count(*) FROM #__mochigame';
    $db->setQuery( $query );
    $total = $db->loadResult();
    return $total;
  }

  function getPagination()
  {
   // Load the content if it doesn't already exist
   if (empty($this->_pagination)) {
       jimport('joomla.html.pagination');
       $this->_pagination = new JPagination($this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
   }
   return $this->_pagination;
  }
}
?>