<?php
/**
 * Joomla! 1.5 component mochigames
 *
 * @version $Id: view.html.php 36 2010-01-26 13:00:20Z yosha79 $
 * @author Martin Mueller
 * @package Joomla
 * @subpackage mochigames
 * @license GNU/GPL
 *
 *
 *
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// Import Joomla! libraries
jimport( 'joomla.application.component.view');
class MochigamesViewMygames extends JView {

	function form($tpl=null) {
    JToolBarHelper::title(   JText::_( 'Add game' ),   'generic.png' );
    JToolBarHelper::Save();
    JToolBarHelper::Cancel();
	    $model =& $this->getModel('mochigames');
	    //$model->isInDB("122");
    	$params = &JComponentHelper::getParams( 'com_mochigames' );
	 	$uid=JRequest::getCmd("tag",NULL);

		if($model->isInDB($uid)) {
		  $game=$model->getGame($uid);
		  $game->keywords=implode(', ',$model->getTagsByGame($game->id));
		  $game->categories=implode(', ',$model->getCatsByGame($game->id));
		  $game->title=$game->name;
		}
		else{
			$game=$model->feed->getGame($uid);
		}
		$cats=$model->getCats();

		$this->assignRef('game',		$game);
		$this->assignRef('cats',		$cats);

	    $session =&JFactory::getSession();
	    $limit=$session->get('limit');
	    $offset=$session->get('offset');
        $fcid=$session->get('fcid');

	 	$this->assignRef('fcid',		$fcid );
		$this->assignRef('limit',		$limit);
		$this->assignRef('offset',		$offset);
		//$this->assignRef('params',		$params);
		//$tpl="form";
		$document = &JFactory::getDocument();
		$document->addScript( 'components/com_mochigames/assets/js/multiple_select.js' );
		$document->addStyleSheet('components/com_mochigames/assets/css/multiple_select.css' );
		
	   parent::display($tpl);
	}

	function manualadd($tpl=null) {
    JToolBarHelper::title(   JText::_( 'Manual add game' ),   'generic.png' );
    JToolBarHelper::Save();
    JToolBarHelper::Cancel();
	   $model =& $this->getModel('mochigames');
       $params = &JComponentHelper::getParams( 'com_mochigames' );
       $cats=$model->getCats();
	   $this->assignRef('cats',		$cats);

	   $session =&JFactory::getSession();
	    $limit=$session->get('limit');
	    $offset=$session->get('offset');
        $fcid=$session->get('fcid');

	 	$this->assignRef('fcid',		$fcid );
		$this->assignRef('limit',		$limit);
		$this->assignRef('offset',		$offset);
		//$this->assignRef('params',		$params);
		//$tpl="form";
		$document = &JFactory::getDocument();
		$document->addScript( 'components/com_mochigames/assets/js/multiple_select.js' );
		$document->addStyleSheet('components/com_mochigames/assets/css/multiple_select.css' );
	   
	   parent::display($tpl);
		
	
	}
	
	function icheck() {
	  //TODO: finde the games that are not connected to categories
	    $model =& $this->getModel('mochigames');
	  $this->show();
	}

	function show($tpl=null) {
		global $mainframe;
	    $model =& $this->getModel('mochigames');
	    //$model->isInDB("122");
    	$params = &JComponentHelper::getParams( 'com_mochigames' );
		$limit=JRequest::getInt("limit",20);
		$offset=JRequest::getInt("offset",NULL);
		if($offset==NULL) 
		  $limitstart=$offset=JRequest::getInt("limitstart",0);
		 else
		  $limitstart=$offset;
	    $fcid=JRequest::getInt("fcid",-1);
		@$ordering = JRequest::getWord( 'filter_order', $id );
		@$direction = JRequest::getWord( 'filter_order_Dir', $order );
		if($ordering=="") $ordering="id";
		if($direction=="") $direction="desc";
	    
	    $session =&JFactory::getSession();
	    $session->set('limit',$limit);
	    $session->set('offset',$offset);
        $session->set('fcid',$fcid);

		$cats=$model->getCats();

        $publisherID = $params->get( 'publisherid' );

		//print_r($params);
		//$ffp=fopen("http://www.mochimedia.com/feeds/games/".$publisherID."/?limit=25&offset=10");
		$filter_cat="";
		$order=$ordering." ".$direction;
		$games = $model->getGames($fcid,$order,$offset,$limit);

		for($i=0;$i<count($games);$i++) {
		  $games[$i]->categories=implode(', ',$model->getCatsByGame($games[$i]->id));
		}
 		$tmpcatlist[] = JHTML::_('select.option',  '-1', JText::_( 'ROOT' ), 'catid', 'catname' );
        $tmpcatlist   = array_merge( $tmpcatlist, $cats);
		$cat='Other';	
		$lists['cats'] = JHTML::_('select.genericlist',   $tmpcatlist, 'fcid', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'catid', 'catname',$fcid);
		
		 $this->assignRef('game',		$games);
		 $this->assignRef('cats',		$cats);
		 $this->assignRef('fcid',		$fcid );
		 $this->assignRef('limit',		$limit);
		 $this->assignRef('offset',		$offset);
		 $this->assignRef('params',		$params);
		 $this->assignRef('lists',$lists); 
		 $this->assignRef('direction',	$direction);
		 $this->assignRef('ordering',	$ordering);
		 
		 $pagination =& $this->get('Pagination');
		$limit    = $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );
  		$this->assignRef('pagination', $pagination);
		
		 
		$document = &JFactory::getDocument();
		$document->addScript( 'components/com_mochigames/assets/js/multiple_select.js' );
		$document->addStyleSheet('components/com_mochigames/assets/css/multiple_select.css' );
		 parent::display($tpl);

	}
    function display($tpl = null) {
        if(JRequest::getCmd('task')=="edit")
          $this->form($tpl);
        else if(JRequest::getCmd('task')=="icheck")
          $this->icheck($tpl);
        else if(JRequest::getCmd('task')=="manualadd")
          $this->manualadd($tpl);
        else $this->show($tpl);


    }


}
?>

