<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.ET.class.php,v 0.6 2005/12/17 13:15:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Class that holds the specific game code for an Return To Castle Wolfenstein
* Enemy Territory server. Extents the Q3 class.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class ET extends Q3 {
	/**
	* Return version information if running version. For Ene,y territory
	* server the ET-pro mod usually is loaded, just mention this when the
	* server version method is triggered.
	*/
	function getServerVersion() {
		$version = $this->serverdata['version'];
		
		# determine if mod-version and gamename are set, if so
		# we return it with the version tag. This is helpfull for et-pro
		# servers, we can determine mod and version this way.
		if ($this->serverdata['gamename'] == 'etpro') {
			$version .= " " . $this->serverdata['gamename'] . " " . $this->serverdata['mod_version'];
		} # End if

		return $version;
	} # End function getServerInfo

	/**
	* Return the hostname.
	* @call   nothing
	* @return string    The name of the host.
	*/
	function getHostName() {
		if(array_key_exists('sv_hostname', $this->serverdata)) return trim(q3Name2HTML($this->serverdata['sv_hostname']));
		return "unknown";
	} # End function

} # End class ET
?>