<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.MOHAA.class.php,v 0.6 2005/12/17 23:45:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Class that holds the specific game code for an Medal Of Honour server (MOHAA).
* Mohaa kind of servers look alot like Q3 servers, only the server initiation
* is different, so we use the Q3 class as fundament.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class MOHAA extends ServerMain {

	/**
	* Constructor.
	*/
	function MOHAA ($serverip, $port, $debug, $retrycount, $timeout) {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if

		# Here we go!
		$this->trace("MOHAA::_constructor", "serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;                                    # Initialize properties
		$this->port = $port;
		$this->result = "";						# Contains server respons data

		$this->socket = $this->getSocket($this->serverip, $this->port);
		if ($this->socket) {
			$i=0;
			do {
				$this->getServerStatus($this->socket);		# Interact with gameserver
				$i++;
			} while (empty($this->result) && $i < $this->retry);	# Retry, sometimes server does not respond that fast :D

			$this->trace("MOHAA::_constructor", $this->result, 1, 1);
			$this->getServerInfo();					# Determine server information...
			$this->getUserInfo();                                   # and the player information
			$this->closeSocket($this->socket);			# Also close the connection
		} else {
			$this->trace("MOHAA::_constructor", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
		} # End if

	} # End constructor MOHAA

	/**
	* Initiates a status call to the server.
	* Returns true if successfull, false if an error occured
	*/
	function getServerStatus($socket) {
		$this->trace ("MOHAA::_getServerStatus ()", "", 0, 0);

		socket_set_blocking ($socket, true);				# Set blocking mode...wait until we have an reaction
		socket_set_timeout ($socket, 0, $this->timeout);		# Set the timeout (in microseconds here!)
		fwrite ($socket, $this->getCommand());				# Interact with gameserver

		$this->trace ("MOHAA::getServerStatus ()", "command issued : " . $this->getCommand(), 1, 1);
		$this->result = @fread($socket, 4096);				# Read stream
		$this->trace ("MOHAA::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
		$this->trace ("MOHAA::getServerStatus ()", $this->result, 2, 1);

		#>>> hier extra controle toevoegen, in ieder geval trace regel toevoegen...
		$socketstatus = socket_get_status($socket);                    # Determine current status of stream
		if (strlen ($this->result) < 20) {
			$this->err = 100;					# Just an code...can be anything
			$this->errmsg = "Connection timed out";			# This is what's wrong ;-)
			$this->result = "";
			$this->trace ("MOHAA::getServerStatus ()", "Connection timed out (or not enough data received)", 2, 1);
			return false;						# We have failed!
		} else {
			$this->result = substr ($this->result, 21);             # Strip header response (something like "statusResponse")
		} # End if

		return true;
	} # End function getServerStatus

	/**
	* Return the server information. The server information is stored in
	* an array, example of server variable: $this->serverdata['sv_minRate']
	*/
        function getServerInfo () {
		$this->trace ("MOHAA::_getServerInfo ()", "", 0, 0);
		$serverinfo = substr ($this->result, 0, strpos($this->result, "\n"));

		$serversplit = split ("[\]", $serverinfo);
		for ($i=0; $i <= sizeof($serversplit) - 2; $i+=2) {
			$j=$i+1;
			$this->serverdata["$serversplit[$i]"] = $serversplit[$j];
		} # End for
	} # End function getServerInfo

	/**
	* Return the user information. The user information for an Mohaa server
	* is stored a bit different then MOHAA, just ovveride the method for
	* this server.
	* The following fields can be uses:
	* 'ping'  --> the players ping time
	* 'name'  --> the name of the player
	*/
	function getUserInfo () {
		$this->trace ("MOHAA::_getUserInfo", "", 0, 0);
		$playerinfo = substr ($this->result, strpos($this->result, "\n"));

		if (strlen ($playerinfo)) {
			$playerdetails = explode ("\"", $playerinfo);
			$this->numofusers=0;
			for ($i=0; $i < count ($playerdetails) - 1; $i=$i+2) {
				$this->userinfo[$this->numofusers]['ping'] = $playerdetails[$i];
				$this->userinfo[$this->numofusers]['name'] = $playerdetails[$i+1];
				$this->numofusers++;
			} # End for
		} # End if
	} # End function getUserInfo

	/**
	* Command line to interact with server, this is different from
	* the MOHAA kinda servers.
	*/
	function getCommand () {
		$this->trace ("MOHAA::_getCommand ()", "", 9, 0);
		return "" . chr (0x02) . "getstatus";			# Command to trigger the mohaa server
	} # End if

	/**
	* Return the maximum number of clients that may connect to this server.
	*/
	function getMaxClients () {
		return number_format($this->serverdata['sv_maxclients']);
	} # End function getMaxClients

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		$this->trace ("MOHAA::_IsServerRunning ()", "", 0, 0);

		if (!empty($this->result)) {
			return true;
		} else {
			return false;
		} # End if
	} # End function IsServerRunning 
} # End class MOHAA
?>