<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.SOF.class.php,v 0.6 2005/12/17 23:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Class that holds the specific game code for an Soldier Of Fortune server (SOF).
* Soldier of Fortune servers look alot like Q3 servers, only the player data 
* retrieval is different, so we use the Q3 class as fundament.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class SOF extends ServerMain {
	/**
	* Constructor.
	*/
	function SOF ($serverip, $port, $debug, $retrycount, $timeout) {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if

		# Here we go!
		$this->trace("SOF::_constructor", "serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;                                    # Initialize properties
		$this->port = $port;
		$this->result = "";						# Contains server respons data

		$this->socket = $this->getSocket($this->serverip, $this->port);
		if ($this->socket) {
			$i=0;
			do {
				$this->getServerStatus($this->socket);		# Interact with gameserver
				$i++;
			} while (empty($this->result) && $i < $this->retry);	# Retry, sometimes server does not respond that fast :D

			$this->trace("SOF::_constructor", $this->result, 1, 1);
			$this->getServerInfo();					# Determine server information...
			$this->getUserInfo();                                   # and the player information
			$this->closeSocket($this->socket);			# Also close the connection
		} # End if
	} # End constructor SOF

	/**
	* Command line to interact with server.
	*/
	function getCommand () {
		$this->trace ("Q3::_getCommand ()", "", 9, 0);
		return "\xff\xff\xff\xffgetstatus\n";
	} # End if

	/**
	* Initiates a status call to the server.
	* Returns true if successfull, false if an error occured
	*/
	function getServerStatus($socket) {
		$this->trace ("Q3::_getServerStatus ()", "", 0, 0);

		socket_set_blocking ($socket, true);				# Set blocking mode...wait until we have an reaction
		socket_set_timeout ($socket, $this->timeout / 100000);		# Set the timeout (in microseconds here!)
		fwrite ($socket, $this->getCommand());				# Interact with gameserver

		$this->trace ("Q3::getServerStatus ()", $this->getCommand(), 1, 1);
		$this->result = @fread($socket, 4096);				# Read stream
		$this->trace ("Q3::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
		$this->trace ("Q3::getServerStatus ()", $this->result, 2, 1);

		#$socketstatus = socket_get_status($socket);                    # Determine current status of stream
		#if ($socketstatus["timed_out"] || strlen ($this->result) <= 20) {
		#	$this->err = 100;					# Just an code...can be anything
		#	$this->errmsg = "Connection timed out";			# This is what's wrong ;-)
		#	$this->trace ("Q3::getServerStatus ()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg , 0, 0);
		#	return false;						# We have failed!
		#} # End if
		$this->result = substr ($this->result, 20);             	# Strip header response (something like "statusResponse")

		return true;
	} # End function getServerStatus

	/**
	* Return the server information. The server information is stored in
	* an array, example of server variable: $this->serverdata['sv_minRate']
	*/
        function getServerInfo () {
		$this->trace ("Q3::_getServerInfo ()", "", 0, 0);
		$serverinfo = substr ($this->result, 0, strpos($this->result, "\n"));

		$serversplit = split ("[\]", $serverinfo);
		for ($i=0; $i <= sizeof($serversplit) - 2; $i+=2) {
			$j=$i+1;
			$this->serverdata["$serversplit[$i]"] = $serversplit[$j];
		} # End for
	} # End function getServerInfo

	/**
	* Return the user information. The user information for an Mohaa server
	* is stored a bit different then Q3, just ovveride the method for
	* this server.
	* The following fields can be uses:
	* 'score' --> the score for this player
	* 'ping'  --> the players ping time
	* 'name'  --> the name of the player
	* 'team'  --> number of team (1 or 2)
	*/
	function getUserInfo () {
		$this->trace ("SOF::_getUserInfo", "", 0, 0);
		$playerinfo = substr ($this->result, strpos($this->result, "\n"));

		if (strlen ($playerinfo)) {
			# Split into two peaces, the first element contains the values for
			# server 'score', 'ping' and team, all delimited by an space, the 
			# second element contains the name of the player.
			$playerdetails = explode ("\"", $playerinfo);
			$this->numofusers=0;
				
			for ($i=0; $i < count ($playerdetails) - 1; $i=$i+2) {
				$elements = explode (" ", $playerdetails[$i]);
				$this->userinfo[$this->numofusers]['score'] = $elements[0];
				$this->userinfo[$this->numofusers]['ping'] = $elements[1];
				$this->userinfo[$this->numofusers]['team'] = $elements[2];
				$this->userinfo[$this->numofusers]['name'] = $playerdetails[$i+1];
				$this->numofusers++;
			} # End for
			

		} # End if
	} # End function getUserInfo

	/**
	* Return the maximum number of clients that may connect to this server.
	*/
	function getMaxClients () {
		return number_format($this->serverdata['sv_maxclients']);
	} # End function getMaxClients

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		$this->trace ("Q3::_IsServerRunning ()", "", 0, 0);
		if (!empty($this->result)) {
			return true;
		} else {
			return false;
		} # End if
	} # End function IsServerRunning 
} # End class SOF
?>