<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.SWAT4.class.php,v 0.6 2005/12/18 22:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* This class contains all logic to question a standard SWAT4 gameserver .
*
* Code example obtained from http://www.10-david.com/?p=files_item&id=2016.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class SWAT4 extends ServerMain {
	/**
	* Constructor.
	*/
	function SWAT4 ($serverip, $port, $debug, $retrycount, $timeout) {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;
		} #End if

		# Here we go!
		$this->trace("SWAT4::_constructor", "serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;
		$this->port = $port;
		$this->result = "";

		# Open socket, and proceed
		$this->socket = $this->getSocket($this->serverip, $this->port);
		if ($this->socket) {
			$i=0;
			do {
				if ($this->getServerStatus($this->socket)) {
					$this->trace ("SWAT4::_constructor ()", "bytes read : " . strlen($this->result), 1, 0);
					$this->getServerInfo();
				} # End if
				$i++;
			} while (empty($this->result) && $i < $this->retry);
			$this->closeSocket($this->socket);
		} else {
			$this->trace("SWAT4::_constructor", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
		} # End if

		$this->serverdata['num_players'] = $this->numofusers;
		$this->serverdata['ip'] = $this->serverip;
		$this->serverdata['port'] = $this->port;
	} # End constructor SWAT4

	/**
	* Command line to interact with server.
	*/
	function getCommand () {
		$this->trace ("SWAT4::_getCommand ()", "", 9, 0);
		return "\\status\\";
		#return "\x5c\x62";
	} # End if

	/**
	* Initiates a status call to the server.
	* Returns true if successfull, false if an error occured
	*/
	function getServerStatus($socket) {
		$this->trace ("SWAT4::_getServerStatus ()", "", 0, 0);

		socket_set_blocking ($socket, true);				# Set blocking mode...wait until we have an reaction
		socket_set_timeout ($socket, $this->timeout / 100000);		# Set the timeout (in microseconds here!)
		fwrite ($socket, $this->getCommand());				# Interact with gameserver

		$this->trace ("SWAT4::getServerStatus ()", $this->getCommand(), 1, 1);
		$this->result = @fread($socket, 4096);				# Read stream
		$this->trace ("SWAT4::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
		$this->trace ("SWAT4::getServerStatus ()", $this->result, 2, 1);

		$socketstatus = socket_get_status($socket);                    # Determine current status of stream
		if ($socketstatus["timed_out"] || strlen ($this->result) <= 20) {
			$this->err = 100;					# Just an code...can be anything
			$this->errmsg = "Connection timed out";			# This is what's wrong ;-)
			$this->trace ("SWAT4::getServerStatus ()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg , 0, 0);
			return false;						# We have failed!
		} # End if
		return true;
	} # End function getServerStatus

	/**
	* Return the server information. The server information is stored in
	* an array, example of server variable: $this->serverdata['sv_minRate']
	*/
        function getServerInfo () {
		$this->trace ("SWAT4::_getServerInfo ()", "", 0, 0);

		# Split response string on '\'.
		$result_b = preg_split ("/\\\\/", substr($this->result, 1), -1, PREG_SPLIT_DELIM_CAPTURE );
		foreach ($result_b as $element) {
			if ($element == "final") {
				break;
			} # End if
			$result_c[] = $element;
		} # End foreach

		if (!isset ($result_c) || count($result_c) < 1) {
			$this->err = 110;					# Just an code...can be anything
			$this->errmsg = "Invalid server response";		# This is what's wrong ;-)
			$this->trace ("SWAT4::getServerStatus ()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg , 0, 0);
			return false;						# We have failed!
		} # End if

		foreach ($result_c as $k => $element) {
			if (!($k % 2)) {
				$this->serverdata["$element"] = $result_c[$k+1];
			} # End if
		} # End foreach

		# Sanity check. $result_d should have half the element count of _c. */
		if ((count ($result_c)/2) != count ($result_d)) {
			$this->err = 110;					# Just an code...can be anything
			$this->errmsg = "WARNING: possible parsing error";	# This is what's wrong ;-)
			$this->trace ("SWAT4::getServerStatus ()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg , 0, 0);
		} # End if

		# At this stage we have collected all variables, now handle all
		# player data.
		for ($i=0; $i < $this->serverdata['numplayers']; $i++) {
			$this->userinfo[$i]['score'] = $this->serverdata["score_$i"];
			$this->userinfo[$i]['ping'] = $this->serverdata["ping_$i"];
			$this->userinfo[$i]['name'] = $this->serverdata["player_$i"];
			$this->numofusers++;
		} # End for


		# Split up the options field, strange way of incorperation some
		# extra info, but what the heck, just split them up here...
		if (isset($this->serverdata["options"])) {
			$options = split (";", $this->serverdata["options"]);
			for ($i=0; $i < count ($options); $i++) {
				$field = split (";", str_replace (")(", ";", $options[$i]));
				$var = substr ($field[0], 1);
				$value = substr ($field[1], 0, strlen($field[1]) - 1);
				$this->serverdata[$var] = $value;
			} # End for
		} # End if
		return true;
		
		
	} # End function getServerInfo

	/**
	* Return version information if running version.
	*/
	function getServerVersion() {
		return $this->serverdata['version'];
	} # End function getServerInfo

	/**
	* Return the maximum number of clients that may connect to this server.
	*/
	function getMaxClients () {
		return number_format($this->serverdata['sv_maxclients']);
	} # End function getMaxClients

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		$this->trace ("SWAT4::_IsServerRunning ()", "", 0, 0);
		if (!empty($this->result)) {
			return true;
		} else {
			return false;
		} # End if
	} # End function IsServerRunning 

	/**
	* Returns true if server is password protected.
	* Returns false for public servers.
	*/
	function isPasswordProtected () {
		if ($this->serverdata['g_needpass'] == 0) {
			return false;
		} # End if
		return true;
	} # End function isPasswordProtected
} # End class SWAT4
?>