<?php
/**
 * Joomla! 1.5 Component Mochigames 0.3 alpha1
 *
 * @version $Id: view.html.php 36 2010-01-26 13:00:20Z yosha79 $
 * @author Martin Mueller
 * @package Joomla
 * @subpackage mochigames
 * @license GNU/GPL
 *
 *
 *
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');

/**
 * HTML View class for the mochigames component
 */
class MochigamesViewMochigames extends JView {
	function display($tpl = null) {

		$params = &JComponentHelper::getParams( 'com_mochigames' );


	    $gid=JRequest::getInt("gid",NULL);
	    if($gid==NULL)
	      $gid=$params->get('gid');

	    $slug=JRequest::getCmd("id",NULL);
	    if($slug==NULL)
	      $gid=$params->get('gid');


	    $model=$this->getModel();
	    $game=$model->getGameBySlug($slug);
	    if($game==NULL) {	
	      die( JError::raiseError( 404, JText::_('Game could not be found') ));  
	    }
	    $gid=$game->id;
	    $model->incGameStat($gid);

        $game->ress_x=$game->res_x;
        $game->ress_y=$game->res_y;


	    $this->assignRef('game',		$game);

	    $cats=$model->getCatsByGame($game->id);
	    $this->assignRef('cats',		$cats);

	    $tags=$model->getTagsByGame($game->id);
	    $this->assignRef('tags',		$tags);

		$params = &JComponentHelper::getParams( 'com_mochigames' );	
	 	$this->assignRef('params',		$params);
	    
		$similar=$model->findSimilarByTag($gid,$params->get('sim_no'));
	    $this->assignRef('similar',		$similar);

	  //get the JDocument and change header information for seo
        $doc = &JFactory::getDocument();
        $doc->setTitle($game->name." - ".$doc->getTitle());

        $key1=$doc->getMetaData("keywords");
		$tag_arr=array();
		for($i=0;$i<count($tags);$i++) {
		  $tag=$tags[$i];
		  $tag_arr[]=$tag->tagname;
		}
		$keytags=implode(", ",$tag_arr);
        $key=$keytags.", ".$key1;
        $doc->setMetaData("keywords",$key);

        $doc->setDescription($game->description);

	  //add styling for tabs
	    $doc->addStyleSheet('components/com_mochigames/assets/tabs.css');

	  //add game to breadcrumb
	  global $mainframe;
	  $breadcrumbs =& $mainframe->getPathWay();
	  $breadcrumbs->addItem( $game->name, '' );

	  
        parent::display($tpl);
    }
}
?>