/**
* GoogleCurrencyConverter module
* This module allows you to add the Google Currency Converter in a module position.
* Author: kksou
* Copyright (C) 2006-2008. kksou.com. All Rights Reserved
* Website: http://www.kksou.com/php-gtk2
* v1.5 August 21, 2008
*/

window.onload = prepareForm;

function prepareForm() {
	if(!document.getElementById) {
		return;
	}
	if(!document.getElementById("currencyForm")) {
		return;
	}
	document.getElementById("currencyForm").onsubmit = function() {
		var data = "";
		for (var i=0; i<this.elements.length; i++) {
			data+= this.elements[i].name;
			data+= "=";
			data+= escape(this.elements[i].value);
			data+= "&";
		}
		data+= "process=1";
		return !sendData(data);
	};
}

function sendData(data) {
	var request = getHTTPObject();
	if (request) {
		//displayLoading(document.getElementById("loading"));
		displayLoading_org(document.getElementById("loading"));
		request.onreadystatechange = function() {
			parseResponse(request);
		};
		//url = lib_url+"?"+data+"&submit_button_label="+submit_button_label;
		url = lib_url+"?"+data+"&submit_button_label="+submit_button_label
		+"&label_convert="+label_convert
		+"&label_into="+label_into
		+"&style="+style;
		request.open( "GET", url, true );
		request.send(null);
		return true;
	} else {
		return false;
	}
}

function parseResponse(request) {
	if (request.readyState == 4) {
		if (request.status == 200 || request.status == 304) {
			var container = document.getElementById("container");
			container.innerHTML = request.responseText;
			fadeUpErrors(container);
			prepareForm();
		}
	}
}

function getHTTPObject() {
	var xhr = false;
	if (window.XMLHttpRequest) {
		xhr = new XMLHttpRequest();
	} else if (window.ActiveXObject) {
		try {
			xhr = new ActiveXObject("Msxml2.XMLHTTP");
		} catch(e) {
			try {
				xhr = new ActiveXObject("Microsoft.XMLHTTP");
			} catch(e) {
				xhr = false;
			}
		}
	}
	return xhr;
}

function displayLoading(element) {
	//element.innerHTML = 'Loading...';
	element.innerHTML = label_loading;
}

function displayLoading_v2(element) {
	var t1 = document.createElement("span");
	var text = document.createTextNode("Loading...");
	t1.appendChild(text);
	element.appendChild(t1);
}

function displayLoading_org(element) {
	var image = document.createElement("img");
	//image.setAttribute("src","progressbar.gif");
	image.setAttribute("src", progress_gif);
	image.setAttribute("alt","Loading...");
	image.setAttribute("align","middle");
	element.appendChild(image);
}

function fadeUp(element,red,green,blue) {
	if (element.fade) {
		clearTimeout(element.fade);
	}
	element.style.backgroundColor = "rgb("+red+","+green+","+blue+")";
	if (red == 255 && green == 255 && blue == 255) {
		return;
	}
	var newred = red + Math.ceil((255 - red)/10);
	var newgreen = green + Math.ceil((255 - green)/10);
	var newblue = blue + Math.ceil((255 - blue)/10);
	var repeat = function() {
		fadeUp(element,newred,newgreen,newblue)
	};
	element.fade = setTimeout(repeat,100);
}

function fadeUpErrors(element) {
	var messages = element.getElementsByTagName("strong");
	for (var i=0; i<messages.length; i++) {
		if (messages[i].className == "error") {
			fadeUp(messages[i],255,153,153);
		}
	}
}