<?php
/**
* GoogleCurrencyConverter module
* This module allows you to add the Google Currency Converter in a module position.
* Author: kksou
* Copyright (C) 2006-2008. kksou.com. All Rights Reserved
* Website: http://www.kksou.com/php-gtk2
* v1.5 August 21, 2008
* v1.5.2 August 28, 2008. Bug Fix. When you set the default "currency from" and "currency to", in the parameters page, these options will now be correctly displayed in the frontend. Thanks to Pablo for pointing this out.
* v1.5.3 September 3, 2008. Support for non-javascript browser
* v1.5.4 May 6, 2009. check for undefined variables
Notice: Undefined index: process on line 12
Notice: Undefined index: a on line 21
Notice: Undefined index: process on line 22
Notice: Undefined index: use_css on line 44
*/

$data = '';
if (isset($_GET['process'])) {
	$app = new App();
	$url = "http://finance.google.com/finance/converter?a={$_GET['a']}&from={$_GET['from']}&to={$_GET['to']}";
	$app->get_page($url);
	$data = $app->process();
}

$currencies = setup_currencies();

$str_a = '';
if (isset($_GET['a'])) $str_a = $_GET['a'];
if (isset($_GET['process'])) $str_a = $app->v;
if ($str_a=='') $str_a = '1';

$str_from = '';
if (isset($currency_from)) $str_from = $currency_from;
if (isset($_GET['from'])) $str_from = $_GET['from'];
if ($str_from=='') $str_from = 'USD';

$str_to = '';
if (isset($currency_to)) $str_to = $currency_to;
if (isset($_GET['to'])) $str_to = $_GET['to'];
if ($str_to=='') $str_to = 'EUR';

if (isset($_GET['label_convert'])) $label_convert = $_GET['label_convert'];
#if ($label_convert=='') $label_convert = 'Convert';
if (isset($_GET['label_into'])) $label_into = $_GET['label_into'];
#if ($label_into=='') $label_into = 'into';

if (isset($_GET['submit_button_label'])) $submit_button_label = $_GET['submit_button_label'];
if ($submit_button_label=='') $submit_button_label = 'Convert';

if (isset($_GET['style'])) $style = $_GET['style'];
if ($style<1 || $style>3) $style = '1';

if (isset($_GET['use_css']) && $_GET['use_css']==1) {
	$highlight = "class=\"highlight\"";
} else {
	$highlight = "style=\"background-color: rgb(255, 255, 160);\"";
}

print '<form action="" method="get" id="currencyForm">';
print "<div class=\"googlecurrency\">";

if ($style==2) {
	print "<table class=\"table1\" border=0>";
	print "<tr><td class=\"td00\">";
	if ($label_convert!='') print "<span class=\"input_label\">$label_convert&nbsp;</span>";
	print "</td>";
	print "<td align=left class=\"td01\"><input name=\"a\" class=\"inputbox\" maxlength=\"12\" size=\"5\" autocomplete=\"off\" value=\"$str_a\">&nbsp;</td><td class=\"td02\">";
	select_currency_pulldownmenu($currencies, 'from', $str_from);
	print "</td><td class=\"td03\"></td></tr><tr><td class=\"td10\"></td><td align=right class=\"td11\">";
	if ($label_into!='') print "<span class=\"input_label\">$label_into&nbsp;</span>";
	print "</td><td class=\"td12\">";
	select_currency_pulldownmenu($currencies, 'to', $str_to);
	print "</td><td class=\"td13\"></td></tr><tr><td colspan = 3 class=\"td2\"><table class=\"table2\" width=100% cellpadding=2 padding-top=\"15px\" border=0><tr><td align=left class=\"td20\">";
	if ($data!='') {
		print "<div id=\"currency_converter_result\" align=left style=\"padding-top:4px;padding-bottom:4px\" class=\"result\">$app->v {$_GET['from']} = <b><span $highlight>$data</span> {$_GET['to']}</b></div>";
	} else {
		print "&nbsp;";
	}
	print "</td><td align=right class=\"td21\">";
	print "<input type=\"submit\" value=\"$submit_button_label\" class=\"button\">";
	print "</td></tr></table>";
	print "<td class=\"td23\"><span id=\"loading\"></span></td>";
	print "</td></tr></table>";

} elseif ($style==3) {
	if ($label_convert!='') print "<span class=\"input_label\">$label_convert&nbsp;</span>";
	print "<input name=\"a\" class=\"inputbox\" maxlength=\"12\" size=\"5\" autocomplete=\"off\" value=\"$str_a\">&nbsp;";
	select_currency_pulldownmenu($currencies, 'from', $str_from);
	if ($label_into!='') print "<span class=\"input_label\">&nbsp;$label_into&nbsp;</span>";
	select_currency_pulldownmenu($currencies, 'to', $str_to);
	print "&nbsp;";
	print "<input type=\"submit\" value=\"$submit_button_label\" class=\"button\">&nbsp;&nbsp;";
	print "<span id=\"loading\"></span><br>";
	if ($data!='') {
		print "<div id=\"currency_converter_result\" align=left style=\"padding-top:4px;padding-bottom:4px\" class=\"result\">$app->v {$_GET['from']} = <b><span $highlight>$data</span> {$_GET['to']}</b></div>";
	}

} else {
	print "<span class=\"input_label\">$label_convert&nbsp;</span>";
	print "<input name=\"a\" class=\"inputbox\" maxlength=\"12\" size=\"5\" autocomplete=\"off\" value=\"$str_a\"><br>";
	select_currency_pulldownmenu($currencies, 'from', $str_from);
	print '<br>';
	print "<span class=\"input_label\">$label_into </span><br>";

	select_currency_pulldownmenu($currencies, 'to', $str_to);
	print "<br>";
	if ($data!='') {
		print "<div id=\"currency_converter_result\" align=left style=\"padding-top:4px;padding-bottom:4px\" class=\"result\">$app->v {$_GET['from']} = <b><span $highlight>$data</span> {$_GET['to']}</b></div>";
	}

	print "<input type=\"submit\" value=\"$submit_button_label\" class=\"button\">&nbsp;&nbsp;";
	print "<span id=\"loading\"></span>";
}


print "<input type=\"hidden\" name=\"submit_button_label\" value=\"$submit_button_label\">";

$use_css2 = '';
if (isset($use_css)) $use_css2 = $use_css;
print "<input type=\"hidden\" name=\"use_css\" value=\"$use_css2\">";

print "<input type=\"hidden\" name=\"process\" value=\"1\">";

$option = '';
if (isset($_REQUEST['option'])) $option = $_REQUEST['option'];
print "<input type=\"hidden\" name=\"option\" value=\"$option\">";

$task = '';
if (isset($_REQUEST['task'])) $task = $_REQUEST['task'];
print "<input type=\"hidden\" name=\"task\" value=\"$task\">";

$id = '';
if (isset($_REQUEST['id'])) $id = $_REQUEST['id'];
print "<input type=\"hidden\" name=\"id\" value=\"$id\">";

$sectionid = '';
if (isset($_REQUEST['sectionid'])) $sectionid = $_REQUEST['sectionid'];
print "<input type=\"hidden\" name=\"sectionid\" value=\"$sectionid\">";

$catid = '';
if (isset($_REQUEST['catid'])) $catid = $_REQUEST['catid'];
print "<input type=\"hidden\" name=\"catid\" value=\"$catid\">";

$Itemid = '';
if (isset($_REQUEST['Itemid'])) $Itemid = $_REQUEST['Itemid'];
print "<input type=\"hidden\" name=\"Itemid\" value=\"$Itemid\">";
print '</div>';
print '</form>';

function select_currency_pulldownmenu($options, $var, $value, $postfix='', $prefix='') {
	$str = "<select name=\"$var\" id=\"$var\">";
	$str = "<select name=\"$var\" id=\"$var\" class=\"$var\">";
	foreach($options as $k=>$v) {
		$selected = '';
		if ($k==$value) $selected = ' selected';
		$str .= "<option value=\"$k\"$selected>$v</option>";
	}
	$str .= "</select>";
	print $prefix.$str.$postfix;
}

class App {

	var $ch;
	var $html;
	var $binary = 0;
	var $url;

	function __construct() {
		$this->html = "";
	}

	function get_page($url) {
		if ($url!='') {
			$ch = curl_init ();
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_BINARYTRANSFER, $this->binary);
			$this->html = curl_exec($ch);
			curl_close($ch);
		}
	}

	function process() {
		$data = $this->html;
		$a = $_GET['a'];
		$from = $_GET['from'];
		$to = $_GET['to'];

		$ok = 0;
		if (preg_match('%<td\s+.*?id="currency_converter_result"\s+.*?>(.*?)</td>%s', $data, $matches)) {
			$data = $matches[1];
			$data = str_replace('&nbsp;', ' ', $data);
		}

		$regexp = "%([\d|.]+)\s+$from\s+=\s+<span\sclass=(.*)>([\d|.]+)\s+$to\s*</span>%s";
		if (preg_match($regexp, $data, $matches)) {
			$data = $matches[3];
			$this->v = $matches[1];
			$ok = 1;
		}

		if (!$ok) $data = '';

		return $data;
	}
}

function setup_currencies() {
	$currencies = array(
		"AED" => 'UAE Dirham (AED)',
		"ANG" => 'Neth Ant Gulden (ANG)',
		"ARS" => 'Argentine Peso (ARS)',
		"AUD" => 'Australian Dollar (AUD)',
		"BGN" => 'Bulgarian Lev (BGN)',
		"BHD" => 'Bahraini Dinar (BHD)',
		"BND" => 'Brunei Dollar (BND)',
		"BOB" => 'Bolivian Boliviano (BOB)',
		"BRL" => 'Brazilian Real (BRL)',
		"BWP" => 'Botswana Pula (BWP)',
		"CAD" => 'Canadian Dollar (CAD)',
		"CHF" => 'Swiss Franc (CHF)',
		"CLP" => 'Chilean Peso (CLP)',
		"CNY" => 'Chinese Yuan (CNY)',
		"COP" => 'Colombian Peso (COP)',
		"CSD" => 'Serbian Dinar (CSD)',
		"CZK" => 'Czech Koruna (CZK)',
		"DKK" => 'Danish Krone (DKK)',
		"EEK" => 'Estonian Kroon (EEK)',
		"EGP" => 'Egyptian Pound (EGP)',
		"EUR" => 'Euro (EUR)',
		"FJD" => 'Fijian Dollar (FJD)',
		"GBP" => 'British Pound (GBP)',
		"HKD" => 'Hong Kong Dollar (HKD)',
		"HNL" => 'Honduran Lempira (HNL)',
		"HRK" => 'Croatian Kuna (HRK)',
		"HUF" => 'Hungarian Forint (HUF)',
		"IDR" => 'Indonesian Rupiah (IDR)',
		"ILS" => 'New Israeli Sheqel (ILS)',
		"INR" => 'Indian Rupee (INR)',
		"ISK" => 'Icelandic Krona (ISK)',
		"JPY" => 'Japanese Yen (JPY)',
		"KRW" => 'South Korean Won (KRW)',
		"KWD" => 'Kuwaiti Dinar (KWD)',
		"KZT" => 'Kazakhstani Tenge (KZT)',
		"LKR" => 'Sri Lankan Rupee (LKR)',
		"LTL" => 'Lithuanian Litas (LTL)',
		"MAD" => 'Moroccan Dirham (MAD)',
		"MUR" => 'Mauritian Rupee (MUR)',
		"MXN" => 'Mexican Peso (MXN)',
		"MYR" => 'Malaysian Ringgit (MYR)',
		"NOK" => 'Norwegian Krone (NOK)',
		"NPR" => 'Nepalese Rupee (NPR)',
		"NZD" => 'New Zealand Dollar (NZD)',
		"OMR" => 'Omani Rial (OMR)',
		"PEN" => 'Peruvian Nuevo Sol (PEN)',
		"PHP" => 'Philippine Peso (PHP)',
		"PKR" => 'Pakistani Rupee (PKR)',
		"PLN" => 'Polish Zloty (PLN)',
		"QAR" => 'Qatari Riyal (QAR)',
		"RON" => 'New Romanian Leu (RON)',
		"RUB" => 'Russian Ruble (RUB)',
		"SAR" => 'Saudi Riyal (SAR)',
		"SEK" => 'Swedish Krona (SEK)',
		"SGD" => 'Singapore Dollar (SGD)',
		"SIT" => 'Slovenian Tolar (SIT)',
		"SKK" => 'Slovak Koruna (SKK)',
		"THB" => 'Thai Baht (THB)',
		"TRY" => 'New Turkish Lira (TRY)',
		"TTD" => 'Trinidad & Tobago (TTD)',
		"TWD" => 'New Taiwan Dollar (TWD)',
		"UAH" => 'Ukrainian Hryvnia (UAH)',
		"USD" => 'United States Dollar (USD)',
		"VEB" => 'Venezuelan Bolivar (VEB)',
		"ZAR" => 'South African Rand (ZAR)',
	);
	return $currencies;
}
?>
