<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: template.game.php,v 0.6 2005/12/21 23:50:00 wilcojansen Exp $
* @package serverstat 0.6
* @copyright (c) 2005 Wilco Jansen
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
* This file contains the serverstat template for gameservers. This template
* handles the output rendering for alsmost all gameservers Serverstat supports.
*
* THIS TEMPLATE IS USED FOR THE INDIVIDUAL MODULE!
*
* Remember that the complete context of the server is available here, so the
* $server and $row objects can be used fully here!
*
* LICENSE
* =======
* Copyright (C) 2005/2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

global $mosConfig_absolute_path, $mosConfig_live_site;

/*
* Let us start to include the variables we need to render the proper information.
* For this we try to include the variable file for the given gametype, if not
* present we render an error message that the server is not supported.
*/
$file = $mosConfig_absolute_path . "/administrator/components/com_serverstat/includes/game." . $row->servertype . ".php";
if (!file_exists($file)) { ?>
	<table width="100%" border="0" class="infoform" cellspacing="0" cellpadding="5">
	<tr>
		<td><?php echo _SERVERSTAT_GAMETYPENOTSUPPORTED; ?> </td>
	</tr>
	</table>
	<?php
	return;
} # End if
include ($file);

$url = $mosConfig_live_site . "/index.php?option=com_serverstat&task=view&id=" . $row->id;
?>

<tr valign="top">
	<td colspan="2">
		<table border="0" cellspacing="0" cellpadding="0" width="100%">
		<tr>
			<td>
			<a href="<?php echo $url; ?>">
			<img src="<?php echo getImagePath ($row, $server); ?>" align="middle" <?php if ($width !=0) echo " width=\"$width\""; if ($height !=0) echo " height=\"$height\""; ?> border="0" align="left">
			</a>
			</td>
		</tr>
		</table>
	</td>
</tr>
<?php
if ($server->IsServerRunning ()) {
	for ($i=0; $i < count($headerfields); $i++) {
		echo "<tr valign=\"top\">\n";
		echo "<td align=\"left\"><small><strong>" . $headerfields[$i] . "</strong></small></td>\n";
		echo "<td align=\"left\"><small>" . $headervalues[$i] . "</small></td>\n";
		echo "</tr>\n";
	} # End for
} else {
	$text = str_replace ('[servername]', $row->servername, _SERVERSTAT_OFFLINE);
	$text = str_replace ('[ip]', $row->ip, $text);
	$text = str_replace ('[port]', $row->port, $text);
?>
	<tr>
		<td align="left" colspan="2"><small><?php echo $text; ?></small></td>
	</tr>
<?php
} # End if
?>
