<?php
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html.
//
// Usage : {mosgoogle} in content displays a google ad as specified in paramenters. 
// You can also use {mosgoogle left}, {mosgoogle right} and {mosgoogle center} if you want the ad align differntly from the set parameters.
// This Plugin is created by ula alkan aka trichnosis
//

defined( '_JEXEC' ) or die( 'Restricted access' );

$mainframe->registerEvent('onPrepareContent', 'plgContentbotGoogleAds') ;

// Import library dependencies
jimport('joomla.event.plugin');


class plgContentbotGoogleAds extends JPlugin
{
	function plgContentbotGoogleAds()
    {

    }
    
    function onPrepareContent(&$row,&$params,$page=0)
    {
        global $mainframe,$mosConfig_live_site;
    $plugin	= JPluginHelper::getPlugin('content', 'bot_adsense');
 	$params= new JParameter( $plugin->params );
 	
        // Plugin code goes here.
        if ($params->get('google_adlinks') == '0')
		{
		$adFormat = $params->get('google_ad_format') ;
		switch ($adFormat)
			{
			case "728x90_as" :
				$ad_width = 728 ;
				$ad_height = 90 ;
				break ;
			case "468x60_as" :
				$ad_width = 468 ;
				$ad_height = 60 ;
				break ;
			case "234x60_as" :
				$ad_width = 243 ;
				$ad_height = 60 ;
				break ;
			case "125x125_as" :
				$ad_width = 125 ;
				$ad_height = 125 ;
				break ;
			case "120x600_as" :
				$ad_width = 120 ;
				$ad_height = 600 ;
				break ;
			case "160x600_as" :
				$ad_width = 160 ;
				$ad_height = 600 ;
				break ;
			case "120x240_as" :
				$ad_width = 120 ;
				$ad_height = 240 ;
				break ;
			case "300x250_as" :
				$ad_width = 300 ;
				$ad_height = 250 ;
				break ;
			case "250x250_as" :
				$ad_width = 250 ;
				$ad_height = 250 ;
				break ;
			case "336x280_as" :
				$ad_width = 336 ;
				$ad_height = 280 ;
				break ;
			case "180x150_as" :
				$ad_width = 180 ;
				$ad_height = 150 ;
				break ;
			}
		}
	else
		{
		$adFormat = $params->get('google_adlink_format') ;

		switch ($adFormat)
			{
			case "728x15_0ads_al" :
				$ad_width = 728 ;
				$ad_height = 15 ;
				break ;
			case "468x15_0ads_al" :
				$ad_width = 468 ;
				$ad_height = 15 ;
				break ;
			case "200x90_0ads_al" :
				$ad_width = 200 ;
				$ad_height = 90 ;
				break ;
			case "180x90_0ads_al" :
				$ad_width = 180 ;
				$ad_height = 90 ;
				break ;
			case "160x90_0ads_al" :
				$ad_width = 160 ;
				$ad_height = 90 ;
				break ;
			case "120x90_0ads_al" :
				$ad_width = 120 ;
				$ad_height = 90 ;
				break ;
			}
			
		if ($params->get('google_adlink_links')  == '5')
			$linksSuffix = '_s' ;
		}

	$alternate = "" ;
	
	if ($params->get('google_collapse') == 'yes')	
		$alternate = "google_alternate_ad_url = \"" . $mosConfig_live_site . "/mambots/content/google_adsense_script.html\";\r\n" ; //Collapse Ads
		
	if ($params->get('google_ad_alt_url') && !$alternate)
		$alternate = "google_alternate_ad_url = \"" . $params->get('google_ad_alt_url') . "\";\r\n" ;
	else 
		if ($params->get('google_ad_alt_color') && !$alternate)
			$alternate = "google_alternate_color = \"" . $params->get('google_ad_alt_color') . "\";\r\n" ;
		
	//The ad code is split so I can change the channel info for each ad
	$googleAd1 	= "<script language=\"javascript\">\r\n"
				. "<!--\r\n"
				. "google_ad_client = \"" . $params->get('google_ad_client') . "\";\r\n"
				. ( $alternate ? $alternate : "" )
				. "google_ad_width = " .  $ad_width . "; \r\n"
				. "google_ad_height = " . $ad_height . "; \r\n"
				. "google_ad_format = \"" . $adFormat . $linksSuffix . "\"; \r\n" ;
	$googleAd2  = "google_ad_channel = \"" . ($channel ? $channel : $params->get('google_ad_channel')) . "\"; \r\n" ;	
	$googleAd3  = ( $params->get('google_ad_in_frame') ? "google_page_url = document.location; \r\n" : "") 
				. "google_ad_type = \"" . $params->get('google_ad_type') . "\"; \r\n"
				. "google_color_border = [\"" . $params->get('google_color_border') . "\",\"" . $params->get('google_color_border2') . "\",\"" . $params->get('google_color_border3') . "\",\"" . $params->get('google_color_border4') . "\"]; \r\n"
				. "google_color_bg = [\"" . $params->get('google_color_bg') . "\",\"" . $params->get('google_color_bg2') . "\",\"" . $params->get('google_color_bg3') . "\",\"" . $params->get('google_color_bg4') . "\"]; \r\n"
				. "google_color_link = [\"" . $params->get('google_color_link') . "\",\"" . $params->get('google_color_link2') . "\",\"" . $params->get('google_color_link3') . "\",\"" . $params->get('google_color_link4') . "\"]; \r\n"
				. "google_color_url = [\"" . $params->get('google_color_url') . "\",\"" . $params->get('google_color_url2') . "\",\"" . $params->get('google_color_url3') . "\",\"" . $params->get('google_color_url4') . "\"]; \r\n"
				. "google_color_text = [\"" . $params->get('google_color_text') . "\",\"" . $params->get('google_color_text2') . "\",\"" . $params->get('google_color_text3') . "\",\"" . $params->get('google_color_text4') . "\"]; \r\n"

				. "google_color_text = \"" . $params->get('google_color_text') . "\"; \r\n"
				. "//--> \r\n"
				. "</script>\r\n"
				. "<script language=\"javascript\"  src=\"http://pagead2.googlesyndication.com/pagead/show_ads.js\"></script>\r\n"
				. "<!-- end of google ads -->\r\n" ;

	if ($params->get('google_autoAds') == 'yes')
		{
		$googleAd = $googleAd1 . $googleAd2 . $googleAd3 ;
		$regex = "#{mosgoogle.*?\}#s" ;
		$regexBreak = '/(<hr )(.*?)(>)/i' ;
		 if ( strpos( $row->text, "{mosgoogle no}" ) ) {
  			$row->text = str_replace( "{mosgoogle no}", '', $row->text );
  			return true;
														}
		$row->text = preg_replace($regex, "", $row->text) ; //Hide all {mosgoogle} tags present in the text
		
		if (!in_array($row->sectionid, explode(",", $params->get('google_exclude_section'))) && !($params->get( 'intro_only' ) && $params->get('google_hide_introAds'))) //If not processing excluded section or hidden intro ad
			{
			$align = $params->get('google_default_align') ;
			$margin =  $params->get('google_margin') ;
			$matches = array() ;
			$regexBreak = '/(<hr )(.*?)(>)/i' ;
			
			preg_match_all( $regexBreak, $row->text, $matches, PREG_SET_ORDER ) ; //Search item for {mospagebreak}
			$text = preg_split( $regexBreak, $row->text ) ; //And split into pages

			$n = count( $text ) ;
			
			$google_position = "top" ;
			
			if ($params->get('google_autoAds_position') == "top") 
				{
				if ($params->get( 'intro_only' ))
					$row->text = $this->alignAd($align, $margin, $googleAd) . $row->text ;
				else
					{
					$row->text = "" ;
			
					for ($i=0 ; $i<$n ; $i++) 
						$row->text .= $this->alignAd($align, $margin, $googleAd) . $text[$i] . $matches[$i][0]  ; //Insert an ad at top of every page
					}
				}
			else			
				{
				if ($params->get( 'intro_only' ))
					$row->text = $row->text . $this->alignAd($align, $margin, $googleAd) ;
				else
					{
					$row->text = "" ;
			
					for ($i=0 ; $i<$n ; $i++) 
						$row->text .= $text[$i] . $this->alignAd($align, $margin, $googleAd) . $matches[$i][0]  ; //Insert an ad at bottom of every page
					}
				}
			
			return true ;
			}
		}
	
	$GLOBALS['botMosGoogle1'] = $googleAd1 ;
	$GLOBALS['botMosGoogle2'] = $googleAd2 ;
	$GLOBALS['botMosGoogle3'] = $googleAd3 ;		
	$GLOBALS['botMosGoogleAlign'] = $params->get('google_default_align') ;
	$GLOBALS['botMosGoogleMargin'] = $params->get('google_margin') ;
	
	$regex = "/{(mosgoogle)\s*(.*?)}/i" ;
	
	$row->text = preg_replace($regex, $this->plgGoogle_replacer($matches), $row->text);
	unset($GLOBALS['botMosGoogle1']) ;		
	unset($GLOBALS['botMosGoogle2']) ;		
	unset($GLOBALS['botMosGoogle3']) ;		
	unset($GLOBALS['botMosGoogleAlign']) ;
	unset($GLOBALS['botMosGoogleMargin']) ;
	
	return true ;
	

   
    }
function plgGoogle_replacer( &$matches )
	{
	$googleAd1 = $GLOBALS['botMosGoogle1'] ;
	$googleAd2 = $GLOBALS['botMosGoogle2'] ;
	$googleAd3 = $GLOBALS['botMosGoogle3'] ;

	$align = $GLOBALS['botMosGoogleAlign'] ;
	$margin = $GLOBALS['botMosGoogleMargin'] ;
		
	$adParams = explode(" ", $matches[2]) ;
		
	$adParams[0] = strtolower($adParams[0]) ;
	
	$channel = $adParams[1] ; // Assume channel info is in 2nd parameter
	
	switch ($adParams[0])
		{
		case "left" :
			$align = "left" ;
			break ;
		case "right" :
			$align = "right" ;
			break ;
		case "center" :
			$align = "center" ;
			break ;
		case "none" :
			$align = "none" ;
			break ;
		default :
			if (!$adParams[1])	//There was no align param; channel info, if exists, is in 1st param
				$channel = $adParams[0] ;

			break ;
		}

	return $this->alignAd($align, $margin, $googleAd1 . ( $channel ? "google_ad_channel = \"" . $channel  . "\"; \r\n" : $googleAd2 ) . $googleAd3) ;
	}
	
function alignAd($align, $margin, $googleAd)
	{
	if ($align == "none")
		return "<div>".$googleAd."</div>" ;

	if ($align != "center")
		return "<div style='float:".$align."; margin-top:".$margin."px ; margin-left:".$margin."px ; margin-right:".$margin."px ; margin-bottom:".$margin."px ;'>".$googleAd."</div>" ;
	
	return "<div align='center'>".$googleAd."</div>" ;
	}
    
}

?>