<?php
/**
* @version $Id: mosserverstat.php,v 0.6 2006/01/01 22:30:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Allows content replacement for Serverstat information
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/ 

# ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

# Register the search function into Mambo framework
$_MAMBOTS->registerFunction( 'onPrepareContent', 'botPrepareContentServerstat' );

# Include for proper reading of Serverstat record
require_once ( $mosConfig_absolute_path."/administrator/components/com_serverstat/class.serverstat.php");

# Load language file
$map = $mosConfig_absolute_path . '/administrator/components/com_serverstat';

if (file_exists($map.'/language/'.$mosConfig_lang.'.php')) {
  include($map.'/language/'.$mosConfig_lang.'.php');
} elseif (file_exists($map.'/language/english.php'))  {
  include($map.'/language/english.php');
} else {
	die ( 'Language file not present...' );
}# End if

# Yes, we want an overlib effect here :D
mosCommonHTML::loadOverlib();

/**
* Onprepare content method (the actual Mambot logic)
*/
function botPrepareContentServerstat( $published, &$row, $mask=0, $page=0  ) {
	global $mosConfig_absolute_path, $dservertypes;
	global $replace;
 
	if (!$published) {
		return true;
	} # End if

	# Some global variables
	$replace = true;
 
	# define the regular expression for the bot
	$regex = "#{serverstat*(.*?)}#s";
 
	# perform the replacement
	$row->text = preg_replace_callback( $regex, 'botMosServerstat_replacer', $row->text );
 
	return true;
} # End function botPrepareContentServerstat

/**
* Replaces the matched tags
* @param array An array of matches (see preg_match_all)
* @return string
*/
function botMosServerstat_replacer( &$matches ) {
	global $mosConfig_live_site, $mosConfig_absolute_path, $database;
	global $serverstat_threshold, $dservertypes, $gamespy2vars;
	global $replace;

	require_once ( $mosConfig_absolute_path."/administrator/components/com_serverstat/includes/function.serverstat.php");
	require_once ( $mosConfig_absolute_path."/administrator/components/com_serverstat/config/config.serverstat.php");

	# Determine action and server id where action applies to 
	list(, $action, $id, $var, $option ) = split (":", $matches[1]);

	# Load the row from the db table
	$row = new mosServerstatServers( $database );
	$row->load( $id );

	if ($replace && $action != "off") {
		# Handle the status rendering logic here (like we do in the module),
		# this includes the slow server support and the overlib status
		# logic.
		$url = $mosConfig_live_site . sefRelToAbs( '/index.php?option=com_serverstat&task=view&id=' . $id );
		if ($row->tcounter > $serverstat_threshold && ($row->views % $serverstat_threshold !=0) && $serverstat_threshold !=0) {
			$tooltip = _SERVERSTAT_UNKNOWN;
			$imagestatus = "unknown.gif";
		} else {
			if ($server = instantiateServerClass ( $row , false, true)) {
				# Handle the on/offline status.
				if ($server->IsServerRunning ()) {
					$imagestatus = "online.gif";
					if ($server->getUsersOnline () == 1) {
						$tooltip = str_replace ('[numofusers]', number_format ($server->getUsersOnline ()), _SERVERSTAT_ONLINE_ONE);
					} else {
						$tooltip = str_replace ('[numofusers]', number_format ($server->getUsersOnline ()), _SERVERSTAT_ONLINE_MORE);
					} # End if
					$tooltip = str_replace ('[os]', $server->getOSRunning(), $tooltip);
				} else {
					$tooltip = _SERVERSTAT_OFFLINE;
					$imagestatus = "offline.gif";
				} # End if
				$tooltip = str_replace ('[servername]', $row->servername, $tooltip);
				$tooltip = str_replace ('[ip]', $row->ip, $tooltip);
				$tooltip = str_replace ('[port]', $row->port, $tooltip);
				$href = mosToolTip( $tooltip, $title=$row->servername, $width='', $image='tooltip.png', $text=$row->servername, $href=$url);
				$content .= "</tr>\n";
			} else {
				return $matches[0];
			} # End if
		} # End if
	} # End if

	$return = $matches[0];

	# Handle the action
 	switch ($action) {
		# Only a linkt to the server
 		case "link":
 			if ($replace) {
 				$return = '<a href="'.sefRelToAbs( 'index.php?option=com_serverstat&task=view&id=' . $id ).'">' . $row->servername . '</a>';
 			} # End if
 			break;

		# Link to the server, render the current online status (like in
		# the Serverstat module).
 		case "status":
 			if ($replace) {
 				$return = $href;
 			} # End if
 			break;

		# Render the online.gif or offline.gif for given server
		case "image":
 			if ($replace) {
 				$return = "<img src=\"" . $mosConfig_live_site . "/administrator/components/com_serverstat/images/" . $imagestatus . "\">";
 			} # End if
			break;

		# Toggle on the Serverstat replacement switch
		case "on":
			$replace = true;
			$return = "";
			break;

		# Toggle the Serverstat replacement switch off
		case "off":
			$replace = false;
			$return = "";
			break;

		# Replace with server variabele. If variable is not set, we
		# do no replacement!
		case "servervar":
 			if ($replace) {
				switch ($option) {
				case "0":
					$return = q3Name2HTML($server->serverdata[$var]);
					break;

				case "1":
					$return = UTName2HTML ($server->serverdata[$var]);
					break;
				default:
					$return = $server->serverdata[$var];
					break;
				} # End switch
			} # End if
			break;

 		default:
 			$return = '<a href="'.sefRelToAbs( 'index.php?option=com_serverstat&task=view&id=' . $id ).'">' . $row->servername . '</a>';
 			break;
 	} # End switch
	return $return;
} # End function botMosServerstat_replacer
?>
