<?php 
/**
* @version $Id: admin.serverstat.php,v 0.6.2 2006/08/28 23:55:00 wilcojansen Exp $
* @package serverstat 0.6.2
* @copyright (c) 2005 Wilco Jansen
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
* Serverstatus main Handler.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/config/config.serverstat.php");
require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/class.serverstat.php");
require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/includes/function.serverstat.php");
require_once( $mosConfig_absolute_path . '/includes/domit/xml_domit_lite_include.php' );
require_once( $mainframe->getPath( 'admin_html' ) );

# Load language file.
$map = $mosConfig_absolute_path . '/administrator/components/com_serverstat';

if (file_exists($map.'/language/'.$mosConfig_lang.'.php')) {
  include($map.'/language/'.$mosConfig_lang.'.php');
} elseif (file_exists($map.'/language/english.php'))  {
  include($map.'/language/english.php');
} else {
	die ( 'Language file not present...' );
}# End if

/**
* Variables handling.
*/
$id = intval( mosGetParam( $_GET, 'id', 0 ) );
if (empty($id)) {
	$id = intval( mosGetParam( $_POST, 'id', 0 ) );
} # End if 

if (isset($cid)) {
	if (!is_array( $cid )) {
		$cid = array(0);
	} # End if
} # End if

# Handle the events.
switch ($task) {
	case "about":
		showAbout();
		break;

	case "edit":
		editServer( $id, $option );
		break;

	case "new":
		editServer( 0, $option );
		break;

	case "orderup":
		orderServers( $cid[0], -1, $option );
		break;

	case "orderdown":
		orderServers( $cid[0], 1, $option );
		break;

	case "publish":
		publishServers( $cid, 1, $option );
		break;

	case "unpublish":
		publishServers( $cid, 0, $option );
		break;

	case 'save':
		saveServer( $id, $option );
		break;

	case 'remove':
		removeServer( $cid, $option );
		break;

	case 'cancel':
		cancelServer( $option );
		break;

	case "config":
		showConfig( $option );
		break;

	case "savesettings":
		saveConfig ( $option );
		break;

	case "stats":
		showStats ( $option, $database);
		break;

	case "statshow":
		showStatsServer ( $option, $database, $id );
		break;

	case "help":
		showHelpScreen ( $option );
		break;

	case "mappack":
		showMapPack ( $option );
		break;

	case "installmappack":
		installMapPacks ( $cid, $option);
		break;

	case "removemappack":
		removeMapPacks ( $cid, $option);
		break;

	# Here we have a un-documented feature. This option generates the
	# mappack.xml file for all servertypes that hold the map-pack images.
	case "generatemappackxml":
		generateMapPackXML ();
		break;

	default:
		showServers( $option, $database );
		break;
} # End switch

/**
* Show the serverlist.
*/
function showServers ( $option, &$db ) {
	global $database, $my, $mainframe, $serverstat_servers, $mosConfig_absolute_path;

	# Determine some paging vars.
	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "viewlimitstart", 'limitstart', 0 );

	$st = mosGetParam( $_POST, 'st', '' );
	if (empty($st)) {
		$st = mosGetParam( $_GET, 'st', '' );
	} # End if
	$rm = mosGetParam( $_POST, 'rm', 0 );
	if (empty($rm)) {
		$rm = mosGetParam( $_GET, 'rm', '' );
	} # End if

	# Get the total number of records, this is used for paging option
	# in form.
	if (empty($st)) {
		if ($rm == 0) {
			$query = "SELECT COUNT(*) FROM #__serverstat_servers WHERE remote=0";
			$query1 = "SELECT * FROM #__serverstat_servers WHERE remote=0";
		} else {
			$query = "SELECT COUNT(*) FROM #__serverstat_servers";
			$query1 = "SELECT * FROM #__serverstat_servers";
		} # End if
	} else {
		if ($rm == 0) {
			$query = "SELECT COUNT(*) FROM #__serverstat_servers WHERE remote=0 AND servertype='$st'";
			$query1 = "SELECT * FROM #__serverstat_servers WHERE remote=0 AND servertype='$st'";
		} else {
			$query = "SELECT COUNT(*) FROM #__serverstat_servers WHERE servertype='$st'";
			$query1 = "SELECT * FROM #__serverstat_servers WHERE servertype='$st'";
		} # End if
	} # End if

	$database->setQuery( $query );
	$total = $database->loadResult();

	# Now read the current dataset, and pass it on...
	$query1 .= " ORDER BY ordering LIMIT $limitstart,$limit";
	$database->setQuery( $query1);
	$rows = $database->loadObjectList();
	if ($db->getErrorNum()) {
		echo $db->stderr();
		return false;
	} # End if

	# Initialize the paging, offer the total number of records, the first record
	# for current page and the number of records to render.
	require_once($mosConfig_absolute_path . "/administrator/includes/pageNavigation.php");
	$pageNav = new mosPageNav( $total, $limitstart, $limit  );

	# Create option field for servertype
	$array = $serverstat_servers;
	$servertypes[] = mosHTML::makeOption( '', _SERVERSTAT_LIST_SELECT_TYPE );
	for ($i=0; $i<count($array); $i++) {
		$servertypes[] = mosHTML::makeOption( $array[$i]['id'], $array[$i]['description'] );
	} # End for
	$javascript = 'onchange="document.adminForm.submit();"';
	$lists['st'] = mosHTML::selectList( $servertypes, 'st', 'class="inputbox" size="1"' . $javascript, 'value', 'text', $st);

	# Use the method in the HTML class to render the server details.
	HTML_serverstat::showServerEntries( $option, $rows, $pageNav, $lists, $st, $rm );
} # End function showServers

/**
* Changes the state of one or servers
*/
function publishServers( $cid=null, $publish=0, $option ) {
	global $database, $my;

	# Check if we have an array of elements that have been marked,
	# if not, we just create an dummy array.
	if (!is_array( $cid )) {
		$cid = array();
	} # End if

	# Is there at least one record selected? No, just render an error
	if (count( $cid ) < 1) {
		$action = $publish == 1 ? 'publish' : ($publish == -1 ? 'archive' : 'unpublish');
		echo "<script> alert('Select an item to $action'); window.history.go(-1);</script>\n";
		exit;
	} # End if

	# Prepare query, and update records.
	$cids = implode( ',', $cid );
	$database->setQuery( "UPDATE #__serverstat_servers SET published='$publish'"
	. "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))"
	);

	# Handle errors here...
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	} # End if

	# And redirect to current page.
	mosRedirect( "index2.php?option=$option" );
} # End function publishServers

/**
 * Changes the rendering order of the servers.
 */
function orderServers( $uid, $inc, $option ) {
	global $database;

	$row = new mosServerstatServers( $database );
	$row->load( $uid );
	$row->move( $inc, "published >= 0" );

	mosRedirect( "index2.php?option=$option" );
} # End function orderServers

/**
 * Compiles information to add or edit the record
 */
function editServer( $id, $option ) {
	global $database, $my, $mainframe, $serverstat_servers;
	global $mosConfig_absolute_path, $mosConfig_live_site, $mosConfig_offset;
	global $serverstat_template, $serverstat_backendcheck;

	# some variables to control the editing flow
	$st = mosGetParam( $_GET, 'st', '' );
	$rm = mosGetParam( $_GET, 'rm', 0 );

	# Load the row from the db table
	$row = new mosServerstatServers( $database );
	$row->load( $id );

	# Fail if checked out not by current user, if we pass the check, just 
	# flip the scheckoutflag.
	if ($row->checked_out && $row->checked_out <> $my->id) {
		mosRedirect( 'index2.php?option=com_serverstat', 'The server '. $row->servername .' is currently being edited by another administrator' );
	} # End if

	$row->checkout( $my->id );

	# Now we just modify some vars for nice and neath rendering.
	$row->created = mosFormatDate( $row->created, '%Y-%m-%d %H:%M:%S' );
	$query = "SELECT name from #__users"
	. "\n WHERE id=$row->created_by"
	;
	$database->setQuery( $query );
	$row->creator = $database->loadResult();

	$row->modified = mosFormatDate( $row->modified, '%Y-%m-%d %H:%M:%S' );
	$query = "SELECT name from #__users"
	. "\n WHERE id=$row->modified_by";
	$database->setQuery( $query );
	$row->modifier = $database->loadResult();

	# Create option field for servertype
	$array = $serverstat_servers;
	$servertypes[] = mosHTML::makeOption( '', _SERVERSTAT_LIST_SELECT_TYPE );
	for ($i=0; $i<count($array); $i++) {
		$servertypes[] = mosHTML::makeOption( $array[$i]['id'], $array[$i]['description'] );
	} # End for
	$javascript = 'onchange="setfields()"';
	$lists['servertype'] = mosHTML::selectList( $servertypes, 'servertype', 'class="inputbox" size="1"' . $javascript, 'value', 'text', $row->servertype);

	# Build the html select list for ordering
	$query = "SELECT ordering AS value, servername AS text"
	. "\n FROM #__serverstat_servers"
	. "\n WHERE published >= 0"
	. "\n ORDER BY ordering"
	;
	$lists['ordering'] = mosAdminMenus::SpecificOrdering( $row, $id, $query, 1 );

	# Build the list with possible server images, remember that when we choose
	# "Default for servertype" we need to replace the image name with
	# the name for this gametype when rendering the online status :P
	$array = $serverstat_servers;
	$images[] = mosHTML::makeOption( "", _SERVERSTAT_LIST_DEFAULT );
	for ($i=0; $i<count($array); $i++) {
		$images[] = mosHTML::makeOption( $array[$i]['icon'], $array[$i]['description'] );
	} # End for
	$lists['images'] = mosHTML::selectList( $images, 'image', 'class="inputbox" size="1"', 'value', 'text', $row->image );

	# Check out the list with possible templates, end build an select list.
	$templates[] = mosHTML::makeOption( "", _SERVERSTAT_LIST_DEFAULT );

	if ($dir = @opendir($mosConfig_absolute_path."/administrator/components/com_serverstat/templates/")) {
  		while (($file = readdir($dir)) !== false) {
    			if ($file != "." && $file != ".." && $file != $serverstat_template) {
    				$templates[] = mosHTML::makeOption( $file, $file );
    			} # End if
  		} # End while
  	closedir($dir);
	} # End if
	$lists['templates'] = mosHTML::selectList( $templates, 'template', 'class="inputbox" size="1"', 'value', 'text', $row->template);

	# Ok, now we are going to check the online status for this servertype.
	# First we need to determine the class this server belongs to, instantiate
	# the class, and check the online status. Of course this only applies for
	# existing servers.
	if ($row->id && $serverstat_backendcheck) {
		$server = instantiateServerClass ($row);
		if ($server->IsServerRunning ()) {
			$status = '<font color="#008000">Online</font>';
		} else {
			$status = '<font color="red">Offline</font>';
		} # End if
	} else {
		$status = "-";
	} # End if

	# Render the form thru the HTML class for this module.
	HTML_serverstat::editServers( $row, $option, $lists, $status, $st, $rm);
} # End function editServers

/**
 * Remove selected servers from table.
 */
function removeServer( &$cid, $option ) {
	global $database, $mainframe;

	# Control the flow here
	$st = mosGetParam( $_POST, 'st', '' );
	$rm = mosGetParam( $_POST, 'rm', 0 );

	$total = count( $cid );
	if ( $total < 1) {
		echo "<script> alert('Select an item to delete'); window.history.go(-1);</script>\n";
		exit;
	} # End if

	# Prepare query to delete records and make it so
	$query = "DELETE FROM #__serverstat_servers"
	. "\n WHERE id IN ( ". implode( ',', $cid ) ." )";
	$database->setQuery( $query );
	if ( !$database->query() ) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	} # End if

	# Return to main page and confirm deletion
	$msg = $total ." Server(s) have been deleted";
	$return = mosGetParam( $_POST, 'returntask', '' );
	mosRedirect( 'index2.php?option='. $option . "&st=$st&rm=$rm", $msg );
} # End function removeServer

/**
 * Save edited field for an server (new/modify).
 */
function saveServer( $id, $option ) {
	global $database, $my, $mosConfig_offset;

	# Control the flow here
	$st = mosGetParam( $_POST, 'st', '' );
	$rm = mosGetParam( $_POST, 'rm', 0 );

	# Just try to open new instance, including error handling
	$row = new mosServerstatServers ( $database );
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	} # End if

	# Determine if we have an new record, and set some variables
	# to the proper value
	$isNew = ( $row->id < 1 );
	if ($isNew) {
		$row->created 		= $row->created ? mosFormatDate( $row->created, '%Y-%m-%d %H:%M:%S', -$mosConfig_offset * 60 * 60 ) : date( "Y-m-d H:i:s" );
		$row->created_by 	= $row->created_by ? $row->created_by : $my->id;
	} else {
		$row->modified 		= date( "Y-m-d H:i:s" );
		$row->modified_by 	= $my->id;
	} # End if

	# Checkbox values return empty when not checked, make this
	# an reasonable value when this happens.
	$row->published = mosGetParam( $_REQUEST, 'published', 0 );
	$row->slowserver = mosGetParam( $_REQUEST, 'slowserver', 0 );
	$row->collectstats = mosGetParam( $_POST, 'collectstats', 0 );
	$row->emailnotification = mosGetParam( $_POST, 'emailnotification', 0 );

	# Perform additional check (if defined in database class, is here for 
	# later use).
 	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	} # End if

	# Store current fields, throw error when not succesfull.
	$row->checkin();
	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	} # End if
	$row->updateOrder();

	# Clean up cache just in case :D and redirect to main server part.
	mosCache::cleanCache( 'com_serverstat' );
	mosRedirect( 'index2.php?option='. $option . "&st=$st&rm=$rm");
} # End function saveServer

/**
 * Cancels an edit operation for given server...
 */
function cancelServer( $option ) {
	global $database;

	# Control the flow here
	$st = mosGetParam( $_POST, 'st', '' );
	$rm = mosGetParam( $_POST, 'rm', 0 );

	# Cancel mutation
	$row = new mosServerstatServers( $database );
	$row->bind( $_POST );
	$row->checkin();

	mosRedirect( 'index2.php?option='. $option . "&st=$st&rm=$rm");
} # End function cancelContent

/**
 * Writes the serverstat configurationfile. For this we read the complete
 * configurationfile, and only replace those lines where we have
 * configurable options, all other lines in the config file will stay
 * untouched!
 */
function saveConfig ($option) {
	global $mosConfig_absolute_path;

	$configfile = $mosConfig_absolute_path."/administrator/components/com_serverstat/config/config.serverstat.php";

	# check for proper rights here
	if (!is_writable ($configfile)) {
		mosRedirect("index2.php?option=$option&task=config", "Config file is not writable");
	} # End if

	# Read file, and write changes back.
	$lines = file ($configfile);

	# Just walk thru file
	foreach ($lines as $line_num => $line) {
  		trim($line);

		if (substr($line, 1, strlen('serverstat_threshold')) == 'serverstat_threshold') {
			$output .= '$serverstat_threshold = ' . $_POST['threshold'] . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_collectstats')) == 'serverstat_collectstats') {
			$output .= '$serverstat_collectstats = ' . number_format ($_POST['collectstats']) . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_jpgraph')) == 'serverstat_jpgraph') {
			$output .= '$serverstat_jpgraph = ' . number_format ($_POST['jpgraph']) . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_remotestatus')) == 'serverstat_remotestatus') {
			$output .= '$serverstat_remotestatus = ' . number_format ($_POST['remotestatus']) . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_serviceprovider')) == 'serverstat_serviceprovider') {
			$output .= '$serverstat_serviceprovider = "' . $_POST['serviceprovider'] . "\";\n";
		} elseif (substr($line, 1, strlen('serverstat_retrycount')) == 'serverstat_retrycount') {
			$output .= '$serverstat_retrycount = ' . number_format ($_POST['retrycount']) . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_tweaking')) == 'serverstat_tweaking') {
			$output .= '$serverstat_tweaking = ' . number_format ($_POST['tweaking']) . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_backendcheck')) == 'serverstat_backendcheck') {
			$output .= '$serverstat_backendcheck = ' . number_format ($_POST['backendcheck']) . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_mastermappack')) == 'serverstat_mastermappack') {
			$output .= '$serverstat_mastermappack = ' . "\"" . $_POST['mastermappack'] . "\";\n";
		} elseif (substr($line, 1, strlen('serverstat_connectbutton')) == 'serverstat_connectbutton') {
			$output .= '$serverstat_connectbutton = ' . number_format ($_POST['connectbutton']) . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_logpublished')) == 'serverstat_logpublished') {
			$output .= '$serverstat_logpublished = ' . number_format ($_POST['logpublished']) . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_logremote')) == 'serverstat_logremote') {
			$output .= '$serverstat_logremote = ' . number_format ($_POST['logremote']) . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_actasserviceprovider')) == 'serverstat_actasserviceprovider') {
			$output .= '$serverstat_actasserviceprovider = ' . number_format ($_POST['actasserviceprovider']) . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_disablewhenlogthresholdreached')) == 'serverstat_disablewhenlogthresholdreached') {
			$output .= '$serverstat_disablewhenlogthresholdreached = ' . number_format ($_POST['disablewhenlogthresholdreached']) . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_logthreshold')) == 'serverstat_logthreshold') {
			$output .= '$serverstat_logthreshold = ' . number_format ($_POST['logthreshold'], 1) . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_logretention')) == 'serverstat_logretention') {
			$output .= '$serverstat_logretention = ' . number_format ($_POST['logretention'], 0) . ";\n";
		} elseif (substr($line, 1, strlen('serverstat_loginterval')) == 'serverstat_loginterval') {
			if ($_POST['collectstats'] != 0) {
				$output .= '$serverstat_loginterval = ' . $_POST['loginterval'] . ";\n";
			} else {
				$output .= $line;
			} # End if
		} else {
			$output .= $line;
		} # End if
	} # End foreach

	# Now we write back the file...
	if ($fp = fopen("$configfile", "w+")) {
		fputs($fp, $output, strlen($output));
		fclose ($fp);
	} # End if

	mosRedirect("index2.php?option=$option&task=config", "Settings saved");
} # End function saveConfig

/**
* Show the serverlist.
*/
function showStats ( $option, &$db ) {
	global $database, $my, $mainframe, $mosConfig_absolute_path;

	# Determine some paging vars.
	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "viewlimitstart", 'limitstart', 0 );

	# Get the total number of records, this is used for paging option
	# in form.
	$database->setQuery( "SELECT COUNT(*) FROM #__serverstat_servers WHERE collectstats > 0");
	$total = $database->loadResult();

	# Now read the current dataset, and pass it on...
	$database->setQuery( "SELECT * FROM #__serverstat_servers"
	. "\nWHERE collectstats > 0"
	. "\nORDER BY ordering"
	. "\nLIMIT $limitstart,$limit"
	);

	$rows = $database->loadObjectList();
	if ($database->getErrorNum()) {
		echo $db->stderr();
		return false;
	} # End if

	# Initialize the paging, offer the total number of records, the first record
	# for current page and the number of records to render.
	require_once($mosConfig_absolute_path . "/administrator/includes/pageNavigation.php");
	$pageNav = new mosPageNav( $total, $limitstart, $limit  );

	# Use the method in the HTML class to render the server details.
	HTML_serverstat::showServerStatEntries( $option, $rows, $pageNav );
} # End function showServers

/**
* Show the server statistics for given server. In this function we keep up the
* strict seperation of the readout and html logic. For this we determine the
* action needed here, read out the database en pass on the info to the
* HTML class for rendering.
*/
function showStatsServer ( $option, &$db, $id ) {
	global $database, $serverstat_monthnames, $dservertypes, $serverstat_loginterval, $gamespy2vars;

	# Determine selctions from form
	$type = intval( mosGetParam( $_POST, 'type', 0 ) );

	# Now read the current dataset, and pass it on...
	$database->setQuery( "SELECT * FROM #__serverstat_servers"
	. "\nWHERE id=$id"
	);

	$rows = $database->loadObjectList();
	if (count ($rows) != 1) {
		echo "Invalid server selected";
		return false;
	} # End if

	$row = $rows[0];

	# Now we just modify some vars for nice and neath rendering.
	$row->created = mosFormatDate( $row->created, '%Y-%m-%d %H:%M:%S' );
	$query = "SELECT name from #__users"
	. "\n WHERE id=$row->created_by"
	;
	$database->setQuery( $query );
	$row->creator = $database->loadResult();

	$row->modified = mosFormatDate( $row->modified, '%Y-%m-%d %H:%M:%S' );
	$query = "SELECT name from #__users"
	. "\n WHERE id=$row->modified_by";
	$database->setQuery( $query );
	$row->modifier = $database->loadResult();

	# Detemine date value
	$seldate = $_POST ['seldata'];
	if (empty ($seldate)) {
		$seldate = date('Y-m-d');
	} # End if
	$lists['seldate'] = $seldate;

	# Fill up the select fields for graph type and date selection
	$database->setQuery( "SELECT * FROM #__serverstat_servers"
	. "\nWHERE collectstats > 0"
	. "\nORDER BY ordering"
	);

	$rows = $database->loadObjectList();

	for ($i=0; $i < count($rows); $i++) {
		$servers[] = mosHTML::makeOption( $rows[$i]->id, $rows[$i]->servername);
	} # End if
	$lists['servers'] = mosHTML::selectList( $servers, 'id', 'class="inputbox" size="1"', 'value', 'text', $id);

	# Only use years that exist in the log...
	$query = "SELECT DATE_FORMAT( date,  '%Y' ) AS year"
	. "\nFROM #__serverstat_stats"
	. "\n WHERE serverid=$id"
	. "\n GROUP BY 1";
	$database->setQuery( $query );
	if ($db->getErrorNum()) {
		echo $db->stderr();
		return false;
	} # End if
	$rows = $database->loadObjectList();

	# Selection based uppon the selected date. Here we render the
	# hours per day, for this we create an array with the hours, and
	# the corresponding values in it. This array will be passed to
	# the HTML class. Also we determine the link for rendering the
	# JpGraph image, that one will be included with an <img src=...tag
	$stats = Array();
	for ($i=0; $i<=23; $i++) {
		$seldata = $seldate . sprintf(" %02d:00:00", $i);

		# Query all record within the given time period
		# for current day. It is for example possible the
		# logger has run with an 15 minute interval, we
		# need to obtain the avarage values for that our,
		# so group it and let the database do the job...
		$query = "SELECT DATE_FORMAT( date,  '%Y-%m-%d %H' ),"
		. "\n AVG( users ) AS users,"
		. "\n AVG( maxusers ) AS maxusers,"
		. "\n AVG( pinglowest ) AS pinglowest,"
		. "\n AVG( pinghighest ) AS pinghighest,"
		. "\n AVG( pingavarage ) AS pingavarage,"
		. "\n AVG( classtiming ) AS classtiming"
		. "\nFROM #__serverstat_stats"
		. "\n WHERE serverid=$id"
		. "\n AND DATE_FORMAT( date,  '%Y-%m-%d %H:00:00'  ) = '$seldata'"
		. "\n GROUP BY 1";
		$database->setQuery( $query );
		$rows = $database->loadObjectList();

		$stats[$i]['type'] = sprintf ("%02d:00", $i);
		if (count($rows) != 0) {
			$stats[$i]['users'] = round ($rows[0]->users);
			$stats[$i]['maxusers'] = round ($rows[0]->maxusers);
			$stats[$i]['load'] = @number_format (($stats[$i]['users'] / $stats[$i]['maxusers']) * 100, 2) . "%";
			$stats[$i]['pinglowest'] = intval ($rows[0]->pinglowest);
			$stats[$i]['pinghighest'] = intval ($rows[0]->pinghighest);
			$stats[$i]['pingavarage'] = intval ($rows[0]->pingavarage);
			$stats[$i]['classtiming'] = number_format ($rows[0]->classtiming, 3);

			$graph[$i]['users'] = round ($rows[0]->users);
			$graph[$i]['maxusers'] = round ($rows[0]->maxusers);
			$graph[$i]['load'] = @number_format (($stats[$i]['users'] / $stats[$i]['maxusers']) * 100, 2) . "%";
			$graph[$i]['pinglowest'] = intval ($rows[0]->pinglowest);
			$graph[$i]['pinghighest'] = intval ($rows[0]->pinghighest);
			$graph[$i]['pingavarage'] = intval ($rows[0]->pingavarage);
			$graph[$i]['classtiming'] = number_format ($rows[0]->classtiming, 3);
		} else {
			$stats[$i]['users'] = "-";
			$stats[$i]['maxusers'] = "-";
			$stats[$i]['load'] = "-";
			$stats[$i]['pinglowest'] = "-";
			$stats[$i]['pinghighest'] = "-";
			$stats[$i]['pingavarage'] = "-";
			$stats[$i]['classtiming'] = "-";

			$graph[$i]['users'] = 0;
			$graph[$i]['maxusers'] = 0;
			$graph[$i]['load'] = 0;
			$graph[$i]['pinglowest'] = 0;
			$graph[$i]['pinghighest'] = 0;
			$graph[$i]['pingavarage'] = 0;
			$graph[$i]['classtiming'] = 0;
		} # End if
	} # End for

	# Determine graph legend
	$lists['jpgraphusers'] = _SERVERSTAT_JPGRAPH_USERS;
	$lists['jpgraphperformance'] = _SERVERSTAT_JPGRAPH_PERFORMANCE;
	$lists['jpgraphclassformance'] = _SERVERSTAT_JPGRAPH_CLASS_PERFORMANCE;
	$lists['lminping'] = _SERVERSTAT_JPGRAPH_MINPING;
	$lists['lmaxping'] = _SERVERSTAT_JPGRAPH_MAXPING;
	$lists['lavgping'] = _SERVERSTAT_JPGRAPH_AVGPING;
	$lists['titlexaxis'] = _SERVERSTAT_JPGRAPH_PERFORMANCE_X;
	$lists['titleyaxis'] = _SERVERSTAT_JPGRAPH_PERFORMANCE_Y;
	$lists['titleyaxisclass'] = _SERVERSTAT_JPGRAPH_PERFORMANCE_CLASS_Y;
	$lists['lclasstiming'] = _SERVERSTAT_JPGRAPH_PERFORMANCE_Y;

	# Ok, now we are going to check the online status for this servertype.
	# First we need to determine the class this server belongs to, instantiate
	# the class, and check the online status. Of course this only applies for
	# existing servers.
	$server = instantiateServerClass ($row);
	if ($server->IsServerRunning ()) {
		$status = '<font color="#008000">Online</font>';
	} else {
		$status = '<font color="red">Offline</font>';
	} # End if

	# Count log record for this server
	$database->setQuery( "SELECT COUNT(*) FROM #__serverstat_stats"
	. "\nWHERE serverid=$id"
	);
	$lists['logcount'] = $database->loadResult();
	
	# Determine when logging started for this server
	$database->setQuery( "SELECT MIN(date) FROM #__serverstat_stats"
	. "\nWHERE serverid=$id"
	);
	$lists['logstart'] = $database->loadResult();

	# Determine the last log record for this server
	$database->setQuery( "SELECT MAX(date) FROM #__serverstat_stats"
	. "\nWHERE serverid=$id"
	);
	$lists['logend'] = $database->loadResult();

	# And the interval which we log
	$lists['loginterval'] = $serverstat_loginterval;

	# Show log interval (in minutes, is config value)
	# Use the method in the HTML class to render the server details.
	HTML_serverstat::showStatsServer( $option, $id, $row, $type, $stats, $lists, $server, $status, $graph);
} # End function showStatsServer

/**
* Cancels an edit operation for given server...
*/
function showConfig( $option ) {
	HTML_serverstat::showConfig( $option);
} # End function showConfig

/**
* Show an help screen show requested page, and go to requested position.
* The table of contents logic has partly been taken from the Joomla core
* (com_admin), and has been altered to fit the needs for the serverstat
* help function.
*
* @param  string  $option      Contains the option (task) currently active.
* @param  string  $helpsearch  A specific keyword on which to filter the
*                              resulting list.
*/
function showHelpScreen( $option ) {
	global $mosConfig_live_site, $mosConfig_absolute_path, $mosConfig_lang;

	# First we check if the Serverstat help component has been installed.
	# If so, we point to that directory, if not we use the default
	# directory where the default helpfile (quite empty) is located
	# within the Serverstat component.
	$version = ComponentVersion ("serverstathelp");
	if ($version) {
		$path = "/administrator/components/com_serverstathelp/";

	} else {
		$path = "/administrator/components/com_serverstat/help/" . $mosConfig_lang ."/";

		$file = $mosConfig_absolute_path . $path . 'credits.html';
		if (!file_exists($file)) {
  			$path = "/administrator/components/com_serverstat/help/english/";
		}# End if
	} # End if
	$helpurl = $mosConfig_live_site . $path;

	# Some other variables
	$files = mosReadDirectory( $mosConfig_absolute_path . $path, '\.xml$|\.html$' );
	$helpsearch = mosGetParam( $_REQUEST, 'helpsearch', '' );
	$page = mosGetParam( $_REQUEST, 'page', '_01_00_index.html' );

	# Read the directory and determine the table of contents
	$toc = array();
	foreach ($files as $file) {
		$xmlDoc =& new DOMIT_Lite_Document();
		$xmlDoc->resolveErrors( true );

		#echo "$file<br>";

		$buffer = file_get_contents( $mosConfig_absolute_path . $path . $file );
		if (preg_match( '#<title>(.*?)</title>#', $buffer, $m )) {
			$title = trim( $m[1] );
			if ($title) {
				// strip the extension
				#$file = preg_replace( '#\.xml$|\.html$#', '', $file );

				if ($helpsearch) {
					if (strpos( strip_tags( $buffer ), $helpsearch ) !== false) {
						$toc[$file] = $title;
					} # End if
				} else {
					$toc[$file] = $title;
				} # End if
			} # End if
		} # End if
	} # End foreach
	#asort( $toc );

	HTML_serverstat::showHelpScreen ( $toc, $helpsearch, $page, $helpurl );
} # End function showHelpScreen

/**
* Render all mappacks that are read from the mappack.xml file
* that resides on the master server specified in the main
* configuration.
*/
function showMapPack ( $option ) {
	global $mosConfig_absolute_path, $serverstat_mastermappack;

	require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/class.mappack.php");

	# try to read the master xml file that holds all
	# information about published map-packs
	$mappack = new MapPack( $serverstat_mastermappack );

	# We now have an array that holds all url referals to the
	# map-packs xml files. In the xml file, we find the specific
	# details for that map-pack, we need this info for rendering
	# the information. Just walk thru the array, and read all xml
	# files for given map-packs.
	HTML_serverstat::showMapPack ( $option, $mappack );
} # End function showMapPack

/**
* Handle the install/deinstallation of mappacks here.
*/
function installMapPacks ( $cid, $option) {
	global $mosConfig_absolute_path, $serverstat_mastermappack;

	require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/class.mappack.php");

	# try to read the master xml file that holds all
	# information about published map-packs
	$mappack = new MapPack( $serverstat_mastermappack );

	# We have an array that holds the mappacks that need to be installed
	# or updated. Just walk thru all mappacks we need to handle here.
	for ($i=0; $i < count($cid); $i++) {
		# Determine action here, possible actions are:
		# - install when not present yet
		# - update when newer mappack is available
		# - do nothing if user tries to install same version
		$servertype = $cid[$i];
		$array = $mappack->mappackdetail[$servertype];

		if (!$array['status']) {					# Not installed?
			# new mappack
			if ($mappack->installMapPack( $servertype)) {
				# successfull
				$result2add = str_replace("[description]", "<strong>" . $array['description'] . " </strong>", _SERVERSTAT_MAPPACK_INSTALLOK);
				$result[] = $result2add;
			} else {
				# error with installation
				$result2add = str_replace("[description]", "<strong>" . $array['description'] . " </strong>", _SERVERSTAT_MAPPACK_INSTALLNOK);
				$result2add = str_replace("[errmsg]", trim($mappack->getError()), $result2add);
				$result[] = $result2add;
			} # End if
		} else {
			# existing map-pack
			if ($mappack->mappackdetail[$servertype]['version'] <= $array['status']) {
				# do nothing
				$result2add = str_replace("[description]", "<strong>" . $array['description'] . " </strong>", _SERVERSTAT_MAPPACK_NOTHING);
				$result[] = $result2add;
			} else {
				# upgrade here, start with removal of mappack
				# existing map-pack
				if (!$mappack->removeMapPack( $servertype)) {
					# error with removal
					$result2add = str_replace("[description]", "<strong>" . $array['description'] . " </strong>", _SERVERSTAT_MAPPACK_DELETENOK);
					$result2add = str_replace("[errmsg]", trim($mappack->getError()), $result2add);
					$result[] = $result2add;
				} else {
					# install map-pack
					if ($mappack->installMapPack( $servertype)) {
						# successfull
						$result2add = str_replace("[description]", "<strong>" . $array['description'] . " </strong>", _SERVERSTAT_MAPPACK_UPGRADEOK);
						$result[] = $result2add;
					} else {
						# error with installation
						$result2add = str_replace("[description]", "<strong>" . $array['description'] . " </strong>", _SERVERSTAT_MAPPACK_UPGRADENOK);
						$result2add = str_replace("[errmsg]", trim($mappack->getError()), $result2add);
						$result[] = $result2add;
					} # End if
				} # End if
			} # End if
		} # End if
	} # End for

	# Show the result screen
	HTML_serverstat::showMapPackResult( $result );
} # End function installMapPacks

/**
* Handle the install/deinstallation of mappacks here.
*/
function removeMapPacks ( $cid, $option) {
	global $mosConfig_absolute_path, $serverstat_mastermappack;

	require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/class.mappack.php");

	# try to read the master xml file that holds all
	# information about published map-packs
	$mappack = new MapPack( $serverstat_mastermappack );

	# We have an array that holds the mappacks that need to be removed,
	# just walk thru all mappacks we need to handle here.
	for ($i=0; $i < count($cid); $i++) {
		$servertype = $cid[$i];
		$array = $mappack->mappackdetail[$servertype];

		if (!$array['status']) {					# Not installed?
			$result2add = str_replace("[description]", "<strong>" . $array['description'] . " </strong>", _SERVERSTAT_MAPPACK_NOTINSTALLED);
			$result[] = $result2add;
		} else {
			# existing map-pack
			if ($mappack->removeMapPack( $servertype)) {
				# successfull removal
				$result2add = str_replace("[description]", "<strong>" . $array['description'] . " </strong>", _SERVERSTAT_MAPPACK_DELETEOK);
				$result[] = $result2add;
			} else {
				# error with removal
				$result2add = str_replace("[description]", "<strong>" . $array['description'] . " </strong>", _SERVERSTAT_MAPPACK_DELETENOK);
				$result2add = str_replace("[errmsg]", trim($mappack->getError()), $result2add);
				$result[] = $result2add;
			} # End if
		} # End if
	} # End for

	# Show the result screen
	HTML_serverstat::showMapPackResult( $result );
} # End function handleMapPacks

/*
* Show the information about this Joomla module. Rendering takes place in
* the admin.serverstat.html.php script.
*/
function showAbout() {
	global $mosConfig_lang, $mosConfig_absolute_path, $mosConfig_live_site;

	# First we check if the Serverstat help component has been installed.
	# If so, we point to that directory, if not we use the default
	# directory where the default helpfile (quite empty) is located
	# within the Serverstat component.
	$version = ComponentVersion ("serverstathelp");
	if ($version) {
		$path = "/administrator/components/com_serverstathelp/html/";

	} else {
		$path = "/administrator/components/com_serverstat/help/" . $mosConfig_lang ."/";

		$file = $mosConfig_absolute_path . $path . 'credits.html';
		if (!file_exists($file)) {
  			$path = "/administrator/components/com_serverstat/help/english/";
		}# End if
	} # End if
	$helpurl = $mosConfig_live_site . $path;

	# Show about screen to user
	HTML_serverstat::showAbout( $helpurl );
} # End function showAbout

/*
* This function "walks thru" the map-pack locations of all Servertypes and
* determines if there are more files then the "unknown.jpg" file. If so,
* it will generate the mappack.xml file needed for map-pack logic.
*/
function generateMapPackXML () {
	global $mosConfig_absolute_path, $serverstat_servers;

	$result = Array();

	for ($i=0; $i < count($serverstat_servers); $i++) {
		$array = $serverstat_servers[$i];

		$path = $mosConfig_absolute_path . "/administrator/components/com_serverstat/images/servers/" . $array['id'];
		if (is_dir($path) && $array['category'] == 0) {
			# Read out the directory and determine the content of
			# the mappack.xml file for current directory.
			if ($handle = opendir( $path )) {
				$filecount = 0;
				$mappack = false;

				$output = "<?xml version=\"1.0\" ?>\n";
				$output .= "<mosinstall type=\"mappack\" version=\"1.0.4\">\n";
				$output .= "<name>" . $array['description'] . "Map Pack Add-on</name>\n";
				$output .= "<creationDate>" . Date("F Y ") . "</creationDate>\n";
				$output .= "<author>Wilco Jansen</author>\n";
				$output .= "<copyright>This mappack is released under the GNU/GPL License</copyright>\n";
				$output .= "<authorEmail>willebil@ned-clan.nl</authorEmail>\n";
				$output .= "<authorUrl>www.ned-clan.nl</authorUrl>\n";
				$output .= "<servertype>" . $array['id'] . "</servertype>\n";
				$output .= "<version>5.0</version>\n";
				$output .= "\t<files>\n";
				while (false !== ($file = readdir($handle))) {
					if ($file != "unknown.jpg" && $file != "." && $file != "..") {
						# replace spaces for underscores and rename file
						$filenwe = strtolower (str_replace (" ", "_", $file));
						rename ($path . "/" . $file, $path . "/" . $filenwe);

						# and create the filetag
						$output .= "\t\t<filename>$filenwe</filename>\n";
						$filecount++;
					} # End if
					
					if ($file == "mappack.xml") {
						$mappack = true;
					} # End if

				} # End while
				
				# Add mappack.xml file when not already present
				if (!$mappack) {
					$output .= "\t\t<filename>mappack.xml</filename>\n";
				} # End if

				$output .= "\t</files>\n";
				$output .= "</mosinstall>\n";

				closedir($handle);
			} else {
				$result[] = "INFO: servertype '" . $array['id'] . "' not processed (could not open directory for readout)";
			} # End if

			# We have processed the directory, great, now we write the
			# mappack.xml file (if filecount > 0).
			if ($filecount > 0) {
				if ($handle = fopen( $path . "/mappack.xml", "w")) {
					if (fwrite($handle, $output) === false) {
						$result[] = "INFO: servertype '" . $array['id'] . "' not processed (error writing file)";
					} # End if
    
					$result[] = "SUCCESS: mappack.xml for servertype '" . $array['id'] . "' has been written";
    					fclose($handle);
				} else {
					$result[] = "INFO: servertype '" . $array['id'] . "' not processed (could not open mappack.xml file)";
				} # End if
			} else {
				$result[] = "INFO: servertype '" . $array['id'] . "' not processed (no files to process)";
			} # End if
		} else {
			$result[] = "INFO: servertype '" . $array['id'] . "' not processed (no directory or other no game as servertype)";
		} # End if
	} # End for
	
	HTML_serverstat::generateMapPackXML ( $result );
} # End function generateMapPackXML
?>