<?php
/**
* @version $Id: admin.serverstat.php,v 0.6 2005/12/22 03:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* This class holds all logic for the mappack readout (master map-pack xml file),
* and installation, de-installation and upgrade logic. Class reuses the
* mosInstaller logic, introducing a new installation type (mappack).
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $mosConfig_absolute_path . '/includes/domit/xml_domit_lite_include.php' );
require_once( $mosConfig_absolute_path . '/administrator/components/com_installer/installer.class.php' );

DEFINE('_MAPPACK_VERSION', 2);

class MapPack extends mosInstaller {
	/**
	* Properties.
	*/
	var $url;								# Url of file we want to open
	var $file;								# Name of file (set when downloading a file)

	var $mappackgeneral = Array();						# Array that all general information of the mappack maxter xml file
	var $mappackdetail = Array();						# Holds an array per with details per servertype

	var $i_componentadmindir = "";

	/**
	* Constructor.
	*/
	function MapPack ( $url ) {
		$this->url = $url;
		$this->getMapPackVars();					# Just readout the xml file
	} # End function MapPack

	/**
	* Local methods.
	*/
	function componentAdminDir($p_dirname = null) {
		if(!is_null($p_dirname)) {
			$this->i_componentadmindir = mosPathName($p_dirname);
		}
		return $this->i_componentadmindir;
	} # End function componentAdminDir

	/**
	* Read out the map-pack status for a given servertype.
	* @param   servertype       the servertype we need to check
	* @return  boolean/integer  false if not installed, or version number of
	*                           mappack installed.
	*/
	function _getMapPackStatus ( $servertype) {
		global $mosConfig_absolute_path;				# Still raping OO here :-)

		# Now we use the Joomla build in xml parser to get the results...
		# First we instantiate the xml class, and read it.
		$file = $mosConfig_absolute_path . "/administrator/components/com_serverstat/images/servers/"  . $servertype . "/mappack.xml";
		$xmldoc =& new DOMIT_Lite_Document();
		$xmldoc->resolveErrors( true );
		if (@!$xmldoc->loadXML( $file, false, true )) {
			return false;
		} # End if

		# First we check the root element, this needs to contain
		# "serverstat", if not we have an invalid respone.
		if ($xmldoc->documentElement->nodeName != "mosinstall") {
			return false;
		} # End if

		# Check if the document has *any* child nodes, if not exit with
		# error...
		if (!$xmldoc->documentElement->hasChildNodes()) {
			return false;
		} # End if

		$childnodes =&$xmldoc->documentElement->childNodes;

		$node = $xmldoc->getElementsByPath( "version", 1 );
		$version = $node->getText();
		return $version;
	} # End function _getMapPackStatus

	/**
	* Download file with given url and write it into the /media directory
	* under its name.
	* @param   url              file to download
	* @return  boolean/integer  false (not downloaded), true (success)
	*/
	function _downloadFile ( $url ) {
		global $mosConfig_absolute_path;				# damn, this feels shitty

		$urlsplit = parse_url($url);					# split up the url
		$urlpath = pathinfo($urlsplit['path']);				# we only are interested in the path
		$this->file = $urlpath['basename'];				# Store for l8r use
		$urlfile = $mosConfig_absolute_path . "/media/" . $this->file;	# where to put the downloaded file?

		$chunksize = 1*(1024*1024); 					# How many bytes per chunk
		$handle = @fopen($url, 'rb');					# Open for binary read
		$handle1 = @fopen($urlfile, "w+");

		if (!$handle) {							# Not found, return asap
			$this->setError( 1, "Map pack cannot be found" );
			return false;
		} # End if

		while (!feof($handle)) {
			$result = fread($handle, $chunksize);			# Read with chunksize
			fwrite($handle1, $result);				# And directly write it...
		} # End while
		@fclose($handle); 
		@fclose($handle1);
		return true;
	} # End function _downloadFile

	/**
	* Public methods.
	*/

	/**
	* Just read the map-pack variables from the given url.
	* @param   url    the url where the xml file can be found
	* @return  array  that holds variables, or false when something is wrong
	*/
	function getMapPackVars () {
		global $mosConfig_live_site;					# And another rape here....

		# Now we use the Joomla build in xml parser to get the results...
		# First we instantiate the xml class, and read it.
		$file = $this->url . "mappack" . _MAPPACK_VERSION . ".xml";
		$xmldoc =& new DOMIT_Lite_Document();
		$xmldoc->resolveErrors( true );
		if (@!$xmldoc->loadXML( $file, false, true )) {
			$this->setError( 1, "Mappack master xml file could not be read ($file)" );
			return false;
		} # End if

		# First we check the root element, this needs to contain
		# "serverstat", if not we have an invalid respone.
		if ($xmldoc->documentElement->nodeName != "serverstat") {
			$this->setError( 1, "Invalid doctype in map-pack master xml file ($file), needs to be serverstat" );
			return false;
		} # End if

		# Check if the document has *any* child nodes, if not exit with
		# error...
		if (!$xmldoc->documentElement->hasChildNodes()) {
			$this->setError( 1, "Invalid structure of map-pack master xml file ($file), Doctype has no child nodes" );
			return false;
		} # End if
		$childnodes =&$xmldoc->documentElement->childNodes;

		# Pre-check look ok, now walk thru the nodelist. The master 
		# map-pack xml file is quite simple, so no recusion of
		# node walk-thru is used, pretty straight forward...
		$j=1;
		for ($i = 0; $i < $xmldoc->documentElement->childCount; $i++) {
			$node = $childnodes[$i];
			$nodename = $node->nodeName;

			if ($nodename == "mappack") {
				# First we store the servertype...
				$servertype = $node->getAttribute("id");

				# Okidoki, we now need to walk the subnodes for
				# this mappack value.
				$subnode = $xmldoc->getElementsByPath( $nodename, $j );
				if ($subnode->hasChildNodes()) {
					$values = $subnode->childNodes;
					foreach ($values as $value) {
						$this->mappackdetail[$servertype][$value->nodeName] = $value->getText();
					} # End foreach
					$this->mappackdetail[$servertype]['id'] = $j;
					$this->mappackdetail[$servertype]['status'] = $this->_getMapPackStatus($servertype);
				} # End if
				$j++;
			} else {
				$this->mappackgeneral[$node->nodeName] = $node->getText();
			} # End if
		} # End for

		# Just finish by closing the connection...
		return true;
	} # End function getMapPackVars

	/**
	* Install a mappack with given servertype.
	* @param   servertype  server for which we want to install the mappack
	* @return  boolean     true when succes, false when error (with errmsg)
	*/
	function installMapPack ( $servertype ) {
		global $mosConfig_absolute_path;				# damn, this feels shitty

		# First we try to determine the mappack file we want to use. We
		# will download this file when found, or else throw an error.
		if (!$this->_downloadFile ( $this->mappackdetail[$servertype]['url'] )) {
			$this->setError( 1, "$file2download could not be downloaded" );
			return false;
		} # End if

		# Use the upload function that comes with the mosInstaller to
		# unpack the just downloaded zipfile.
		$result = $this->upload ($this->file);
		if ($result == false) {
			$this->setError( 1, "File downloaded ("  .  $this->file . "), but could not be unpacked" );
			return false;
		} # Enf if

		# Install the files
		$this->componentAdminDir( mosPathName( $mosConfig_absolute_path . "/administrator/components/com_serverstat/images/servers/" . $servertype));
		$this->parseFiles( 'files','','', 1 );

		# Just do a global cleanup for this installation...also re-use
		# the code from the mosInstaller :p
		cleanupInstall( $this->file, $this->unpackDir() );

		return true;
	} # End function installMapPack

	/**
	* Remove a mappack with given servertype.
	* @param   servertype  server for which we want to install the mappack
	* @return  boolean     true when succes, false when error (with errmsg)
	*/
	function removeMapPack ( $servertype ) {
		global $mosConfig_absolute_path;				# No comment....

		# Now we use the Joomla build in xml parser to get the results...
		# First we instantiate the xml class, and read it.
		$file = $mosConfig_absolute_path . "/administrator/components/com_serverstat/images/servers/$servertype/mappack.xml";
		$xmldoc =& new DOMIT_Lite_Document();
		$xmldoc->resolveErrors( true );
		if (@!$xmldoc->loadXML( $file, false, true )) {
			$this->setError( 1, "Mappack xml file could not be read ($file)" );
			return false;
		} # End if

		# First we check the root element, this needs to contain
		# "mosinstall", if not we have an invalid respone.
		if ($xmldoc->documentElement->nodeName != "mosinstall") {
			$this->setError( 1, "Invalid doctype in map-pack xml file ($file), needs to be mosinstall" );
			return false;
		} # End if

		# Check if the document has *any* child nodes, if not exit with
		# error...
		if (!$xmldoc->documentElement->hasChildNodes()) {
			$this->setError( 1, "Invalid structure of map-pack xml file ($file), Doctype has no child nodes" );
			return false;
		} # End if
		$childnodes =&$xmldoc->documentElement->childNodes;

		$files_element =& $xmldoc->getElementsByPath( "files", 1 );
		#if (is_null( $files_element )) {
		#	return 0;
		#}

		if (!$files_element->hasChildNodes()) {
			$this->setError( 1, "No files defined in map-pack xml file ($file)" );
			return false;
		} # End if

		$files = $files_element->childNodes;
		if (count( $files ) == 0) {
			$this->setError( 1, "Files were defined in map-pack xml file ($file), but no files have been found" );
			return false;
		} # End if

		foreach ($files as $file) {
			@unlink ( $mosConfig_absolute_path . "/administrator/components/com_serverstat/images/servers/$servertype/" . $file->getText() );
		} # End foreach

		return true;
	} # End function removeMapPack
} # End class MapPack 
?>