<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.DOOM3.class.php,v 0.6 2005/12/17 21:15:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Class that holds the specific game code for an DOOM III (DOOM3).
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class DOOM3 extends ServerMain {
	/**
	* Constructor.
	*/
	function DOOM3 ($serverip, $port, $debug, $retrycount, $timeout, $servertype) {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		$this->servertype = $servertype;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if

		# Here we go!
		$this->trace("DOOM3::_constructor", "serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;                                    # Initialize properties
		$this->port = $port;
		$this->result = "";

		$this->socket = $this->getSocket($this->serverip, $this->port);
		if ($this->socket) {
			$i=0;
			do {
				$this->getServerStatus($this->socket);		# Interact with gameserver
				$i++;
			} while (empty($this->result) && $i < $this->retry);	# Retry, sometimes server does not respond that fast :D

			$this->trace("DOOM3::_constructor", $this->result, 1, 1);
			$this->getServerInfo();					# Determine server information...
			$this->closeSocket($this->socket);			# Also close the connection
		} else {
			$this->trace("DOOM3::_constructor", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
		} # End if
		$this->serverdata['num_players'] = $this->numofusers;
		$this->serverdata['ip'] = $this->serverip;
		$this->serverdata['port'] = $this->port;
	} # End constructor DOOM3

	/**
	* Return the server information. The server information is stored in
	* an array, example of server variable: $this->serverdata['sv_minRate']
	*/
	function getServerInfo () {
		$this->trace ("DOOM3::_getServerInfo ()", "", 0, 0);

		if (strlen($this->result) == 0) {
			return false;
		} # End if

		$serversplit = explode("\x00", $this->result);

		for ($i=0; $i <= sizeof($serversplit) - 2; $i+=2) {
			$j=$i+1;
			if (empty($serversplit[$i]) && empty($serversplit[$j])) {
				break;	# after this we have the users online...
			} else {
				$tagname = strtolower($serversplit[$i]);
				$this->serverdata["$tagname"] = $serversplit[$j];
				$playersdivisor = $serversplit[$i] . "\x00" . $serversplit[$j] . "\x00\x00\x00";
			} # End if
		} # End for
                          
		$playersstr = explode($playersdivisor, $this->result);
		$playersstr = $playersstr[1];

		# build an array of all the players
		$playerlist = array();

		$this->numofusers = 0;
		$counter = 0;
		while ($counter < strlen($playersstr)) {
			$key = ord($playersstr[$counter++]); # single byte player number
			if($key == 32) # last packet appears to be playernum 32
				break;

			# Determine the ping
			$playerping1 = ord($playersstr[$counter++]);
			$playerping2 = ord($playersstr[$counter++]);
			$playerping = $playerping1 + (256 * $playerping2);

			# And the player rate
			$playerrate1 = ord($playersstr[$counter++]);
			$playerrate2 = ord($playersstr[$counter++]);
			$playerrate = $playerrate1 + (256 * $playerrate2);

			$str1length = strpos($playersstr, "\x00", $counter) - $counter; # find null-terminator
			$str1 = substr($playersstr, $counter, $str1length);
			$counter += $str1length + 1; # shift off name + null-terminator

			$str2length = strpos($playersstr, "\x00", $counter) - $counter; # find null-terminator
			$str2 = substr($playersstr, $counter, $str2length);
			$counter += $str2length + 1; # shift off name + null-terminator

			# The name of the user
			$namelength = strpos($playersstr, "\x00", $counter) - $counter; # find null-terminator
			$playername = substr($playersstr, $counter, $namelength);
			$counter += $namelength + 1; # shift off name + null-terminator

			# In Quake 4 there is something strange, playernames can be
			# devided with an ASCII 0, i really have no clue what the meaning
			# of this is, but here we need to do some name tricking.
			# For this we check the sequence number, if not the next player
			# we need to add some extra to the current playername.
			$nextplayer = $this->numofusers + 1;
			if (ord(substr($playersstr, $counter, 1)) != $nextplayer) {
				$namelength = strpos($playersstr, "\x00", $counter) - $counter; # find null-terminator
				$playername .= substr($playersstr, $counter, $namelength);
				$counter += $namelength + 1; # shift off name + null-terminator
			} # End if

			$this->userinfo[$key]['slot'] = $key;
			$this->userinfo[$key]['ping'] = $playerping;
			$this->userinfo[$key]['name'] = $playername;
			$this->userinfo[$key]['rate'] = $playerrate;
			$this->userinfo[$key]['score'] = 0;
			$this->numofusers++;
		} # End while
} # End function getServerInfo

	/**
	* Initiates a status call to the server.
	* Returns true if successfull, false if an error occured
	*/
	function getServerStatus($socket) {
		$this->trace ("DOOM3::_getServerStatus ()", "", 0, 0);

		socket_set_blocking ($socket, true);				# Set blocking mode...wait until we have an reaction
		socket_set_timeout ($socket, 0, $this->timeout);		# Set the timeout (in microseconds here!)
		fwrite ($socket, $this->getCommand());				# Interact with gameserver

		$this->trace ("DOOM3::getServerStatus ()", "command issued : " . $this->getCommand(), 1, 1);
		$this->result = @fread($socket, 4096);				# Read stream
		$this->trace ("DOOM3::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
		$this->trace ("DOOM3::getServerStatus ()", $this->result, 2, 1);

		$socketstatus = socket_get_status($socket);                    # Determine current status of stream
		if ($socketstatus["timed_out"] || strlen ($this->result) <= 20) {
			$this->err = 100;					# Just an code...can be anything
			$this->errmsg = "Connection timed out";			# This is what's wrong ;-)
			$this->result = "";
			return false;						# We have failed!
		} else {
			if (strlen($this->result) > 0) {
				$this->result = substr ($this->result, 23);	# Strip header response (something like "statusResponse")
			} # End if
		} # End if
		return true;
	} # End function getServerStatus

	/**
	* Return the maximum number of clients that may connect to this server.
	*/
	function getMaxClients () {
		return number_format($this->serverdata['si_maxplayers']);
	} # End function getMaxClients

      /**
        * Command line to interact with server, this is different from
        * the DOOM3 kinda servers.
        */
        function getCommand () {
		$this->trace ("DOOM3::_getCommand ()", "", 9, 0);
                return "\xff\xffgetInfo";
        } # End if

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		$this->trace ("DOOM3::_IsServerRunning ()", "", 0, 0);

		if (!empty($this->result)) {
			return true;
		} else {
			return false;
		} # End if
	} # End function IsServerRunning 
} # End class DOOM3
?>