<?php
/**
* Serverstatus 0.6 for Joomla CMS
* @version $Id: serverstat.TS.class.php,v 0.6 2005/12/17 21:15:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Module that contains several functions that make it possible to retrieve
* some information from a teamspeak server, and control it.
* Tested with TS server 2.0.19.40 Linux! Please send bug reports to mail addr.
* above, but preferrable send the solution with it ;-)
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

Class Teamspeak extends ServerMain {
	var $serverdata = '';							# Array that contains the server information
	var $userinfo = '';							# Array that contains the user information
	var $serverip = "localhost";						# Ip addr for server to query
	var $port = 51234;							# Port to query (=admin port)
	var $cport = 8767;							# Clientport to query (=client port)

	var $timeout = 100000;							# Timeout in microsecond, keep low or else the performance
										# can drop dramatically when trying to access offline servers!
	var $retry;

	var $numofusers = 0;							# Number of users on server
	var $numofchannels = 0;
	var $version = "";							# Version tag for teamspeak server

	var $clientchannelactive = false;

	var $err = 0;								# Error code, set when an error has occured
	var $errmsg = "";							# Error message...

	/**
	* Constructor.
	*/
	function Teamspeak ($serverip, $port, $cport, $debug, $retrycount, $timeout) {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if

		$this->trace("TS::_constructor", "serverip: $serverip  port: $port  cport: $cport  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;					# Initialize properties
		$this->port = $port;
		$this->cport = $cport;
		$this->getTeamSpeakserverdata();				# Initialize the server and online users variables...
		if (!empty($this->result)) {
			$this->trace("TS::_constructor", $this->result, 1, 1);
		} # End if
	} # End function Teamspeak

	/**
	* Opens a connection to the teamspeak server.
	*/
	function getSocket($host, $port) {
		$socket = @fsockopen($host, $port, $this->err, $this->errmsg, $this->timeout / 100000);
		if(!$socket or fread($socket, 4) != "[TS]") {	# TS not running!
			return false;
		}// end if
        	return $socket;
	} # End function getSocket

	/**
	* Sends a query to the teamspeak server.
	*/
	function sendQuery($socket, $query) {
		fputs($socket, $query. "\n");
	} # End function sendQuery

	/**
	* Returns the result of the last query.
	*/
	function getResults($socket) {
		return fgets($socket, 4096);
	} # End function getResults(...)

	/**
	* Closes the connection to the teamspeak server.
	*/
	function closeSocket($socket) {
		fputs($socket, "quit");
		fclose($socket);
	} # end function closeSocket(...)

	/**
	* Determine user performance numbers, minimum ping, maximum ping and
	* of course the avarage.
	*/
	function determinePingvalues () {
		$this->maxping = 0;
		$this->avgping = 0;

		if ($this->getUsersOnline() == 0) {
			$this->minping = 0;
			return;
		} # End if

		$this->minping = 999;

		for ($i=0; $i < $this->getUsersOnline(); $i++) {
			if ($this->userinfo[$i]['ping'] < $this->minping) {
				$this->minping = $this->userinfo[$i]['ping'];
			} # end if

			if ($this->userinfo[$i]['ping'] > $this->maxping) {
				$this->maxping = $this->userinfo[$i]['ping'];
			} # end if

			$this->avgping += $this->userinfo[$i]['ping'];
		} # End for
		
		$this->avgping = @intval($this->avgping / $this->getUsersOnline());
	} # End functon determinePingvalues 

	/**
	* Function to remove funny characters from usernames.
	*/
	function removefunchars($data) {
		$result="";
		$skipnextchar=false;
		for ($i=0;$i<strlen($data);$i++) {
			if (!$skipnextchar) {
				$currentchar=ord(substr($data,$i,1));
				if (($currentchar==27) || ($currentchar==94)) {
					$skipnextchar=true;
				} else {
                                        if (($currentchar==32)) $result=$result . " "; // allow spaces
					if (($currentchar>=35) && ($currentchar<=127)) $result=$result.chr($currentchar);
					if (($currentchar>=160) && ($currentchar<=255)) $result=$result.chr($currentchar-128);
				} # End if
			} else {
				$skipnextchar=false;
			} # End if
		} # End for
		return $result;
	} # End function removefunchars

	/**
	* Function that retrieves the basic server information.
	*/
	function getTeamSpeakserverdata() {
		$this->trace("TS::_getTeamSpeakserverdata()", "", 0, 0);
		$this->serverdata['host'] = $this->serverip;			# For general use we store this one...
		$this->serverdata['adminport'] = $this->port;
		$this->serverdata['clientport'] = $this->cport;
		$this->clientchannelactive = true;

		# Step 1: establish connection to teamspeak server
		$socket = $this->getSocket($this->serverip, $this->port);
		if($socket == false) {
			$this->clientchannelactive = false;
                        $this->err = 100;
       	                $this->errmsg = "Connection timed out";
			$this->trace("TS::getTeamSpeakserverdata()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
			return false;
		} # End if
		$this->getResults($socket);

		# Step 2: select the server on port given port
		$this->trace("TS::getTeamSpeakserverdata()", "selection of server thru port: " . $this->cport, 1, 0);
		$this->sendQuery($socket, "sel " . $this->cport);
		$result = chop($this->getResults($socket));
		$this->trace("TS::getTeamSpeakserverdata()", $result, 1, 1);
		if($result != "OK") {
			$this->clientchannelactive = false;
                        $this->err = 110;
       	                $this->errmsg = "Invalid response from server after establishing an connection";
			$this->trace("TS::getTeamSpeakserverdata()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
			return false;
		} # end if

		# Step 3: retrieve server information
		$this->trace("TS::getTeamSpeakserverdata()", "server list: " . $this->cport, 1, 0);
		$result = "";
		$this->sendQuery($socket,"si");
		do {
			$line = chop($this->getResults($socket));
			$result .= $line;
			if ($line != "OK") {
				list($key, $value) = split ("=", $line);
				$this->serverdata[$key] = $value;
				#$this->trace("TS::getTeamSpeakserverdata()", "$key=$value", 1, 0);
			} # End if
		} while($line != "OK");
		$this->trace("TS::getTeamSpeakserverdata()", $result, 1, 1);

		# Step 4: retrieve user information
		$result = "";
		$this->sendQuery($socket,"pl");
		$this->numofusers=0;
                // proper parsing of TS server replies which contain spaces
		while (($line = chop($this->getResults($socket))) != "OK") {
                    list($number, $channel, $d, $d, $d, $d, $d, $ping, $time, $d, $privilege, $userstatus, $attribute, $ip, $name) = split("\t", $line);
                    if (is_numeric($number)) {
                    	$this->userinfo[$this->numofusers]['channel'] = $channel;
                    	$this->userinfo[$this->numofusers]['ping'] = $ping;
                    	$this->userinfo[$this->numofusers]['time'] = $time;
                    	$this->userinfo[$this->numofusers]['ip'] = $ip;
                    	$this->userinfo[$this->numofusers]['name'] = $this->removefunchars($name);

			# Some extra information for this user (user status and attribute)
                    	$this->userinfo[$this->numofusers]['userstatus'] = $this->getPlayerStatus ($userstatus);
                    	$this->userinfo[$this->numofusers]['namefull'] = $this->userinfo[$this->numofusers]['name'] . " (" . $this->getPlayerFlags ( $userstatus, $privilege, $attribute ) . ")";

			# Just increase number of users
                    	$this->numofusers++;
                    } # End if		    
		} # End while

		# Step 4: retrieve channel information
		$result = "";
		$this->sendQuery($socket,"cl");
		$this->numofchannels=0;
                // proper parsing of TS server replies which contain spaces
		while (($line = chop($this->getResults($socket))) != "OK") {
                    list($channel, $codec, $parent, $order, $maxusers, $name, $flags, $password, $topic) = split("\t", $line);
                    if (is_numeric($channel)) {
                    	$this->channelinfo[$this->numofchannels]['channel'] = $channel;
                    	$this->channelinfo[$this->numofchannels]['codec'] = $codec;
                    	$this->channelinfo[$this->numofchannels]['parent'] = $parent;
                    	$this->channelinfo[$this->numofchannels]['order'] = $order;
                    	$this->channelinfo[$this->numofchannels]['maxusers'] = $maxusers;
                    	$this->channelinfo[$this->numofchannels]['name'] = trim($this->removefunchars($name));
                    	$this->channelinfo[$this->numofchannels]['flags'] = $flags;
                    	$this->channelinfo[$this->numofchannels]['password'] = $password;
                    	$this->channelinfo[$this->numofchannels]['topic'] = $topic;

			# Some extra information for this channel, only needed
			# for root channels (top level).
			$this->channelinfo[$this->numofchannels]['namefull'] = $this->channelinfo[$this->numofchannels]['name'];
			if ( $parent < 1) {
				$this->channelinfo[$this->numofchannels]['namefull'] .= " (" . $this->getChannelFlags ($flags) . ")";
			} # End if

			# Increase the number of channels
                    	$this->numofchannels++;
                    } # End if
		} # End while

		# Step 6: Retrieve server version
		$this->sendQuery($socket,"ver");
		$this->version  = chop($this->getResults($socket));
		$this->serverdata["server_version"] = $this->version;

		# Final step: close connection and return succesfull		
		$this->closeSocket($socket);
		return true;
	} # End function TeamSpeakserverdata

	/**
	* Function to validate if the teamspeak server is running.
	*/
	function IsServerRunning() {
		$socket = $this->getSocket($this->serverip, $this->port);
		if($socket == false) return false;
		$this->closeSocket($socket);
		return true;
	} # End function IsServerRunning

	#-----------------------------------------------------------------------
	# Function that returns true/false if an client server is running.
	# The difference between the IsTeamspeakServerRunning() method is that
	# we here atually can see if an channel is active or not.
	#-----------------------------------------------------------------------
	function IsClientServerRunning() {
		return $this->clientchannelactive;
	} # End if

	/**
	* Return the maximum number of clients that may connect to this server.
	*/
	function getMaxClients () {
		return number_format($this->serverdata["server_maxusers"]);
	} # End function getMaxClients

	/**
	* Return the hostname for current running teamspeakserver.
	*/
	function getHostname () {
		return $this->serverdata["server_name"];
	} # End function getHostname

	/**
	* Return version information if running version.
	*/
	function getServerVersion() {
		return $this->serverdata["server_version"];
	} # End function getserverdata

	/*
	* Function that returns the current status for a player.
	* 0 = normal
	* 1 = channel commander
	* 2 = away
	* 3 = microphone muted
	* 4 = speakers muted
	*/
	function getPlayerStatus ( $userstatus ) {
		if (($userstatus & 32) == 32) { $status = 4; }
		else if (($userstatus & 16) == 16) { $status = 3; }
		else if (($userstatus & 8) == 8) { $status = 2; }
		else if (($userstatus & 1) == 1) { $status = 1; }
		else { $status = 0; }
		return $status;
	} # End function getPlayerStatus

	/*
	* Determine the player status:
	* U = Unregistered
	* R = Registered
	* SA = Server Admin
	* CA = Channel Admin
	* AO = Auto-Operator
	* AV = Auto-Voice
	* O = Operator
	* V = Voice
	*/
	function getPlayerFlags ( $userstatus, $privilege, $attribute ) {
		$playerstatus = "";

		if (($userstatus & 4) == 4) { $playerstatus = "R"; } else { $playerstatus = 'U'; }
		if (($userstatus & 1) == 1) { $playerstatus .= " SA"; }
		if (($privilege & 1) == 1) { $playerstatus .= " CA"; }
		if (($privilege & 8) == 8) { $playerstatus .= " AO"; }
		if (($privilege & 16) == 16) { $playerstatus .= " AV"; }
		if (($privilege & 2) == 2) { $playerstatus .= " O"; }
		if (($privilege & 4) == 4) { $playerstatus .= " V"; }
		if (($attribute & 64) == 64) { $playerstatus .= " Rec"; }

		return $playerstatus;
	} # End function getPlayerFlags

	/*
	* Determine the channel status:
	* U = Unregisterd
	* R = Registered
	* M = Moderated
	* P = Passworded
	* S = Sub-channels
	* D = Default
	*/
	function getChannelFlags ( $flags ) {
		$channelstatus = "";
		if (($flags & 1) == 1) {$channelstatus ='U';} else {$channelstatus ='R';}
		if (($flags & 2) == 2) {$channelstatus .='M';}
		if (($flags & 4) == 4) {$channelstatus .='P';}
		if (($flags & 8) == 8) {$channelstatus .='S';}
		if (($flags & 16) == 16) {$channelstatus .='D';}

		return $channelstatus;
	} # End function getChannelFlags
} # End class classTeamspeak
?>