<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.UT.class.php,v 0.6 2005/12/17 17:45:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Class that holds the specific game code for Unreal Tournament Servers. Parts
* of the code have been taken from the KjStat v0.87 (beta, public) package
* that was developed by Sam 'KingJackaL' Evans.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class UT extends ServerMain {
	/**
	* Properties.
	*/
	var $serverip = "localhost";						# Ip addr for server to query
	var $port = "29253";							# Port to query
	var $timeout = 160000;							# Timeout in microsecond
	var $retry = 3;

	var $socket = "";							# Socket var...
	var $err = 0;								# Error code, set when an error has occured
	var $errmsg = "";							# Error message...

	var $result = "";							# The result of a status request to the gameserver
	var $serverdata = "";							# Contains server information
	var $userinfo = "";							# Contains player information
	var $numofusers = 0;							# Number of players on server

	var $game;

	/**
	* Constructor.
	*/
	function UT ($serverip, $port, $debug, $retrycount, $timeout, $game) {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if
		$this->game = $game;

		# Here we go!
		$this->trace("UT::_constructor", "game:$game  serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;                                    # Initialize properties
		$this->port = $port;
		$this->result = "";						# Contains server respons data

		# Remember the status port for UT alike servers is one higher
		# then the game port provided!!!
		$this->socket = $this->getSocket($this->serverip, $this->port + 1);
		if ($this->socket) {
			$i=0;
			do {
				$this->trace("UT::_constructor", "Retry number : " . $i, 0, 0);
				if ($this->getServerStatus($this->socket)) {	# Interact with gameserver
					$this->serveronline = true;
				} else {
					$this->serveronline = false;
				} # End if;		
				$i++;
			} while (empty($this->result) && $i < $this->retry);	# Retry, sometimes server does not respond that fast :D

			#$this->trace("UT::_constructor", $this->result, 1, 1);
			$this->closeSocket($this->socket);
		} else {
			$this->trace("UT::_constructor", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
		} # End if
	} # End constructor UT

	/**
	* Retrieve the basic information of this server.
	* log information.
	* @param  string   $socket  Socket descriptor
	* @return boolean  true: retrieval succesfull, false: failure
	*/
	function getServerStatus($socket) {
		$this->trace("UT::_getServerStatus()", "", 0, 0);

		# Set timeout value here.
		socket_set_blocking ($socket, true);				# Set blocking mode...wait until we have an reaction
		socket_set_timeout ($socket, $this->timeout / 100000);		# Set the timeout (in microseconds here!)

		# Query the server, walking through a set of datagrams we expect
		# here: 00 short, 01 game, 02 players, 03 game + players
		$queries = array(
			"\x00",
			"\x01",
			"\x02",
			"\x03"
			);

		foreach($queries as $typestring) {
			# In the type response we retrieve the current number
			# of players, if 0 we do not need to retrieve the user
			# response here.
			if (isset($this->serverdata['sv_clients'])) {
				if ($this->serverdata['sv_clients'] == 0 && $typestring == "\x02") {
					break;
				} # End if
			} # End if

			$command = $this->getCommand() . $typestring;
			$this->trace("UT::getServerStatus()", "Retrieving details", 0, 0);
			$this->trace("UT::getServerStatus()", $command, 0, 1);
			fwrite($socket, $command);					# Command to retrieve basic info
			$this->result = @fread($socket, 4096);				# Read stream

			if (strlen($this->result) == 0) {
				break;
			} # End if

			$socketstatus = socket_get_status($socket);			# Determine current status of stream
			if ($socketstatus["timed_out"] ) {
				$this->err = 100;					# Just an code...can be anything
				$this->errmsg = "Connection timed out";			# This is what's wrong ;-)
				$this->result = "";
				$this->trace("UT::getServerStatus()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
				return false;						# We have failed!
			} # End if

			$this->trace ("UT::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
			$this->trace ("UT::getServerStatus ()", $this->result, 2, 1);

			$i = 4; // skip reply start
			switch (ord($this->result[$i])) {
			case 0:
				$status = $this->unreal2shortshredder(substr($this->result, $i + 1));
				$this->trace ("UT::getServerStatus ()", "Basic server info parsed", 2, 0);
				break;
			case 1:
				$status = $this->unreal2gameshredder(substr($this->result, $i + 1));
				$this->trace ("UT::getServerStatus ()", "Server game info parsed", 2, 0);
				break;
			case 2:
				$status = $this->unreal2playershredder(substr($this->result, $i + 1));
				$this->trace ("UT::getServerStatus ()", "Server player info parsed", 2, 0);
				break;
			default:
				$status = $this->unreal2gameshredder(substr($this->result, $i + 1));
				$status = $this->unreal2playershredder(substr($this->result, $i + 1));
				break;
			} # End switch
		} # End foreach
		return true;
	} # End function getServerStatus

	/**
	* Returns the sections of a status array that can be obtained from a
	* UT2 engine Server Status query.
	*/
	function unreal2shortshredder($result) {
		$i = 4; 								# skip unused 4-char server ID
		$i++;									# skip unused server IP
		$i += 4;								# skip game port
		$i += 4;								# skip unused query port

		$namelength = ord($result[$i++]);
		$this->serverdata['sv_hostname'] = substr($result, $i, $namelength - 1);
		$i += $namelength;

		$maplength = ord($result[$i++]);
		$this->serverdata['mapname'] = substr($result, $i, $maplength - 1);
		$i += $maplength;

		$gametypelength = ord($result[$i++]);
		$this->serverdata['g_gametype'] = substr($result, $i, $gametypelength - 1);
		$i += $gametypelength;

		$this->serverdata['sv_clients'] = ord($result[$i]);
		$i += 4;

		$this->serverdata['sv_maxclients'] = ord($result[$i]);
		$i += 4;

		$this->serverdata['sv_ping'] = ord($result[$i]);
		$i += 4;

		$this->serverdata['sv_flags'] = ord($result[$i]);
		$i += 4;

		if ($this->game == 'UT2K4') {
			$skilllength = ord($result[$i++]);
			$this->serverdata['skill_level'] = substr($result, $i, $skilllength - 1);
		} # End if
	} # End function unreal2shortshredder

	/*
	* Returns the sections of a status array that can be obtained from a
	* UT2 engine Game Status query.
	*/
	function unreal2gameshredder($result) {
		$i = 0;
		while ($i < strlen($result)) {
			$stringlength = ord($result[$i++]);
			$stringname = substr($result, $i, $stringlength - 1);
			$i += $stringlength;

			$valuelength = ord($result[$i++]);
			$valuename = substr($result, $i, $valuelength - 1);
			$i += $valuelength;

			if ($valuelength > 0) {
				$this->serverdata[$stringname] = $valuename;
			} else {
				$this->serverdata[$stringname] = "";
			}# End if
		} # End while
	} # End function unreal2gameshredder

	/*
	* Returns the sections of a status array that can be obtained from a
	* UT2 engine Players Status query.
	*/
	function unreal2playershredder($result) {
		$i = 0;
		$pid = 0;
		while ($i < strlen($result)) {
			if($this->game == 'UT2K4' && substr($result, $i, 4) == "\x00\x00\x00\x00") {
				break;
			} # End if

			if($this->game == 'XMP'){
				$playernum = ord(substr($result, $i, 4));
				$i += 4;
			} # End if

			$playerID = ord(substr($result, $i, 4));
			$i += 4;

			if ($this->game == 'XMP') {
				$playerID = $pid++; 				# xmp doesn't tell you player ID's...
			} # End if

			$playerlength = ord($result[$i++]);
			if ($playerlength > 128) { 				# colorized U2 string
				$playerlength -= 128;
				$playername = "";
				for($j = 0; $j < $playerlength - 1; $j++) {
					$playername .= $result[$i + 2*($j)];
				} # End for
				$i += 2 * $playerlength;
			} else {
				$playername = substr($result, $i, $playerlength - 1);
				$i += $playerlength;
			} # End if

			$ping = ord(substr($result, $i, 4));
			$i += 4;

			$score = ord(substr($result, $i, 4));
			$i += 4;

			$statsID = ord(substr($result, $i, 4));
			$i += 4;
			
			$this->userinfo[$this->numofusers]['slot'] = $playerID;
			$this->userinfo[$this->numofusers]['name'] = $playername;
			$this->userinfo[$this->numofusers]['ping'] = $ping;
			$this->userinfo[$this->numofusers]['score'] = $score;
			$this->userinfo[$this->numofusers]['stats'] = $statsID;

			# We have determined the player information, now check out
			# the players details, and site he/she is playing on.
			if ($this->game == 'UT2K4') {
				$teamnum = (int) $statsID[3];
				$teamnum << 6; 					# shift left 30 spots
				if ($statsID == 1)
					$this->userinfo[$this->numofusers]['side'] = "red";
				else if ($statsID == 2)
					$this->userinfo[$this->numofusers]['side'] = "blue";
			} elseif ($this->game == 'XMP') {
				$numprops = ord($result[$i++]);
				for($j = 0; $j < $numprops; $j++) {
					$stringlength = ord($result[$i++]);
					$stringname = substr($result, $i, $stringlength - 1);
					$i += $stringlength;
					$valuelength = ord($result[$i++]);

					if ($stringname == "team") { // team info is weird - hack to get xmp working
						if($result[$i - 1] == "\x87") {
							$valuename = "red";
							$i += 14;
						} else {
							$valuename = "blue";
							$i += 16;
						} # End if
					} else if ($valuelength > 128) { //colorized U2 string
						$valuelength -= 128;
						$valuename = "";
						for($j = 0; $j < $valuelength - 1; $j++) {
							$valuename .= $result[$i + 2*($j)];
						} # End for
						$i += 2 * $valuelength;
					} else {
						$valuename = substr($result, $i, $valuelength - 1);
						$i += $valuelength;
					} # End if

					$var = "props" . $j;
					$this->userinfo[$this->numofusers][$stringname] = $valuename;
				} # End for
			} # end if
			$this->numofusers++;
		} # End while
	} # End function unreal2playershredder

	/**
	* Command line to interact with server. Here we define the command for
	* an Unreal Tournament server. For other UT versions, this command
	* differs (see individual classes).
	*/
	function getCommand () {
		$this->trace ("Q3::_getCommand ()", "", 9, 0);
		switch ($this->game) {
			case 'XMP':
				$return = "\x7e\x00\x00\x00";
				break;
			case 'UT2K3':
				$return = "\x79\x00\x00\x00";
				break;
			case 'UT2K4':
				$return = "\x7f\x00\x00\x00";
				break;
		} # End switch

		return $return;
	} # End if

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		$this->trace ("UT::_IsServerRunning ()", "", 0, 0);
		if (!empty($this->result)) {
			return true;
		} else {
			return false;
		} # End if
	} # End function IsServerRunning 

	/**
	* Return the maximum number of clients that may connect to this server.
	*/
	function getMaxClients () {
		return number_format($this->serverdata['sv_maxclients']);
	} # End function getMaxClients

	/**
	* Just an routine used for debugging and tracing. Builds an array of
	* log information.
	* @param  string   $method  The method that is logging
	* @param  string   $string  The string for logging/tracing
	* @param  integer  $level   The debug level, determines which messages get logged
	* @param  integer  $type    0 = informational
	*                           1 = data
	* @return nothing
	*/
	function trace($method, $string, $level=0, $type=0) {
		if(!$this->debug) return;

		# Add entries to the variable
		$entry = Array();
		$entry['method'] = $method;
		$entry['string'] = $string;
		$entry['level'] = $level;
		$entry['type'] = $type;
		$entry['time'] = $this->getmicrotime();
		$this->debug_log[] = $entry;
	} # End function trace
} # End class ET
?>