<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.remoteserver.class.php,v 0.6 2005/12/17 11:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Serverclass that is used to handle the remote status retrievement option.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/
defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

require_once( $mosConfig_absolute_path . '/includes/domit/xml_domit_lite_include.php' );

class RemoteServer extends ServerMain {
	/**
	* Properties.
	*/
	var $serverip = "localhost";						# Ip addr for server to query
	var $port = 0;								# Port to query
	var $timeout = 160000;							# Timeout in microsecond
	var $retry = 3;

	var $socket = "";							# Socket var...
	var $err = 0;								# Error code, set when an error has occured
	var $errmsg = "";							# Error message...

	var $result = "";							# The result of a status request to the gameserver
	var $serverdata = Array();						# Contains server information
	var $userinfo = Array();						# Contains player information
	var $channelinfo = Array();

	var $numofusers = 0;							# Number of players on server
	var $numofchannels = 0;

	var $online = false;
	/**
	* Constructor. Within this constructor we handle all the logic.
	* First we are going to read 
	*/
	function RemoteServer ($database, $id ) {
		$this->trace("remoteserver::_constructor", "_start", 0, 0);

		# Read corresponding server record.
		$database->setQuery( "SELECT * FROM #__serverstat_servers"
		. "\nWHERE id=$id"
		);
		$rows = $database->loadObjectList();

		# If server vars is empty, the server is considered offline,
		# else we unpack all variables into the properties. Remember
		# we only have the variables needed for module response, this
		# logic will not work for detailed information purposed.
		if (count ($rows) == 1) {
			$row = $rows[0];

			$this->trace("remoteserver::_constructor", "serverip: " . $row->ip . "port: "  . $row->port, 0, 0);
			$this->getRemoteStatus ($row);
		} else {
			$this->trace("remoteserver::_constructor", "No servers found, record count = " . count ($rows), 0, 0);
		} # End if

		$this->serverip = $row->ip;
		$this->port = $row->port;
		$this->trace("remoteserver::_constructor", "_end", 0, 0);
	} # End function RemoteServer

	/**
	* Try to read the remote xml file.
	* @param   $row   The row object that holds the record we want to retrieve
	* @return         All properties set to the proper value
	*/
	function getRemoteStatus ($row) {
		global $mosConfig_live_site, $serverstat_serviceprovider, $mosConfig_absolute_path;

		$this->trace("remoteserver::_getRemoteStatus", "_start", 0, 0);
		$file = $serverstat_serviceprovider . "/index.php?option=com_serverstat&task=remote&ip=" . $row->ip . "&port=" . $row->port . "&port1=" . $row->port1 . "&servertype=" . $row->servertype . "&username=" . $row->username . "&password=" . $row->password;

		# don't uncomment, security issue can exploit the icecast server credentials!
		#$this->trace("remoteserver::_getRemoteStatus", "Status file --> " . $file, 0, 0);

		# Now we use the Joomla build in xml parser to get the results...
		# First we instantiate the xml class, and read it.
		$xmldoc =& new DOMIT_Lite_Document();
		$xmldoc->resolveErrors( true );
		if (@!$xmldoc->loadXML( $file, false, true )) {
			$this->trace("remoteserver::_getRemoteStatus", "Remote xml file could not be read", 0, 0);
			return false;
		} # End if

		# First we check the root element, this needs to contain
		# "serverstat", if not we have an invalid respone.
		if ($xmldoc->documentElement->nodeName != "serverstat") {
			$this->trace("remoteserver::_getRemoteStatus", "Invalid doctype in remote xml file ($file), needs to be serverstat", 0, 0);
			return false;
		} # End if

		# Check if the document has *any* child nodes, if not exit with
		# error...
		if (!$xmldoc->documentElement->hasChildNodes()) {
			$this->trace("remoteserver::_getRemoteStatus", "Invalid structure of remote xml file ($file), Doctype has no child nodes", 0, 0);
			return false;
		} # End if
		$childnodes =&$xmldoc->documentElement->childNodes;

		# Pre-check look ok, now walk thru the nodelist. The master 
		# map-pack xml file is quite simple, so no recusion of
		# node walk-thru is used, pretty straight forward...
		$server=1;
		$user=1;
		$channel=1;
		for ($i = 0; $i < $xmldoc->documentElement->childCount; $i++) {
			$node = $childnodes[$i];
			$nodename = $node->nodeName;

			if ($node->nodeName == "result") {
				if ($node->getText() == "?" || $node->getText() == "-1") {
					$this->online = false;
				} else {
					$this->online = true;
				} # End if
			} # End if

			if ($node->nodeName == "serverdata") {
				$this->trace("remoteserver::_getRemoteStatus", "Retrieving serverdata", 0, 0);

				$subnode = $xmldoc->getElementsByPath( $nodename, $server );
				if ($subnode->hasChildNodes()) {
					$values = $subnode->childNodes;
					foreach ($values as $value) {
						$this->serverdata[$value->nodeName] = $value->getText();
					} # End foreach
				} # End if
				$server++;
			} # End if

			if ($node->nodeName == "userinfo") {
				$this->trace("remoteserver::_getRemoteStatus", "Retrieving userinfo", 0, 0);

				# First we store the player index...
				$key = $node->getAttribute("id");

				$subnode = $xmldoc->getElementsByPath( $nodename, $user );
				if ($subnode->hasChildNodes()) {
					$values = $subnode->childNodes;
					foreach ($values as $value) {
						$this->userinfo[$key][$value->nodeName] = $value->getText();
					} # End foreach
				} # End if
				$this->numofusers++;
				$user++;
			} # End if

			if ($node->nodeName == "channelinfo") {
				$this->trace("remoteserver::_getRemoteStatus", "Retrieving channelinfo", 0, 0);

				# First we store the player index...
				$key = $node->getAttribute("id");

				$subnode = $xmldoc->getElementsByPath( $nodename, $channel );
				if ($subnode->hasChildNodes()) {
					$values = $subnode->childNodes;
					foreach ($values as $value) {
						$this->channelinfo[$key][$value->nodeName] = $value->getText();
					} # End foreach
				} # End if
				$this->numofchannels++;
				$channel++;
			} # End if
		} # End for
		
		$this->trace("remoteserver::_getRemoteStatus", "_end", 0, 0);
	} # End function getRemoteStatus

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		return $this->online;
	} # End function IsServerRunning
	
	/**
	* Returns the current number of users on the server.
	*/
	function getUsersOnline () {
		return number_format($this->numofusers);
	} # End function getUsersOnline

	/**
	* Return the operating system the server is running on.
	*/
	function getOSRunning () {
		return "Unknown";
	} # End function getOSRunning
} # End class SlowServer
?>