<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.php,v 0.6 2006/01/21 12:00:00 wilcojansen Exp $
* @package serverstat 0.6.1 - Collection of several functions for usage of serverstat
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $mosConfig_absolute_path . '/includes/domit/xml_domit_lite_include.php' );
require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/config/config.serverstat.php");
require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.main.class.php");

/**
* Here we do some basic initialisation for Serverstat logic. All Serverstat
* globals, needed at certain places are defined and set here. We start with
* the readout of the serverstat xml configuration file that contains
* the basic settings for all servers.
*/

# Use the Joomla build in xml parser to get the results...first we
# instantiate the xml class, and read it.
global $serverstat_servers;

$file = $mosConfig_absolute_path . "/administrator/components/com_serverstat/config/config.serverstat.xml";
$xmldoc =& new DOMIT_Lite_Document();
$xmldoc->resolveErrors( true );
if (!$xmldoc->loadXML( $file, false, true )) {
	Die ("Panic! Main xml configuration file $file cannot be found");
} # End if

# We have opened our xml file for readout. First we check the root 
# element, this needs to contain "serverstat", if not we have an
# invalid respone.
if ($xmldoc->documentElement->nodeName != "serverstat") {
	Die ("Panic! Main xml configuration file $file is not a serverstat file (root element missing or false)");
} # End if

# Check if the document has *any* child nodes, if not exit with
# error...
if (!$xmldoc->documentElement->hasChildNodes()) {
	Die ("Panic! Main xml configuration file $file does not have any child nodes");
} # End if
$childnodes =&$xmldoc->documentElement->childNodes;

$serverstat_servers = Array();

# Pre-check look ok, now walk thru the nodelist. The xml config
# config file is quite simple, so no recusion of node walk-thru,
# pretty straight forward...
$j=1;
for ($i = 0; $i < $xmldoc->documentElement->childCount; $i++) {
	$node = $childnodes[$i];
	$nodename = $node->nodeName;
		if ($nodename == "server") {
		# First we store the servertype...
		$servertype = $node->getAttribute("id");
			# Is this the servertype we are looking for? If so,
		# just walkt thru the nodelist and retrieve the
		# serverclass.
		$subnode = $xmldoc->getElementsByPath( $nodename, $j );
		if ($subnode->hasChildNodes()) {
			$values = $subnode->childNodes;
			$sarray['id'] = $servertype;
			foreach ($values as $value) {
				$sarray[$value->nodeName] = $value->getText();
			} # End foreach
			$serverstat_servers[] = $sarray;
		} # End if
		$j++;
	} # End if
} # End for

unset ($xmldoc);
	
/**
* Function to instantiate the proper server class.
* @param   row        the row object fo the server we want to instantiate
*          debug      debugging (component trace) needed?
*          slowserver if true, and slowserver is active for server, use the slowserver class
* @return  boolean  true = success
*/
function instantiateServerClass ( $row, $debug=false, $slowserver=false ) {
	global $mosConfig_absolute_path, $database;
	global $serverstat_timeout, $serverstat_retrycount, $serverstat_remotestatus;

	# Let's determine the server class this server belongs too. The server
	# class is determined by reading the main server config (xml) using
	# the servertype that is stored in the row we just got. This value
	# is overridden when we have a slow server option, or remote server
	# option.
	if ($row->slowserver != 0  && $slowserver) {
		$serverclass = 'slowserver';
	} elseif ($serverstat_remotestatus != 0) {
		$serverclass = 'remoteserver';
	} elseif (!$serverclass = getServerConfigVar ($row, "class")) {
		return false;
	} # End if

	# Determine default retrycount when value is 0 (use default config value)
	if ($row->retrycount == 0) {
		$row->retrycount = $serverstat_retrycount;
	} # End if

	# Instantiate object depending on given serverclass
	switch ($serverclass) {
		case "ASE":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.ASE.class.php");
			$server = new Ase ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout, $row->servertype);
			break;

		case "DOOM3":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.DOOM3.class.php");
			$server = new DOOM3 ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout, $row->servertype);
			break;

		case "ET":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.Q3.class.php");
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.ET.class.php");
			$server = new ET ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout);
			break;


		case "FTP":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.FTP.class.php");
			$server = new Ftp ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout);
			break;

		case "GS":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.GS.class.php");
			$server = new Gamespy ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout, $row->servertype);
			break;

		case "GS2":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.GS2.class.php");
			$server = new Gamespy2 ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout, $row->servertype);
			break;

		case "HL1":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.HL1.class.php");
			$server = new HL ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout);
			break;

		case "HL2":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.HL2.class.php");
			$server = new HL2 ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout, $row->servertype);
			break;

		case "ICE":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.ICE.class.php");
			$server = new Icecast ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout, $row->username, $row->password);
			break;

		case "MOHAA":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.MOHAA.class.php");
			$server = new MOHAA ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout);
			break;

		case "Q3":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.Q3.class.php");
			$server = new Q3 ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout, $row->servertype);
			break;

		case "SC":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.SC.class.php");
			$server = new Shoutcast ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout, $row->username, $row->password);
			break;

		case "SOF":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.SOF.class.php");
			$server = new SOF ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout);
			break;

		case "SWAT4":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.SWAT4.class.php");
			$server = new SWAT4 ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout);
			break;

		case "TS":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.TS.class.php");
			$server = new Teamspeak ($row->ip, $row->port, $row->port1, $debug, $row->retrycount, $row->timeout);
			break;

		case "XMP":
		case "UT2K3":
		case "UT2K4":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.UT.class.php");
			$server = new UT ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout, $serverclass);
			break;

		case "VENT":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.VENTRILO.class.php");
			$server = new Ventrilo ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout, $row->username, $row->password);
			break;

		case "WEB":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.WEB.class.php");
			$server = new Webserver ($row->ip, $row->port, $debug, $row->retrycount, $row->timeout);
			break;

		case "slowserver":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.slowserver.class.php");
			$server = new SlowServer ($database, $row->id );
			break;

		case "remoteserver":
			require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/classes/serverstat.remoteserver.class.php");
			$server = new RemoteServer ($database, $row->id );
			break;

		default:
			$server = false;
			break;
	} # End switch

	return $server;
} # End function instantiateServerClass

/**
* Function to get a specific value from the serverstat xml config file.
* @param   row      the row object fo the server we want to determine the
*                   value for
*          var      the variable we want to get the value off
* @return  string   the value out of the xml file
*/
function getServerConfigVar ($row, $var) {
	global $mosConfig_absolute_path, $serverstat_servers;

	for ($i=0; $i<count($serverstat_servers); $i++) {
		if ($serverstat_servers[$i]['id'] == $row->servertype) {
			return $serverstat_servers[$i][$var];
		} # End if
	} # End for

	return false;
} # End function getServerConfigVar

/**
* Function to convert seconds to an time.
*/
function sec2time ($s) {
	$r = "";
	$days = intval($s / (24 * 3600));
	$s = $s - ($days * (24 * 3600));
	$hours = intval($s / 3600);
	$s = $s - ($hours * 3600);
	$minutes = intval($s / 60);
	$seconds = $s % 60;
	if ($days > 0) {
		$r  = $days . _SERVERSTAT_DAYS;
	} # End if
	$r  .= sprintf("%02d", $hours) . ":" . sprintf("%02d", $minutes) . ":" . sprintf("%02d", $seconds);
	return $r;
} # End function sec2time

/**
* Function to convert special encoded name (player/server) from q3 alike
* servers to the proper HTML variant.
*/
function q3Name2HTML( $text ) {
	# Let us define the colors here
	$color["0"] = "Black";
	$color["1"] = "Red";
	$color["2"] = "Green";
	$color["3"] = "Yellow";
	$color["4"] = "Blue";
	$color["5"] = "Cyan";
	$color["6"] = "Pink";
	$color["7"] = "White";
	$color["8"] = "Orange";
	$color["9"] = "Gray";
	$color["a"] = "Orange";
	$color["b"] = "Turquoise";
	$color["c"] = "Purple";
	$color["d"] = "Light Blue";
	$color["e"] = "Purple";
	$color["f"] = "Light Blue";
	$color["g"] = "Light Green";
	$color["h"] = "Dark Green";
	$color["i"] = "Dark Red";
	$color["j"] = "Claret";
	$color["k"] = "Brown";
	$color["l"] = "Light Brown";
	$color["m"] = "Olive";
	$color["n"] = "Beige";
	$color["o"] = "Beige";
	$color["p"] = "Black";
	$color["q"] = "Red";
	$color["r"] = "Green";
	$color["s"] = "Yellow";
	$color["t"] = "Blue";
	$color["u"] = "Cyan";
	$color["v"] = "Pink";
	$color["w"] = "White";
	$color["x"] = "Orange";
	$color["y"] = "Gray";
	$color["z"] = "Orange";
	$color["/"] = "Beige";
	$color["*"] = "Gray";
	$color["-"] = "Olive";
	$color["+"] = "Foxy Red";
	$color["?"] = "Dark Brown";
	$color["@"] = "Brown";

	# Walk thru string, find the "^" for color markers, replace and build
	# the html return string.
	$count = 0;
	foreach($color as $key => $value) {
		$search = "^$key";
		$replace = "<font color=\"$value\">";
		if ($count != 0) {
			$replace = "</font>" . $replace;
		} # End if

		if (strstr ( $text , $search)) {
			$text = str_replace ( $search, $replace , $text);
			$count++;
		} # End if
	} # End if

	if ($count > 0) {
		$text .= "</font>";
	} # End if

	return $text;
} # End function q3Name2HTML

/**
* Function to convert special encoded name (player/server)
* from UT 2/XMP/2k3/2k4 alike servers to the proper HTML variant. Parts of the 
* code have been taken from the KjStat v0.87 (beta, public) package that was
* developed by Sam 'KingJackaL' Evans.
*/
function UTName2HTML ($text) {

	# Let us define the colors here
	$utColors = array(
		1 => "#F0F8FF",
		2 => "#FAEBD7",
		3 => "#00FFFF",
		4 => "#7FFFD4",
		5 => "#F0FFFF",
		6 => "#F5F5DC",
		7 => "#FFE4C4",
		8 => "#000000",
		9 => "#FFEBCD",
		10 => "#0000FF",
		11 => "#8A2BE2",
		12 => "#A52A2A",
		13 => "#DEB887",
		14 => "#5F9EA0",
		15 => "#7FFF00",
		16 => "#D2691E",
		17 => "#FF7F50",
		18 => "#6495ED",
		19 => "#FFF8DC",
		20 => "#DC143C",
		21 => "#00FFFF",
		22 => "#00008B",
		23 => "#008B8B",
		24 => "#B8860B",
		25 => "#A9A9A9",
		26 => "#006400",
		27 => "#BDB76B",
		28 => "#8B008B",
		29 => "#556B2F",
		30 => "#FF8C00",
		31 => "#9932CC",
		32 => "#8B0000",
		33 => "#E9967A",
		34 => "#8FBC8F",
		35 => "#483D8B",
		36 => "#2F4F4F",
		37 => "#00CED1",
		38 => "#9400D3",
		39 => "#FF1493",
		40 => "#00BFFF",
		41 => "#696969",
		42 => "#1E90FF",
		43 => "#B22222",
		44 => "#FFFAF0",
		45 => "#228B22",
		46 => "#FF00FF",
		47 => "#DCDCDC",
		48 => "#F8F8FF",
		49 => "#FFD700",
		50 => "#DAA520",
		51 => "#808080",
		52 => "#008000",
		53 => "#ADFF2F",
		54 => "#F0FFF0",
		55 => "#FF69B4",
		56 => "#CD5C5C",
		57 => "#4B0082",
		58 => "#FFFFF0",
		59 => "#F0E68C",
		60 => "#E6E6FA",
		61 => "#FFF0F5",
		62 => "#7CFC00",
		63 => "#FFFACD",
		64 => "#ADD8E6",
		65 => "#F08080",
		66 => "#E0FFFF",
		67 => "#FAFAD2",
		68 => "#90EE90",
		69 => "#D3D3D3",
		70 => "#FFB6C1",
		71 => "#FFA07A",
		72 => "#20B2AA",
		73 => "#87CEFA",
		74 => "#778899",
		75 => "#B0C4DE",
		76 => "#FFFFE0",
		77 => "#00FF00",
		78 => "#32CD32",
		79 => "#FAF0E6",
		80 => "#FF00FF",
		81 => "#800000",
		82 => "#66CDAA",
		83 => "#0000CD",
		84 => "#BA55D3",
		85 => "#9370DB",
		86 => "#3CB371",
		87 => "#7B68EE",
		88 => "#00FA9A",
		89 => "#48D1CC",
		90 => "#C71585",
		91 => "#191970",
		92 => "#F5FFFA",
		93 => "#FFE4E1",
		94 => "#FFE4B5",
		95 => "#FFDEAD",
		96 => "#000080",
		97 => "#FDF5E6",
		98 => "#808000",
		99 => "#6B8E23",
		100 => "#FFA500",
		101 => "#FF4500",
		102 => "#DA70D6",
		103 => "#EEE8AA",
		104 => "#98FB98",
		105 => "#AFEEEE",
		106 => "#DB7093",
		107 => "#FFEFD5",
		108 => "#FFDAB9",
		109 => "#CD853F",
		110 => "#FFC0CB",
		111 => "#DDA0DD",
		112 => "#B0E0E6",
		113 => "#800080",
		114 => "#FF0000",
		115 => "#BC8F8F",
		116 => "#4169E1",
		117 => "#8B4513",
		118 => "#FA8072",
		119 => "#F4A460",
		120 => "#2E8B57",
		121 => "#FFF5EE",
		122 => "#A0522D",
		123 => "#C0C0C0",
		124 => "#87CEEB",
		125 => "#6A5ACD",
		126 => "#708090",
		127 => "#FFFAFA",
		128 => "#00FF7F",
		129 => "#4682B4",
		130 => "#D2B48C",
		131 => "#008080",
		132 => "#D8BFD8",
		133 => "#FF6347",
		134 => "#40E0D0",
		135 => "#EE82EE",
		136 => "#F5DEB3",
		137 => "#FFFFFF",
		138 => "#F5F5F5",
		139 => "#FFFF00",
		140 => "#9ACD32"
	);

	$curcolor = -1;
	$nextcolor = 137;
	$buf = "";

	for ($x = 0; $x < strlen($text); $x++) {
		if ($text[$x] == '^' && $text[$x + 1] == '#') {
			if ($x < strlen($text) - 2)
				if ($text[$x + 2] != '^') {
					$nextcolor = (ord($text[$x + 2]) % 140) + 1;
					$x += 2;
					continue;
				} # End if
		} # End if

		if ($curcolor != $nextcolor) {
			if ($curcolor != -1)
				$buf .= "</span>";
			$curcolor = $nextcolor;
			$buf .= sprintf("<span style=\"color: %s\">", $utColors[$curcolor]);
		} # End if
		$buf .= $text[$x];
	} # End for

	if ($curcolor != -1)
		$buf .= "</span>";

	return $buf;
} # End function UTName2HTML

/**
* Function to convert special encoded characters (player/server)
* to norman ASCII.
*/

/**
* Function to check if a component is installed, and if so, we retrieve
* the version installed.
*
* Returns Installed component version (when installed)
* Returns false if not found
*/

function ComponentVersion ( $component ) {
	global $mosConfig_absolute_path;	

	$installFilename = $mosConfig_absolute_path . "/administrator/components/com_$component/$component.xml";

	if (!file_exists( $installFilename )) {
		return false;
	} # End if

	$xmldoc =& new DOMIT_Lite_Document();
	$xmldoc->resolveErrors( true );
	if (!$xmldoc->loadXML( $installFilename, false, true )) {
		return false;							# File cannot be read
	} # End if

	$main_element = &$xmldoc->documentElement;

	# Check that it's an installation file
	if ($main_element->getTagName() != 'mosinstall') {
		die ('File :"' . $installFilename() . '" is not a valid Joomla installation file' );
		return false;
	} # End if

	# Get version value into element
	$element = &$xmldoc->getElementsByPath('version', 1);

	unset ($xmldoc);

	# Yes, now return the value of the version found	
	return $element->getText();
} # End function ComponentVersion

/**
* View a binary string as a hexidecimal dump.
*
* @version      1.2.2
* @author       Peter Waller <iridum@php.net>
* @author       Aidan Lister <aidan@php.net>
* @param        string  $data        The string to be dumped
* @param        bool    $htmloutput  Set to false for non-HTML output
* @param        bool    $uppercase   Set to true for uppercase hex
* @param        bool    $return      Set to true to return the dump
*/
function hexdump ($data, $htmloutput = true, $uppercase = false, $return = false) {
	$hexi = $ascii = '';
	$dump = $htmloutput === true ? "<pre>\n" : '';

	# Upper or lower case hexidecimal
	if ($uppercase === false) {
		$x = 'x';
	} else {
		$x = 'X';
	} # End if

	# Split the data into lines 16 chars long
	$lines = array();
	$i = 0;
	while ($i * 16 < strlen($data)) {
		$lines[] = substr($data, 16 * $i++, 16);
	} # End while
    
	# Loop through each line
	$offset = 0;
	foreach ($lines as $line) {
		# Loop through each char in the line
		for ($i = 0; $i < strlen($line); $i++) {
			# Convert to hexidecimal
			$hexi .= sprintf("%02$x ", ord($line{$i}));

			# Replace non-viewable bytes with '.'
			if (ord($line{$i}) >= 32) {
				$ascii .= $htmloutput === true ? htmlentities($line{$i}) : $line{$i};
			} else {
				$ascii .= '.';
			} # End if

			# Split into two columns
			if ($i == 7) {
				$hexi .= ' ';
				$ascii .= ' ';
			} # End if
		} # End for

		# Join the hexi / ascii output
		$dump .= sprintf("%04$x  %-49s  %s\n", $offset, $hexi, $ascii);
        
		# Line count
		$offset += 16;

		# Reset
		$hexi = $ascii = '';
	} # End foreach
    
	# Strip last newline
	$dump = substr($dump, 0, -1);
	$dump .= $htmloutput === true ? '</pre>' : '';
	$dump .= "\n";

	# Output method
	if ($return === false) {
		echo $dump;
	} else {
		return $dump;
	} # End if
} # End function 

/**
* Determine size of given itemin Kb, Mb of Gb
*
* @param        long    $size        Size we want to calculate values for
* @param        string  $size        Return value
*/
function DataSize ($size) {
	if($size >= 1073741824) {
		$size = round($size / 1073741824 * 100) / 100 . " Gb";
	} elseif($size >= 1048576) {
		$size = round($size / 1048576 * 100) / 100 . " Mb";
	} elseif($size >= 1024) {
		$size = round($size / 1024 * 100) / 100 . " Kb";
	} else $size = $size . " Bytes";
	if($size==0) $size="-";

	return $size;
} # End function DataSize 


/**
* Determine the url for a given page.
*
* @param  string  $page  The help page you want to retrieve
* @param  string  $size  The complete url (http:// ...) as return value
*/
function HelpUrl ($page) {
	global $mosConfig_live_site;
	
	$url = $mosConfig_live_site . "/administrator/index2.php?option=com_serverstat&task=help&page=";
	
	#if (ComponentVersion ("jpgraph")) {
	#	$url .= $page;
	#} # End if

	return $url;
} # End function HelpUrl 

/**
* Return the port where a client needs to connect to.
*
* @param  object   $row   An row object for the given servertype
* @param  integer  $port  Port value the client need to connect to
*/
function getGamePort ( $row) {
	return $row->port1 ? $row->port1 : $row->port;
} # End function getGamePort


/**
* Filter out non standard ASCI characters in a string.
*
* @param  string   $text  The text we want to filter out
* @param  string   $text  Text containing only ASCII characters
*/
function getASCII ( $text ) {
	$newtext = "";
	for ($i=0; $i<strlen($text); $i++) {
		$char = substr($text, $i, 1);
		$ascii = ord($char);
		if ($ascii > 47 && $ascii < 58) $newtext .= $char;
		if ($ascii > 64 && $ascii < 91) $newtext .= $char;
		if ($ascii > 96 && $ascii < 123) $newtext .= $char;
		if ($char == "-")  $newtext .= $char;
		if ($char == "_")  $newtext .= $char;
	} # End for
	return $newtext;
} # End function getASCII

/*
* Retrieve the path to the image we want to use.
*/
function getImagePath ($row, $server) {
	global $mosConfig_absolute_path, $mosConfig_live_site;

	$image= "/administrator/components/com_serverstat/images/servers/" . $row->servertype . "/" . $server->getMapName() . ".jpg";

	if (!file_exists($mosConfig_absolute_path . $image)) {
		$image= "/administrator/components/com_serverstat/images/servers/" . $row->servertype . "/unknown.jpg";
	} # End if

	# Determine full url, and return result
	return $mosConfig_live_site . $image;
} # End function getImagePath

/*
* Render a connect button, returns full HTML string with connect button in it.
*/
function renderConnectButton ( $row ) {
	global $serverstat_servers;

	$html = "";
	for ($i=0; $i < count($serverstat_servers); $i++) {
		if ($serverstat_servers[$i]['id'] == $row->servertype) {
			$array = $serverstat_servers[$i];
			break;
		} # End if
	} # End for

	# Check the connectiontype for given servertype.
	switch ($array['connectiontype']) {
		case 1:	# steam
			$html .= "<form action='steam:-applaunch " . $array['steamid'] . " +connect " . $row->ip . ":" . getGamePort ($row) . "'>";
			$html .= "<input type=\"submit\" value=\""  . _SERVERSTAT_BUTTON_CONNECT . "\">";
			$html .= "</form>";
			break;

		case 2: # battlefield 2
			$html .= "<form action='bf2://" . $row->ip . ":" . getGamePort ($row) . "/'>";
			$html .= "<input type=\"submit\" value=\""  . _SERVERSTAT_BUTTON_CONNECT . "\">";
			$html .= "</form>";
			break;

		default:	# not supported
			return false;
			break;
	} # End switch

	return $html;
} # End function renderConnectButton
?>