<?php
/**
 * This file contains the default template for the eWeather Forecast module.
 *
 * This file is part of the eWeather Module.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * 04/11/2010: Bob Lavey - Initial revision
 * 03/14/2011: Bob Lavey - Converted to work with Joomla! 1.6.x 
 *
 * @package eWeather
 * @subpackage eWeather Forecast Module
 * @copyright Copyright (C) 2000 - 2005 Miro International Pty Ltd,
 *            2006 Harald Baer<br/>
 *            2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

require_once( JPATH_SITE .DS.'modules'.DS.'mod_eweather_forecast'.DS.'helpers'.DS.'defines.php' );


echo '<!-- eWeather Forecast Module Version '.MOD_EWEATHER_FORECAST_VERSION.' '.MOD_EWEATHER_FORECAST_VERSION_DATE.' -->';
?>

<div class="eweather" >
<table>
	<tr>
		<td colspan="2" align="center" >
			<div align="center">
                <?php echo JText::_('COM_EWEATHER_FORECAST').'&nbsp;'.JText::_('COM_EWEATHER_FORECAST_FOR').'&nbsp;'.$this->data->twcContent->loc_city; ?>
                <br/>
                <?php echo JText::_('COM_EWEATHER_LASTUPDATED').'&nbsp;'.$this->data->twcContent->dayf_lastupdate; ?>
			</div>
		</td>
	</tr>
<?php echo '<!-- Forecast Body -->' ?>
	 <tr>
<?php
		for ($i = 0; $i < $this->numberOfForecastDays; ++$i)
		{
?>        
		<td>
			<table>
				<tr>
					<td class="ForecastBlockHeader<?php echo $this->moduleClassSuffix; ?>" height="19" colspan="2" >
						<div style="font-weight: bold; text-align: center; color: #000000; vertical-align: bottom;">
							<a href="<?php echo $this->data->detailedForecastUrls[$i]; ?>" title="<?php echo JText::_('COM_EWEATHER_FORECAST_TITLE'); ?>" >
								<img src="<?php echo $this->data->imageUrls['weatherDetailOpen']; ?>" align="left" border="0" alt="" />
							</a>
							<?php echo $this->data->formattedForecastDates[$i]; ?>
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC;" >
						<div style="font-weight: bold; text-align: center;" >
							<?php echo JText::_('COM_EWEATHER_FORECAST_DAY'); ?>
						</div>
					</td>
					<td style="border-right: 1px solid #CCCCCC;">
						<div style="font-weight: bold; text-align: center;" >
							<?php echo JText::_('COM_EWEATHER_FORECAST_NIGHT'); ?>
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center">
							<img src="<?php echo $this->data->forecastDayIcons[$i]; ?>" border="0" alt="<?php echo $this->data->twcContent->dayf_forecasts[$i]->day_d_text; ?>" />
							<br />
						</div>
					</td>
					<td style="border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center">
						<img src="<?php echo $this->data->forecastNightIcons[$i]; ?>" border="0" alt="<?php echo $this->data->twcContent->dayf_forecasts[$i]->day_n_text; ?>" />
							<br />
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC;" colspan="2" >
						<div style="font-weight: bold; text-align: center; color: #000000; background: #EFEFEF;" >
							<?php echo JText::_('COM_EWEATHER_FORECAST_TEMP'); ?>
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center">
<?php
						if ('N/A' == $this->data->twcContent->dayf_forecasts[$i]->day_d_text)
						{
							echo 'N/A';
						}
						else
						{
							echo JText::_('COM_EWEATHER_FORECAST_TEMP_MAX').': '.$this->data->twcContent->dayf_forecasts[$i]->day_temp_max.'&deg;'.$this->data->twcContent->h_temp;
						}
?>
							<br />
						</div>
					</td>
					<td style="border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center">
							<?php echo JText::_('COM_EWEATHER_FORECAST_TEMP_MIN').': '.$this->data->twcContent->dayf_forecasts[$i]->day_temp_min.'&deg;'.$this->data->twcContent->h_temp; ?>
							<br />
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC;" colspan="2" >
						<div style="font-weight: bold; text-align: center; color: #000000; background: #EFEFEF;" >
							<?php echo JText::_('COM_EWEATHER_FORECAST_RAIN'); ?>
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center">
<?php
						if ('N/A' == $this->data->twcContent->dayf_forecasts[$i]->day_d_text)
						{
							echo 'N/A';
						}
						else
						{
							echo $this->data->twcContent->dayf_forecasts[$i]->day_d_precipitation.'%';
						}
?>
							<br />
						</div>
					</td>
					<td style="border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center">
							<?php echo $this->data->twcContent->dayf_forecasts[$i]->day_n_precipitation.'%'; ?>
							<br />
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC;" colspan="2" >
						<div style="font-weight: bold; text-align: center; color: #000000; background: #EFEFEF;">
							<?php echo JText::_('COM_EWEATHER_WIND'); ?>
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center">
<?php
						if ('N/A' == $this->data->twcContent->dayf_forecasts[$i]->day_d_text)
						{
							echo 'N/A';
						}
						else
						{

							echo $this->data->twcContent->dayf_forecasts[$i]->day_d_windtext.'&nbsp;'.$this->data->twcContent->dayf_forecasts[$i]->day_d_windspeed;
						}
?>
							<br />
						</div>
					</td>
					<td style="border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center">
							<?php echo $this->data->twcContent->dayf_forecasts[$i]->day_n_windtext.'&nbsp;'.$this->data->twcContent->dayf_forecasts[$i]->day_n_windspeed; ?>
							<br />
						</div>
					</td>
				</tr>
			</table>
		</td>
<?php
		// If this is the last forecast for this row, close the row and start a new one
		if (($i % $this->forecastsPerRow) == ($this->forecastsPerRow - 1))
	    {
?>
	</tr>
	<tr>
		<td colspan="15" height="10"></td>
	</tr>
<?php
	// If there are more forecasts, open a new row
	if ($i != ($this->numberOfForecastDays - 1))
	{
?>
	<tr>
<?php
	}
		}
		// Not at the end of a row
		elseif ($i != ($this->numberOfForecastDays - 1))
		{
?>
		<td width="15"></td>
<?php
		}
    } // end for loop

	//
	// if there is still a forecast row open, close it
	// there will be a forecast row open in the case that
	//  the number of forecasts per row is not an even
	//  multiple of the number of forecasts
	//
    if (($this->numberOfForecastDays % $this->forecastsPerRow) != 0)
	{
?>
	</tr>
<?php
	}
?>
	<tr>
		<td colspan="2" style="text-align: center; padding-top: 8px; float: none;" align="center">
			<a class="button<?php echo $this->moduleClassSuffix; ?>" style="float: none;" href="<?php echo $this->data->weatherUrl; ?>">
				<?php echo JText::_('MOD_EWEATHER_FORECAST_SHOW_DETAILS'); ?>
			</a>
		</td>
	</tr>
<?php
	if ('1' == $this->allowUserProfiles)
	{
?>
	<tr>
		<td colspan="2" style="text-align: center; padding-bottom: 8px; float: none;" align="center">
			<a class="button<?php echo $this->moduleClassSuffix; ?>" style="float: none;" href="<?php echo $this->data->profileUrl; ?>">
				<?php echo JText::_('MOD_EWEATHER_FORECAST_SELECT_LOCATION'); ?>
			</a>
		</td>
	</tr>
<?php
	}
?>
	<tr>
		<td colspan="2">
			<table>
				<tr>
					<td align="right" style="font-size: 70%; padding-top: 15px;">
						<div align="left">
							<?php echo JText::_('COM_EWEATHER_PROVIDER').':'; ?>
							<br/>
							<a href="http://www.weather.com" target="blank">
								<img src="<?php echo $this->data->imageUrls['weatherChannelLogoSmall']; ?>" border="0" alt="www.weather.com" />
							</a>
						</div>
					</td>
					<td align="right" style="font-size: 80%; padding-left: 5px; padding-top: 15px; text-align: right;" >
<?php
		    		$numLinks = count($this->data->twcContent->partnerLinks);
    				for ($x = 0; $x < $numLinks; $x++)
    				{
	    			$url = JROUTE::_(str_replace('&','&amp;',$this->data->twcContent->partnerLinks[$x]->url));
	    			$text = str_replace('&','&amp;',$this->data->twcContent->partnerLinks[$x]->text)
?>
						<a target="_blank" href="<?php echo $url; ?>" title="<?php echo $text; ?>" >
							<?php echo $text; ?>
						</a>
						<br/>
<?php
					}
?>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</div>
<?php
echo '<!-- end eWeather Forecast Module Version '.MOD_EWEATHER_FORECAST_VERSION.' '.MOD_EWEATHER_FORECAST_VERSION_DATE.' -->';
?>
