<?php
/**
 * Parameter class for eWeatherTide module.
 * This class holds the parameters passed to the NOAA CO-OPS
 *  tide prediction web service.
 * 
 * This file is part of eWeatherTide.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * 04/11/2010: Bob Lavey - Initial revision
 * 03/14/2011: Bob Lavey - Converted to work with Joomla! 1.6.x 
 *
 * @package eWeatherTide
 * @subpackage eWeatherTide Module
 * @copyright Copyright (C) 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// <soapenv:Body>
//   <hilo:getHLPredAndMetadata xmlns:hilo="http://opendap.co-ops.nos.noaa.gov/axis/webservices/highlowtidepred/wsdl">
//     <stationId xmlns="">8454000</stationId> 
//     <beginDate xmlns="">20060920 00:00</beginDate> 
//     <endDate xmlns="">20060922 23:59</endDate> 
//     <datum xmlns="">0</datum> 
//     <unit xmlns="">0</unit> 
//     <timeZone xmlns="">0</timeZone> 
//   </hilo:getHLPredAndMetadata>
// </soapenv:Envelope>

class TideParams extends JObject
{
	var $stationId = null;
   	var $beginDate = null;
   	var $endDate = null;
   	var $datum = 0;
   	var $unit = null;
   	var $timeZone = 0;  // always local standard time
   	
   	function __construct($stationId, $date, $unit)
   	{
   		$this->stationId = $stationId;
   		$this->beginDate = $date.' 00:00';
   		$this->endDate = $date.' 23:59';
   		$this->unit = $unit;
   	}
}
