<?php
/**
 * eWeatherTideModule class for eWeatherTide module.
 * This class retrieves the tide data from NOAA CO-OPS and
 *  returns an error string if there was a failure.
 * 
 * This file is part of eWeatherTide.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * 04/11/2010: Bob Lavey - Initial revision
 * 03/14/2011: Bob Lavey - Converted to work with Joomla! 1.6.x 
 *
 * @package eWeatherTide
 * @subpackage eWeatherTide Module
 * @copyright Copyright (C) 2011 Bob Lavey
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

jimport('joomla.application.component.model');

// setup paths
require_once( JPATH_SITE.DS.'modules'.DS.'mod_eweather_tide'.DS.'helpers'.DS.'defines.php' );
JLoader::register('TideParams', MOD_EWEATHER_TIDE_CLASSES_PATH.DS.'TideParams.php' );

JModel::addIncludePath( COM_EWEATHER_MODELS_PATH );			


class eWeatherTideModule extends JObject
{
	protected $model = false;
	
	function __construct($params)
	{
		if (defined( 'COM_EWEATHER_ADMIN_VERSION' ))
		{
			// load the com_eweather language file
			$lang = JFactory::getLanguage();
			$lang->load('com_eweather', COM_EWEATHER_PATH );
			
			// get the module's params
			$this->moduleClassSuffix = $params->get( 'moduleClassSuffix' );
			$this->stationId = $params->get( 'stationId' );
			$this->predictionUnits = $params->get( 'predictionUnits' );
			$this->dst = $params->get( 'dst' );
			$this->timeFormat = $params->get( 'timeFormat' );
			
			// set constant params
			$this->datum = 0;
			$this->timeZone = 0;
		
			$this->weatherUrl = JROUTE::_("http://www.weather.com/weather/tenday/");
			
			// include the appropriate style sheets
			JHTML::stylesheet( 'eweathertide.css', MOD_EWEATHER_TIDE_CSS_URL );
	
			// get eWeather Component's "main" model
			$this->model = JModel::getInstance('main', 'eWeatherModel');
			if (false == $this->model)
			{
				$this->_errors['moduleError'] = JText::_('MOD_EWEATHER_TIDE_COMPONENT_NOT_FOUND').': com_eweather';
			}
		}
		else
		{
			$this->_errors['moduleError'] = JText::_('MOD_EWEATHER_CCDETAILS_COMPONENT_NOT_FOUND').': com_eweather';
		}
	}
	
	function display()
	{
		if (false != $this->model)
		{
			$this->data = $this->model->getData(null);
			if ('error' != $this->data->dataType)
			{
				$this->weatherUrl .= $this->data->locationId;
			}
		}
		
		$today = strtotime(date("Ymd"));
		$yesterday = strtotime("-1 hour", $today);

		// start with yesterday, because the dates are in standard time,
		//  and a DST conversion could cause a time from yesterday to become today
		$this->beginDate = date("Ymd", $yesterday).' 00:00';
		$this->endDate = date("Ymd", $today).' 23:59';
		
		if (isset($this->_errors['moduleError']))
		{
			require(JModuleHelper::getLayoutPath('mod_eweather_tide', 'componenterror'));
		}
		else if ('error' == $this->data->dataType)
		{
			require(JModuleHelper::getLayoutPath('mod_eweather_tide', 'weathererror'));
		}
		else
		{
			require(JModuleHelper::getLayoutPath('mod_eweather_tide', 'default'));
		}
	}
	function getWindDescription()
	{
    	$windText = null;
    	
    	switch ($this->data->twcContent->cc_windtext)
		{
			case 'E':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_E');
				break;
			case 'ENE':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_ENE');
				break;
			case 'ESE':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_ESE');
				break;
			case 'N':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_N');
				break;
			case 'NE':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_NE');
				break;
			case 'NNE':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_NNE');
				break;
			case 'NNW':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_NNW');
				break;
			case 'NW':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_NW');
				break;
			case 'S':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_S');
				break;
			case 'SE':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_SE');
				break;
			case 'SSE':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_SSE');
				break;
			case 'SSW':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_SSW');
				break;
			case 'SW':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_SW');
				break;
			case 'W':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_W');
				break;
			case 'WNW':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_WNW');
				break;
			case 'WSW':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_WSW');
				break;
			case 'CALM':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_CALM');
				break;
			case 'VAR':
				$windText = JText::_('MOD_EWEATHER_TIDE_WIND_VAR');
				break;
		}
		
		if (('CALM' != $windText) && ('VAR' != $windText))
		{
			$wind  = $this->data->twcContent->cc_windspeed.'&nbsp;'.$this->data->twcContent->h_speed.'&nbsp;';
			$wind .= JText::_('MOD_EWEATHER_TIDE_WIND_OUT_OF_THE').' ';
			$wind .= $windText;
			return $wind;
		}
		else
		{
			return $windText;
		}    	
	}
}
