<?php
/**
 * This file contains the default template for the eWeatherTide module.
 *
 * This file is part of the eWeatherTide Module.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * 04/11/2010: Bob Lavey - Initial revision
 * 03/14/2011: Bob Lavey - Converted to work with Joomla! 1.6.x 
 *
 * @package eWeatherTide
 * @subpackage eWeatherTide Module
 * @copyright Copyright (C) 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

require_once( JPATH_SITE .DS.'modules'.DS.'mod_eweather_tide'.DS.'helpers'.DS.'defines.php' );


echo '<!-- eWeatherTide Module Version '.MOD_EWEATHER_TIDE_VERSION.' '.MOD_EWEATHER_TIDE_VERSION_DATE.' -->';

?>

<script type="text/javascript">
function printTideInfo(h1, h2, l1, l2)
{
	document.getElementById("HighTide1").innerHTML = h1;
	document.getElementById("HighTide2").innerHTML = h2;
	document.getElementById("LowTide1").innerHTML = l1;
	document.getElementById("LowTide2").innerHTML = l2;
}
</script>
<applet code="SendRequest.class"
		codebase="<?php echo JROUTE::_(MOD_EWEATHER_TIDE_JAVA_URL); ?>"
		archive="sendrequest.jar"
		name="SendRequest"
		WIDTH="0" HEIGHT="0"
		MAYSCRIPT>
	<param name="stationId" value="<?php echo $this->stationId; ?>" >
	<param name="beginDate" value="<?php echo $this->beginDate; ?>" >
	<param name="endDate" value="<?php echo $this->endDate; ?>" >
	<param name="datum" value="<?php echo $this->datum; ?>" >
	<param name="unit" value="<?php echo $this->predictionUnits; ?>" >
	<param name="timeZone" value="<?php echo $this->timeZone; ?>" >
	<param name="adjustDst" value="<?php echo $this->dst; ?>" >
	<param name="timeFormat" value="<?php echo $this->timeFormat; ?>" >
	<param name="connectionErrorMsg" value="<?php echo JTEXT::_('MOD_EWEATHER_TIDE_NOAA_CONNECTION_ERROR'); ?>" >
	<param name="dataRetrievalErrorMsg" value="<?php echo JTEXT::_('MOD_EWEATHER_TIDE_NOAA_DATA_RETRIEVAL_ERROR'); ?>" >
	<param name="dataErrorMsg" value="<?php echo JTEXT::_('MOD_EWEATHER_TIDE_NOAA_DATA_ERROR'); ?>" >
</applet>

<div class="eweather" >
<table border="0" cellspacing="0" style="border-collapse: collapse; width: 100% !important;" align="center" width="99%">
	<tr>
		<td colspan="2" class="CityTitle" >
			<div align="center">
				<strong><?php echo $this->data->twcContent->loc_city; ?></strong>
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<p class="CurrentConditionsImage<?php echo $this->data->pageClassSuffix; ?>" >
				<img src="<?php echo $this->data->imageUrls['currentConditionsSmall']; ?>" alt="<?php echo $this->data->twcContent->cc_text; ?>" border="0" />
			</p>
		</td>
		<td valign="top">
			<table border="0" style="margin: 0px; padding: 0px;" cellspacing="0" cellpadding="0" width="99%" align="center">
				<tr>
					<td style="margin: 0px; margin-top: 20px; padding: 0px; text-align: center;">
						<strong><?php echo JText::_('COM_EWEATHER_SUNRISE').':'; ?></strong>
					</td>
				</tr>
				<tr>
					<td style="margin: 0px; padding: 0px; text-align: center;">
						<?php echo JHTML::_('date', strtotime($this->data->twcContent->loc_sunrise), $this->timeFormat, false); ?>
					</td>
				</tr>
				<tr>
					<td style="margin: 0px; padding: 0px; text-align: center;">
						<strong><?php echo JText::_('COM_EWEATHER_SUNSET').':'; ?></strong>
					</td>
				</tr>
				<tr>
					<td style="margin: 0px; padding: 0px; text-align: center;">
						<?php echo JHTML::_('date', strtotime($this->data->twcContent->loc_sunset), $this->timeFormat, false); ?>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td>
			<div class="CurrentConditionsTemperature<?php echo $this->data->pageClassSuffix; ?>" >
				<?php echo $this->data->twcContent->cc_temp.'&deg;'.$this->data->twcContent->h_temp; ?>
			</div>
			<br />
		</td>
	</tr>
</table>
<table border="0" cellspacing="0" style="border-collapse: collapse;" align="center" width="99%">
<?php require(JModuleHelper::getLayoutPath('mod_eweather_tide', 'tide')); ?>
	<tr>
		<td colspan="2" class="WindHeader" >
			<?php echo JText::_('MOD_EWEATHER_TIDE_WIND'); ?>
		</td>
	</tr>
	<tr>
		<td colspan="2" class="WindDescription" >
			<?php echo $this->getWindDescription(); ?>
		</td>
	</tr>
	<tr>
		<td colspan="2" style="text-align: center; padding-top: 8px; float: none;" align="center">
			<a class="button<?php echo $this->moduleClassSuffix; ?>" style="float: none;" href="<?php echo $this->weatherUrl; ?>" target="_blank" >
				<?php echo JText::_('MOD_EWEATHER_TIDE_EXTENDED_FORECAST'); ?>
			</a>
		</td>
	</tr>
	<tr>
		<td colspan="2">
			<table border="0" cellspacing="0" style="border-collapse: collapse;" align="center" width="99%">
				<tr>
					<td colspan=2 style="font-size: 70%; line-height:90%; padding-top: 15px; text-align: center;">
						<p align="center">
							<?php echo JText::_('MOD_EWEATHER_TIDE_EWEATHER_PROVIDER'); ?>
							<br/>
							<a href="http://www.weather.com" target="blank">
								<img src="<?php echo $this->data->imageUrls['weatherChannelLogoSmall']; ?>" border="0" alt="www.weather.com" />
							</a>
						</p>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</div>
<?php
echo '<!-- end eWeatherTide Module Version '.MOD_EWEATHER_TIDE_VERSION.' '.MOD_EWEATHER_TIDE_VERSION_DATE.' -->';
?>
