<?php
/**
 * This file contains the default template for the Raf Weather module.
 *
 * This file is part of the eWeather Module.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * 03/14/2010: Bob Lavey - Initial revision, converted to MVC module.
 * 03/14/2011: Bob Lavey - Converted to work with Joomla! 1.6.x 
 *
 * @package eWeather
 * @subpackage Raf Weather Module
 * @copyright Copyright (C) 2007 Skorp<br/>
 *            2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

require_once( JPATH_SITE .DS.'modules'.DS.'mod_rafweather'.DS.'helpers'.DS.'defines.php' );


echo '<!-- Raf Weather Module Version '.MOD_RAFWEATHER_VERSION.' '.MOD_RAFWEATHER_VERSION_DATE.' -->';
?>

<div class="eweather" >
<table class="moduletable"<?php echo $this->moduleClassSuffix; ?> >
	<tr>	
<?php
	for ($i = 0; $i < $this->numLocations; ++$i)
	{
		$loc = $this->locations[$i];
?>
		<td>
			<table>
				<tr>
					<td colspan="3">
						<strong>
<?php
						if (null != $loc->weatherLink)
						{
?>
							<a href="<?php echo $loc->weatherLink; ?>" target="_blank">
<?php
						}
?>
								<?php echo $loc->locName; ?>
<?php
						if (null != $loc->weatherLink)
						{
?>
							</a>
<?php
						}
?>
						</strong>
					</td>
				</tr>
<?php
				if (null != $loc->weatherData)
				{
?>
				<tr>
					<td>
						<img src="<?php echo $loc->weatherData->imageUrls['currentConditionsSmall']; ?>"
				    		 alt="<?php echo $loc->weatherData->twcContent->cc_text; ?>"
							 width="<?php echo $this->currentConditionsIconSize; ?>"
						     height="<?php echo $this->currentConditionsIconSize; ?>"
						     border="0" />
					</td>
					<td>
						<strong>
<?php
						if (is_numeric($loc->weatherData->twcContent->cc_temp))
						{
							echo $loc->weatherData->twcContent->cc_temp.$this->degreeSymbol.$loc->weatherData->twcContent->h_temp;
						}
						else
						{
							echo $loc->weatherData->twcContent->cc_temp;
						}
?>
						</strong>
						<br/>
<?php
						if (is_numeric($loc->weatherData->twcContent->cc_barpressure))
						{
							echo $loc->weatherData->twcContent->cc_barpressure."&nbsp;".$loc->weatherData->twcContent->h_pressure;
						}
						else
						{
							echo $loc->weatherData->twcContent->cc_barpressure;
						}
?>
					</td>
					<td align="center">
						<img src="<?php echo $loc->weatherData->imageUrls['windDirSmall']; ?>"
							 width="<?php echo $this->windDirIconSize; ?>"
							 height="<?php echo $this->windDirIconSize; ?>"
							 alt="<?php echo $loc->weatherData->twcContent->cc_windtext; ?>"
							 border="0" />
						<br/>
<?php
						if (is_numeric($loc->weatherData->twcContent->cc_windspeed))
						{
							echo $loc->weatherData->twcContent->cc_windspeed.'&nbsp;'.$loc->weatherData->twcContent->h_speed;
						}
						else
						{
							echo $loc->weatherData->twcContent->cc_windspeed;
						}
?>
					</td>
				</tr>
<?php
				} // end if (null != $loc->weatherData)
				else
				{
?>
				<tr>
					<td>
						Weather data not available for <?php echo $loc->locationId ?>
					</td>
				</tr>
<?php
				} // end else
?>
			</table>
		</td>
<?php
		// If this is the last location for this row, close the row
		if (($i % $this->numColumns) == ($this->numColumns - 1))
	    {
?>
	</tr>
	<tr>
		<td colspan="15" height="10"></td>
	</tr>
<?php
			// If there are more locations, open a new row
			if ($i != ($this->numLocations - 1))
			{
?>
	<tr>
<?php
			}
		}
		// Else, not at the end of a row, so insert some spacing
		elseif ($i != ($this->numLocations - 1))
		{
?>
		<td width="15"></td>
<?php
		}
    } // end for loop

	//
	// if there is still a location row open, close it
	// there will be a location row open in the case that
	//  the number of locations per row is not an even
	//  multiple of the number of locations
	//
    if (($this->numLocations % $this->numColumns) != 0)
	{
?>
	</tr>
<?php
	}
?>
	<tr>
		<td colspan="2">
			<table>
				<tr>
					<td align="right" style="font-size: 70%; padding-top: 15px;">
						<div align="left">
							<?php echo JText::_('COM_EWEATHER_PROVIDER').':'; ?>
							<br/>
							<a href="http://www.weather.com" target="blank">
								<img src="<?php echo $this->locations[0]->weatherData->imageUrls['weatherChannelLogoSmall']; ?>" border="0" alt="www.weather.com" />
							</a>
						</div>
					</td>
					<td align="right" style="font-size: 80%; padding-left: 5px; padding-top: 15px; text-align: right;" >
<?php
		    		$numLinks = count($this->locations[0]->weatherData->twcContent->partnerLinks);
    				for ($x = 0; $x < $numLinks; $x++)
    				{
	    			$url = JROUTE::_(str_replace('&','&amp;',$this->locations[0]->weatherData->twcContent->partnerLinks[$x]->url));
	    			$text = str_replace('&','&amp;',$this->locations[0]->weatherData->twcContent->partnerLinks[$x]->text)
?>
						<a target="_blank" href="<?php echo $url; ?>" title="<?php echo $text; ?>" >
							<?php echo $text; ?>
						</a>
						<br/>
<?php
					}
?>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</div>
<?php
echo '<!-- end Raf Weather Module Version '.MOD_RAFWEATHER_VERSION.' '.MOD_RAFWEATHER_VERSION_DATE.' -->';
?>
